/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.commandline;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.io.function.IOSupplier;
import org.apache.rat.ConfigurationException;

public enum StyleSheets {
    PLAIN("plain-rat", "The default style."),
    MISSING_HEADERS("missing-headers", "Produces a report of files that are missing headers."),
    UNAPPROVED_LICENSES("unapproved-licenses", "Produces a report of the files with unapproved licenses."),
    XML("xml", "Produces output in pretty-printed XML.");

    private final String name;
    private final String desc;

    private StyleSheets(String name, String description) {
        this.name = name;
        this.desc = description;
    }

    public IOSupplier<InputStream> getStyleSheet() {
        return Objects.requireNonNull(StyleSheets.class.getClassLoader().getResource(String.format("org/apache/rat/%s.xsl", this.name)), "missing stylesheet: " + this.name)::openStream;
    }

    public static IOSupplier<InputStream> getStyleSheet(String name) {
        URL url = StyleSheets.class.getClassLoader().getResource(String.format("org/apache/rat/%s.xsl", name));
        if (url != null) {
            return url::openStream;
        }
        Path p = Paths.get(name, new String[0]);
        if (p.toFile().exists()) {
            return () -> Files.newInputStream(p, new OpenOption[0]);
        }
        throw new ConfigurationException(String.format("Stylesheet file '%s' not found", name));
    }

    public String arg() {
        return this.name;
    }

    public String desc() {
        return this.desc;
    }
}

