/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EJBQLQueryDescriptor;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.ProcedureQueryDescriptor;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SQLTemplateDescriptor;
import org.apache.cayenne.map.SelectQueryDescriptor;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.DataChannelValidator;
import org.apache.cayenne.project.validation.DataMapValidator;
import org.apache.cayenne.project.validation.DataNodeValidator;
import org.apache.cayenne.project.validation.DbAttributeValidator;
import org.apache.cayenne.project.validation.DbEntityValidator;
import org.apache.cayenne.project.validation.DbRelationshipValidator;
import org.apache.cayenne.project.validation.EJBQLQueryValidator;
import org.apache.cayenne.project.validation.EmbeddableAttributeValidator;
import org.apache.cayenne.project.validation.EmbeddableValidator;
import org.apache.cayenne.project.validation.ObjAttributeValidator;
import org.apache.cayenne.project.validation.ObjEntityValidator;
import org.apache.cayenne.project.validation.ObjRelationshipValidator;
import org.apache.cayenne.project.validation.ProcedureParameterValidator;
import org.apache.cayenne.project.validation.ProcedureQueryValidator;
import org.apache.cayenne.project.validation.ProcedureValidator;
import org.apache.cayenne.project.validation.ProjectValidator;
import org.apache.cayenne.project.validation.SQLTemplateValidator;
import org.apache.cayenne.project.validation.SelectQueryValidator;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.validation.ValidationResult;

public class DefaultProjectValidator
implements ProjectValidator {
    protected final Map<Class<? extends ConfigurationNode>, ConfigurationNodeValidator<?>> validators;
    protected ValidationConfig defaultConfig;

    protected DefaultProjectValidator(Supplier<ValidationConfig> configSupplier) {
        this.validators = DefaultProjectValidator.prepareValidators(configSupplier);
    }

    public DefaultProjectValidator() {
        this.defaultConfig = new ValidationConfig();
        this.validators = DefaultProjectValidator.prepareValidators(() -> this.defaultConfig);
    }

    @Override
    public ValidationResult validate(ConfigurationNode node) {
        return (ValidationResult)node.acceptVisitor((ConfigurationNodeVisitor)new ValidationVisitor());
    }

    private static Map<Class<? extends ConfigurationNode>, ConfigurationNodeValidator<?>> prepareValidators(Supplier<ValidationConfig> configSupplier) {
        HashMap validators = new HashMap();
        validators.put(DataChannelDescriptor.class, new DataChannelValidator(configSupplier));
        validators.put(DataNodeDescriptor.class, new DataNodeValidator(configSupplier));
        validators.put(DataMap.class, new DataMapValidator(configSupplier));
        validators.put(ObjEntity.class, new ObjEntityValidator(configSupplier));
        validators.put(ObjAttribute.class, new ObjAttributeValidator(configSupplier));
        validators.put(ObjRelationship.class, new ObjRelationshipValidator(configSupplier));
        validators.put(DbEntity.class, new DbEntityValidator(configSupplier));
        validators.put(DbAttribute.class, new DbAttributeValidator(configSupplier));
        validators.put(DbRelationship.class, new DbRelationshipValidator(configSupplier));
        validators.put(Embeddable.class, new EmbeddableValidator(configSupplier));
        validators.put(EmbeddableAttribute.class, new EmbeddableAttributeValidator(configSupplier));
        validators.put(Procedure.class, new ProcedureValidator(configSupplier));
        validators.put(ProcedureParameter.class, new ProcedureParameterValidator(configSupplier));
        validators.put(SelectQueryDescriptor.class, new SelectQueryValidator(configSupplier));
        validators.put(ProcedureQueryDescriptor.class, new ProcedureQueryValidator(configSupplier));
        validators.put(EJBQLQueryDescriptor.class, new EJBQLQueryValidator(configSupplier));
        validators.put(SQLTemplateDescriptor.class, new SQLTemplateValidator(configSupplier));
        return validators;
    }

    protected <T extends ConfigurationNode> ConfigurationNodeValidator<T> getValidator(Class<T> node) {
        return this.validators.get(node);
    }

    class ValidationVisitor
    implements ConfigurationNodeVisitor<ValidationResult> {
        private final ValidationResult validationResult = new ValidationResult();

        ValidationVisitor() {
        }

        public ValidationResult visitDataChannelDescriptor(DataChannelDescriptor channelDescriptor) {
            DefaultProjectValidator.this.getValidator(DataChannelDescriptor.class).validate(channelDescriptor, this.validationResult);
            for (DataNodeDescriptor node : channelDescriptor.getNodeDescriptors()) {
                this.visitDataNodeDescriptor(node);
            }
            for (DataMap map : channelDescriptor.getDataMaps()) {
                this.visitDataMap(map);
            }
            return this.validationResult;
        }

        public ValidationResult visitDataMap(DataMap dataMap) {
            DefaultProjectValidator.this.getValidator(DataMap.class).validate(dataMap, this.validationResult);
            for (Embeddable emb : dataMap.getEmbeddables()) {
                this.visitEmbeddable(emb);
            }
            for (ObjEntity ent : dataMap.getObjEntities()) {
                this.visitObjEntity(ent);
            }
            for (ObjEntity ent : dataMap.getDbEntities()) {
                this.visitDbEntity((DbEntity)ent);
            }
            for (Procedure proc : dataMap.getProcedures()) {
                this.visitProcedure(proc);
            }
            for (QueryDescriptor q : dataMap.getQueryDescriptors()) {
                this.visitQuery(q);
            }
            return this.validationResult;
        }

        public ValidationResult visitDataNodeDescriptor(DataNodeDescriptor nodeDescriptor) {
            DefaultProjectValidator.this.getValidator(DataNodeDescriptor.class).validate(nodeDescriptor, this.validationResult);
            return this.validationResult;
        }

        public ValidationResult visitDbAttribute(DbAttribute attribute) {
            DefaultProjectValidator.this.getValidator(DbAttribute.class).validate(attribute, this.validationResult);
            return this.validationResult;
        }

        public ValidationResult visitDbEntity(DbEntity entity) {
            DefaultProjectValidator.this.getValidator(DbEntity.class).validate(entity, this.validationResult);
            for (DbAttribute attr : entity.getAttributes()) {
                this.visitDbAttribute(attr);
            }
            for (DbRelationship rel : entity.getRelationships()) {
                this.visitDbRelationship(rel);
            }
            return this.validationResult;
        }

        public ValidationResult visitDbRelationship(DbRelationship relationship) {
            DefaultProjectValidator.this.getValidator(DbRelationship.class).validate(relationship, this.validationResult);
            return this.validationResult;
        }

        public ValidationResult visitEmbeddable(Embeddable embeddable) {
            DefaultProjectValidator.this.getValidator(Embeddable.class).validate(embeddable, this.validationResult);
            for (EmbeddableAttribute attr : embeddable.getAttributes()) {
                this.visitEmbeddableAttribute(attr);
            }
            return this.validationResult;
        }

        public ValidationResult visitEmbeddableAttribute(EmbeddableAttribute attribute) {
            DefaultProjectValidator.this.getValidator(EmbeddableAttribute.class).validate(attribute, this.validationResult);
            return this.validationResult;
        }

        public ValidationResult visitObjAttribute(ObjAttribute attribute) {
            DefaultProjectValidator.this.getValidator(ObjAttribute.class).validate(attribute, this.validationResult);
            return this.validationResult;
        }

        public ValidationResult visitObjEntity(ObjEntity entity) {
            DefaultProjectValidator.this.getValidator(ObjEntity.class).validate(entity, this.validationResult);
            for (ObjAttribute attr : entity.getAttributes()) {
                this.visitObjAttribute(attr);
            }
            for (ObjRelationship rel : entity.getRelationships()) {
                this.visitObjRelationship(rel);
            }
            return this.validationResult;
        }

        public ValidationResult visitObjRelationship(ObjRelationship relationship) {
            DefaultProjectValidator.this.getValidator(ObjRelationship.class).validate(relationship, this.validationResult);
            return this.validationResult;
        }

        public ValidationResult visitProcedure(Procedure procedure) {
            DefaultProjectValidator.this.getValidator(Procedure.class).validate(procedure, this.validationResult);
            ProcedureParameter parameter = procedure.getResultParam();
            if (parameter != null) {
                this.visitProcedureParameter(parameter);
            }
            for (ProcedureParameter procPar : procedure.getCallOutParameters()) {
                this.visitProcedureParameter(procPar);
            }
            for (ProcedureParameter procPar : procedure.getCallParameters()) {
                this.visitProcedureParameter(procPar);
            }
            return this.validationResult;
        }

        public ValidationResult visitProcedureParameter(ProcedureParameter parameter) {
            DefaultProjectValidator.this.getValidator(ProcedureParameter.class).validate(parameter, this.validationResult);
            return this.validationResult;
        }

        public ValidationResult visitQuery(QueryDescriptor query) {
            switch (query.getType()) {
                case "SelectQuery": {
                    DefaultProjectValidator.this.getValidator(SelectQueryDescriptor.class).validate((SelectQueryDescriptor)query, this.validationResult);
                    break;
                }
                case "SQLTemplate": {
                    DefaultProjectValidator.this.getValidator(SQLTemplateDescriptor.class).validate((SQLTemplateDescriptor)query, this.validationResult);
                    break;
                }
                case "ProcedureQuery": {
                    DefaultProjectValidator.this.getValidator(ProcedureQueryDescriptor.class).validate((ProcedureQueryDescriptor)query, this.validationResult);
                    break;
                }
                case "EJBQLQuery": {
                    DefaultProjectValidator.this.getValidator(EJBQLQueryDescriptor.class).validate((EJBQLQueryDescriptor)query, this.validationResult);
                }
            }
            return this.validationResult;
        }
    }
}

