/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.ToCacheKeyPrefetchProcessor;
import org.apache.cayenne.query.ToCacheKeyTraversalHandler;

class ObjectSelectMetadata
extends BaseQueryMetadata {
    private static final long serialVersionUID = -4936484509363047672L;
    protected Map<String, String> pathSplitAliases;

    ObjectSelectMetadata() {
    }

    @Override
    void copyFromInfo(QueryMetadata info) {
        super.copyFromInfo(info);
        this.pathSplitAliases = new HashMap<String, String>(info.getPathSplitAliases());
    }

    boolean resolve(Object root, EntityResolver resolver, ObjectSelect<?> query) {
        if (super.resolve(root, resolver)) {
            if (this.cacheStrategy != null && this.cacheStrategy != QueryCacheStrategy.NO_CACHE) {
                this.cacheKey = this.makeCacheKey(query, resolver);
            }
            this.resolveAutoAliases(query);
            return true;
        }
        return false;
    }

    protected String makeCacheKey(FluentSelect<?, ?> query, EntityResolver resolver) {
        StringBuilder key = new StringBuilder();
        ToCacheKeyTraversalHandler traversalHandler = null;
        ObjEntity entity = this.getObjEntity();
        if (entity != null) {
            key.append(entity.getName());
        } else if (this.dbEntity != null) {
            key.append("db:").append(this.dbEntity.getName());
        }
        if (query.getColumns() != null && !query.getColumns().isEmpty()) {
            traversalHandler = new ToCacheKeyTraversalHandler(resolver.getValueObjectTypeRegistry(), key);
            for (Property property : query.getColumns()) {
                key.append("/c:");
                property.getExpression().traverse(traversalHandler);
            }
        }
        if (query.getWhere() != null) {
            key.append('/');
            traversalHandler = new ToCacheKeyTraversalHandler(resolver.getValueObjectTypeRegistry(), key);
            query.getWhere().traverse(traversalHandler);
        }
        if (query.getOrderings() != null && !query.getOrderings().isEmpty()) {
            for (Ordering ordering : query.getOrderings()) {
                key.append('/').append(ordering.getSortSpecString());
                if (!ordering.isAscending()) {
                    key.append(":d");
                }
                if (!ordering.isCaseInsensitive()) continue;
                key.append(":i");
            }
        }
        if (query.getHaving() != null) {
            key.append('/');
            if (traversalHandler == null) {
                traversalHandler = new ToCacheKeyTraversalHandler(resolver.getValueObjectTypeRegistry(), key);
            }
            query.getHaving().traverse(traversalHandler);
        }
        if (this.fetchLimit > 0 || this.fetchOffset > 0) {
            key.append('/');
            if (this.fetchOffset > 0) {
                key.append('o').append(this.fetchOffset);
            }
            if (this.fetchLimit > 0) {
                key.append('l').append(this.fetchLimit);
            }
        }
        if (this.prefetchTree != null) {
            this.prefetchTree.traverse(new ToCacheKeyPrefetchProcessor(key));
        }
        return key.toString();
    }

    protected void resolveAutoAliases(FluentSelect<?, ?> query) {
        this.resolveQualifierAliases(query);
        this.resolveOrderingAliases(query);
        this.resolveHavingQualifierAliases(query);
    }

    protected void resolveQualifierAliases(FluentSelect<?, ?> query) {
        Expression qualifier = query.getWhere();
        if (qualifier != null) {
            this.resolveAutoAliases(qualifier);
        }
    }

    protected void resolveHavingQualifierAliases(FluentSelect<?, ?> query) {
        Expression havingQualifier = query.getHaving();
        if (havingQualifier != null) {
            this.resolveAutoAliases(havingQualifier);
        }
    }

    protected void resolveOrderingAliases(FluentSelect<?, ?> query) {
        Collection<Ordering> orderings = query.getOrderings();
        if (orderings != null) {
            for (Ordering ordering : orderings) {
                Expression sortSpec = ordering.getSortSpec();
                if (sortSpec == null) continue;
                this.resolveAutoAliases(sortSpec);
            }
        }
    }

    protected void resolveAutoAliases(Expression expression) {
        Map<String, String> aliases = expression.getPathAliases();
        if (!aliases.isEmpty()) {
            if (this.pathSplitAliases == null) {
                this.pathSplitAliases = new HashMap<String, String>();
            }
            for (Map.Entry<String, String> entry : aliases.entrySet()) {
                this.pathSplitAliases.compute(entry.getKey(), (key, value) -> {
                    if (value != null && !value.equals(entry.getValue())) {
                        throw new CayenneRuntimeException("Can't add the same alias to different path segments.", new Object[0]);
                    }
                    return (String)entry.getValue();
                });
            }
        }
        int len = expression.getOperandCount();
        for (int i = 0; i < len; ++i) {
            Object operand = expression.getOperand(i);
            if (!(operand instanceof Expression)) continue;
            this.resolveAutoAliases((Expression)operand);
        }
    }

    @Override
    public Map<String, String> getPathSplitAliases() {
        return this.pathSplitAliases != null ? this.pathSplitAliases : Collections.emptyMap();
    }
}

