/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.util.XMLEncoder;

public class SelectQueryDescriptor
extends QueryDescriptor {
    private static final long serialVersionUID = -8798258795351950215L;
    public static final String DISTINCT_PROPERTY = "cayenne.SelectQuery.distinct";
    public static final boolean DISTINCT_DEFAULT = false;
    protected Expression qualifier;
    protected List<Ordering> orderings = new ArrayList<Ordering>();
    protected Map<String, Integer> prefetchesMap = new HashMap<String, Integer>();

    public SelectQueryDescriptor() {
        super("SelectQuery");
    }

    public void setDistinct(boolean value) {
        this.setProperty(DISTINCT_PROPERTY, String.valueOf(value));
    }

    public boolean isDistinct() {
        String distinct = this.getProperty(DISTINCT_PROPERTY);
        return distinct != null ? Boolean.parseBoolean(distinct) : false;
    }

    public Expression getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(Expression qualifier) {
        this.qualifier = qualifier;
    }

    public List<Ordering> getOrderings() {
        return this.orderings;
    }

    public void setOrderings(List<Ordering> orderings) {
        this.orderings = orderings;
    }

    public void addOrdering(Ordering ordering) {
        this.orderings.add(ordering);
    }

    public void removeOrdering(Ordering ordering) {
        this.orderings.remove(ordering);
    }

    public Map<String, Integer> getPrefetchesMap() {
        return this.prefetchesMap;
    }

    public void setPrefetchesMap(HashMap<String, Integer> prefetchesMap) {
        this.prefetchesMap = prefetchesMap;
    }

    public void addPrefetch(String prefetchPath, int semantics) {
        this.prefetchesMap.put(prefetchPath, semantics);
    }

    public void removePrefetch(String prefetchPath) {
        this.prefetchesMap.remove(prefetchPath);
    }

    @Override
    public ObjectSelect<?> buildQuery() {
        String rootEntityName;
        Object root = this.getRoot();
        if (root instanceof ObjEntity) {
            rootEntityName = ((ObjEntity)root).getName();
        } else if (root instanceof String) {
            rootEntityName = (String)root;
        } else {
            throw new CayenneRuntimeException("Unexpected root for the SelectQueryDescriptor '%s'.", root);
        }
        ObjectSelect<Object> query = ObjectSelect.query(Object.class, this.getQualifier());
        query.entityName(rootEntityName);
        query.setRoot(root);
        List<Ordering> orderings = this.getOrderings();
        if (orderings != null && !orderings.isEmpty()) {
            query.orderBy(orderings);
        }
        if (this.prefetchesMap != null) {
            this.prefetchesMap.forEach(query::prefetch);
        }
        query.initWithProperties(this.getProperties());
        if (this.isDistinct()) {
            query.distinct();
        }
        return query;
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("query").attribute("name", this.getName()).attribute("type", this.type);
        String rootString = null;
        String rootType = null;
        if (this.root instanceof String) {
            rootType = "obj-entity";
            rootString = this.root.toString();
        } else if (this.root instanceof ObjEntity) {
            rootType = "obj-entity";
            rootString = ((ObjEntity)this.root).getName();
        } else if (this.root instanceof DbEntity) {
            rootType = "db-entity";
            rootString = ((DbEntity)this.root).getName();
        } else if (this.root instanceof Procedure) {
            rootType = "procedure";
            rootString = ((Procedure)this.root).getName();
        } else if (this.root instanceof Class) {
            rootType = "java-class";
            rootString = ((Class)this.root).getName();
        }
        if (rootType != null) {
            encoder.attribute("root", rootType).attribute("root-name", rootString);
        }
        this.encodeProperties(encoder);
        if (this.qualifier != null) {
            encoder.start("qualifier").nested(this.qualifier, delegate).end();
        }
        encoder.nested(this.orderings, delegate);
        PrefetchTreeNode prefetchTree = new PrefetchTreeNode();
        for (String prefetchPath : this.prefetchesMap.keySet()) {
            PrefetchTreeNode node = prefetchTree.addPath(prefetchPath);
            node.setSemantics(this.prefetchesMap.get(prefetchPath));
            node.setPhantom(false);
        }
        encoder.nested(prefetchTree, delegate);
        delegate.visitQuery(this);
        encoder.end();
    }
}

