/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.parser.ASTNot;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.ExpressionParserTreeConstants;
import org.apache.cayenne.exp.parser.Node;
import org.apache.cayenne.util.Util;

public abstract class SimpleNode
extends Expression
implements Node {
    private static final long serialVersionUID = 4471832357335707557L;
    protected Node parent;
    protected Node[] children;
    protected int id;

    protected static void encodeScalarAsEJBQL(List<Object> parameterAccumulator, Appendable out, Object scalar) throws IOException {
        if (null == scalar) {
            out.append("null");
            return;
        }
        if (scalar instanceof Boolean) {
            if (((Boolean)scalar).booleanValue()) {
                out.append("true");
            } else {
                out.append("false");
            }
            return;
        }
        if (null != parameterAccumulator) {
            parameterAccumulator.add(scalar);
            out.append('?');
            out.append(Integer.toString(parameterAccumulator.size()));
            return;
        }
        if (scalar instanceof Integer || scalar instanceof Long || scalar instanceof Float || scalar instanceof Double) {
            out.append(scalar.toString());
            return;
        }
        if (scalar instanceof Persistent) {
            ObjectId id = ((Persistent)scalar).getObjectId();
            Object encode = id != null ? id : scalar;
            SimpleNode.appendAsEscapedString(out, String.valueOf(encode));
            return;
        }
        if (scalar instanceof Enum) {
            Enum e = (Enum)scalar;
            out.append("enum:");
            out.append(e.getClass().getName()).append(".").append(e.name());
            return;
        }
        if (scalar instanceof String) {
            out.append('\'');
            SimpleNode.appendAsEscapedString(out, scalar.toString());
            out.append('\'');
            return;
        }
        throw new IllegalStateException("the scalar type '" + scalar.getClass().getSimpleName() + "' is not supported as a scalar type in EJBQL");
    }

    protected static void appendScalarAsString(Appendable out, Object scalar, char quoteChar) throws IOException {
        boolean quote = scalar instanceof String;
        if (quote) {
            out.append(quoteChar);
        }
        if (scalar instanceof Persistent) {
            ObjectId id = ((Persistent)scalar).getObjectId();
            Object encode = id != null ? id : scalar;
            SimpleNode.appendAsEscapedString(out, String.valueOf(encode));
        } else if (scalar instanceof Enum) {
            Enum e = (Enum)scalar;
            out.append("enum:");
            out.append(e.getClass().getName()).append(".").append(e.name());
        } else {
            SimpleNode.appendAsEscapedString(out, String.valueOf(scalar));
        }
        if (quote) {
            out.append(quoteChar);
        }
    }

    protected static void appendAsEscapedString(Appendable out, String source) throws IOException {
        int len = source.length();
        block10: for (int i = 0; i < len; ++i) {
            char c = source.charAt(i);
            switch (c) {
                case '\n': {
                    out.append("\\n");
                    continue block10;
                }
                case '\r': {
                    out.append("\\r");
                    continue block10;
                }
                case '\t': {
                    out.append("\\t");
                    continue block10;
                }
                case '\b': {
                    out.append("\\b");
                    continue block10;
                }
                case '\f': {
                    out.append("\\f");
                    continue block10;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block10;
                }
                case '\'': {
                    out.append("\\'");
                    continue block10;
                }
                case '\"': {
                    out.append("\\\"");
                    continue block10;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    protected SimpleNode(int i) {
        this.id = i;
    }

    @Override
    public Map<String, String> getPathAliases() {
        return Collections.emptyMap();
    }

    protected abstract String getExpressionOperator(int var1);

    protected String getEJBQLExpressionOperator(int index) {
        return this.getExpressionOperator(index);
    }

    @Override
    protected boolean pruneNodeForPrunedChild(Object prunedChild) {
        return true;
    }

    @Override
    public String expName() {
        return ExpressionParserTreeConstants.jjtNodeName[this.id];
    }

    @Override
    protected void flattenTree() {
        boolean shouldFlatten = false;
        int newSize = 0;
        for (Node child : this.children) {
            if (child.getClass() == this.getClass()) {
                shouldFlatten = true;
                newSize += child.jjtGetNumChildren();
                continue;
            }
            ++newSize;
        }
        if (shouldFlatten) {
            Node[] newChildren = new Node[newSize];
            int j = 0;
            for (Node c : this.children) {
                if (c.getClass() == this.getClass()) {
                    for (int k = 0; k < c.jjtGetNumChildren(); ++k) {
                        newChildren[j++] = c.jjtGetChild(k);
                    }
                    continue;
                }
                newChildren[j++] = c;
            }
            if (j != newSize) {
                throw new ExpressionException("Assertion error: " + j + " != " + newSize, new Object[0]);
            }
            this.children = newChildren;
        }
    }

    @Override
    public void appendAsString(Appendable out) throws IOException {
        if (this.parent != null) {
            out.append("(");
        }
        if (this.children != null && this.children.length > 0) {
            for (int i = 0; i < this.children.length; ++i) {
                if (i > 0) {
                    out.append(' ');
                    out.append(this.getExpressionOperator(i));
                    out.append(' ');
                }
                if (this.children[i] == null) {
                    out.append("null");
                    continue;
                }
                ((SimpleNode)this.children[i]).appendAsString(out);
            }
        }
        if (this.parent != null) {
            out.append(')');
        }
    }

    @Override
    public Object getOperand(int index) {
        Node child = this.jjtGetChild(index);
        return this.unwrapChild(child);
    }

    protected Node wrapChild(Object child) {
        return child instanceof Node || child == null ? (Node)child : new ASTScalar(child);
    }

    protected Object unwrapChild(Node child) {
        return child instanceof ASTScalar ? ((ASTScalar)child).getValue() : child;
    }

    @Override
    public int getOperandCount() {
        return this.jjtGetNumChildren();
    }

    @Override
    public void setOperand(int index, Object value) {
        Node node = value == null || value instanceof Node ? (Node)value : new ASTScalar(value);
        this.jjtAddChild(node, index);
        if (node != null) {
            node.jjtSetParent(this);
        }
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        if (!this.isValidParent(n)) {
            String label = n instanceof SimpleNode ? ((SimpleNode)n).expName() : String.valueOf(n);
            throw new ExpressionException(this.expName() + ": invalid parent - " + label, new Object[0]);
        }
        this.parent = n;
    }

    protected boolean isValidParent(Node n) {
        return true;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public final int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    protected abstract Object evaluateNode(Object var1) throws Exception;

    protected void connectChildren() {
        if (this.children != null) {
            for (Node child : this.children) {
                if (child == null) continue;
                child.jjtSetParent(this);
            }
        }
    }

    protected Object evaluateChild(int index, Object o) throws Exception {
        SimpleNode node = (SimpleNode)this.jjtGetChild(index);
        return node != null ? node.evaluate(o) : null;
    }

    @Override
    public Expression notExp() {
        return new ASTNot(this);
    }

    @Override
    public Expression exists() {
        throw new UnsupportedOperationException("Can't use exists() operator with this expression");
    }

    @Override
    public Expression notExists() {
        throw new UnsupportedOperationException("Can't use not exists() operator with this expression");
    }

    @Override
    public Object evaluate(Object o) {
        try {
            return this.evaluateNode(o);
        }
        catch (Throwable th) {
            String string = this.toString();
            throw new ExpressionException("Error evaluating expression '%s'", string, Util.unwindException(th), string);
        }
    }

    @Override
    public void appendAsEJBQL(Appendable out, String rootId) throws IOException {
        this.appendAsEJBQL(null, out, rootId);
    }

    @Override
    public void appendAsEJBQL(List<Object> parameterAccumulator, Appendable out, String rootId) throws IOException {
        if (this.parent != null) {
            out.append("(");
        }
        if (this.children != null && this.children.length > 0) {
            this.appendChildrenAsEJBQL(parameterAccumulator, out, rootId);
        }
        if (this.parent != null) {
            out.append(')');
        }
    }

    protected void appendChildrenAsEJBQL(List<Object> parameterAccumulator, Appendable out, String rootId) throws IOException {
        for (int i = 0; i < this.children.length; ++i) {
            if (i > 0) {
                out.append(' ');
                out.append(this.getEJBQLExpressionOperator(i));
                out.append(' ');
            }
            if (this.children[i] == null) {
                out.append("null");
                continue;
            }
            ((SimpleNode)this.children[i]).appendAsEJBQL(parameterAccumulator, out, rootId);
        }
    }
}

