/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTAggregateFunctionCall;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.Node;
import org.apache.cayenne.exp.parser.SimpleNode;

public class ASTCustomAggregate
extends ASTAggregateFunctionCall {
    private boolean isNameSet;

    ASTCustomAggregate(int id) {
        super(id, "");
    }

    protected ASTCustomAggregate(String functionName) {
        super(37, functionName);
    }

    public ASTCustomAggregate(String functionName, Expression ... expressions) {
        super(37, functionName, expressions);
    }

    @Override
    public Expression shallowCopy() {
        return new ASTCustomAggregate(this.functionName);
    }

    @Override
    protected void setFunctionName(String functionName) {
        super.setFunctionName(functionName);
        if (!functionName.isEmpty()) {
            this.isNameSet = true;
        }
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (!this.isNameSet && i == 0) {
            if (!(n instanceof ASTScalar)) {
                throw new IllegalArgumentException("ASTScalar expected, got " + n);
            }
            this.setFunctionName(((ASTScalar)n).getValue().toString());
            return;
        }
        super.jjtAddChild(n, this.isNameSet ? i : --i);
    }

    @Override
    public void appendAsString(Appendable out) throws IOException {
        out.append("agg").append('(').append('\"').append(this.functionName).append('\"');
        if (this.children != null) {
            for (Node child : this.children) {
                out.append(", ");
                if (child == null) {
                    out.append("null");
                    continue;
                }
                ((SimpleNode)child).appendAsString(out);
            }
        }
        out.append(')');
    }
}

