/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.HashSet;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.translator.select.BaseColumnExtractor;
import org.apache.cayenne.access.translator.select.PathTranslationResult;
import org.apache.cayenne.access.translator.select.PathTranslator;
import org.apache.cayenne.access.translator.select.ResultNodeDescriptor;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResult;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

class DescriptorColumnExtractor
extends BaseColumnExtractor
implements PropertyVisitor {
    private final ClassDescriptor descriptor;
    private final PathTranslator pathTranslator;
    private final Set<String> columnTracker = new HashSet<String>();
    private EntityResult entityResult;
    private CayennePath prefix;
    private CayennePath labelPrefix;

    DescriptorColumnExtractor(TranslatorContext context, ClassDescriptor descriptor) {
        super(context);
        this.descriptor = descriptor;
        this.pathTranslator = context.getPathTranslator();
    }

    @Override
    public void extract(CayennePath prefix) {
        this.prefix = prefix;
        boolean newEntityResult = false;
        this.labelPrefix = CayennePath.EMPTY_PATH;
        TranslatorContext.DescriptorType type = TranslatorContext.DescriptorType.OTHER;
        if (prefix != null && prefix.hasMarker(1)) {
            type = TranslatorContext.DescriptorType.PREFETCH;
            this.labelPrefix = prefix;
            if (this.context.getQuery().needsResultSetMapping()) {
                this.entityResult = this.context.getRootEntityResult();
                if (this.entityResult == null) {
                    throw new CayenneRuntimeException("Can't process prefetch descriptor without root.", new Object[0]);
                }
            }
        } else {
            if (this.context.getQuery().needsResultSetMapping()) {
                this.entityResult = new EntityResult(this.descriptor.getObjectClass());
                newEntityResult = true;
            }
            if (this.descriptor.getEntity().getDbEntity() == this.context.getRootDbEntity()) {
                type = TranslatorContext.DescriptorType.ROOT;
                this.context.setRootEntityResult(this.entityResult);
            }
        }
        this.context.markDescriptorStart(type);
        this.descriptor.visitAllProperties(this);
        DbEntity table = this.descriptor.getEntity().getDbEntity();
        String alias = this.context.getTableTree().aliasForPath(this.prefix);
        for (DbAttribute dba : table.getPrimaryKeys()) {
            String columnUniqueName = alias + "." + dba.getName();
            if (!this.columnTracker.add(columnUniqueName)) continue;
            this.addDbAttribute(this.prefix, this.labelPrefix, dba);
            this.addEntityResultField(dba);
        }
        if (newEntityResult) {
            this.context.getSqlResult().addEntityResult(this.entityResult);
        }
        this.context.markDescriptorEnd(type);
    }

    @Override
    public boolean visitAttribute(AttributeProperty property) {
        ObjAttribute oa = property.getAttribute();
        if (oa.isLazy()) {
            return true;
        }
        PathTranslationResult result = this.pathTranslator.translatePath(oa.getEntity(), CayennePath.of(property.getName()), this.prefix);
        int count = result.getDbAttributes().size();
        for (int i = 0; i < count; ++i) {
            ResultNodeDescriptor resultNodeDescriptor = this.processTranslationResult(result, i);
            DbAttribute dbAttribute = result.getDbAttributes().get(i);
            if (resultNodeDescriptor == null) continue;
            if (dbAttribute == oa.getDbAttribute()) {
                resultNodeDescriptor.setJavaType(oa.getType());
            }
            if (count > 1) {
                CayennePath dataRowKey = result.getAttributePaths().get(i).dot(dbAttribute.getName());
                resultNodeDescriptor.setDataRowKey(dataRowKey);
                this.addEntityResultField(dataRowKey);
                continue;
            }
            this.addEntityResultField(dbAttribute);
        }
        return true;
    }

    @Override
    public boolean visitToOne(ToOneProperty property) {
        ObjRelationship rel = property.getRelationship();
        if (!rel.isToPK()) {
            return true;
        }
        PathTranslationResult result = this.pathTranslator.translatePath(rel.getSourceEntity(), CayennePath.of(property.getName()), this.prefix);
        int count = result.getDbAttributes().size();
        for (int i = 0; i < count; ++i) {
            this.processTranslationResult(result, i);
            this.addEntityResultField(result.getDbAttributes().get(i));
        }
        return true;
    }

    private ResultNodeDescriptor processTranslationResult(PathTranslationResult result, int i) {
        DbAttribute attribute;
        CayennePath path = result.getAttributePaths().get(i);
        String alias = this.context.getTableTree().aliasForPath(path);
        String columnUniqueName = alias + "." + (attribute = result.getDbAttributes().get(i)).getName();
        if (this.columnTracker.add(columnUniqueName)) {
            CayennePath attributePath = path.dot(attribute.getName());
            Node columnNode = SQLBuilder.table(alias).column(attribute).build();
            return this.context.addResultNode(columnNode, attributePath).setDbAttribute(attribute);
        }
        return null;
    }

    private void addEntityResultField(DbAttribute attribute) {
        String name = this.labelPrefix.dot(attribute.getName()).value();
        if (this.context.getQuery().needsResultSetMapping()) {
            this.entityResult.addDbField(name, name);
        }
    }

    private void addEntityResultField(CayennePath pathForFlattenedAttribute) {
        if (this.context.getQuery().needsResultSetMapping()) {
            String nameForFlattenedAttribute = pathForFlattenedAttribute.value();
            this.entityResult.addDbField(nameForFlattenedAttribute, nameForFlattenedAttribute);
        }
    }

    @Override
    public boolean visitToMany(ToManyProperty property) {
        return true;
    }
}

