/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder.sqltree;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.sqlbuilder.QuotingAppendable;
import org.apache.cayenne.access.sqlbuilder.SQLGenerationContext;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NodeType;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.map.DbAttribute;

public class ValueNode
extends Node {
    private final Object value;
    private final boolean isArray;
    private final DbAttribute attribute;
    private final boolean needBinding;

    public ValueNode(Object value, boolean isArray, DbAttribute attribute, boolean needBinding) {
        super(NodeType.VALUE);
        this.value = value;
        this.isArray = isArray;
        this.attribute = attribute;
        this.needBinding = needBinding;
    }

    public Object getValue() {
        return this.value;
    }

    public DbAttribute getAttribute() {
        return this.attribute;
    }

    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public QuotingAppendable append(QuotingAppendable buffer) {
        this.appendValue(this.value, buffer);
        return buffer;
    }

    protected void appendNullValue(QuotingAppendable buffer) {
        buffer.append(" NULL");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendValue(Object val, QuotingAppendable buffer) {
        if (val == null) {
            this.appendNullValue(buffer);
            return;
        }
        if (this.isArray && val.getClass().isArray()) {
            if (val instanceof short[]) {
                this.appendValue((short[])val, buffer);
                return;
            } else if (val instanceof char[]) {
                this.appendValue((char[])val, buffer);
                return;
            } else if (val instanceof int[]) {
                this.appendValue((int[])val, buffer);
                return;
            } else if (val instanceof long[]) {
                this.appendValue((long[])val, buffer);
                return;
            } else if (val instanceof float[]) {
                this.appendValue((float[])val, buffer);
                return;
            } else if (val instanceof double[]) {
                this.appendValue((double[])val, buffer);
                return;
            } else if (val instanceof boolean[]) {
                this.appendValue((boolean[])val, buffer);
                return;
            } else if (val instanceof Object[]) {
                this.appendValue((Object[])val, buffer);
                return;
            } else {
                if (!(val instanceof byte[])) throw new CayenneRuntimeException("Unsupported array type %s", val.getClass().getName());
                this.appendValue((byte[])val, buffer);
            }
            return;
        } else if (val instanceof Persistent) {
            this.appendValue((Persistent)val, buffer);
            return;
        } else if (val instanceof ObjectId) {
            this.appendValue((ObjectId)val, buffer);
            return;
        } else if (val instanceof Supplier) {
            this.appendValue(((Supplier)val).get(), buffer);
            return;
        } else if (val instanceof CharSequence) {
            this.appendStringValue(buffer, (CharSequence)val);
            return;
        } else {
            this.appendObjectValue(buffer, val);
        }
    }

    protected void appendObjectValue(QuotingAppendable buffer, Object value) {
        if (value == null) {
            return;
        }
        if (buffer.getContext() == null || !this.needBinding) {
            buffer.append(' ').append(value.toString());
        } else {
            buffer.append(" ?");
            this.addValueBinding(buffer, value);
        }
    }

    protected void appendStringValue(QuotingAppendable buffer, CharSequence value) {
        if (buffer.getContext() == null || !this.needBinding) {
            buffer.append(" '").append(value).append("'");
        } else {
            buffer.append(" ?");
            this.addValueBinding(buffer, value);
        }
    }

    protected void addValueBinding(QuotingAppendable buffer, Object value) {
        SQLGenerationContext context = buffer.getContext();
        ExtendedType extendedType = context.getAdapter().getExtendedTypes().getRegisteredType(value.getClass());
        DbAttributeBinding binding = new DbAttributeBinding(this.attribute);
        binding.setStatementPosition(context.getBindings().size() + 1);
        binding.setExtendedType(extendedType);
        binding.setValue(value);
        context.getBindings().add(binding);
    }

    private void appendValue(Persistent value, QuotingAppendable buffer) {
        this.appendValue(value.getObjectId(), buffer);
    }

    private void appendValue(ObjectId value, QuotingAppendable buffer) {
        for (Object idVal : value.getIdSnapshot().values()) {
            this.appendValue(idVal, buffer);
        }
    }

    private void appendValue(short[] val, QuotingAppendable buffer) {
        boolean first = true;
        for (short i : val) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            this.appendValue(i, buffer);
        }
    }

    private void appendValue(char[] val, QuotingAppendable buffer) {
        boolean first = true;
        for (char i : val) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            this.appendValue(Character.valueOf(i), buffer);
        }
    }

    private void appendValue(int[] val, QuotingAppendable buffer) {
        boolean first = true;
        for (int i : val) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            this.appendValue(i, buffer);
        }
    }

    private void appendValue(long[] val, QuotingAppendable buffer) {
        boolean first = true;
        for (long i : val) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            this.appendValue(i, buffer);
        }
    }

    private void appendValue(float[] val, QuotingAppendable buffer) {
        boolean first = true;
        for (float i : val) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            this.appendValue(Float.valueOf(i), buffer);
        }
    }

    private void appendValue(double[] val, QuotingAppendable buffer) {
        boolean first = true;
        for (double i : val) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            this.appendValue(i, buffer);
        }
    }

    private void appendValue(boolean[] val, QuotingAppendable buffer) {
        boolean first = true;
        for (boolean i : val) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            this.appendValue(i, buffer);
        }
    }

    private void appendValue(byte[] val, QuotingAppendable buffer) {
        boolean first = true;
        for (byte i : val) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            this.appendValue(i, buffer);
        }
    }

    private void appendValue(Object[] val, QuotingAppendable buffer) {
        boolean first = true;
        for (Object i : val) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            this.appendValue(i, buffer);
        }
    }

    @Override
    public Node copy() {
        return new ValueNode(this.value, this.isArray, this.attribute, this.needBinding);
    }

    public boolean isNeedBinding() {
        return this.needBinding;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValueNode valueNode = (ValueNode)o;
        return this.isArray == valueNode.isArray && this.needBinding == valueNode.needBinding && Objects.equals(this.value, valueNode.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value, this.isArray, this.needBinding);
    }
}

