/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.compatibility.configuration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.xml.LoaderContext;
import org.apache.cayenne.configuration.xml.RootDataMapHandler;
import org.apache.cayenne.configuration.xml.XMLDataMapLoader;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.project.compatibility.CompatibilityUpgradeService;
import org.apache.cayenne.project.compatibility.DocumentProvider;
import org.apache.cayenne.project.upgrade.UpgradeService;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.Util;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class CompatibilityDataMapLoader
extends XMLDataMapLoader {
    @Inject
    Provider<UpgradeService> upgradeServiceProvider;
    @Inject
    DocumentProvider documentProvider;

    public DataMap load(Resource configurationResource) throws CayenneRuntimeException {
        Document document = this.documentProvider.getDocument(configurationResource.getURL());
        if (document == null) {
            if (!(this.upgradeServiceProvider.get() instanceof CompatibilityUpgradeService)) {
                throw new ConfigurationException("CompatibilityUpgradeService expected", new Object[0]);
            }
            CompatibilityUpgradeService upgradeService = (CompatibilityUpgradeService)((Object)this.upgradeServiceProvider.get());
            upgradeService.upgradeDataMap(configurationResource);
            document = this.documentProvider.getDocument(configurationResource.getURL());
            if (document == null) {
                return super.load(configurationResource);
            }
        }
        DataMap[] maps = new DataMap[1];
        try {
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TransformerFactory transFactory = TransformerFactory.newInstance();
            transFactory.newTransformer().transform(source, new StreamResult(baos));
            InputSource isource = new InputSource(source.getSystemId());
            isource.setByteStream(new ByteArrayInputStream(baos.toByteArray()));
            XMLReader parser = Util.createXmlReader();
            LoaderContext loaderContext = new LoaderContext(parser, this.handlerFactory);
            loaderContext.addDataMapListener(dataMap -> {
                maps[0] = dataMap;
            });
            RootDataMapHandler rootHandler = new RootDataMapHandler(loaderContext);
            parser.setContentHandler((ContentHandler)rootHandler);
            parser.setErrorHandler((ErrorHandler)rootHandler);
            parser.parse(isource);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error loading configuration from %s", (Throwable)e, new Object[]{configurationResource.getURL()});
        }
        if (maps[0] == null) {
            throw new CayenneRuntimeException("Unable to load data map from %s", new Object[]{configurationResource.getURL()});
        }
        DataMap map = maps[0];
        if (map.getName() == null) {
            map.setName(this.mapNameFromLocation(configurationResource.getURL().getFile()));
        }
        return map;
    }
}

