/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing.components.tree;

import java.util.Objects;

public class CheckBoxNodeData {
    protected final Object value;
    protected final State state;

    public CheckBoxNodeData(Object value, boolean isSelected) {
        this(value, isSelected ? State.SELECTED : State.DESELECTED);
    }

    public CheckBoxNodeData(CheckBoxNodeData data) {
        this(data.value, data.state);
    }

    public CheckBoxNodeData(Object value, State state) {
        this.value = value;
        this.state = Objects.requireNonNull(state);
    }

    protected CheckBoxNodeData(CheckBoxNodeData data, State state) {
        this(data.value, state);
    }

    public CheckBoxNodeData toggleState() {
        switch (this.state) {
            case DESELECTED: 
            case INDETERMINATE: {
                return this.withState(State.SELECTED);
            }
            case SELECTED: {
                return this.withState(State.DESELECTED);
            }
        }
        throw new IllegalStateException();
    }

    public CheckBoxNodeData withState(State state) {
        return new CheckBoxNodeData(this, state);
    }

    public CheckBoxNodeData withState(boolean isSelected) {
        return isSelected ? this.withState(State.SELECTED) : this.withState(State.DESELECTED);
    }

    public boolean isSelected() {
        return this.getState() == State.SELECTED;
    }

    public State getState() {
        return this.state;
    }

    public Object getValue() {
        return this.value;
    }

    public String getLabel() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CheckBoxNodeData data = (CheckBoxNodeData)object;
        return Objects.equals(this.value, data.value) && this.state == data.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.state});
    }

    public String toString() {
        return "CheckBoxNodeData{value=" + this.value + ", state=" + this.state + "}";
    }

    public static enum State {
        SELECTED,
        DESELECTED,
        INDETERMINATE;

    }
}

