/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.NameValidationHelper;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class DbRelationshipValidator
extends ConfigurationNodeValidator<DbRelationship> {
    public DbRelationshipValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    public void validate(DbRelationship node, ValidationResult validationResult) {
        this.on(node, validationResult).performIfEnabled(Inspection.DB_RELATIONSHIP_NO_NAME, this::checkForName).performIfEnabled(Inspection.DB_RELATIONSHIP_NAME_DUPLICATE, this::checkForNameDuplicates).performIfEnabled(Inspection.DB_RELATIONSHIP_INVALID_NAME, this::validateName).performIfEnabled(Inspection.DB_RELATIONSHIP_PATH_DUPLICATE, this::checkForPathDuplicates).performIfEnabled(Inspection.DB_RELATIONSHIP_NO_TARGET, this::checkForTarget).performIfEnabled(Inspection.DB_RELATIONSHIP_TARGET_NOT_PK, this::checkForTargetPK).performIfEnabled(Inspection.DB_RELATIONSHIP_NO_JOINS, this::checkForJoins).performIfEnabled(Inspection.DB_RELATIONSHIP_INVALID_JOIN, this::validateJoins).performIfEnabled(Inspection.DB_RELATIONSHIP_BOTH_TO_MANY, this::validateReverse).performIfEnabled(Inspection.DB_RELATIONSHIP_DIFFERENT_TYPES, this::checkForSameTypes).performIfEnabled(Inspection.DB_RELATIONSHIP_GENERATED_WITH_DEPENDENT_PK, this::checkOnGeneratedStrategyConflict);
    }

    private void checkForName(DbRelationship relationship, ValidationResult validationResult) {
        if (Util.isEmptyString(relationship.getName())) {
            this.addFailure(validationResult, relationship, "Unnamed DbRelationship", new Object[0]);
        }
    }

    private void checkForNameDuplicates(DbRelationship relationship, ValidationResult validationResult) {
        if (((DbEntity)relationship.getSourceEntity()).getAttribute(relationship.getName()) != null) {
            this.addFailure(validationResult, relationship, "Name of DbRelationship '%s' conflicts with the name of one of DbAttributes in the same entity", this.toString(relationship));
        }
    }

    private void validateName(DbRelationship relationship, ValidationResult validationResult) {
        NameValidationHelper helper = NameValidationHelper.getInstance();
        String invalidChars = helper.invalidCharsInDbPathComponent(relationship.getName());
        if (invalidChars != null) {
            this.addFailure(validationResult, relationship, "Name of DbRelationship '%s' contains invalid characters: %s", this.toString(relationship), invalidChars);
        }
    }

    private void checkForPathDuplicates(DbRelationship relationship, ValidationResult validationResult) {
        if (relationship == null || relationship.getName() == null || relationship.getTargetEntityName() == null) {
            return;
        }
        String dbRelationshipPath = relationship.getTargetEntityName() + "." + this.getJoins(relationship);
        DbEntity entity = (DbEntity)relationship.getSourceEntity();
        for (DbRelationship otherRelationship : entity.getRelationships()) {
            String otherDbRelationshipPath;
            if (relationship == otherRelationship || !dbRelationshipPath.equals(otherDbRelationshipPath = otherRelationship.getTargetEntityName() + "." + this.getJoins(otherRelationship))) continue;
            this.addFailure(validationResult, relationship, "DbEntity '%s' contains a duplicate DbRelationship mapping ('%s' -> '%s')", entity.getName(), relationship.getName(), dbRelationshipPath);
            return;
        }
    }

    private void checkForTarget(DbRelationship relationship, ValidationResult validationResult) {
        if (relationship.getTargetEntity() == null) {
            this.addFailure(validationResult, relationship, "DbRelationship '%s' has no target entity", this.toString(relationship));
        }
    }

    private void checkForTargetPK(DbRelationship relationship, ValidationResult validationResult) {
        DbRelationship reverseRelationship;
        if (!relationship.isToPK() && (reverseRelationship = relationship.getReverseRelationship()) != null && !reverseRelationship.isToPK()) {
            this.addFailure(validationResult, relationship, "DbRelationship '%s' has join not to PK. Cayenne doesn't allow this type of relationship", this.toString(relationship));
        }
    }

    private void checkForJoins(DbRelationship relationship, ValidationResult validationResult) {
        if (relationship.getJoins().isEmpty()) {
            this.addFailure(validationResult, relationship, "DbRelationship '%s' has no joins", this.toString(relationship));
        }
    }

    private void validateJoins(DbRelationship relationship, ValidationResult validationResult) {
        for (DbJoin join : relationship.getJoins()) {
            if (join.getSource() == null && join.getTarget() == null) {
                this.addFailure(validationResult, relationship, "DbRelationship '%s' has a join with no source and target attributes selected", this.toString(relationship));
                continue;
            }
            if (join.getSource() == null) {
                this.addFailure(validationResult, relationship, "DbRelationship '%s' has a join with no source attribute selected", this.toString(relationship));
                continue;
            }
            if (join.getTarget() != null) continue;
            this.addFailure(validationResult, relationship, "DbRelationship '%s' has a join with no target attribute selected", this.toString(relationship));
        }
    }

    private void validateReverse(DbRelationship relationship, ValidationResult validationResult) {
        if (relationship.getReverseRelationship() != null && relationship.isToMany() && relationship.getReverseRelationship().isToMany()) {
            this.addFailure(validationResult, relationship, "Relationship '%s' and reverse '%s' are both toMany", relationship.getName(), relationship.getReverseRelationship().getName());
        }
    }

    private void checkForSameTypes(DbRelationship relationship, ValidationResult validationResult) {
        for (DbJoin join : relationship.getJoins()) {
            if (join.getSource() == null || join.getTarget() == null || join.getSource().getType() == join.getTarget().getType()) continue;
            this.addFailure(validationResult, relationship, "Attributes '%s' and '%s' have different types in a relationship '%s'", join.getSourceName(), join.getTargetName(), relationship.getName());
        }
    }

    private void checkOnGeneratedStrategyConflict(DbRelationship relationship, ValidationResult validationResult) {
        if (!relationship.isToDependentPK()) {
            return;
        }
        Collection<DbAttribute> attributes = relationship.getTargetEntity().getGeneratedAttributes();
        for (DbAttribute attribute : attributes) {
            if (!attribute.isGenerated()) continue;
            this.addFailure(validationResult, relationship, "'To Dep Pk' incompatible with Database-Generated on '%s' relationship", this.toString(relationship));
        }
    }

    private String getJoins(DbRelationship relationship) {
        ArrayList<CallSite> joins = new ArrayList<CallSite>();
        for (DbJoin join : relationship.getJoins()) {
            joins.add((CallSite)((Object)("[source=" + join.getSourceName() + ",target=" + join.getTargetName() + "]")));
        }
        Collections.sort(joins);
        return Util.join(joins, ",");
    }

    private String toString(DbRelationship relationship) {
        if (relationship.getSourceEntity() == null) {
            return "[null source entity]." + relationship.getName();
        }
        return ((DbEntity)relationship.getSourceEntity()).getName() + "." + relationship.getName();
    }
}

