/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.state;

import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.util.state.DisplayEventType;

class ProcedureDisplayEventType
extends DisplayEventType {
    public ProcedureDisplayEventType(ProjectController controller) {
        super(controller);
    }

    @Override
    public void fireLastDisplayEvent() {
        DataChannelDescriptor dataChannel = (DataChannelDescriptor)this.controller.getProject().getRootNode();
        if (!dataChannel.getName().equals(this.preferences.getDomain())) {
            return;
        }
        DataMap dataMap = dataChannel.getDataMap(this.preferences.getDataMap());
        if (dataMap == null) {
            return;
        }
        Procedure procedure = dataMap.getProcedure(this.preferences.getProcedure());
        if (procedure == null) {
            return;
        }
        ProcedureDisplayEvent procedureDisplayEvent = new ProcedureDisplayEvent((Object)this, procedure, dataMap, dataChannel);
        this.controller.fireProcedureDisplayEvent(procedureDisplayEvent);
    }

    @Override
    public void saveLastDisplayEvent() {
        this.preferences.setEvent(ProcedureDisplayEvent.class.getSimpleName());
        this.preferences.setDomain(this.controller.getCurrentDataChanel().getName());
        this.preferences.setDataMap(this.controller.getCurrentDataMap().getName());
        this.preferences.setProcedure(this.controller.getCurrentProcedure().getName());
    }
}

