/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen.templateeditor;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.ArtefactsConfigurator;

public class EntityArtefactsConfigurator
implements ArtefactsConfigurator {
    @Override
    public void config(ClassGenerationAction action, String artifactName) {
        action.addEntities(Collections.singleton(this.getSelectedEntity(artifactName, action)));
    }

    @Override
    public List<String> getArtifactsNames(DataMap dataMap) {
        if (dataMap != null) {
            return dataMap.getObjEntities().stream().map(Entity::getName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private ObjEntity getSelectedEntity(String artifactName, ClassGenerationAction action) {
        DataMap dataMap = action.getCgenConfiguration().getDataMap();
        if (dataMap != null) {
            return dataMap.getObjEntity(artifactName);
        }
        return null;
    }
}

