/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen.templateeditor;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.ArtefactsConfigurator;

public class EmbeddableArtefactsConfigurator
implements ArtefactsConfigurator {
    @Override
    public void config(ClassGenerationAction action, String artifactName) {
        action.addEmbeddables(Collections.singleton(this.getSelectedEntity(artifactName, action)));
    }

    @Override
    public List<String> getArtifactsNames(DataMap dataMap) {
        if (dataMap != null) {
            return dataMap.getEmbeddables().stream().map(Embeddable::getClassName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Embeddable getSelectedEntity(String artifactName, ClassGenerationAction action) {
        DataMap dataMap = action.getCgenConfiguration().getDataMap();
        if (dataMap != null) {
            return dataMap.getEmbeddable(artifactName);
        }
        return null;
    }
}

