/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.BaseQueryMainTab;
import org.apache.cayenne.modeler.editor.RawQueryPropertiesPanel;
import org.apache.cayenne.modeler.editor.SelectPropertiesPanel;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.project.extension.info.ObjectInfo;
import org.apache.cayenne.query.CapsStrategy;

public class SQLTemplateMainTab
extends BaseQueryMainTab {
    private static final String DEFAULT_CAPS_LABEL = "Database Default";
    private static final String LOWER_CAPS_LABEL = "Force Lower Case";
    private static final String UPPER_CAPS_LABEL = "Force Upper Case";
    private static final CapsStrategy[] LABEL_CAPITALIZATION = new CapsStrategy[]{CapsStrategy.DEFAULT, CapsStrategy.LOWER, CapsStrategy.UPPER};
    private static final Map<CapsStrategy, String> labelCapsLabels = new HashMap<CapsStrategy, String>();
    protected TextAdapter comment;
    protected SelectPropertiesPanel properties;

    public SQLTemplateMainTab(ProjectController mediator) {
        super(mediator);
        this.initQueryRoot();
        this.initView();
    }

    private void initView() {
        this.name = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                SQLTemplateMainTab.this.setQueryName(text);
            }
        };
        this.comment = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                SQLTemplateMainTab.this.setQueryComment(text);
            }
        };
        this.properties = new SQLTemplateQueryPropertiesPanel(this.mediator);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:max(80dlu;pref), 3dlu, fill:max(200dlu;pref)", "p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("SQLTemplate Settings", cc.xywh(1, 1, 3, 1));
        builder.addLabel("Query Name:", cc.xy(1, 3));
        builder.add((Component)this.name.getComponent(), cc.xy(3, 3));
        builder.addLabel("Comment:", cc.xy(1, 5));
        builder.add((Component)this.comment.getComponent(), cc.xy(3, 5));
        builder.addLabel("Query Root:", cc.xy(1, 7));
        builder.add((Component)this.queryRoot, cc.xy(3, 7));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "North");
        this.add((Component)this.properties, "Center");
    }

    void initFromModel() {
        QueryDescriptor query = this.mediator.getCurrentQuery();
        if (query == null || !"SQLTemplate".equals(query.getType())) {
            this.setVisible(false);
            return;
        }
        this.name.setText(query.getName());
        this.properties.initFromModel(query);
        this.comment.setText(this.getQueryComment(query));
        DataMap map = this.mediator.getCurrentDataMap();
        ObjEntity[] roots = map.getObjEntities().toArray(new ObjEntity[0]);
        if (roots.length > 1) {
            Arrays.sort(roots, Comparators.getDataMapChildrenComparator());
        }
        DefaultComboBoxModel<ObjEntity> model = new DefaultComboBoxModel<ObjEntity>(roots);
        model.setSelectedItem(query.getRoot());
        this.queryRoot.setModel(model);
        this.setVisible(true);
    }

    @Override
    protected QueryDescriptor getQuery() {
        QueryDescriptor query = this.mediator.getCurrentQuery();
        return query != null && "SQLTemplate".equals(query.getType()) ? query : null;
    }

    ObjEntity getEntity(QueryDescriptor query) {
        return query != null && query.getRoot() instanceof ObjEntity ? (ObjEntity)query.getRoot() : null;
    }

    void setEntity(ObjEntity entity) {
        QueryDescriptor template = this.getQuery();
        if (template != null) {
            ObjEntity root = entity != null ? entity : this.mediator.getCurrentDataMap();
            template.setRoot(root);
            this.mediator.fireQueryEvent(new QueryEvent((Object)this, template));
        }
    }

    private void setQueryComment(String text) {
        QueryDescriptor query = this.getQuery();
        if (query == null) {
            return;
        }
        ObjectInfo.putToMetaData(this.mediator.getApplication().getMetaData(), query, "comment", text);
        this.mediator.fireQueryEvent(new QueryEvent((Object)this, query));
    }

    private String getQueryComment(QueryDescriptor queryDescriptor) {
        return ObjectInfo.getFromMetaData(this.mediator.getApplication().getMetaData(), queryDescriptor, "comment");
    }

    static {
        labelCapsLabels.put(CapsStrategy.DEFAULT, DEFAULT_CAPS_LABEL);
        labelCapsLabels.put(CapsStrategy.LOWER, LOWER_CAPS_LABEL);
        labelCapsLabels.put(CapsStrategy.UPPER, UPPER_CAPS_LABEL);
    }

    final class SQLTemplateQueryPropertiesPanel
    extends RawQueryPropertiesPanel {
        private JComboBox<CapsStrategy> labelCase;

        SQLTemplateQueryPropertiesPanel(ProjectController mediator) {
            super(mediator);
        }

        @Override
        protected PanelBuilder createPanelBuilder() {
            RowSpec[] extraRows;
            this.labelCase = Application.getWidgetFactory().createUndoableComboBox();
            this.labelCase.setRenderer(new LabelCapsRenderer());
            this.labelCase.addActionListener(event -> {
                CapsStrategy value = (CapsStrategy)((Object)((Object)this.labelCase.getModel().getSelectedItem()));
                this.setQueryProperty("cayenne.SQLTemplate.columnNameCapitalization", value.name());
            });
            PanelBuilder builder = super.createPanelBuilder();
            for (RowSpec extraRow : extraRows = RowSpec.decodeSpecs("3dlu, p")) {
                builder.appendRow(extraRow);
            }
            CellConstraints cc = new CellConstraints();
            builder.addLabel("Row Label Case:", cc.xy(1, 17));
            builder.add(this.labelCase, cc.xywh(3, 17, 5, 1));
            return builder;
        }

        @Override
        public void initFromModel(QueryDescriptor query) {
            super.initFromModel(query);
            if (query != null && "SQLTemplate".equals(query.getType())) {
                DefaultComboBoxModel<CapsStrategy> labelCaseModel = new DefaultComboBoxModel<CapsStrategy>(LABEL_CAPITALIZATION);
                String columnNameCapitalization = query.getProperty("cayenne.SQLTemplate.columnNameCapitalization");
                labelCaseModel.setSelectedItem((Object)(columnNameCapitalization != null ? CapsStrategy.valueOf(columnNameCapitalization) : CapsStrategy.DEFAULT));
                this.labelCase.setModel(labelCaseModel);
            }
        }

        @Override
        protected void setEntity(ObjEntity entity) {
            SQLTemplateMainTab.this.setEntity(entity);
        }

        @Override
        public ObjEntity getEntity(QueryDescriptor query) {
            if (query != null && "SQLTemplate".equals(query.getType())) {
                return SQLTemplateMainTab.this.getEntity(query);
            }
            return null;
        }

        @Override
        protected void setFetchingPersistentObjects(boolean fetchingPersistentObjects) {
            super.setFetchingPersistentObjects(fetchingPersistentObjects);
            if (!fetchingPersistentObjects) {
                this.setEntity(null);
            }
        }
    }

    final class LabelCapsRenderer
    extends DefaultListCellRenderer {
        LabelCapsRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object object, int arg2, boolean arg3, boolean arg4) {
            object = labelCapsLabels.get(object);
            return super.getListCellRendererComponent((JList<?>)list, object, arg2, arg3, arg4);
        }
    }
}

