/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db.load;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.PatternParam;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.modeler.editor.dbimport.tree.NodeType;

public class DbImportTreeNode
extends DefaultMutableTreeNode {
    private boolean isLoaded;

    public DbImportTreeNode() {
        this(null);
    }

    public DbImportTreeNode(Object userObject) {
        this(userObject, true);
    }

    private DbImportTreeNode(Object userObject, boolean allowsChildren) {
        this.userObject = userObject;
        this.allowsChildren = allowsChildren;
        this.parent = null;
        if (userObject != null && (this.isCatalog() || this.isSchema() || this.isIncludeTable())) {
            this.add(new ExpandableEnforcerNode());
        }
    }

    public boolean isIncludeTable() {
        return this.getUserObjectClass() == IncludeTable.class;
    }

    public boolean isExcludeTable() {
        return this.getUserObjectClass() == ExcludeTable.class;
    }

    public boolean isIncludeColumn() {
        return this.getUserObjectClass() == IncludeColumn.class;
    }

    public boolean isExcludeColumn() {
        return this.getUserObjectClass() == ExcludeColumn.class;
    }

    public boolean isExcludeProcedure() {
        return this.getUserObjectClass() == ExcludeProcedure.class;
    }

    public boolean isIncludeProcedure() {
        return this.getUserObjectClass() == IncludeProcedure.class;
    }

    public boolean isLabel() {
        return this.getUserObjectClass() == String.class;
    }

    public boolean isSchema() {
        return this.getUserObjectClass() == Schema.class;
    }

    public boolean isCatalog() {
        return this.getUserObjectClass() == Catalog.class;
    }

    public boolean isReverseEngineering() {
        return this.getUserObjectClass() == ReverseEngineering.class;
    }

    public Class<?> getUserObjectClass() {
        return this.getUserObject() != null ? this.getUserObject().getClass() : null;
    }

    public boolean parentsIsEqual(DbImportTreeNode reverseEngineeringNode) {
        ArrayList<DbImportTreeNode> reverseEngineeringNodeParents = reverseEngineeringNode == null ? new ArrayList() : reverseEngineeringNode.getParents();
        ArrayList<DbImportTreeNode> dbNodeParents = this.getParents();
        for (DbImportTreeNode node : reverseEngineeringNodeParents) {
            int deleteIndex = -1;
            for (int i = 0; i < dbNodeParents.size(); ++i) {
                if (!node.getSimpleNodeName().equals(dbNodeParents.get(i).getSimpleNodeName())) continue;
                deleteIndex = i;
                break;
            }
            if (deleteIndex != -1) {
                dbNodeParents.remove(deleteIndex);
                continue;
            }
            return false;
        }
        return true;
    }

    public ArrayList<DbImportTreeNode> getParents() {
        ArrayList<DbImportTreeNode> parents = new ArrayList<DbImportTreeNode>();
        DbImportTreeNode tmpNode = this;
        while (tmpNode.getParent() != null) {
            parents.add(tmpNode.getParent());
            tmpNode = tmpNode.getParent();
        }
        return parents;
    }

    @Override
    public DbImportTreeNode getParent() {
        return (DbImportTreeNode)super.getParent();
    }

    protected String getFormattedName(String className, String nodeName) {
        if (nodeName == null) {
            return className;
        }
        return String.format("%s", nodeName);
    }

    protected String getNodeName() {
        if (this.userObject instanceof FilterContainer) {
            return this.getFormattedName(this.userObject.getClass().getSimpleName(), ((FilterContainer)this.userObject).getName());
        }
        if (this.userObject instanceof PatternParam) {
            return this.getFormattedName(this.userObject.getClass().getSimpleName(), ((PatternParam)this.userObject).getPattern());
        }
        if (this.userObject != null) {
            return this.userObject.toString();
        }
        return "";
    }

    public String getSimpleNodeName() {
        if (this.userObject instanceof ReverseEngineering) {
            return "";
        }
        if (this.userObject instanceof FilterContainer) {
            return ((FilterContainer)this.userObject).getName();
        }
        if (this.userObject instanceof PatternParam) {
            return ((PatternParam)this.userObject).getPattern();
        }
        return "";
    }

    @Override
    public String toString() {
        if (this.userObject == null) {
            return "";
        }
        if (this.userObject instanceof ReverseEngineering) {
            return "Reverse Engineering Configuration:";
        }
        return this.getNodeName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DbImportTreeNode objNode = (DbImportTreeNode)obj;
        return Objects.equals(this.getSimpleNodeName(), objNode.getSimpleNodeName()) && this.getUserObjectClass() == objNode.getUserObjectClass();
    }

    public int hashCode() {
        return Objects.hash(this.getSimpleNodeName(), this.getUserObjectClass());
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean loaded) {
        this.isLoaded = loaded;
    }

    public List<DbImportTreeNode> getChildNodes() {
        return Collections.list(this.children());
    }

    public NodeType getNodeType() {
        if (this.userObject instanceof Catalog) {
            return NodeType.CATALOG;
        }
        if (this.userObject instanceof Schema) {
            return NodeType.SCHEMA;
        }
        if (this.userObject instanceof IncludeTable) {
            return NodeType.INCLUDE_TABLE;
        }
        if (this.userObject instanceof ExcludeTable) {
            return NodeType.EXCLUDE_TABLE;
        }
        if (this.userObject instanceof IncludeColumn) {
            return NodeType.INCLUDE_COLUMN;
        }
        if (this.userObject instanceof ExcludeColumn) {
            return NodeType.EXCLUDE_COLUMN;
        }
        if (this.userObject instanceof IncludeProcedure) {
            return NodeType.INCLUDE_PROCEDURE;
        }
        if (this.userObject instanceof ExcludeProcedure) {
            return NodeType.EXCLUDE_PROCEDURE;
        }
        return NodeType.UNKNOWN;
    }

    public <T> List<T> getChildrenObjectsByType(NodeType type) {
        return this.getChildNodes().stream().filter(n -> type.equals((Object)n.getNodeType())).map(filteredNode -> filteredNode.getUserObject()).collect(Collectors.toList());
    }

    @Override
    public DbImportTreeNode getLastChild() {
        return (DbImportTreeNode)super.getLastChild();
    }

    public static class ExpandableEnforcerNode
    extends DbImportTreeNode {
        public ExpandableEnforcerNode() {
            super("", false);
        }
    }
}

