/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ExpressionParserTreeConstants;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.util.CayenneMapEntry;

public abstract class ASTPath
extends SimpleNode {
    private static final long serialVersionUID = -8099822503585617295L;
    protected CayennePath path;
    protected Map<String, String> pathAliases;

    ASTPath(int i) {
        super(i);
    }

    @Override
    public int getOperandCount() {
        return 1;
    }

    @Override
    public Object getOperand(int index) {
        if (index == 0) {
            return this.path;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public void setOperand(int index, Object value) {
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.setPath(value);
    }

    protected void setPath(CayennePath path) {
        this.path = path;
    }

    protected void setPath(Object path) {
        if (path instanceof CayennePath) {
            this.setPath((CayennePath)path);
        } else {
            this.path = path != null ? CayennePath.of(path.toString()) : CayennePath.EMPTY_PATH;
        }
    }

    public CayennePath getPath() {
        return this.path;
    }

    @Override
    public Map<String, String> getPathAliases() {
        return this.pathAliases != null ? this.pathAliases : super.getPathAliases();
    }

    public void setPathAliases(Map<String, String> pathAliases) {
        this.pathAliases = pathAliases;
    }

    protected CayenneMapEntry evaluateEntityNode(Entity<?, ?, ?> entity) {
        Iterator<PathComponent<?, ?>> path = entity.resolvePath(this, this.getPathAliases()).iterator();
        PathComponent<?, ?> next = null;
        while (path.hasNext()) {
            next = path.next();
        }
        if (next == null) {
            return null;
        }
        if (next.getRelationship() != null) {
            return next.getRelationship();
        }
        return next.getAttribute();
    }

    @Override
    protected String getExpressionOperator(int index) {
        throw new UnsupportedOperationException("No operator for '" + ExpressionParserTreeConstants.jjtNodeName[this.id] + "'");
    }

    @Override
    public Expression exists() {
        return ExpressionFactory.exists(this);
    }

    @Override
    public Expression notExists() {
        return ExpressionFactory.notExists(this);
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }
}

