/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.dbsync.merge.DbEntityDictionary;
import org.apache.cayenne.dbsync.merge.Merger;
import org.apache.cayenne.dbsync.merge.MergerDictionaryDiff;
import org.apache.cayenne.dbsync.merge.MergerDiffPair;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;

abstract class AbstractMerger<T, M>
implements Merger<T> {
    private MergerDictionaryDiff<M> diff;
    private MergerTokenFactory tokenFactory;
    private DbEntityDictionary originalDictionary;

    AbstractMerger(MergerTokenFactory tokenFactory) {
        this.tokenFactory = tokenFactory;
    }

    @Override
    public List<MergerToken> createMergeTokens(T original, T imported) {
        this.diff = this.createDiff(original, imported);
        ArrayList<MergerToken> tokens = new ArrayList<MergerToken>();
        for (MergerDiffPair<M> pair : this.diff.getMissing()) {
            Collection<MergerToken> tokensForMissing = this.createTokensForMissing(pair);
            if (tokensForMissing == null) continue;
            tokens.addAll(tokensForMissing);
        }
        for (MergerDiffPair<M> pair : this.diff.getSame()) {
            Collection<MergerToken> tokensForSame = this.createTokensForSame(pair);
            if (tokensForSame == null) continue;
            tokens.addAll(tokensForSame);
        }
        return tokens;
    }

    MergerDictionaryDiff<M> getDiff() {
        return this.diff;
    }

    MergerTokenFactory getTokenFactory() {
        return this.tokenFactory;
    }

    private Collection<MergerToken> createTokensForMissing(MergerDiffPair<M> missing) {
        if (missing.getOriginal() == null) {
            return this.createTokensForMissingOriginal(missing.getImported());
        }
        return this.createTokensForMissingImported(missing.getOriginal());
    }

    public abstract List<MergerToken> createMergeTokens();

    abstract MergerDictionaryDiff<M> createDiff(T var1, T var2);

    abstract Collection<MergerToken> createTokensForMissingOriginal(M var1);

    abstract Collection<MergerToken> createTokensForMissingImported(M var1);

    abstract Collection<MergerToken> createTokensForSame(MergerDiffPair<M> var1);

    public void setOriginalDictionary(DbEntityDictionary originalDictionary) {
        this.originalDictionary = originalDictionary;
    }

    public DbEntityDictionary getOriginalDictionary() {
        return this.originalDictionary;
    }
}

