/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.firebird;

import java.util.List;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.SQLTreeProcessor;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslatorFactory;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.firebird.FirebirdActionBuilder;
import org.apache.cayenne.dba.firebird.FirebirdEJBQLTranslatorFactory;
import org.apache.cayenne.dba.firebird.FirebirdSQLTreeProcessor;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.resource.ResourceLocator;

public class FirebirdAdapter
extends JdbcAdapter {
    private static final String NCHAR_SUFFIX = " CHARACTER SET UNICODE_FSS";

    public FirebirdAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.resource_locator") ResourceLocator resourceLocator, @Inject ValueObjectTypeRegistry valueObjectTypeRegistry) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator, valueObjectTypeRegistry);
        this.setSupportsBatchUpdates(true);
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new ByteArrayType(true, false));
        map.registerType(new CharType(true, false));
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        String type = FirebirdAdapter.getType(this, column);
        String length = FirebirdAdapter.sizeAndPrecision(this, column);
        sqlBuffer.append(this.quotingStrategy.quotedName(column));
        sqlBuffer.append(' ');
        int suffixIndex = type.indexOf(NCHAR_SUFFIX);
        if (!length.isEmpty() && suffixIndex > 0) {
            sqlBuffer.append(type.substring(0, suffixIndex)).append(length).append(NCHAR_SUFFIX);
        } else {
            sqlBuffer.append(type).append(" ").append(length);
        }
        sqlBuffer.append(column.isMandatory() ? " NOT NULL" : "");
    }

    @Override
    public SQLTreeProcessor getSqlTreeProcessor() {
        return new FirebirdSQLTreeProcessor();
    }

    @Override
    public EJBQLTranslatorFactory getEjbqlTranslatorFactory() {
        return new FirebirdEJBQLTranslatorFactory();
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new FirebirdActionBuilder(node));
    }
}

