/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.ejbql;

import java.util.Iterator;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslationContext;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.Util;

class EJBQLTableId {
    private String entityId;
    private String dbPath;

    private static String appendPath(EJBQLTableId baseId, String dbPathSuffix) {
        if (baseId.getDbPath() == null) {
            return dbPathSuffix;
        }
        if (dbPathSuffix == null) {
            return baseId.getDbPath();
        }
        return baseId.getDbPath() + "." + dbPathSuffix;
    }

    EJBQLTableId(String entityId) {
        this(entityId, null);
    }

    EJBQLTableId(EJBQLTableId baseId, String dbPathSuffix) {
        this(baseId.getEntityId(), EJBQLTableId.appendPath(baseId, dbPathSuffix));
    }

    EJBQLTableId(String entityId, String dbPath) {
        if (entityId == null) {
            throw new NullPointerException("Null entityId");
        }
        this.entityId = entityId;
        this.dbPath = dbPath;
    }

    boolean isPrimaryTable() {
        return this.dbPath == null;
    }

    DbEntity getDbEntity(EJBQLTranslationContext context) {
        ClassDescriptor descriptor = context.getEntityDescriptor(this.entityId);
        DbEntity rootEntity = descriptor.getEntity().getDbEntity();
        if (this.dbPath == null) {
            return rootEntity;
        }
        DbRelationship r = null;
        Iterator<CayenneMapEntry> it = rootEntity.resolvePathComponents(this.dbPath);
        while (it.hasNext()) {
            r = (DbRelationship)it.next();
        }
        return r.getTargetEntity();
    }

    String getEntityId() {
        return this.entityId;
    }

    String getDbPath() {
        return this.dbPath;
    }

    public int hashCode() {
        int hash = this.entityId.hashCode();
        if (this.dbPath != null) {
            hash += this.dbPath.hashCode() * 7;
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EJBQLTableId)) {
            return false;
        }
        EJBQLTableId id = (EJBQLTableId)object;
        if (!Util.nullSafeEquals(this.entityId, id.entityId)) {
            return false;
        }
        return Util.nullSafeEquals(this.dbPath, id.dbPath);
    }

    public String toString() {
        return this.dbPath != null ? this.entityId + "/" + this.dbPath : this.entityId;
    }
}

