/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.ejbql;

import java.util.Map;
import org.apache.cayenne.access.translator.ejbql.EJBQLIdentifierColumnsTranslator;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.ClassDescriptor;

class EJBQLIdColumnsTranslator
extends EJBQLIdentifierColumnsTranslator {
    private EJBQLTranslationContext context;

    EJBQLIdColumnsTranslator(EJBQLTranslationContext context) {
        super(context);
        this.context = context;
    }

    @Override
    public boolean visitIdentifier(EJBQLExpression expression) {
        Map<String, String> fields = null;
        if (this.context.isAppendingResultColumns()) {
            fields = this.context.nextEntityResult().getFields();
        }
        String idVar = expression.getText();
        ClassDescriptor descriptor = this.context.getEntityDescriptor(idVar);
        ObjEntity oe = descriptor.getEntity();
        for (ObjAttribute oa : oe.getPrimaryKeys()) {
            DbAttribute t = (DbAttribute)oe.getDbEntity().getAttribute(oa.getDbAttributeName());
            this.appendColumn(idVar, oa, t, fields, oa.getType());
        }
        return false;
    }
}

