/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: HTTPBridgeConfigDocumentToHTTPBridgeConfigTransreptor.java,v $
  Version:       $Name:  $ $Revision: 1.6 $
  Last Modified: $Date: 2007/09/20 12:28:48 $
 *****************************************************************************/
package org.ten60.transport.http.bridge;

import org.ten60.netkernel.layer1.transrepresentation.*;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.urii.representation.ITransrepresentor;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.transrepresentation.*;
import com.ten60.netkernel.urii.aspect.*;

import org.ten60.transport.http.aspect.*;

import java.net.*;

/**
 * Transrepresent an HTTPBridgeConfig XML Document to a HTTPBridgeConfig
 * @author  pjr
 */
public class HTTPBridgeConfigDocumentToHTTPBridgeConfigTransreptor extends NKFTransreptorImpl
{
	
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return aTo.isAssignableFrom(IAspectHTTPBridgeConfig.class);
	}
	
	/*
	 <zone>
		<match></match>			[required]
		<to></to>				[optional]
		<processQueries/>		[optional]
		<passMethod/>			method  - GET, POST, PUT, DELETE
		<passCookies/>			cookie
		<passHeaders>HTTPHEADER-x space separated list</passHeaders>
		
		param
		[uploads]
		<exceptionURI>Special Exception Handler</exceptionURI>
	</zone>
	 */
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IXAspect doc=(IXAspect)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM, IXAspect.class);
		HTTPBridgeConfig result=new HTTPBridgeConfig();
		try
		{	// create default zone
			HTTPBridgeZone defaultZone = new HTTPBridgeZone();
			defaultZone.setMatch(".*");
			defaultZone.setProcessQueries(true);
			defaultZone.setPassCookies(true);
			if(doc.getXDA().isTrue("/HTTPBridgeConfig/defaultExceptionURI"))
			{	String exceptionURI = doc.getXDA().getText("/HTTPBridgeConfig/defaultExceptionURI", true);
				defaultZone.setExceptionURI(exceptionURI);
			}
			if(doc.getXDA().isTrue("/HTTPBridgeConfig/defaultMaximumEntitySize"))
			{	int maxSize=Integer.parseInt(doc.getXDA().getText("/HTTPBridgeConfig/defaultMaxEntitySize", true));
				defaultZone.setMaximumEntitySize(maxSize);
			}
		
			//add other zones
			IXDAReadOnlyIterator i=doc.getXDA().readOnlyIterator("/HTTPBridgeConfig/zone");
			while(i.hasNext())
			{	i.next();
				HTTPBridgeZone z=new HTTPBridgeZone();
				String match = i.getText("match", true);
				z.setMatch(match);
				if(i.isTrue("SOAPMode"))
				{   //This Zone is SOAP HTTP Binding Mode
				    z.setSOAPMode(true);
				    if(i.isTrue("SOAPConfig")) z.setSOAPConfig(i.getText("SOAPConfig",true));
				}
				else
				{   //General Options
				    z.setProcessQueries(i.isTrue("processQueries"));
				    z.setPassCookies(i.isTrue("passCookies"));
				    z.setPassMethod(i.isTrue("passMethod"));
					z.setPassByURI(i.isTrue("passByURI"));
					z.setPassRemoteHost(i.isTrue("passRemoteHost"));
				    z.setPassRequestURL(i.isTrue("passRequestURL"));
				    if(i.isTrue("passHeaders")) z.setHeaders(i.getText("passHeaders", true));
				    else z.setExceptionURI(defaultZone.getExceptionURI());
				}
				if(i.isTrue("exceptionURI")) z.setExceptionURI(i.getText("exceptionURI",true));
				else z.setExceptionURI(defaultZone.getExceptionURI());
				if(i.isTrue("maxEntitySize")) z.setMaximumEntitySize(Integer.parseInt(i.getText("maxEntitySize",true)));
				result.addZone(z);
			}
			// add default zone as last match
			result.addZone(defaultZone);
			IURAspect aspect= new HTTPBridgeConfigAspect(result);
			context.createResponseFrom(aspect);
		}
		catch(Exception e)
		{	NetKernelException nke=new NetKernelException("Failure in HTTPBridgeConfig Transreptor");
			nke.addCause(e);
			throw nke;
		}
	}
	
}