<?xml version="1.0" encoding="UTF-8" ?>


<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

    <xsl:template match="/">
        <batch>
			<sql>
				SELECT @reporter:=id FROM users WHERE login='<xsl:value-of select="/nvp/reporter/text()"/>';
			</sql>
			<sql>
				SELECT @assigned:=id FROM users WHERE login='<xsl:value-of select="/nvp/assigned_to/text()"/>';
			</sql>
			<sql>
				SELECT @qa:=id FROM users WHERE login='<xsl:value-of select="/nvp/qa_contact/text()"/>';
			</sql>
			<sql>
				UPDATE bugs SET
					reporter=@reporter,
					assigned_to=@assigned,
					qa_contact=@qa,
					title='<xsl:value-of select="/nvp/title/text()"/>',
					short_desc='<xsl:value-of select="/nvp/short_desc/text()"/>',
					buggy_file='<xsl:value-of select="/nvp/buggy_file/text()"/>',
					priority='<xsl:value-of select="/nvp/priority/text()"/>',
					bug_severity='<xsl:value-of select="/nvp/bug_severity/text()"/>',
					bug_status='<xsl:value-of select="/nvp/bug_status/text()"/>',
					status_report='<xsl:value-of select="/nvp/status_report/text()"/>',
					op_sys='<xsl:value-of select="/nvp/op_sys/text()"/>',
					jvm_version='<xsl:value-of select="/nvp/jvm_version/text()"/>',
					resolution='<xsl:value-of select="/nvp/resolution/text()"/>',
					target='<xsl:value-of select="/nvp/target/text()"/>',
					confirmed=<xsl:value-of select="/nvp/confirmed/text()"/>
				
				WHERE id=<xsl:value-of select="/nvp/id/text()"/>
				;
			</sql>
        </batch>
		
    </xsl:template>

</xsl:stylesheet>
