<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : nvp_to_updateComponents_batch.xsl
    Created on : 11 March 2004, 10:55
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

    <xsl:param name="param"/>
	<xsl:param name="token"/>
	
    <xsl:template match="/">
        <batch>
			<sql>
				SELECT @who:=userid FROM sessions WHERE token="<xsl:value-of select="$token/token/text()"/>";
			</sql>
			<xsl:apply-templates select="results/row/*"/>
		</batch>
	</xsl:template>
		
	<xsl:template match="*">
			<xsl:variable name="pos" select="position()"/>
			
			<xsl:if test="not( /results/row/*[$pos] = $param/results/row/*[$pos] )">
				<sql>
					INSERT INTO activity VALUES
						(	<xsl:value-of select="/results/row/id"/>,
							@who,
							NOW(),
							<xsl:value-of select="$pos"/>,
							'<xsl:value-of select="$param/results/row/*[$pos]"/>',
							'<xsl:value-of select="."/>'
						)
					;
				</sql>
			</xsl:if>
	</xsl:template>		
	
</xsl:stylesheet>
