<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_polls.xsl
    Created on : 29 November 2003, 09:26
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

    <xsl:template match="/">		
				<xsl:apply-templates />
	</xsl:template>
	
	<xsl:template match="null">
		<div/>
	</xsl:template>
	
	<xsl:key name="polls" match="row" use="id"/>
	
	<xsl:template match="results">
		<td class="blog-poll-column">
			<div class="blog-poll-main">
				<xsl:for-each select="row[count(. | key('polls', id)[1]) = 1]">
					<div class="blog-poll-question">
						<xsl:value-of select="question"/>
					</div>	
					<form action="xrl:vote" xrl:resolve="action" method="get">
						<input name="pollid" type="hidden">
							<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
						</input>	
						<xsl:for-each select="key('polls', id)">
							<label class="blog-poll-choice">
								<input type="radio" name="choice">
									<xsl:attribute name="value"><xsl:value-of select="choiceid"/></xsl:attribute>
									<xsl:if test="position()=1">
										<xsl:attribute name="checked">true</xsl:attribute>
									</xsl:if>
								</input>
								<xsl:value-of select="choice"/>
							</label>
						</xsl:for-each>
						<input type="submit" value="Vote" class="blog-poll-vote" />
					</form>
				</xsl:for-each>
			</div>
		</td>
    </xsl:template>

</xsl:stylesheet> 
