<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_stats_to_popularity_table.xsl
    Created on : 05 December 2003, 16:26
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

    <xsl:template match="/stats">
		<table>
			<tr>
			<td>
				<xsl:if test="last10/results/row">
					<h3>Popularity of Recent Entries</h3>
					<table width="100%" cellspacing="0" cellpadding="2">
						<tr bgcolor="#afaf9a">
							<td/>
							<td width="300">
								Title
							</td>
							<td>
								Hits
							</td>
							<td>
								Hits/Day
							</td>
						</tr>
						<xsl:for-each select="last10/results/row">
							<tr bgcolor="#dcdcc1">
								<td><xsl:value-of select="position()"/></td>
								<td>
									<a>
										<xsl:attribute name="href">entry?publicid=<xsl:value-of select="publicid"/></xsl:attribute>
										<xsl:value-of select="title"/>
									</a>
								</td>
								<td>
									<xsl:value-of select="hits"/>
								</td>
								<td>
									<xsl:value-of select="hitsPerDay"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</xsl:if>
			</td>
			<td>
				<xsl:if test="alltime/results/row">
					<h3>All Time Most Popular Entries</h3>
					<table width="100%" cellspacing="0" cellpadding="2">
						<tr bgcolor="#afaf9a">
							<td/>
							<td width="300">
								Title
							</td>
							<td>
								Hits
							</td>
						</tr>
						<xsl:for-each select="alltime/results/row">
							<tr bgcolor="#dcdcc1">
								<td><xsl:value-of select="position()"/></td>
								<td>
									<a>
										<xsl:attribute name="href">entry?publicid=<xsl:value-of select="publicid"/></xsl:attribute>
										<xsl:value-of select="title"/>
									</a>
								</td>
								<td>
									<xsl:value-of select="hits"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</xsl:if>
			</td>
			</tr>
			
			
		</table>
    </xsl:template>

</xsl:stylesheet> 
