<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

	
    <xsl:template match="/">
        <div>
			<xsl:apply-templates />
		</div>
    </xsl:template>
	
	<xsl:template match="null">
		<div style="visibilty: hidden;"/>
	</xsl:template>
	
	<xsl:template match="myblogs">
		<xsl:apply-templates select="blogs"/>
	</xsl:template>
	
	<xsl:template match="blogs">
		<xsl:apply-templates select="results"/>
	</xsl:template>
	
	<xsl:key name="blogs" match="row" use="id"/>
	
	
	<xsl:template match="results">
		<h2>My Blogs</h2>
		<table cellpadding="1" cellspacing="0" width="100%" bgcolor="#dcdcc1">
				<tr bgcolor="#afaf9a">
					<td width="20%">
					</td>
					<td width="30%">
					</td>
					<td>
					</td>
					<td colspan="2">
						<b>Comments</b>
					</td>
					<td colspan="2">
						<b>Trackbacks</b>
					</td>
					<td colspan="10" width="25%"/>
				</tr>
				<tr bgcolor="#afaf9a">
					<td width="150">
						<b>Name</b>
					</td>
					<td width="300">
						<b>Description</b>
					</td>
					<td>
						<b>Entries</b>
					</td>
					<td align="center">
						<b class="tiny">Appr</b>
					</td>
					<td align="center">
						<b class="tiny">Pend</b>
					</td>
					<td align="center">
						<b class="tiny">Appr</b>
					</td>
					<td align="center">
						<b class="tiny">Pend</b>
					</td>
					<td colspan="10"/>
				</tr>
				<xsl:for-each select="row[count(. | key('blogs', id)[1]) = 1]">
					<xsl:variable name="blogid" select="id"/>
					<tr bgcolor="#dcdcc1">
					<td>
						<xsl:value-of select="name"/>
					</td>
					<td>
						<xsl:value-of select="descr"/>
					</td>
					<td align="center" class="tiny">
						<xsl:value-of select="total_entries"/>
					</td>
					<td align="center" class="tiny">
						<xsl:value-of select="/myblogs/stats-comment/results/row[id=$blogid]/total_comments_approved"/>
					</td>
					<td align="center" class="tiny">
						<xsl:value-of select="/myblogs/stats-comment/results/row[id=$blogid]/total_comments_pending"/>
					</td>
					<td align="center" class="tiny">
						<xsl:value-of select="/myblogs/stats-trackback/results/row[id=$blogid]/total_trackbacks_approved"/>
					</td>
					<td align="center" class="tiny">
						<xsl:value-of select="/myblogs/stats-trackback/results/row[id=$blogid]/total_trackbacks_pending"/>
					</td>
					<td>
						
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="key('blogs',id)/grpname='author'">
								<span style="float: left;">
									<form action="startedit" method="post">
										<input type="submit" value="edit"/>
										<input type="hidden" name="blogid">
											<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
										</input>
									</form>
								</span>
								<span style="float: left;">
									<form action="preparestats" method="post">
										<input type="submit" value="stats"/>
										<input type="hidden" name="blogid">
											<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
										</input>
									</form>
								</span>
							</xsl:when>
							<xsl:otherwise>
								<span style="float: left;">
									<input type="submit" value="edit" disabled="true"/>
								</span>
								<span style="float: left;">
									<input type="submit" value="stats" disabled="true"/>
								</span>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="key('blogs',id)/grpname='admin'">
								<span style="float: left;">
									<form action="xrl:myblog_startmanage" xrl:resolve="action" method="post">
										<input type="submit" value="manage"/>
										<input type="hidden" name="blogid">
											<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
										</input>
									</form>
								</span>
							</xsl:when>
							<xsl:otherwise>
								<span style="float: left;">
									<input type="submit" value="manage" disabled="true"/>
								</span>
							</xsl:otherwise>
						</xsl:choose>
						
						<xsl:choose>
							<xsl:when test="key('blogs',id)/grpname='member'">
								<span style="float: left;">
									<form action="xrl:myblog_publish" xrl:resolve="action" method="post">
										<input type="submit" value="read"/>
										<input type="hidden" name="blogid">
											<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>

										</input>
										<input type="hidden" value="1" name="page"/>
										<input type="hidden" value="1" name="myblog"/>
									</form>
								</span>
							</xsl:when>
							<xsl:otherwise>
								<span style="float: left;">
									<input type="submit" value="read" disabled="true"/>
								</span>
							</xsl:otherwise>
						</xsl:choose>
					</td>
					</tr>
				</xsl:for-each>
			</table>
	</xsl:template>
	
</xsl:stylesheet> 
