<?xml version="1.0" encoding="UTF-8" ?>

<!--
    <comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Public License v1.0 - You may modifiy and
		use this software in any manner provided that any derivative work
		is licensed in compliance with the terms of the 1060 Public License.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

	<xsl:param name="param"/>
	
    <xsl:template match="/nvp">
        <nvp>
			<publicid><xsl:value-of select="substring-after($param/uri, 'guid:')"/></publicid>
			<xsl:copy-of select="url"/>
			<xsl:choose>
				<xsl:when test="title">
					<xsl:copy-of select="title"/>
				</xsl:when>
				<xsl:otherwise><title/></xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="excerpt">
					<xsl:copy-of select="excerpt"/>
				</xsl:when>
				<xsl:otherwise><excerpt/></xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="blog_name">
					<xsl:copy-of select="blog_name"/>
				</xsl:when>
				<xsl:otherwise><blog_name/></xsl:otherwise>
			</xsl:choose>
		</nvp>
    </xsl:template>

</xsl:stylesheet> 
