<?xml version="1.0" encoding="UTF-8" ?>

<!--
    <comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Public License v1.0 - You may modifiy and
		use this software in any manner provided that any derivative work
		is licensed in compliance with the terms of the 1060 Public License.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

    <xsl:template match="/stats">
		<xsl:variable name="count" select="count(month/results/row)"/>
		<chart>
		  <properties>
			<type>area</type>
			<title>Hits last month</title>
			<width>400</width>
			<height>300</height>
			<xAxisTitle>Days Ago</xAxisTitle>
			<yAxisTitle>Hits</yAxisTitle>
			<xAxisLabels>
				<xsl:call-template name="fill">
					<xsl:with-param name="count" select="0"/>
					<xsl:with-param name="total" select="31"/>
					<xsl:with-param name="type" select="'label'"/>
				</xsl:call-template>
			</xAxisLabels>
		  </properties>
		  <data>
			<dataset color="c1c1d0aa" name="Hits">
				<xsl:call-template name="fill">
					<xsl:with-param name="count" select="0"/>
					<xsl:with-param name="total" select="31"/>
					<xsl:with-param name="type" select="'point'"/>
				</xsl:call-template>
			</dataset>
		  </data>
		</chart>
        
    </xsl:template>
	
	<xsl:template name="fill">
		<xsl:param name="total"/>
		<xsl:param name="count"/>
		<xsl:param name="type"/>
		<xsl:choose>
			<xsl:when test="$count &lt; $total and $type='label'">
				<label><xsl:value-of select="$total - $count - 1"/></label>
				<xsl:call-template name="fill">
					<xsl:with-param name="count" select="$count+1"/>
					<xsl:with-param name="total" select="31"/>
					<xsl:with-param name="type" select="'label'"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$count &lt; $total and $type='point'">
				<xsl:variable name="hits" select="/stats/month/results/row[day=($total - $count - 1)]/hits"/>
				<xsl:choose>
					<xsl:when test="$hits">
						<point>
							<xsl:attribute name="y"><xsl:value-of select="$hits"/></xsl:attribute>
						</point>
					</xsl:when>
					<xsl:otherwise>
						<point y="0"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="fill">
						<xsl:with-param name="count" select="$count+1"/>
						<xsl:with-param name="total" select="31"/>
						<xsl:with-param name="type" select="'point'"/>
					</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet> 
