<?xml version="1.0" encoding="UTF-8" ?>
<!--
////////////////////////////////////////////////
//Forum StyleSheet Library
///////////////////////////////////////////////
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>
		
	<!--
	//////////////////////////////////////////////
	//A dynamic BB Form - inspired by PHPBB http://www.phpbb.org
	//////////////////////////////////////////////
	-->
	<xsl:template name="bbform">
		<xsl:param name="param"/>
		<xsl:param name="id"/>
		<div>
			<script language="JavaScript" type="text/javascript">
<xsl:comment>
// bbCode control by
// subBlue design
// www.subBlue.com
// Modifications and AJAX support by 1060 Research  www.1060research.com

////////////////////////////////////////////////
//AJAX Preview
////////////////////////////////////////////////

//Setup keyevent detection
nn=(document.layers)?true:false;
ie=(document.all)?true:false;
document.onkeyup=keyUp;
if(nn) document.captureEvents(Event.KEYUP);

//KeyPress Event Handler - Preview after Return or . or ]
function keyUp(e)
{	var evt=(e)?e:(window.event)?window.event:null;
	if(evt)
	{	var key=(evt.charCode)?evt.charCode: ((evt.keyCode)?evt.keyCode:((evt.which)?evt.which:0));
		if(key=="13" || key=="32" || key=="190" || key=="221") 
		{	ajaxPreview();
		}
	}
}

//AJAX Preview
function ajaxPreview()
{	var title=escape(post.title.value);
	var entry=escape(post.entry.value);
	var postdata="title="+title+"&amp;entry="+entry;
	loadResource("/forum/post/preview", "preview-block", postdata);
}

//AJAX Connection Methods
var con1=newConnection();

function newConnection()
{	var xml;
	if (window.XMLHttpRequest)
	{	xml = new XMLHttpRequest();
	}
	else if (window.ActiveXObject)
	{	xml = new ActiveXObject("Microsoft.XMLHTTP");
	}
	return xml;
}

function loadFragmentImpl(http, url, postdata, element_id)
{   var element = document.getElementById(element_id);
	http.open("POST",url,true);
	http.setRequestHeader("Content-Type","application/x-www-form-urlencoded; charset=UTF-8");
    http.onreadystatechange = function()
	{   if (http.readyState == 4 &amp;&amp; http.status == 200)
		{	element.innerHTML = http.responseText;
        }
    }
    http.send(postdata);
}

function loadResource(href, target, postdata)
{	loadFragmentImpl(con1, href, postdata, target);
}

//END AJAX

//////////////////////
//Special Case for Preview Login
//When session times out during an edit.
//////////////////////
function setPreviewLoginURL()
{	var value=getActionURL()+"?id="+post.id.value+"&amp;topic="+post.topic.value+"&amp;preview=true&amp;title="+escape(post.title.value)+"&amp;entry="+escape(post.entry.value);
	loginform.url.setAttribute("value", value);
	loginform.submit();
}

function getActionURL()
{	var array=window.location.href.split("?");
	return array[0];
}

function setActionURL()
{	post.setAttribute("action", getActionURL());
}

// Startup variables
var imageTag = false;
var theSelection = false;

// Check for Browser &amp; Platform for PC &amp; IE specific bits
// More details from: http://www.mozilla.org/docs/web-developer/sniffer/browser_type.html
var clientPC = navigator.userAgent.toLowerCase(); // Get client info
var clientVer = parseInt(navigator.appVersion); // Get browser version

var is_ie = ((clientPC.indexOf("msie") != -1) &amp;&amp; (clientPC.indexOf("opera") == -1));
var is_nav = ((clientPC.indexOf('mozilla')!=-1) &amp;&amp; (clientPC.indexOf('spoofer')==-1)
                &amp;&amp; (clientPC.indexOf('compatible') == -1) &amp;&amp; (clientPC.indexOf('opera')==-1)
                &amp;&amp; (clientPC.indexOf('webtv')==-1) &amp;&amp; (clientPC.indexOf('hotjava')==-1));
var is_moz = 0;

var is_win = ((clientPC.indexOf("win")!=-1) || (clientPC.indexOf("16bit") != -1));
var is_mac = (clientPC.indexOf("mac")!=-1);

// Helpline messages
b_help = "Bold text: [b]text[/b]  (alt+b)";
i_help = "Italic text: [i]text[/i]  (alt+i)";
u_help = "Underline text: [u]text[/u]  (alt+u)";
q_help = "Quote text: [quote]text[/quote]  (alt+q)";
c_help = "Code display: [code]code[/code]  (alt+c)";
x_help = "XML display: [xml]xml[/xml]  (alt+x)";
l_help = "List: [list]text[/list] (alt+l)";
o_help = "Ordered list: [list=]text[/list]  (alt+o)";
p_help = "Insert image: [img]http://image_url[/img]  (alt+p)";
w_help = "Insert URL: [url]http://url[/url] or [url=http://url]URL text[/url]  (alt+w)";
a_help = "Close all open bbCode tags";
s_help = "Font color: [color=red]text[/color]  Tip: you can also use color=#FF0000";
f_help = "Font size: [size=x-small]small text[/size]";

// Define the bbCode tags
bbcode = new Array();
bbtags = new Array('[b]','[/b]','[i]','[/i]','[u]','[/u]','[quote]','[/quote]','[code]','[/code]','[list]','[/list]','[list=]','[/list]','[img]','[/img]','[url]','[/url]','[xml]','[/xml]');
imageTag = false;

// Shows the help messages in the helpline window
function helpline(help) {
	document.post.helpbox.value = eval(help + "_help");
}


// Replacement for arrayname.length property
function getarraysize(thearray) {
	for (i = 0; i &lt; thearray.length; i++) {
		if ((thearray[i] == "undefined") || (thearray[i] == "") || (thearray[i] == null))
			return i;
		}
	return thearray.length;
}

// Replacement for arrayname.push(value) not implemented in IE until version 5.5
// Appends element to the array
function arraypush(thearray,value) {
	thearray[ getarraysize(thearray) ] = value;
}

// Replacement for arrayname.pop() not implemented in IE until version 5.5
// Removes and returns the last element of an array
function arraypop(thearray) {
	thearraysize = getarraysize(thearray);
	retval = thearray[thearraysize - 1];
	delete thearray[thearraysize - 1];
	return retval;
}


function checkForm() {
	//Must set a cleaned up version of the form action since we don't want both POST and URL queries in the submission.
	setActionURL();
	
	formErrors = false;

	if (document.post.entry.value.length &lt; 2) {
		formErrors = "You must enter a message when posting.";
	}

	if (formErrors) {
		alert(formErrors);
		return false;
	} else {
		bbstyle(-1);
		return true;
	}
}

function emoticon(text) {
	var txtarea = document.post.entry;
	text = ' ' + text + ' ';
	if (txtarea.createTextRange &amp;&amp; txtarea.caretPos) {
		var caretPos = txtarea.caretPos;
		caretPos.text = caretPos.text.charAt(caretPos.text.length - 1) == ' ' ? caretPos.text + text + ' ' : caretPos.text + text;
		txtarea.focus();
	} else {
		txtarea.value  += text;
		txtarea.focus();
	}
}

function bbfontstyle(bbopen, bbclose) {
	var txtarea = document.post.entry;

	if ((clientVer >= 4) &amp;&amp; is_ie &amp;&amp; is_win) {
		theSelection = document.selection.createRange().text;
		if (!theSelection) {
			txtarea.value += bbopen + bbclose;
			txtarea.focus();
			return;
		}
		document.selection.createRange().text = bbopen + theSelection + bbclose;
		txtarea.focus();
		return;
	}
	else if (txtarea.selectionEnd &amp;&amp; (txtarea.selectionEnd - txtarea.selectionStart > 0))
	{
		mozWrap(txtarea, bbopen, bbclose);
		return;
	}
	else
	{
		txtarea.value += bbopen + bbclose;
		txtarea.focus();
	}
	storeCaret(txtarea);
}


function bbstyle(bbnumber) {
	var txtarea = document.post.entry;

	txtarea.focus();
	donotinsert = false;
	theSelection = false;
	bblast = 0;

	if (bbnumber == -1) { // Close all open tags &amp; default button names
		while (bbcode[0]) {
			butnumber = arraypop(bbcode) - 1;
			txtarea.value += bbtags[butnumber + 1];
			buttext = eval('document.post.addbbcode' + butnumber + '.value');
			eval('document.post.addbbcode' + butnumber + '.value ="' + buttext.substr(0,(buttext.length - 1)) + '"');
		}
		imageTag = false; // All tags are closed including image tags :D
		txtarea.focus();
		return;
	}

	if ((clientVer >= 4) &amp;&amp; is_ie &amp;&amp; is_win)
	{
		theSelection = document.selection.createRange().text; // Get text selection
		if (theSelection) {
			// Add tags around selection
			document.selection.createRange().text = bbtags[bbnumber] + theSelection + bbtags[bbnumber+1];
			txtarea.focus();
			theSelection = '';
			return;
		}
	}
	else if (txtarea.selectionEnd &amp;&amp; (txtarea.selectionEnd - txtarea.selectionStart > 0))
	{
		mozWrap(txtarea, bbtags[bbnumber], bbtags[bbnumber+1]);
		return;
	}

	// Find last occurance of an open tag the same as the one just clicked
	for (i = 0; i &lt; bbcode.length; i++) {
		if (bbcode[i] == bbnumber+1) {
			bblast = i;
			donotinsert = true;
		}
	}

	if (donotinsert) {		// Close all open tags up to the one just clicked &amp; default button names
		while (bbcode[bblast]) {
				butnumber = arraypop(bbcode) - 1;
				txtarea.value += bbtags[butnumber + 1];
				buttext = eval('document.post.addbbcode' + butnumber + '.value');
				eval('document.post.addbbcode' + butnumber + '.value ="' + buttext.substr(0,(buttext.length - 1)) + '"');
				imageTag = false;
			}
			txtarea.focus();
			return;
	} else { // Open tags

		if (imageTag &amp;&amp; (bbnumber != 14)) {		// Close image tag before adding another
			txtarea.value += bbtags[15];
			lastValue = arraypop(bbcode) - 1;	// Remove the close image tag from the list
			document.post.addbbcode14.value = "Img";	// Return button back to normal state
			imageTag = false;
		}

		// Open tag
		txtarea.value += bbtags[bbnumber];
		if ((bbnumber == 14) &amp;&amp; (imageTag == false)) imageTag = 1; // Check to stop additional tags after an unclosed image tag
		arraypush(bbcode,bbnumber+1);
		eval('document.post.addbbcode'+bbnumber+'.value += "*"');
		txtarea.focus();
		return;
	}
	storeCaret(txtarea);
}

// From http://www.massless.org/mozedit/
function mozWrap(txtarea, open, close)
{
	var selLength = txtarea.textLength;
	var selStart = txtarea.selectionStart;
	var selEnd = txtarea.selectionEnd;
	if (selEnd == 1 || selEnd == 2)
		selEnd = selLength;

	var s1 = (txtarea.value).substring(0,selStart);
	var s2 = (txtarea.value).substring(selStart, selEnd)
	var s3 = (txtarea.value).substring(selEnd, selLength);
	txtarea.value = s1 + open + s2 + close + s3;
	return;
}

// Insert at Claret position. Code from
// http://www.faqts.com/knowledge_base/view.phtml/aid/1052/fid/130
function storeCaret(textEl) {
	if (textEl.createTextRange) textEl.caretPos = document.selection.createRange().duplicate();
}

</xsl:comment>
</script>
			<form action="" method="POST" name="post" ENCTYPE="application/x-www-form-urlencoded" accept-charset="ISO-8859-1" onsubmit="return checkForm(this)">
				<input type="hidden" name="id" value="{$param/nvp/id}"/>
				<input type="hidden" name="topic" value="{$param/nvp/id}"/>
				<input type="hidden" name="summary"/>
				<table class="title-table" style="margin-bottom: 5px; padding-right: 25px;">
							  <tr align="center" valign="middle">
							  <td/>
			<td>
			  <input type="button" class="button" accesskey="b" name="addbbcode0" value=" B " style="font-weight:bold; width: 30px" onClick="bbstyle(0); ajaxPreview();" onMouseOver="helpline('b')" />
			  </td>
			<td>
			  <input type="button" class="button" accesskey="i" name="addbbcode2" value=" i " style="font-style:italic; width: 30px" onClick="bbstyle(2); ajaxPreview();" onMouseOver="helpline('i')" />
			  </td>
			<td>
			  <input type="button" class="button" accesskey="u" name="addbbcode4" value=" u " style="text-decoration: underline; width: 30px" onClick="bbstyle(4); ajaxPreview();" onMouseOver="helpline('u')" />

			 </td>
			<td>
			  <input type="button" class="button" accesskey="q" name="addbbcode6" value="Quote" style="width: 50px" onClick="bbstyle(6); ajaxPreview();" onMouseOver="helpline('q')" />
			 </td>
			<td>
			  <input type="button" class="button" accesskey="c" name="addbbcode8" value="Code" style="width: 40px" onClick="bbstyle(8); ajaxPreview();" onMouseOver="helpline('c')" />
			 </td>
			 <td>
			  <input type="button" class="button" accesskey="x" name="addbbcode8" value="XML" style="width: 40px" onClick="bbstyle(18); ajaxPreview();" onMouseOver="helpline('x')" />
			 </td>
			 <!--
			<td>
			  <input type="button" class="button" accesskey="l" name="addbbcode10" value="List" style="width: 40px" onClick="bbstyle(10)" onMouseOver="helpline('l')" />

			 </td>
			<td>
			  <input type="button" class="button" accesskey="o" name="addbbcode12" value="List=" style="width: 40px" onClick="bbstyle(12)" onMouseOver="helpline('o')" />
			 </td>
			 -->
			<td>
			  <input type="button" class="button" accesskey="p" name="addbbcode14" value="Img" style="width: 40px"  onClick="bbstyle(14); ajaxPreview();" onMouseOver="helpline('p')" />
			 </td>
			<td>
			  <input type="button" class="button" accesskey="w" name="addbbcode16" value="URL" style="text-decoration: underline; width: 40px" onClick="bbstyle(16); ajaxPreview();" onMouseOver="helpline('w')" />

			 </td>
		  </tr>
		  <tr>
			<td/>
			<td colspan="9">
			  <table width="100%" border="0" cellspacing="0" cellpadding="0">
				<tr>
				  <td> Font colour:
					<select name="addbbcode18" onChange="bbfontstyle('[color=' + this.form.addbbcode18.options[this.form.addbbcode18.selectedIndex].value + ']', '[/color]');this.selectedIndex=0; ajaxPreview();" onMouseOver="helpline('s')">
					  <option style="color:black; background-color: #FAFAFA" value="#444444" class="genmed">Default</option>

					  <option style="color:darkred; background-color: #FAFAFA" value="darkred" class="genmed">Dark Red</option>
					  <option style="color:red; background-color: #FAFAFA" value="red" class="genmed">Red</option>
					  <option style="color:orange; background-color: #FAFAFA" value="orange" class="genmed">Orange</option>
					  <option style="color:brown; background-color: #FAFAFA" value="brown" class="genmed">Brown</option>
					  <option style="color:yellow; background-color: #FAFAFA" value="yellow" class="genmed">Yellow</option>
					  <option style="color:green; background-color: #FAFAFA" value="green" class="genmed">Green</option>

					  <option style="color:olive; background-color: #FAFAFA" value="olive" class="genmed">Olive</option>
					  <option style="color:cyan; background-color: #FAFAFA" value="cyan" class="genmed">Cyan</option>
					  <option style="color:blue; background-color: #FAFAFA" value="blue" class="genmed">Blue</option>
					  <option style="color:darkblue; background-color: #FAFAFA" value="darkblue" class="genmed">Dark Blue</option>
					  <option style="color:indigo; background-color: #FAFAFA" value="indigo" class="genmed">Indigo</option>
					  <option style="color:violet; background-color: #FAFAFA" value="violet" class="genmed">Violet</option>

					  <option style="color:white; background-color: #FAFAFA" value="white" class="genmed">White</option>
					  <option style="color:black; background-color: #FAFAFA" value="black" class="genmed">Black</option>
					</select> Font size:<select name="addbbcode20" onChange="bbfontstyle('[size=' + this.form.addbbcode20.options[this.form.addbbcode20.selectedIndex].value + ']', '[/size]');  ajaxPreview();" onMouseOver="helpline('f')">
					  <option value="1" class="genmed">Tiny</option>
					  <option value="2" class="genmed">Small</option>
					  <option value="3" selected="true" class="genmed">Normal</option>

					  <option value="5" class="genmed">Large</option>
					  <option  value="10" class="genmed">Huge</option>
					</select>
					</td>
				  <td nowrap="nowrap" align="right"></td>
				</tr>
			  </table>

			</td>
		  </tr>
					<tr>
						<td/>
						
						<td colspan="9">
							<input name="helpbox" style="width:500px; font-weight: bold;" disabled="true"/>
						</td>		
					</tr>
					<tr>
						<td>Subject:</td>
						
						<td colspan="9">
							<input name="title" style="width:500px" onBlur="ajaxPreview();">
								<xsl:if test="$param/nvp/preview">
									<xsl:attribute name="value"><xsl:value-of select="$param/nvp/title"/></xsl:attribute>
								</xsl:if>
							</input>
						</td>		
					</tr>
					<tr>
						<td>Message:</td>
						<td colspan="9">
						<textarea style="width: 500px; height: 150px;" name="entry"><xsl:if test="$param/nvp/preview"><xsl:value-of select="$param/nvp/entry"/></xsl:if></textarea>
						</td>		
					</tr>
					<tr>
						<td/>
						<td colspan="9">
						<center>
							<input type="button" value="Manualy Refresh Preview" style="float: left;" onClick="ajaxPreview()"/>
							<!--<input type="submit" name="preview" value="Full Page Reload" style="float: right;"/>-->
							<input type="submit" name="submit" value="Submit" style="float: right;"/>
						</center>
						</td>
					</tr>
				</table>
			</form>
			<script language="JavaScript" type="text/javascript">
			post.title.focus();
			</script>
		</div>
	</xsl:template>
	
</xsl:stylesheet> 
