<?php
/*------------------------------------------------------------------------------
Copyright (c) 2004, 2005 thaler

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

$Id$

You may retrieve the latest version of this file at the tsWebEditor home page,
located at http://tswebeditor.tigris.org

Known Issues:
------------------------------------------------------------------------------*/

include 'dbobjs.class.php';

define('CRLF', "\r\n");
define('CRLF2P', CRLF . '  ');


abstract class basedb
{
  protected $props;
  protected $dblink;

  function __construct($properties) {
    $this->props = $properties;
    $this->testRequs();
  }
  
  function __destruct() {
    if($this->isConnected())
      $this->CloseConnect();
  }

  protected abstract function testRequs();
  protected abstract function OpenConnect();
  protected abstract function isConnected();
  protected abstract function CloseConnect();
  public abstract function testConnection();
  protected abstract function DoImportDB(ObjList $ObjList, $filter);
  protected abstract function DoGenerateDDL(ObjList $DataDict, ObjList $ObjList, &$ddl);
  protected abstract function DoExecuteDDL($ddl);
  
  public function getProp($name)
  {
    if(isset($this->props[$name]))
      return $this->props[$name];
    else
      return '';
  }
  
  static protected function Log($msg) {
    print '  ' . $msg . "\n";
  }
  
  static protected function Hint($msg) {
    print '+ ' . $msg . "\n";
  }
  
  static protected function Warn($msg) {
    print '~ ' . $msg . "\n";
  }
  
  public function ImportDB(ObjList $ObjList, $filter) {
    self::Log('Loading Database Model ...');
    $this->DoImportDB($ObjList, $filter);
    self::Log('Ready.');
  }
  
  public function GenerateDDL(ObjList $DataDict, ObjList $ObjList, &$ddl) {
    self::Log('Generate DDL ...');
    $this->DoGenerateDDL($DataDict, $ObjList, $ddl);
    self::Log('Ready.');
  }
  
  public function ExecuteDDL($ddl) {
    $this->DoExecuteDDL($ddl);
  }
}

?>