<?php
require('includes/session.inc.php');
require('includes/config.inc.php');
require('includes/functions.inc.php');
require('includes/styles.inc.php');

/* Login check */
if (!isLoggedIn())
{
	printError("Sorry, you must be logged in to view this");
	exit;
}

/* Does the user have credentials to view this? */
if (!checkSecurity())
{
	printError("Sorry, you do not have the credentials to view this page");
	exit;
}

/* Don't print anything if no GET req */
if (!$_GET[note])
{
	echo "<p align='center'>Please select a note above</p>";
	exit;
}

/* Filter bogus notes */
if ($_GET[note] && $_GET[note] != "" && (!is_numeric($_GET[note])))
{
	printError("You must pass a problem in GET! Please do not call this script directly");
	exit;
}

$note = $_GET[note];

/* SQL */
require("includes/db.inc.php");
$query = "SELECT * FROM $tbl_notes WHERE note_id = $note";
$result = pg_exec($query) or die("Query failed : " . pg_last_error($connection));


if (pg_num_rows($result) < 1)
{
	printError("No such note!");
	exit;
}


$row = pg_fetch_object($result);

/* Print note */
echo "<div align='center'>";
echo "<i>Author: $row->author</i><br>\n";
echo "<i>Written: $row->date</i><br>\n";
echo "<br>\n<i>$row->text</i>";
echo "</div>";
?>
