/*
 * Copyright (c) 2016, 2020 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "TextEncoderStreamBuiltins.h"

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/ImplementationVisibility.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSObjectInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_textEncoderStreamInitializeTextEncoderStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_textEncoderStreamInitializeTextEncoderStreamCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_textEncoderStreamInitializeTextEncoderStreamCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_textEncoderStreamInitializeTextEncoderStreamCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_textEncoderStreamInitializeTextEncoderStreamCodeLength = 1623;
static const JSC::Intrinsic s_textEncoderStreamInitializeTextEncoderStreamCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_textEncoderStreamInitializeTextEncoderStreamCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const startAlgorithm = () => {\n" \
    "        return @Promise.@resolve();\n" \
    "    };\n" \
    "    const transformAlgorithm = (chunk) => {\n" \
    "        const encoder = @getByIdDirectPrivate(this, \"textEncoderStreamEncoder\");\n" \
    "        let buffer;\n" \
    "        try {\n" \
    "            buffer = encoder.@encode(chunk);\n" \
    "        } catch (e) {\n" \
    "            return @Promise.@reject(e);\n" \
    "        }\n" \
    "        if (buffer) {\n" \
    "            const transformStream = @getByIdDirectPrivate(this, \"textEncoderStreamTransform\");\n" \
    "            const controller = @getByIdDirectPrivate(transformStream, \"controller\");\n" \
    "            @transformStreamDefaultControllerEnqueue(controller, buffer);\n" \
    "        }\n" \
    "        return @Promise.@resolve();\n" \
    "    };\n" \
    "    const flushAlgorithm = () => {\n" \
    "        const encoder = @getByIdDirectPrivate(this, \"textEncoderStreamEncoder\");\n" \
    "        const buffer = encoder.@flush();\n" \
    "        if (buffer) {\n" \
    "            const transformStream = @getByIdDirectPrivate(this, \"textEncoderStreamTransform\");\n" \
    "            const controller = @getByIdDirectPrivate(transformStream, \"controller\");\n" \
    "            @transformStreamDefaultControllerEnqueue(controller, buffer);\n" \
    "        }\n" \
    "        return @Promise.@resolve();\n" \
    "    };\n" \
    "\n" \
    "    const [transform, readable, writable] = @createTransformStream(startAlgorithm, transformAlgorithm, flushAlgorithm);\n" \
    "    @putByIdDirectPrivate(this, \"textEncoderStreamTransform\", transform);\n" \
    "    @putByIdDirectPrivate(this, \"textEncoderStreamEncoder\", new @TextEncoderStreamEncoder());\n" \
    "    @putByIdDirectPrivate(this, \"readable\", readable);\n" \
    "    @putByIdDirectPrivate(this, \"writable\", writable);\n" \
    "\n" \
    "    return this;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_textEncoderStreamEncodingCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_textEncoderStreamEncodingCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_textEncoderStreamEncodingCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_textEncoderStreamEncodingCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_textEncoderStreamEncodingCodeLength = 193;
static const JSC::Intrinsic s_textEncoderStreamEncodingCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_textEncoderStreamEncodingCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@getByIdDirectPrivate(this, \"textEncoderStreamTransform\"))\n" \
    "        throw @makeThisTypeError(\"TextEncoderStream\", \"encoding\");\n" \
    "\n" \
    "    return \"utf-8\";\n" \
    "})\n" \
;

const JSC::ConstructAbility s_textEncoderStreamReadableCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_textEncoderStreamReadableCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_textEncoderStreamReadableCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_textEncoderStreamReadableCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_textEncoderStreamReadableCodeLength = 258;
static const JSC::Intrinsic s_textEncoderStreamReadableCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_textEncoderStreamReadableCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const transform = @getByIdDirectPrivate(this, \"textEncoderStreamTransform\");\n" \
    "    if (!transform)\n" \
    "        throw @makeThisTypeError(\"TextEncoderStream\", \"readable\");\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"readable\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_textEncoderStreamWritableCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_textEncoderStreamWritableCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_textEncoderStreamWritableCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_textEncoderStreamWritableCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_textEncoderStreamWritableCodeLength = 258;
static const JSC::Intrinsic s_textEncoderStreamWritableCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_textEncoderStreamWritableCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const transform = @getByIdDirectPrivate(this, \"textEncoderStreamTransform\");\n" \
    "    if (!transform)\n" \
    "        throw @makeThisTypeError(\"TextEncoderStream\", \"writable\");\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"writable\");\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().textEncoderStreamBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().textEncoderStreamBuiltins().codeName##Source(), std::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_TEXTENCODERSTREAM_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore
