/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLMultiDrawInstancedBaseVertexBaseInstance.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebGLMultiDrawInstancedBaseVertexBaseInstancePrototypeFunction_multiDrawArraysInstancedBaseInstanceWEBGL);
static JSC_DECLARE_HOST_FUNCTION(jsWebGLMultiDrawInstancedBaseVertexBaseInstancePrototypeFunction_multiDrawElementsInstancedBaseVertexBaseInstanceWEBGL);

class JSWebGLMultiDrawInstancedBaseVertexBaseInstancePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLMultiDrawInstancedBaseVertexBaseInstancePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLMultiDrawInstancedBaseVertexBaseInstancePrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLMultiDrawInstancedBaseVertexBaseInstancePrototype>(vm)) JSWebGLMultiDrawInstancedBaseVertexBaseInstancePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLMultiDrawInstancedBaseVertexBaseInstancePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLMultiDrawInstancedBaseVertexBaseInstancePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLMultiDrawInstancedBaseVertexBaseInstancePrototype, JSWebGLMultiDrawInstancedBaseVertexBaseInstancePrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLMultiDrawInstancedBaseVertexBaseInstancePrototypeTableValues[] =
{
    { "multiDrawArraysInstancedBaseInstanceWEBGL"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLMultiDrawInstancedBaseVertexBaseInstancePrototypeFunction_multiDrawArraysInstancedBaseInstanceWEBGL, 10 } },
    { "multiDrawElementsInstancedBaseVertexBaseInstanceWEBGL"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLMultiDrawInstancedBaseVertexBaseInstancePrototypeFunction_multiDrawElementsInstancedBaseVertexBaseInstanceWEBGL, 13 } },
};

const ClassInfo JSWebGLMultiDrawInstancedBaseVertexBaseInstancePrototype::s_info = { "WebGLMultiDrawInstancedBaseVertexBaseInstance"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLMultiDrawInstancedBaseVertexBaseInstancePrototype) };

void JSWebGLMultiDrawInstancedBaseVertexBaseInstancePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLMultiDrawInstancedBaseVertexBaseInstance::info(), JSWebGLMultiDrawInstancedBaseVertexBaseInstancePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLMultiDrawInstancedBaseVertexBaseInstance::s_info = { "WebGLMultiDrawInstancedBaseVertexBaseInstance"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLMultiDrawInstancedBaseVertexBaseInstance) };

JSWebGLMultiDrawInstancedBaseVertexBaseInstance::JSWebGLMultiDrawInstancedBaseVertexBaseInstance(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLMultiDrawInstancedBaseVertexBaseInstance>&& impl)
    : JSDOMWrapper<WebGLMultiDrawInstancedBaseVertexBaseInstance>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLMultiDrawInstancedBaseVertexBaseInstance>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLMultiDrawInstancedBaseVertexBaseInstance::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLMultiDrawInstancedBaseVertexBaseInstancePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLMultiDrawInstancedBaseVertexBaseInstancePrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLMultiDrawInstancedBaseVertexBaseInstance::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLMultiDrawInstancedBaseVertexBaseInstance>(vm, globalObject);
}

void JSWebGLMultiDrawInstancedBaseVertexBaseInstance::destroy(JSC::JSCell* cell)
{
    JSWebGLMultiDrawInstancedBaseVertexBaseInstance* thisObject = static_cast<JSWebGLMultiDrawInstancedBaseVertexBaseInstance*>(cell);
    thisObject->JSWebGLMultiDrawInstancedBaseVertexBaseInstance::~JSWebGLMultiDrawInstancedBaseVertexBaseInstance();
}

static inline JSC::EncodedJSValue jsWebGLMultiDrawInstancedBaseVertexBaseInstancePrototypeFunction_multiDrawArraysInstancedBaseInstanceWEBGLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLMultiDrawInstancedBaseVertexBaseInstance>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 10))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto modeConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(modeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto firstsListConversionResult = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(firstsListConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto firstsOffsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(firstsOffsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto countsListConversionResult = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument3.value());
    if (UNLIKELY(countsListConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto countsOffsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument4.value());
    if (UNLIKELY(countsOffsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto instanceCountsListConversionResult = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument5.value());
    if (UNLIKELY(instanceCountsListConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto instanceCountsOffsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument6.value());
    if (UNLIKELY(instanceCountsOffsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument7 = callFrame->uncheckedArgument(7);
    auto baseInstancesListConversionResult = convert<IDLUnion<IDLUint32Array, IDLSequence<IDLUnsignedLong>>>(*lexicalGlobalObject, argument7.value());
    if (UNLIKELY(baseInstancesListConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument8 = callFrame->uncheckedArgument(8);
    auto baseInstancesOffsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument8.value());
    if (UNLIKELY(baseInstancesOffsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument9 = callFrame->uncheckedArgument(9);
    auto drawcountConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument9.value());
    if (UNLIKELY(drawcountConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.multiDrawArraysInstancedBaseInstanceWEBGL(modeConversionResult.releaseReturnValue(), firstsListConversionResult.releaseReturnValue(), firstsOffsetConversionResult.releaseReturnValue(), countsListConversionResult.releaseReturnValue(), countsOffsetConversionResult.releaseReturnValue(), instanceCountsListConversionResult.releaseReturnValue(), instanceCountsOffsetConversionResult.releaseReturnValue(), baseInstancesListConversionResult.releaseReturnValue(), baseInstancesOffsetConversionResult.releaseReturnValue(), drawcountConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLMultiDrawInstancedBaseVertexBaseInstancePrototypeFunction_multiDrawArraysInstancedBaseInstanceWEBGL, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLMultiDrawInstancedBaseVertexBaseInstance>::call<jsWebGLMultiDrawInstancedBaseVertexBaseInstancePrototypeFunction_multiDrawArraysInstancedBaseInstanceWEBGLBody>(*lexicalGlobalObject, *callFrame, "multiDrawArraysInstancedBaseInstanceWEBGL");
}

static inline JSC::EncodedJSValue jsWebGLMultiDrawInstancedBaseVertexBaseInstancePrototypeFunction_multiDrawElementsInstancedBaseVertexBaseInstanceWEBGLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLMultiDrawInstancedBaseVertexBaseInstance>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 13))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto modeConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(modeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto countsListConversionResult = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(countsListConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto countsOffsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(countsOffsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto typeConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument3.value());
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto offsetsListConversionResult = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument4.value());
    if (UNLIKELY(offsetsListConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto offsetsOffsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument5.value());
    if (UNLIKELY(offsetsOffsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto instanceCountsListConversionResult = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument6.value());
    if (UNLIKELY(instanceCountsListConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument7 = callFrame->uncheckedArgument(7);
    auto instanceCountsOffsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument7.value());
    if (UNLIKELY(instanceCountsOffsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument8 = callFrame->uncheckedArgument(8);
    auto baseVerticesListConversionResult = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument8.value());
    if (UNLIKELY(baseVerticesListConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument9 = callFrame->uncheckedArgument(9);
    auto baseVerticesOffsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument9.value());
    if (UNLIKELY(baseVerticesOffsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument10 = callFrame->uncheckedArgument(10);
    auto baseInstancesListConversionResult = convert<IDLUnion<IDLUint32Array, IDLSequence<IDLUnsignedLong>>>(*lexicalGlobalObject, argument10.value());
    if (UNLIKELY(baseInstancesListConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument11 = callFrame->uncheckedArgument(11);
    auto baseInstancesOffsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument11.value());
    if (UNLIKELY(baseInstancesOffsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument12 = callFrame->uncheckedArgument(12);
    auto drawcountConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument12.value());
    if (UNLIKELY(drawcountConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.multiDrawElementsInstancedBaseVertexBaseInstanceWEBGL(modeConversionResult.releaseReturnValue(), countsListConversionResult.releaseReturnValue(), countsOffsetConversionResult.releaseReturnValue(), typeConversionResult.releaseReturnValue(), offsetsListConversionResult.releaseReturnValue(), offsetsOffsetConversionResult.releaseReturnValue(), instanceCountsListConversionResult.releaseReturnValue(), instanceCountsOffsetConversionResult.releaseReturnValue(), baseVerticesListConversionResult.releaseReturnValue(), baseVerticesOffsetConversionResult.releaseReturnValue(), baseInstancesListConversionResult.releaseReturnValue(), baseInstancesOffsetConversionResult.releaseReturnValue(), drawcountConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLMultiDrawInstancedBaseVertexBaseInstancePrototypeFunction_multiDrawElementsInstancedBaseVertexBaseInstanceWEBGL, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLMultiDrawInstancedBaseVertexBaseInstance>::call<jsWebGLMultiDrawInstancedBaseVertexBaseInstancePrototypeFunction_multiDrawElementsInstancedBaseVertexBaseInstanceWEBGLBody>(*lexicalGlobalObject, *callFrame, "multiDrawElementsInstancedBaseVertexBaseInstanceWEBGL");
}

JSC::GCClient::IsoSubspace* JSWebGLMultiDrawInstancedBaseVertexBaseInstance::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLMultiDrawInstancedBaseVertexBaseInstance, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLMultiDrawInstancedBaseVertexBaseInstance.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLMultiDrawInstancedBaseVertexBaseInstance = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLMultiDrawInstancedBaseVertexBaseInstance.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLMultiDrawInstancedBaseVertexBaseInstance = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLMultiDrawInstancedBaseVertexBaseInstance::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLMultiDrawInstancedBaseVertexBaseInstance*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLMultiDrawInstancedBaseVertexBaseInstanceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsWebGLMultiDrawInstancedBaseVertexBaseInstance = jsCast<JSWebGLMultiDrawInstancedBaseVertexBaseInstance*>(handle.slot()->asCell());
    auto& owner = jsWebGLMultiDrawInstancedBaseVertexBaseInstance->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsWebGLMultiDrawInstancedBaseVertexBaseInstance"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLMultiDrawInstancedBaseVertexBaseInstanceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLMultiDrawInstancedBaseVertexBaseInstance = static_cast<JSWebGLMultiDrawInstancedBaseVertexBaseInstance*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLMultiDrawInstancedBaseVertexBaseInstance->protectedWrapped().ptr(), jsWebGLMultiDrawInstancedBaseVertexBaseInstance);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLMultiDrawInstancedBaseVertexBaseInstance@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore45WebGLMultiDrawInstancedBaseVertexBaseInstanceE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, WebGLMultiDrawInstancedBaseVertexBaseInstance>, void>> static inline void verifyVTable(WebGLMultiDrawInstancedBaseVertexBaseInstance* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLMultiDrawInstancedBaseVertexBaseInstance@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore45WebGLMultiDrawInstancedBaseVertexBaseInstanceE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLMultiDrawInstancedBaseVertexBaseInstance has subclasses. If WebGLMultiDrawInstancedBaseVertexBaseInstance has subclasses that get passed
        // to toJS() we currently require WebGLMultiDrawInstancedBaseVertexBaseInstance you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLMultiDrawInstancedBaseVertexBaseInstance>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebGLMultiDrawInstancedBaseVertexBaseInstance>(impl.ptr());
#endif
    return createWrapper<WebGLMultiDrawInstancedBaseVertexBaseInstance>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLMultiDrawInstancedBaseVertexBaseInstance& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLMultiDrawInstancedBaseVertexBaseInstance* JSWebGLMultiDrawInstancedBaseVertexBaseInstance::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLMultiDrawInstancedBaseVertexBaseInstance*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
