/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSPannerOptions.h"

#include "JSChannelCountMode.h"
#include "JSChannelInterpretation.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDistanceModelType.h"
#include "JSPanningModelType.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> ConversionResult<IDLDictionary<PannerOptions>> convertDictionary<PannerOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    PannerOptions result;
    JSValue channelCountValue;
    if (isNullOrUndefined)
        channelCountValue = jsUndefined();
    else {
        channelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!channelCountValue.isUndefined()) {
        auto channelCountConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, channelCountValue);
        if (UNLIKELY(channelCountConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.channelCount = channelCountConversionResult.releaseReturnValue();
    }
    JSValue channelCountModeValue;
    if (isNullOrUndefined)
        channelCountModeValue = jsUndefined();
    else {
        channelCountModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCountMode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!channelCountModeValue.isUndefined()) {
        auto channelCountModeConversionResult = convert<IDLEnumeration<ChannelCountMode>>(lexicalGlobalObject, channelCountModeValue);
        if (UNLIKELY(channelCountModeConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.channelCountMode = channelCountModeConversionResult.releaseReturnValue();
    }
    JSValue channelInterpretationValue;
    if (isNullOrUndefined)
        channelInterpretationValue = jsUndefined();
    else {
        channelInterpretationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelInterpretation"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!channelInterpretationValue.isUndefined()) {
        auto channelInterpretationConversionResult = convert<IDLEnumeration<ChannelInterpretation>>(lexicalGlobalObject, channelInterpretationValue);
        if (UNLIKELY(channelInterpretationConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.channelInterpretation = channelInterpretationConversionResult.releaseReturnValue();
    }
    JSValue coneInnerAngleValue;
    if (isNullOrUndefined)
        coneInnerAngleValue = jsUndefined();
    else {
        coneInnerAngleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "coneInnerAngle"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto coneInnerAngleConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, coneInnerAngleValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 360 }; });
    if (UNLIKELY(coneInnerAngleConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.coneInnerAngle = coneInnerAngleConversionResult.releaseReturnValue();
    JSValue coneOuterAngleValue;
    if (isNullOrUndefined)
        coneOuterAngleValue = jsUndefined();
    else {
        coneOuterAngleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "coneOuterAngle"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto coneOuterAngleConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, coneOuterAngleValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 360 }; });
    if (UNLIKELY(coneOuterAngleConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.coneOuterAngle = coneOuterAngleConversionResult.releaseReturnValue();
    JSValue coneOuterGainValue;
    if (isNullOrUndefined)
        coneOuterGainValue = jsUndefined();
    else {
        coneOuterGainValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "coneOuterGain"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto coneOuterGainConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, coneOuterGainValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0 }; });
    if (UNLIKELY(coneOuterGainConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.coneOuterGain = coneOuterGainConversionResult.releaseReturnValue();
    JSValue distanceModelValue;
    if (isNullOrUndefined)
        distanceModelValue = jsUndefined();
    else {
        distanceModelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "distanceModel"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto distanceModelConversionResult = convertOptionalWithDefault<IDLEnumeration<DistanceModelType>>(lexicalGlobalObject, distanceModelValue, [&]() -> ConversionResult<IDLEnumeration<DistanceModelType>> { return Converter<IDLEnumeration<DistanceModelType>>::ReturnType { DistanceModelType::Inverse }; });
    if (UNLIKELY(distanceModelConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.distanceModel = distanceModelConversionResult.releaseReturnValue();
    JSValue maxDistanceValue;
    if (isNullOrUndefined)
        maxDistanceValue = jsUndefined();
    else {
        maxDistanceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxDistance"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto maxDistanceConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, maxDistanceValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 10000 }; });
    if (UNLIKELY(maxDistanceConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.maxDistance = maxDistanceConversionResult.releaseReturnValue();
    JSValue orientationXValue;
    if (isNullOrUndefined)
        orientationXValue = jsUndefined();
    else {
        orientationXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "orientationX"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto orientationXConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, orientationXValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 1 }; });
    if (UNLIKELY(orientationXConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.orientationX = orientationXConversionResult.releaseReturnValue();
    JSValue orientationYValue;
    if (isNullOrUndefined)
        orientationYValue = jsUndefined();
    else {
        orientationYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "orientationY"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto orientationYConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, orientationYValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0 }; });
    if (UNLIKELY(orientationYConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.orientationY = orientationYConversionResult.releaseReturnValue();
    JSValue orientationZValue;
    if (isNullOrUndefined)
        orientationZValue = jsUndefined();
    else {
        orientationZValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "orientationZ"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto orientationZConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, orientationZValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0 }; });
    if (UNLIKELY(orientationZConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.orientationZ = orientationZConversionResult.releaseReturnValue();
    JSValue panningModelValue;
    if (isNullOrUndefined)
        panningModelValue = jsUndefined();
    else {
        panningModelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "panningModel"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto panningModelConversionResult = convertOptionalWithDefault<IDLEnumeration<PanningModelType>>(lexicalGlobalObject, panningModelValue, [&]() -> ConversionResult<IDLEnumeration<PanningModelType>> { return Converter<IDLEnumeration<PanningModelType>>::ReturnType { PanningModelType::Equalpower }; });
    if (UNLIKELY(panningModelConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.panningModel = panningModelConversionResult.releaseReturnValue();
    JSValue positionXValue;
    if (isNullOrUndefined)
        positionXValue = jsUndefined();
    else {
        positionXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "positionX"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto positionXConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, positionXValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0 }; });
    if (UNLIKELY(positionXConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.positionX = positionXConversionResult.releaseReturnValue();
    JSValue positionYValue;
    if (isNullOrUndefined)
        positionYValue = jsUndefined();
    else {
        positionYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "positionY"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto positionYConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, positionYValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0 }; });
    if (UNLIKELY(positionYConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.positionY = positionYConversionResult.releaseReturnValue();
    JSValue positionZValue;
    if (isNullOrUndefined)
        positionZValue = jsUndefined();
    else {
        positionZValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "positionZ"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto positionZConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, positionZValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0 }; });
    if (UNLIKELY(positionZConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.positionZ = positionZConversionResult.releaseReturnValue();
    JSValue refDistanceValue;
    if (isNullOrUndefined)
        refDistanceValue = jsUndefined();
    else {
        refDistanceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "refDistance"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto refDistanceConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, refDistanceValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 1 }; });
    if (UNLIKELY(refDistanceConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.refDistance = refDistanceConversionResult.releaseReturnValue();
    JSValue rolloffFactorValue;
    if (isNullOrUndefined)
        rolloffFactorValue = jsUndefined();
    else {
        rolloffFactorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rolloffFactor"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto rolloffFactorConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, rolloffFactorValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 1 }; });
    if (UNLIKELY(rolloffFactorConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.rolloffFactor = rolloffFactorConversionResult.releaseReturnValue();
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
