/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNodeIterator.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "JSNodeFilter.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsNodeIteratorPrototypeFunction_nextNode);
static JSC_DECLARE_HOST_FUNCTION(jsNodeIteratorPrototypeFunction_previousNode);
static JSC_DECLARE_HOST_FUNCTION(jsNodeIteratorPrototypeFunction_detach);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsNodeIteratorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsNodeIterator_root);
static JSC_DECLARE_CUSTOM_GETTER(jsNodeIterator_referenceNode);
static JSC_DECLARE_CUSTOM_GETTER(jsNodeIterator_pointerBeforeReferenceNode);
static JSC_DECLARE_CUSTOM_GETTER(jsNodeIterator_whatToShow);
static JSC_DECLARE_CUSTOM_GETTER(jsNodeIterator_filter);

class JSNodeIteratorPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSNodeIteratorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNodeIteratorPrototype* ptr = new (NotNull, JSC::allocateCell<JSNodeIteratorPrototype>(vm)) JSNodeIteratorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNodeIteratorPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNodeIteratorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNodeIteratorPrototype, JSNodeIteratorPrototype::Base);

using JSNodeIteratorDOMConstructor = JSDOMConstructorNotConstructable<JSNodeIterator>;

template<> const ClassInfo JSNodeIteratorDOMConstructor::s_info = { "NodeIterator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNodeIteratorDOMConstructor) };

template<> JSValue JSNodeIteratorDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSNodeIteratorDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "NodeIterator"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSNodeIterator::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSNodeIteratorPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsNodeIteratorConstructor, 0 } },
    { "root"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNodeIterator_root, 0 } },
    { "referenceNode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNodeIterator_referenceNode, 0 } },
    { "pointerBeforeReferenceNode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNodeIterator_pointerBeforeReferenceNode, 0 } },
    { "whatToShow"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNodeIterator_whatToShow, 0 } },
    { "filter"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNodeIterator_filter, 0 } },
    { "nextNode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodeIteratorPrototypeFunction_nextNode, 0 } },
    { "previousNode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodeIteratorPrototypeFunction_previousNode, 0 } },
    { "detach"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodeIteratorPrototypeFunction_detach, 0 } },
};

const ClassInfo JSNodeIteratorPrototype::s_info = { "NodeIterator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNodeIteratorPrototype) };

void JSNodeIteratorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNodeIterator::info(), JSNodeIteratorPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSNodeIterator::s_info = { "NodeIterator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNodeIterator) };

JSNodeIterator::JSNodeIterator(Structure* structure, JSDOMGlobalObject& globalObject, Ref<NodeIterator>&& impl)
    : JSDOMWrapper<NodeIterator>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, NodeIterator>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSNodeIterator::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSNodeIteratorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSNodeIteratorPrototype::create(vm, &globalObject, structure);
}

JSObject* JSNodeIterator::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSNodeIterator>(vm, globalObject);
}

JSValue JSNodeIterator::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNodeIteratorDOMConstructor, DOMConstructorID::NodeIterator>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSNodeIterator::destroy(JSC::JSCell* cell)
{
    JSNodeIterator* thisObject = static_cast<JSNodeIterator*>(cell);
    thisObject->JSNodeIterator::~JSNodeIterator();
}

JSC_DEFINE_CUSTOM_GETTER(jsNodeIteratorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSNodeIteratorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSNodeIterator::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsNodeIterator_rootGetter(JSGlobalObject& lexicalGlobalObject, JSNodeIterator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Node>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.root())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNodeIterator_root, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNodeIterator>::get<jsNodeIterator_rootGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNodeIterator_referenceNodeGetter(JSGlobalObject& lexicalGlobalObject, JSNodeIterator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Node>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.referenceNode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNodeIterator_referenceNode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNodeIterator>::get<jsNodeIterator_referenceNodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNodeIterator_pointerBeforeReferenceNodeGetter(JSGlobalObject& lexicalGlobalObject, JSNodeIterator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.pointerBeforeReferenceNode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNodeIterator_pointerBeforeReferenceNode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNodeIterator>::get<jsNodeIterator_pointerBeforeReferenceNodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNodeIterator_whatToShowGetter(JSGlobalObject& lexicalGlobalObject, JSNodeIterator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.whatToShow())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNodeIterator_whatToShow, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNodeIterator>::get<jsNodeIterator_whatToShowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNodeIterator_filterGetter(JSGlobalObject& lexicalGlobalObject, JSNodeIterator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLCallbackInterface<JSNodeFilter>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.filter())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNodeIterator_filter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNodeIterator>::get<jsNodeIterator_filterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsNodeIteratorPrototypeFunction_nextNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNodeIterator>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.nextNode())));
}

JSC_DEFINE_HOST_FUNCTION(jsNodeIteratorPrototypeFunction_nextNode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNodeIterator>::call<jsNodeIteratorPrototypeFunction_nextNodeBody>(*lexicalGlobalObject, *callFrame, "nextNode");
}

static inline JSC::EncodedJSValue jsNodeIteratorPrototypeFunction_previousNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNodeIterator>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.previousNode())));
}

JSC_DEFINE_HOST_FUNCTION(jsNodeIteratorPrototypeFunction_previousNode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNodeIterator>::call<jsNodeIteratorPrototypeFunction_previousNodeBody>(*lexicalGlobalObject, *callFrame, "previousNode");
}

static inline JSC::EncodedJSValue jsNodeIteratorPrototypeFunction_detachBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNodeIterator>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.detach(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNodeIteratorPrototypeFunction_detach, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNodeIterator>::call<jsNodeIteratorPrototypeFunction_detachBody>(*lexicalGlobalObject, *callFrame, "detach");
}

JSC::GCClient::IsoSubspace* JSNodeIterator::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSNodeIterator, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForNodeIterator.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForNodeIterator = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForNodeIterator.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForNodeIterator = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSNodeIterator::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSNodeIterator*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSNodeIterator);

template<typename Visitor>
void JSNodeIterator::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSNodeIterator*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSNodeIterator::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSNodeIterator::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSNodeIterator::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSNodeIterator*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSNodeIteratorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSNodeIteratorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsNodeIterator = static_cast<JSNodeIterator*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsNodeIterator->protectedWrapped().ptr(), jsNodeIterator);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7NodeIterator@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12NodeIteratorE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, NodeIterator>, void>> static inline void verifyVTable(NodeIterator* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7NodeIterator@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12NodeIteratorE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // NodeIterator has subclasses. If NodeIterator has subclasses that get passed
        // to toJS() we currently require NodeIterator you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<NodeIterator>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<NodeIterator>(impl.ptr());
#endif
    return createWrapper<NodeIterator>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, NodeIterator& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

NodeIterator* JSNodeIterator::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSNodeIterator*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
