/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SESSION)

#include "JSMediaSessionActionDetails.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMGlobalObject.h"
#include "JSMediaSessionAction.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>

#if ENABLE(MEDIA_SESSION_PLAYLIST)
#include "JSDOMConvertStrings.h"
#endif


namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_SESSION)

template<> ConversionResult<IDLDictionary<MediaSessionActionDetails>> convertDictionary<MediaSessionActionDetails>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    MediaSessionActionDetails result;
    JSValue actionValue;
    if (isNullOrUndefined)
        actionValue = jsUndefined();
    else {
        actionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "action"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (actionValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "action"_s, "MediaSessionActionDetails"_s, "MediaSessionAction"_s);
        return ConversionResultException { };
    }
    auto actionConversionResult = convert<IDLEnumeration<MediaSessionAction>>(lexicalGlobalObject, actionValue);
    if (UNLIKELY(actionConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.action = actionConversionResult.releaseReturnValue();
    JSValue fastSeekValue;
    if (isNullOrUndefined)
        fastSeekValue = jsUndefined();
    else {
        fastSeekValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fastSeek"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!fastSeekValue.isUndefined()) {
        auto fastSeekConversionResult = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, fastSeekValue);
        if (UNLIKELY(fastSeekConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.fastSeek = fastSeekConversionResult.releaseReturnValue();
    }
    JSValue isActivatingValue;
    if (isNullOrUndefined)
        isActivatingValue = jsUndefined();
    else {
        isActivatingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isActivating"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!isActivatingValue.isUndefined()) {
        auto isActivatingConversionResult = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, isActivatingValue);
        if (UNLIKELY(isActivatingConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.isActivating = isActivatingConversionResult.releaseReturnValue();
    }
    JSValue seekOffsetValue;
    if (isNullOrUndefined)
        seekOffsetValue = jsUndefined();
    else {
        seekOffsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "seekOffset"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!seekOffsetValue.isUndefined()) {
        auto seekOffsetConversionResult = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, seekOffsetValue);
        if (UNLIKELY(seekOffsetConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.seekOffset = seekOffsetConversionResult.releaseReturnValue();
    }
    JSValue seekTimeValue;
    if (isNullOrUndefined)
        seekTimeValue = jsUndefined();
    else {
        seekTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "seekTime"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!seekTimeValue.isUndefined()) {
        auto seekTimeConversionResult = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, seekTimeValue);
        if (UNLIKELY(seekTimeConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.seekTime = seekTimeConversionResult.releaseReturnValue();
    }
#if ENABLE(MEDIA_SESSION_PLAYLIST)
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().mediaSessionPlaylistEnabled) {
        JSValue trackIdentifierValue;
        if (isNullOrUndefined)
            trackIdentifierValue = jsUndefined();
        else {
            trackIdentifierValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "trackIdentifier"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        if (!trackIdentifierValue.isUndefined()) {
            auto trackIdentifierConversionResult = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, trackIdentifierValue);
            if (UNLIKELY(trackIdentifierConversionResult.hasException(throwScope)))
                return ConversionResultException { };
            result.trackIdentifier = trackIdentifierConversionResult.releaseReturnValue();
        }
    }
#endif
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaSessionActionDetails& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto actionValue = toJS<IDLEnumeration<MediaSessionAction>>(lexicalGlobalObject, throwScope, dictionary.action);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "action"_s), actionValue);
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.fastSeek)) {
        auto fastSeekValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.fastSeek));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "fastSeek"_s), fastSeekValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.isActivating)) {
        auto isActivatingValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.isActivating));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "isActivating"_s), isActivatingValue);
    }
    if (!IDLNullable<IDLDouble>::isNullValue(dictionary.seekOffset)) {
        auto seekOffsetValue = toJS<IDLNullable<IDLDouble>>(lexicalGlobalObject, throwScope, IDLNullable<IDLDouble>::extractValueFromNullable(dictionary.seekOffset));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "seekOffset"_s), seekOffsetValue);
    }
    if (!IDLNullable<IDLDouble>::isNullValue(dictionary.seekTime)) {
        auto seekTimeValue = toJS<IDLNullable<IDLDouble>>(lexicalGlobalObject, throwScope, IDLNullable<IDLDouble>::extractValueFromNullable(dictionary.seekTime));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "seekTime"_s), seekTimeValue);
    }
#if ENABLE(MEDIA_SESSION_PLAYLIST)
    if (jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext()->settingsValues().mediaSessionPlaylistEnabled) {
        if (!IDLNullable<IDLDOMString>::isNullValue(dictionary.trackIdentifier)) {
            auto trackIdentifierValue = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, IDLNullable<IDLDOMString>::extractValueFromNullable(dictionary.trackIdentifier));
            RETURN_IF_EXCEPTION(throwScope, { });
            result->putDirect(vm, JSC::Identifier::fromString(vm, "trackIdentifier"_s), trackIdentifierValue);
        }
    }
#endif
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(MEDIA_SESSION)
