/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SESSION)

#include "JSMediaPositionState.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_SESSION)

template<> ConversionResult<IDLDictionary<MediaPositionState>> convertDictionary<MediaPositionState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    MediaPositionState result;
    JSValue durationValue;
    if (isNullOrUndefined)
        durationValue = jsUndefined();
    else {
        durationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "duration"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (durationValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "duration"_s, "MediaPositionState"_s, "double"_s);
        return ConversionResultException { };
    }
    auto durationConversionResult = convert<IDLDouble>(lexicalGlobalObject, durationValue);
    if (UNLIKELY(durationConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.duration = durationConversionResult.releaseReturnValue();
    JSValue playbackRateValue;
    if (isNullOrUndefined)
        playbackRateValue = jsUndefined();
    else {
        playbackRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "playbackRate"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto playbackRateConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, playbackRateValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 1 }; });
    if (UNLIKELY(playbackRateConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.playbackRate = playbackRateConversionResult.releaseReturnValue();
    JSValue positionValue;
    if (isNullOrUndefined)
        positionValue = jsUndefined();
    else {
        positionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "position"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto positionConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, positionValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0 }; });
    if (UNLIKELY(positionConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.position = positionConversionResult.releaseReturnValue();
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaPositionState& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto durationValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.duration);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "duration"_s), durationValue);
    auto playbackRateValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.playbackRate);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "playbackRate"_s), playbackRateValue);
    auto positionValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.position);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "position"_s), positionValue);
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(MEDIA_SESSION)
