/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFragmentDirective.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFragmentDirectiveConstructor);

class JSFragmentDirectivePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFragmentDirectivePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFragmentDirectivePrototype* ptr = new (NotNull, JSC::allocateCell<JSFragmentDirectivePrototype>(vm)) JSFragmentDirectivePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFragmentDirectivePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFragmentDirectivePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFragmentDirectivePrototype, JSFragmentDirectivePrototype::Base);

using JSFragmentDirectiveDOMConstructor = JSDOMConstructorNotConstructable<JSFragmentDirective>;

template<> const ClassInfo JSFragmentDirectiveDOMConstructor::s_info = { "FragmentDirective"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFragmentDirectiveDOMConstructor) };

template<> JSValue JSFragmentDirectiveDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFragmentDirectiveDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "FragmentDirective"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFragmentDirective::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSFragmentDirectivePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFragmentDirectiveConstructor, 0 } },
};

const ClassInfo JSFragmentDirectivePrototype::s_info = { "FragmentDirective"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFragmentDirectivePrototype) };

void JSFragmentDirectivePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFragmentDirective::info(), JSFragmentDirectivePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFragmentDirective::s_info = { "FragmentDirective"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFragmentDirective) };

JSFragmentDirective::JSFragmentDirective(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FragmentDirective>&& impl)
    : JSDOMWrapper<FragmentDirective>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, FragmentDirective>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSFragmentDirective::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFragmentDirectivePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSFragmentDirectivePrototype::create(vm, &globalObject, structure);
}

JSObject* JSFragmentDirective::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFragmentDirective>(vm, globalObject);
}

JSValue JSFragmentDirective::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFragmentDirectiveDOMConstructor, DOMConstructorID::FragmentDirective>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSFragmentDirective::destroy(JSC::JSCell* cell)
{
    JSFragmentDirective* thisObject = static_cast<JSFragmentDirective*>(cell);
    thisObject->JSFragmentDirective::~JSFragmentDirective();
}

JSC_DEFINE_CUSTOM_GETTER(jsFragmentDirectiveConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFragmentDirectivePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFragmentDirective::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSFragmentDirective::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFragmentDirective, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFragmentDirective.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFragmentDirective = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFragmentDirective.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFragmentDirective = std::forward<decltype(space)>(space); }
    );
}

void JSFragmentDirective::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFragmentDirective*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSFragmentDirectiveOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFragmentDirectiveOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFragmentDirective = static_cast<JSFragmentDirective*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFragmentDirective->protectedWrapped().ptr(), jsFragmentDirective);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FragmentDirective@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17FragmentDirectiveE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, FragmentDirective>, void>> static inline void verifyVTable(FragmentDirective* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7FragmentDirective@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore17FragmentDirectiveE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // FragmentDirective has subclasses. If FragmentDirective has subclasses that get passed
        // to toJS() we currently require FragmentDirective you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<FragmentDirective>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<FragmentDirective>(impl.ptr());
#endif
    return createWrapper<FragmentDirective>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, FragmentDirective& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

FragmentDirective* JSFragmentDirective::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFragmentDirective*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
