/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTDepthClamp.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

class JSEXTDepthClampPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTDepthClampPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTDepthClampPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTDepthClampPrototype>(vm)) JSEXTDepthClampPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTDepthClampPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTDepthClampPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTDepthClampPrototype, JSEXTDepthClampPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSEXTDepthClampPrototypeTableValues[] =
{
    { "DEPTH_CLAMP_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x864F } },
};

const ClassInfo JSEXTDepthClampPrototype::s_info = { "EXTDepthClamp"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTDepthClampPrototype) };

void JSEXTDepthClampPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEXTDepthClamp::info(), JSEXTDepthClampPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTDepthClamp::s_info = { "EXTDepthClamp"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTDepthClamp) };

JSEXTDepthClamp::JSEXTDepthClamp(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTDepthClamp>&& impl)
    : JSDOMWrapper<EXTDepthClamp>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTDepthClamp>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTDepthClamp::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTDepthClampPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTDepthClampPrototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTDepthClamp::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTDepthClamp>(vm, globalObject);
}

void JSEXTDepthClamp::destroy(JSC::JSCell* cell)
{
    JSEXTDepthClamp* thisObject = static_cast<JSEXTDepthClamp*>(cell);
    thisObject->JSEXTDepthClamp::~JSEXTDepthClamp();
}

JSC::GCClient::IsoSubspace* JSEXTDepthClamp::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTDepthClamp, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTDepthClamp.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTDepthClamp = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTDepthClamp.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTDepthClamp = std::forward<decltype(space)>(space); }
    );
}

void JSEXTDepthClamp::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTDepthClamp*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTDepthClampOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsEXTDepthClamp = jsCast<JSEXTDepthClamp*>(handle.slot()->asCell());
    auto& owner = jsEXTDepthClamp->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsEXTDepthClamp"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTDepthClampOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTDepthClamp = static_cast<JSEXTDepthClamp*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEXTDepthClamp->protectedWrapped().ptr(), jsEXTDepthClamp);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTDepthClamp@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13EXTDepthClampE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, EXTDepthClamp>, void>> static inline void verifyVTable(EXTDepthClamp* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTDepthClamp@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13EXTDepthClampE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTDepthClamp has subclasses. If EXTDepthClamp has subclasses that get passed
        // to toJS() we currently require EXTDepthClamp you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTDepthClamp>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<EXTDepthClamp>(impl.ptr());
#endif
    return createWrapper<EXTDepthClamp>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTDepthClamp& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTDepthClamp* JSEXTDepthClamp::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTDepthClamp*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
