/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGTransform.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMMatrix2DInit.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGMatrix.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSVGTransformPrototypeFunction_setMatrix);
static JSC_DECLARE_HOST_FUNCTION(jsSVGTransformPrototypeFunction_setTranslate);
static JSC_DECLARE_HOST_FUNCTION(jsSVGTransformPrototypeFunction_setScale);
static JSC_DECLARE_HOST_FUNCTION(jsSVGTransformPrototypeFunction_setRotate);
static JSC_DECLARE_HOST_FUNCTION(jsSVGTransformPrototypeFunction_setSkewX);
static JSC_DECLARE_HOST_FUNCTION(jsSVGTransformPrototypeFunction_setSkewY);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGTransformConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGTransform_type);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGTransform_matrix);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGTransform_angle);

class JSSVGTransformPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGTransformPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGTransformPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGTransformPrototype>(vm)) JSSVGTransformPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGTransformPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGTransformPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGTransformPrototype, JSSVGTransformPrototype::Base);

using JSSVGTransformDOMConstructor = JSDOMConstructorNotConstructable<JSSVGTransform>;

/* Hash table for constructor */

static const HashTableValue JSSVGTransformConstructorTableValues[] =
{
    { "SVG_TRANSFORM_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "SVG_TRANSFORM_MATRIX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "SVG_TRANSFORM_TRANSLATE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "SVG_TRANSFORM_SCALE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    { "SVG_TRANSFORM_ROTATE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
    { "SVG_TRANSFORM_SKEWX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
    { "SVG_TRANSFORM_SKEWY"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 6 } },
};

static_assert(SVGTransformValue::SVG_TRANSFORM_UNKNOWN == 0, "SVG_TRANSFORM_UNKNOWN in SVGTransformValue does not match value from IDL");
static_assert(SVGTransformValue::SVG_TRANSFORM_MATRIX == 1, "SVG_TRANSFORM_MATRIX in SVGTransformValue does not match value from IDL");
static_assert(SVGTransformValue::SVG_TRANSFORM_TRANSLATE == 2, "SVG_TRANSFORM_TRANSLATE in SVGTransformValue does not match value from IDL");
static_assert(SVGTransformValue::SVG_TRANSFORM_SCALE == 3, "SVG_TRANSFORM_SCALE in SVGTransformValue does not match value from IDL");
static_assert(SVGTransformValue::SVG_TRANSFORM_ROTATE == 4, "SVG_TRANSFORM_ROTATE in SVGTransformValue does not match value from IDL");
static_assert(SVGTransformValue::SVG_TRANSFORM_SKEWX == 5, "SVG_TRANSFORM_SKEWX in SVGTransformValue does not match value from IDL");
static_assert(SVGTransformValue::SVG_TRANSFORM_SKEWY == 6, "SVG_TRANSFORM_SKEWY in SVGTransformValue does not match value from IDL");

template<> const ClassInfo JSSVGTransformDOMConstructor::s_info = { "SVGTransform"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGTransformDOMConstructor) };

template<> JSValue JSSVGTransformDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGTransformDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGTransform"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGTransform::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSSVGTransform::info(), JSSVGTransformConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSSVGTransformPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGTransformConstructor, 0 } },
    { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGTransform_type, 0 } },
    { "matrix"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGTransform_matrix, 0 } },
    { "angle"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGTransform_angle, 0 } },
    { "setMatrix"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGTransformPrototypeFunction_setMatrix, 0 } },
    { "setTranslate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGTransformPrototypeFunction_setTranslate, 2 } },
    { "setScale"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGTransformPrototypeFunction_setScale, 2 } },
    { "setRotate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGTransformPrototypeFunction_setRotate, 3 } },
    { "setSkewX"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGTransformPrototypeFunction_setSkewX, 1 } },
    { "setSkewY"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGTransformPrototypeFunction_setSkewY, 1 } },
    { "SVG_TRANSFORM_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "SVG_TRANSFORM_MATRIX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "SVG_TRANSFORM_TRANSLATE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "SVG_TRANSFORM_SCALE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    { "SVG_TRANSFORM_ROTATE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
    { "SVG_TRANSFORM_SKEWX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
    { "SVG_TRANSFORM_SKEWY"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 6 } },
};

const ClassInfo JSSVGTransformPrototype::s_info = { "SVGTransform"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGTransformPrototype) };

void JSSVGTransformPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGTransform::info(), JSSVGTransformPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGTransform::s_info = { "SVGTransform"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGTransform) };

JSSVGTransform::JSSVGTransform(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGTransform>&& impl)
    : JSDOMWrapper<SVGTransform>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, SVGTransform>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSVGTransform::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGTransformPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSVGTransformPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGTransform::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGTransform>(vm, globalObject);
}

JSValue JSSVGTransform::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGTransformDOMConstructor, DOMConstructorID::SVGTransform>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGTransform::destroy(JSC::JSCell* cell)
{
    JSSVGTransform* thisObject = static_cast<JSSVGTransform*>(cell);
    thisObject->JSSVGTransform::~JSSVGTransform();
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGTransformConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGTransformPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGTransform::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGTransform_typeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGTransform& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGTransform_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGTransform>::get<jsSVGTransform_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGTransform_matrixGetter(JSGlobalObject& lexicalGlobalObject, JSSVGTransform& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGMatrix>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.matrix())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGTransform_matrix, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGTransform>::get<jsSVGTransform_matrixGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGTransform_angleGetter(JSGlobalObject& lexicalGlobalObject, JSSVGTransform& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.angle())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGTransform_angle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGTransform>::get<jsSVGTransform_angleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsSVGTransformPrototypeFunction_setMatrixBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGTransform>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto matrixConversionResult = convert<IDLDictionary<DOMMatrix2DInit>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(matrixConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setMatrix(matrixConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGTransformPrototypeFunction_setMatrix, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGTransform>::call<jsSVGTransformPrototypeFunction_setMatrixBody>(*lexicalGlobalObject, *callFrame, "setMatrix");
}

static inline JSC::EncodedJSValue jsSVGTransformPrototypeFunction_setTranslateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGTransform>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto txConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(txConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto tyConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(tyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setTranslate(txConversionResult.releaseReturnValue(), tyConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGTransformPrototypeFunction_setTranslate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGTransform>::call<jsSVGTransformPrototypeFunction_setTranslateBody>(*lexicalGlobalObject, *callFrame, "setTranslate");
}

static inline JSC::EncodedJSValue jsSVGTransformPrototypeFunction_setScaleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGTransform>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto sxConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(sxConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto syConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(syConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setScale(sxConversionResult.releaseReturnValue(), syConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGTransformPrototypeFunction_setScale, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGTransform>::call<jsSVGTransformPrototypeFunction_setScaleBody>(*lexicalGlobalObject, *callFrame, "setScale");
}

static inline JSC::EncodedJSValue jsSVGTransformPrototypeFunction_setRotateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGTransform>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto angleConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(angleConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto cxConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(cxConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto cyConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(cyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setRotate(angleConversionResult.releaseReturnValue(), cxConversionResult.releaseReturnValue(), cyConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGTransformPrototypeFunction_setRotate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGTransform>::call<jsSVGTransformPrototypeFunction_setRotateBody>(*lexicalGlobalObject, *callFrame, "setRotate");
}

static inline JSC::EncodedJSValue jsSVGTransformPrototypeFunction_setSkewXBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGTransform>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto angleConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(angleConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setSkewX(angleConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGTransformPrototypeFunction_setSkewX, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGTransform>::call<jsSVGTransformPrototypeFunction_setSkewXBody>(*lexicalGlobalObject, *callFrame, "setSkewX");
}

static inline JSC::EncodedJSValue jsSVGTransformPrototypeFunction_setSkewYBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGTransform>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto angleConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(angleConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setSkewY(angleConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGTransformPrototypeFunction_setSkewY, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGTransform>::call<jsSVGTransformPrototypeFunction_setSkewYBody>(*lexicalGlobalObject, *callFrame, "setSkewY");
}

JSC::GCClient::IsoSubspace* JSSVGTransform::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGTransform, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGTransform.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGTransform = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGTransform.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGTransform = std::forward<decltype(space)>(space); }
    );
}

void JSSVGTransform::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGTransform*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGTransformOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGTransformOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGTransform = static_cast<JSSVGTransform*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGTransform->protectedWrapped().ptr(), jsSVGTransform);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SVGTransform@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12SVGTransformE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, SVGTransform>, void>> static inline void verifyVTable(SVGTransform* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7SVGTransform@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12SVGTransformE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // SVGTransform has subclasses. If SVGTransform has subclasses that get passed
        // to toJS() we currently require SVGTransform you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SVGTransform>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<SVGTransform>(impl.ptr());
#endif
    return createWrapper<SVGTransform>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SVGTransform& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SVGTransform* JSSVGTransform::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGTransform*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
