/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPathSegCurvetoQuadraticAbs.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegCurvetoQuadraticAbsConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegCurvetoQuadraticAbs_x);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGPathSegCurvetoQuadraticAbs_x);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegCurvetoQuadraticAbs_y);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGPathSegCurvetoQuadraticAbs_y);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegCurvetoQuadraticAbs_x1);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGPathSegCurvetoQuadraticAbs_x1);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegCurvetoQuadraticAbs_y1);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGPathSegCurvetoQuadraticAbs_y1);

class JSSVGPathSegCurvetoQuadraticAbsPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGPathSegCurvetoQuadraticAbsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPathSegCurvetoQuadraticAbsPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPathSegCurvetoQuadraticAbsPrototype>(vm)) JSSVGPathSegCurvetoQuadraticAbsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPathSegCurvetoQuadraticAbsPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPathSegCurvetoQuadraticAbsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPathSegCurvetoQuadraticAbsPrototype, JSSVGPathSegCurvetoQuadraticAbsPrototype::Base);

using JSSVGPathSegCurvetoQuadraticAbsDOMConstructor = JSDOMConstructorNotConstructable<JSSVGPathSegCurvetoQuadraticAbs>;

template<> const ClassInfo JSSVGPathSegCurvetoQuadraticAbsDOMConstructor::s_info = { "SVGPathSegCurvetoQuadraticAbs"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegCurvetoQuadraticAbsDOMConstructor) };

template<> JSValue JSSVGPathSegCurvetoQuadraticAbsDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGPathSeg::getConstructor(vm, &globalObject);
}

template<> void JSSVGPathSegCurvetoQuadraticAbsDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGPathSegCurvetoQuadraticAbs"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGPathSegCurvetoQuadraticAbs::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPathSegCurvetoQuadraticAbsPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegCurvetoQuadraticAbsConstructor, 0 } },
    { "x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegCurvetoQuadraticAbs_x, setJSSVGPathSegCurvetoQuadraticAbs_x } },
    { "y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegCurvetoQuadraticAbs_y, setJSSVGPathSegCurvetoQuadraticAbs_y } },
    { "x1"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegCurvetoQuadraticAbs_x1, setJSSVGPathSegCurvetoQuadraticAbs_x1 } },
    { "y1"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegCurvetoQuadraticAbs_y1, setJSSVGPathSegCurvetoQuadraticAbs_y1 } },
};

const ClassInfo JSSVGPathSegCurvetoQuadraticAbsPrototype::s_info = { "SVGPathSegCurvetoQuadraticAbs"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegCurvetoQuadraticAbsPrototype) };

void JSSVGPathSegCurvetoQuadraticAbsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPathSegCurvetoQuadraticAbs::info(), JSSVGPathSegCurvetoQuadraticAbsPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGPathSegCurvetoQuadraticAbs::s_info = { "SVGPathSegCurvetoQuadraticAbs"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegCurvetoQuadraticAbs) };

JSSVGPathSegCurvetoQuadraticAbs::JSSVGPathSegCurvetoQuadraticAbs(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPathSegCurvetoQuadraticAbs>&& impl)
    : JSSVGPathSeg(structure, globalObject, WTFMove(impl))
{
}

Ref<SVGPathSegCurvetoQuadraticAbs> JSSVGPathSegCurvetoQuadraticAbs::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, SVGPathSegCurvetoQuadraticAbs>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSVGPathSegCurvetoQuadraticAbs::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGPathSegCurvetoQuadraticAbsPrototype::createStructure(vm, &globalObject, JSSVGPathSeg::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGPathSegCurvetoQuadraticAbsPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGPathSegCurvetoQuadraticAbs::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGPathSegCurvetoQuadraticAbs>(vm, globalObject);
}

JSValue JSSVGPathSegCurvetoQuadraticAbs::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegCurvetoQuadraticAbsDOMConstructor, DOMConstructorID::SVGPathSegCurvetoQuadraticAbs>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegCurvetoQuadraticAbsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPathSegCurvetoQuadraticAbsPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGPathSegCurvetoQuadraticAbs::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGPathSegCurvetoQuadraticAbs_xGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoQuadraticAbs& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.x())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegCurvetoQuadraticAbs_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoQuadraticAbs>::get<jsSVGPathSegCurvetoQuadraticAbs_xGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGPathSegCurvetoQuadraticAbs_xSetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoQuadraticAbs& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setX(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGPathSegCurvetoQuadraticAbs_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoQuadraticAbs>::set<setJSSVGPathSegCurvetoQuadraticAbs_xSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGPathSegCurvetoQuadraticAbs_yGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoQuadraticAbs& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.y())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegCurvetoQuadraticAbs_y, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoQuadraticAbs>::get<jsSVGPathSegCurvetoQuadraticAbs_yGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGPathSegCurvetoQuadraticAbs_ySetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoQuadraticAbs& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setY(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGPathSegCurvetoQuadraticAbs_y, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoQuadraticAbs>::set<setJSSVGPathSegCurvetoQuadraticAbs_ySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGPathSegCurvetoQuadraticAbs_x1Getter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoQuadraticAbs& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.x1())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegCurvetoQuadraticAbs_x1, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoQuadraticAbs>::get<jsSVGPathSegCurvetoQuadraticAbs_x1Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGPathSegCurvetoQuadraticAbs_x1Setter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoQuadraticAbs& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setX1(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGPathSegCurvetoQuadraticAbs_x1, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoQuadraticAbs>::set<setJSSVGPathSegCurvetoQuadraticAbs_x1Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGPathSegCurvetoQuadraticAbs_y1Getter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoQuadraticAbs& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.y1())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegCurvetoQuadraticAbs_y1, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoQuadraticAbs>::get<jsSVGPathSegCurvetoQuadraticAbs_y1Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGPathSegCurvetoQuadraticAbs_y1Setter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoQuadraticAbs& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setY1(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGPathSegCurvetoQuadraticAbs_y1, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoQuadraticAbs>::set<setJSSVGPathSegCurvetoQuadraticAbs_y1Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSVGPathSegCurvetoQuadraticAbs::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGPathSegCurvetoQuadraticAbs, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGPathSegCurvetoQuadraticAbs.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGPathSegCurvetoQuadraticAbs = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGPathSegCurvetoQuadraticAbs.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGPathSegCurvetoQuadraticAbs = std::forward<decltype(space)>(space); }
    );
}

void JSSVGPathSegCurvetoQuadraticAbs::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGPathSegCurvetoQuadraticAbs*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
