/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSKeyframeEffect.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSCompositeOperation.h"
#include "JSCompositeOperationOrAuto.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "JSIterationCompositeOperation.h"
#include "JSKeyframeEffect.h"
#include "JSKeyframeEffectOptions.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<KeyframeEffect::BasePropertyIndexedKeyframe>> convertDictionary<KeyframeEffect::BasePropertyIndexedKeyframe>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    KeyframeEffect::BasePropertyIndexedKeyframe result;
    JSValue compositeValue;
    if (isNullOrUndefined)
        compositeValue = jsUndefined();
    else {
        compositeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composite"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto compositeConversionResult = convertOptionalWithDefault<IDLUnion<IDLSequence<IDLEnumeration<CompositeOperationOrAuto>>, IDLEnumeration<CompositeOperationOrAuto>>>(lexicalGlobalObject, compositeValue, [&]() -> ConversionResult<IDLUnion<IDLSequence<IDLEnumeration<CompositeOperationOrAuto>>, IDLEnumeration<CompositeOperationOrAuto>>> { return Converter<IDLUnion<IDLSequence<IDLEnumeration<CompositeOperationOrAuto>>, IDLEnumeration<CompositeOperationOrAuto>>>::ReturnType { }; });
    if (UNLIKELY(compositeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.composite = compositeConversionResult.releaseReturnValue();
    JSValue easingValue;
    if (isNullOrUndefined)
        easingValue = jsUndefined();
    else {
        easingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "easing"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto easingConversionResult = convertOptionalWithDefault<IDLUnion<IDLSequence<IDLDOMString>, IDLDOMString>>(lexicalGlobalObject, easingValue, [&]() -> ConversionResult<IDLUnion<IDLSequence<IDLDOMString>, IDLDOMString>> { return Converter<IDLUnion<IDLSequence<IDLDOMString>, IDLDOMString>>::ReturnType { }; });
    if (UNLIKELY(easingConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.easing = easingConversionResult.releaseReturnValue();
    JSValue offsetValue;
    if (isNullOrUndefined)
        offsetValue = jsUndefined();
    else {
        offsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "offset"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto offsetConversionResult = convertOptionalWithDefault<IDLUnion<IDLNull, IDLSequence<IDLNullable<IDLDouble>>, IDLDouble>>(lexicalGlobalObject, offsetValue, [&]() -> ConversionResult<IDLUnion<IDLNull, IDLSequence<IDLNullable<IDLDouble>>, IDLDouble>> { return Converter<IDLUnion<IDLNull, IDLSequence<IDLNullable<IDLDouble>>, IDLDouble>>::ReturnType { }; });
    if (UNLIKELY(offsetConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.offset = offsetConversionResult.releaseReturnValue();
    return result;
}

template<> ConversionResult<IDLDictionary<KeyframeEffect::BaseKeyframe>> convertDictionary<KeyframeEffect::BaseKeyframe>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    KeyframeEffect::BaseKeyframe result;
    JSValue compositeValue;
    if (isNullOrUndefined)
        compositeValue = jsUndefined();
    else {
        compositeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composite"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto compositeConversionResult = convertOptionalWithDefault<IDLEnumeration<CompositeOperationOrAuto>>(lexicalGlobalObject, compositeValue, [&]() -> ConversionResult<IDLEnumeration<CompositeOperationOrAuto>> { return Converter<IDLEnumeration<CompositeOperationOrAuto>>::ReturnType { CompositeOperationOrAuto::Auto }; });
    if (UNLIKELY(compositeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.composite = compositeConversionResult.releaseReturnValue();
    JSValue easingValue;
    if (isNullOrUndefined)
        easingValue = jsUndefined();
    else {
        easingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "easing"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto easingConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, easingValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { "linear"_s }; });
    if (UNLIKELY(easingConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.easing = easingConversionResult.releaseReturnValue();
    JSValue offsetValue;
    if (isNullOrUndefined)
        offsetValue = jsUndefined();
    else {
        offsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "offset"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto offsetConversionResult = convertOptionalWithDefault<IDLNullable<IDLDouble>>(lexicalGlobalObject, offsetValue, [&]() -> ConversionResult<IDLNullable<IDLDouble>> { return typename Converter<IDLNullable<IDLDouble>>::ReturnType { std::nullopt }; });
    if (UNLIKELY(offsetConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.offset = offsetConversionResult.releaseReturnValue();
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const KeyframeEffect::BaseComputedKeyframe& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto compositeValue = toJS<IDLEnumeration<CompositeOperationOrAuto>>(lexicalGlobalObject, throwScope, dictionary.composite);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "composite"_s), compositeValue);
    if (!IDLDouble::isNullValue(dictionary.computedOffset)) {
        auto computedOffsetValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.computedOffset));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "computedOffset"_s), computedOffsetValue);
    }
    auto easingValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.easing);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "easing"_s), easingValue);
    auto offsetValue = toJS<IDLNullable<IDLDouble>>(lexicalGlobalObject, throwScope, dictionary.offset);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "offset"_s), offsetValue);
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsKeyframeEffectPrototypeFunction_getKeyframes);
static JSC_DECLARE_HOST_FUNCTION(jsKeyframeEffectPrototypeFunction_setKeyframes);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsKeyframeEffectConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyframeEffect_target);
static JSC_DECLARE_CUSTOM_SETTER(setJSKeyframeEffect_target);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyframeEffect_pseudoElement);
static JSC_DECLARE_CUSTOM_SETTER(setJSKeyframeEffect_pseudoElement);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyframeEffect_iterationComposite);
static JSC_DECLARE_CUSTOM_SETTER(setJSKeyframeEffect_iterationComposite);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyframeEffect_composite);
static JSC_DECLARE_CUSTOM_SETTER(setJSKeyframeEffect_composite);

class JSKeyframeEffectPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSKeyframeEffectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSKeyframeEffectPrototype* ptr = new (NotNull, JSC::allocateCell<JSKeyframeEffectPrototype>(vm)) JSKeyframeEffectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSKeyframeEffectPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSKeyframeEffectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSKeyframeEffectPrototype, JSKeyframeEffectPrototype::Base);

using JSKeyframeEffectDOMConstructor = JSDOMConstructor<JSKeyframeEffect>;

static inline EncodedJSValue constructJSKeyframeEffect1(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSKeyframeEffectDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "KeyframeEffect"_s);
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto targetConversionResult = convert<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target"_s, "KeyframeEffect"_s, nullptr, "Element"_s); });
    if (UNLIKELY(targetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto keyframesConversionResult = convert<IDLNullable<IDLObject>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(keyframesConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto optionsConversionResult = convert<IDLOptional<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<KeyframeEffectOptions>>>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(optionsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = KeyframeEffect::create(*castedThis->globalObject(), document, targetConversionResult.releaseReturnValue(), keyframesConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<KeyframeEffect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<KeyframeEffect>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

static inline EncodedJSValue constructJSKeyframeEffect2(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSKeyframeEffectDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto sourceConversionResult = convert<IDLInterface<KeyframeEffect>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "source"_s, "KeyframeEffect"_s, nullptr, "KeyframeEffect"_s); });
    if (UNLIKELY(sourceConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = KeyframeEffect::create(*sourceConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<KeyframeEffect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<KeyframeEffect>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSKeyframeEffectDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 1) {
        RELEASE_AND_RETURN(throwScope, (constructJSKeyframeEffect2(lexicalGlobalObject, callFrame)));
    }
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (constructJSKeyframeEffect1(lexicalGlobalObject, callFrame)));
    }
    if (argsCount == 3) {
        RELEASE_AND_RETURN(throwScope, (constructJSKeyframeEffect1(lexicalGlobalObject, callFrame)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}
JSC_ANNOTATE_HOST_FUNCTION(JSKeyframeEffectConstructorConstruct, JSKeyframeEffectDOMConstructor::construct);

template<> const ClassInfo JSKeyframeEffectDOMConstructor::s_info = { "KeyframeEffect"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKeyframeEffectDOMConstructor) };

template<> JSValue JSKeyframeEffectDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAnimationEffect::getConstructor(vm, &globalObject);
}

template<> void JSKeyframeEffectDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "KeyframeEffect"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSKeyframeEffect::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSKeyframeEffectPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyframeEffectConstructor, 0 } },
    { "target"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyframeEffect_target, setJSKeyframeEffect_target } },
    { "pseudoElement"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyframeEffect_pseudoElement, setJSKeyframeEffect_pseudoElement } },
    { "iterationComposite"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyframeEffect_iterationComposite, setJSKeyframeEffect_iterationComposite } },
    { "composite"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyframeEffect_composite, setJSKeyframeEffect_composite } },
    { "getKeyframes"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsKeyframeEffectPrototypeFunction_getKeyframes, 0 } },
    { "setKeyframes"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsKeyframeEffectPrototypeFunction_setKeyframes, 1 } },
};

const ClassInfo JSKeyframeEffectPrototype::s_info = { "KeyframeEffect"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKeyframeEffectPrototype) };

void JSKeyframeEffectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSKeyframeEffect::info(), JSKeyframeEffectPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSKeyframeEffect::s_info = { "KeyframeEffect"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKeyframeEffect) };

JSKeyframeEffect::JSKeyframeEffect(Structure* structure, JSDOMGlobalObject& globalObject, Ref<KeyframeEffect>&& impl)
    : JSAnimationEffect(structure, globalObject, WTFMove(impl))
{
}

Ref<KeyframeEffect> JSKeyframeEffect::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, KeyframeEffect>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSKeyframeEffect::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSKeyframeEffectPrototype::createStructure(vm, &globalObject, JSAnimationEffect::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSKeyframeEffectPrototype::create(vm, &globalObject, structure);
}

JSObject* JSKeyframeEffect::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSKeyframeEffect>(vm, globalObject);
}

JSValue JSKeyframeEffect::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSKeyframeEffectDOMConstructor, DOMConstructorID::KeyframeEffect>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyframeEffectConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSKeyframeEffectPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSKeyframeEffect::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsKeyframeEffect_targetGetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.target())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyframeEffect_target, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyframeEffect>::get<jsKeyframeEffect_targetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSKeyframeEffect_targetSetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "KeyframeEffect"_s, "target"_s, "Element"_s); });
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setTarget(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSKeyframeEffect_target, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyframeEffect>::set<setJSKeyframeEffect_targetSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsKeyframeEffect_pseudoElementGetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.pseudoElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyframeEffect_pseudoElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyframeEffect>::get<jsKeyframeEffect_pseudoElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSKeyframeEffect_pseudoElementSetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLNullable<IDLUSVString>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPseudoElement(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSKeyframeEffect_pseudoElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyframeEffect>::set<setJSKeyframeEffect_pseudoElementSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsKeyframeEffect_iterationCompositeGetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<IterationCompositeOperation>>(lexicalGlobalObject, throwScope, impl.iterationComposite())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyframeEffect_iterationComposite, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyframeEffect>::get<jsKeyframeEffect_iterationCompositeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSKeyframeEffect_iterationCompositeSetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<IterationCompositeOperation>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setIterationComposite(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSKeyframeEffect_iterationComposite, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyframeEffect>::set<setJSKeyframeEffect_iterationCompositeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsKeyframeEffect_compositeGetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<CompositeOperation>>(lexicalGlobalObject, throwScope, impl.bindingsComposite())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyframeEffect_composite, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyframeEffect>::get<jsKeyframeEffect_compositeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSKeyframeEffect_compositeSetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CompositeOperation>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBindingsComposite(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSKeyframeEffect_composite, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyframeEffect>::set<setJSKeyframeEffect_compositeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsKeyframeEffectPrototypeFunction_getKeyframesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSKeyframeEffect>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    RELEASE_AND_RETURN(throwScope, (JSValue::encode(castedThis->getKeyframes(*lexicalGlobalObject, *callFrame))));
}

JSC_DEFINE_HOST_FUNCTION(jsKeyframeEffectPrototypeFunction_getKeyframes, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSKeyframeEffect>::call<jsKeyframeEffectPrototypeFunction_getKeyframesBody>(*lexicalGlobalObject, *callFrame, "getKeyframes");
}

static inline JSC::EncodedJSValue jsKeyframeEffectPrototypeFunction_setKeyframesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSKeyframeEffect>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto keyframesConversionResult = convert<IDLNullable<IDLObject>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(keyframesConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setBindingsKeyframes(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), document, keyframesConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsKeyframeEffectPrototypeFunction_setKeyframes, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSKeyframeEffect>::call<jsKeyframeEffectPrototypeFunction_setKeyframesBody>(*lexicalGlobalObject, *callFrame, "setKeyframes");
}

JSC::GCClient::IsoSubspace* JSKeyframeEffect::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSKeyframeEffect, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForKeyframeEffect.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForKeyframeEffect = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForKeyframeEffect.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForKeyframeEffect = std::forward<decltype(space)>(space); }
    );
}

void JSKeyframeEffect::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSKeyframeEffect*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7KeyframeEffect@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14KeyframeEffectE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, KeyframeEffect>, void>> static inline void verifyVTable(KeyframeEffect* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7KeyframeEffect@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14KeyframeEffectE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // KeyframeEffect has subclasses. If KeyframeEffect has subclasses that get passed
        // to toJS() we currently require KeyframeEffect you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<KeyframeEffect>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<KeyframeEffect>(impl.ptr());
#endif
    return createWrapper<KeyframeEffect>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, KeyframeEffect& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

KeyframeEffect* JSKeyframeEffect::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSKeyframeEffect*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
