/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUColorDict.h"

#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUColorDict>> convertDictionary<GPUColorDict>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUColorDict result;
    JSValue aValue;
    if (isNullOrUndefined)
        aValue = jsUndefined();
    else {
        aValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "a"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (aValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "a"_s, "GPUColorDict"_s, "double"_s);
        return ConversionResultException { };
    }
    auto aConversionResult = convert<IDLDouble>(lexicalGlobalObject, aValue);
    if (UNLIKELY(aConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.a = aConversionResult.releaseReturnValue();
    JSValue bValue;
    if (isNullOrUndefined)
        bValue = jsUndefined();
    else {
        bValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "b"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (bValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "b"_s, "GPUColorDict"_s, "double"_s);
        return ConversionResultException { };
    }
    auto bConversionResult = convert<IDLDouble>(lexicalGlobalObject, bValue);
    if (UNLIKELY(bConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.b = bConversionResult.releaseReturnValue();
    JSValue gValue;
    if (isNullOrUndefined)
        gValue = jsUndefined();
    else {
        gValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "g"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (gValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "g"_s, "GPUColorDict"_s, "double"_s);
        return ConversionResultException { };
    }
    auto gConversionResult = convert<IDLDouble>(lexicalGlobalObject, gValue);
    if (UNLIKELY(gConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.g = gConversionResult.releaseReturnValue();
    JSValue rValue;
    if (isNullOrUndefined)
        rValue = jsUndefined();
    else {
        rValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "r"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (rValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "r"_s, "GPUColorDict"_s, "double"_s);
        return ConversionResultException { };
    }
    auto rConversionResult = convert<IDLDouble>(lexicalGlobalObject, rValue);
    if (UNLIKELY(rConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.r = rConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
