/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUBufferUsage.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUBufferUsageConstructor);

class JSGPUBufferUsagePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUBufferUsagePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUBufferUsagePrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUBufferUsagePrototype>(vm)) JSGPUBufferUsagePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUBufferUsagePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUBufferUsagePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUBufferUsagePrototype, JSGPUBufferUsagePrototype::Base);

using JSGPUBufferUsageDOMConstructor = JSDOMConstructorNotConstructable<JSGPUBufferUsage>;

/* Hash table for constructor */

static const HashTableValue JSGPUBufferUsageConstructorTableValues[] =
{
    { "MAP_READ"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0001 } },
    { "MAP_WRITE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0002 } },
    { "COPY_SRC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0004 } },
    { "COPY_DST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0008 } },
    { "INDEX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0010 } },
    { "VERTEX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0020 } },
    { "UNIFORM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0040 } },
    { "STORAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0080 } },
    { "INDIRECT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0100 } },
    { "QUERY_RESOLVE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0200 } },
};

static_assert(GPUBufferUsage::MAP_READ == 0x0001, "MAP_READ in GPUBufferUsage does not match value from IDL");
static_assert(GPUBufferUsage::MAP_WRITE == 0x0002, "MAP_WRITE in GPUBufferUsage does not match value from IDL");
static_assert(GPUBufferUsage::COPY_SRC == 0x0004, "COPY_SRC in GPUBufferUsage does not match value from IDL");
static_assert(GPUBufferUsage::COPY_DST == 0x0008, "COPY_DST in GPUBufferUsage does not match value from IDL");
static_assert(GPUBufferUsage::INDEX == 0x0010, "INDEX in GPUBufferUsage does not match value from IDL");
static_assert(GPUBufferUsage::VERTEX == 0x0020, "VERTEX in GPUBufferUsage does not match value from IDL");
static_assert(GPUBufferUsage::UNIFORM == 0x0040, "UNIFORM in GPUBufferUsage does not match value from IDL");
static_assert(GPUBufferUsage::STORAGE == 0x0080, "STORAGE in GPUBufferUsage does not match value from IDL");
static_assert(GPUBufferUsage::INDIRECT == 0x0100, "INDIRECT in GPUBufferUsage does not match value from IDL");
static_assert(GPUBufferUsage::QUERY_RESOLVE == 0x0200, "QUERY_RESOLVE in GPUBufferUsage does not match value from IDL");

template<> const ClassInfo JSGPUBufferUsageDOMConstructor::s_info = { "GPUBufferUsage"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUBufferUsageDOMConstructor) };

template<> JSValue JSGPUBufferUsageDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUBufferUsageDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUBufferUsage"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUBufferUsage::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSGPUBufferUsage::info(), JSGPUBufferUsageConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSGPUBufferUsagePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUBufferUsageConstructor, 0 } },
    { "MAP_READ"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0001 } },
    { "MAP_WRITE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0002 } },
    { "COPY_SRC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0004 } },
    { "COPY_DST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0008 } },
    { "INDEX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0010 } },
    { "VERTEX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0020 } },
    { "UNIFORM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0040 } },
    { "STORAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0080 } },
    { "INDIRECT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0100 } },
    { "QUERY_RESOLVE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0200 } },
};

const ClassInfo JSGPUBufferUsagePrototype::s_info = { "GPUBufferUsage"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUBufferUsagePrototype) };

void JSGPUBufferUsagePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUBufferUsage::info(), JSGPUBufferUsagePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUBufferUsage::s_info = { "GPUBufferUsage"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUBufferUsage) };

JSGPUBufferUsage::JSGPUBufferUsage(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUBufferUsage>&& impl)
    : JSDOMWrapper<GPUBufferUsage>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUBufferUsage>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUBufferUsage::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUBufferUsagePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUBufferUsagePrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUBufferUsage::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUBufferUsage>(vm, globalObject);
}

JSValue JSGPUBufferUsage::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUBufferUsageDOMConstructor, DOMConstructorID::GPUBufferUsage>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUBufferUsage::destroy(JSC::JSCell* cell)
{
    JSGPUBufferUsage* thisObject = static_cast<JSGPUBufferUsage*>(cell);
    thisObject->JSGPUBufferUsage::~JSGPUBufferUsage();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUBufferUsageConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUBufferUsagePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUBufferUsage::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSGPUBufferUsage::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUBufferUsage, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUBufferUsage.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUBufferUsage = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUBufferUsage.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUBufferUsage = std::forward<decltype(space)>(space); }
    );
}

void JSGPUBufferUsage::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUBufferUsage*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUBufferUsageOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUBufferUsageOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUBufferUsage = static_cast<JSGPUBufferUsage*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGPUBufferUsage->protectedWrapped().ptr(), jsGPUBufferUsage);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUBufferUsage@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14GPUBufferUsageE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, GPUBufferUsage>, void>> static inline void verifyVTable(GPUBufferUsage* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUBufferUsage@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14GPUBufferUsageE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUBufferUsage has subclasses. If GPUBufferUsage has subclasses that get passed
        // to toJS() we currently require GPUBufferUsage you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUBufferUsage>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<GPUBufferUsage>(impl.ptr());
#endif
    return createWrapper<GPUBufferUsage>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUBufferUsage& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUBufferUsage* JSGPUBufferUsage::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUBufferUsage*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
