/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTDisjointTimerQuery.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertWebGL.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSWebGLTimerQueryEXT.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsEXTDisjointTimerQueryPrototypeFunction_createQueryEXT);
static JSC_DECLARE_HOST_FUNCTION(jsEXTDisjointTimerQueryPrototypeFunction_deleteQueryEXT);
static JSC_DECLARE_HOST_FUNCTION(jsEXTDisjointTimerQueryPrototypeFunction_isQueryEXT);
static JSC_DECLARE_HOST_FUNCTION(jsEXTDisjointTimerQueryPrototypeFunction_beginQueryEXT);
static JSC_DECLARE_HOST_FUNCTION(jsEXTDisjointTimerQueryPrototypeFunction_endQueryEXT);
static JSC_DECLARE_HOST_FUNCTION(jsEXTDisjointTimerQueryPrototypeFunction_queryCounterEXT);
static JSC_DECLARE_HOST_FUNCTION(jsEXTDisjointTimerQueryPrototypeFunction_getQueryEXT);
static JSC_DECLARE_HOST_FUNCTION(jsEXTDisjointTimerQueryPrototypeFunction_getQueryObjectEXT);

class JSEXTDisjointTimerQueryPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTDisjointTimerQueryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTDisjointTimerQueryPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTDisjointTimerQueryPrototype>(vm)) JSEXTDisjointTimerQueryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTDisjointTimerQueryPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTDisjointTimerQueryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTDisjointTimerQueryPrototype, JSEXTDisjointTimerQueryPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSEXTDisjointTimerQueryPrototypeTableValues[] =
{
    { "createQueryEXT"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsEXTDisjointTimerQueryPrototypeFunction_createQueryEXT, 0 } },
    { "deleteQueryEXT"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsEXTDisjointTimerQueryPrototypeFunction_deleteQueryEXT, 1 } },
    { "isQueryEXT"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsEXTDisjointTimerQueryPrototypeFunction_isQueryEXT, 1 } },
    { "beginQueryEXT"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsEXTDisjointTimerQueryPrototypeFunction_beginQueryEXT, 2 } },
    { "endQueryEXT"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsEXTDisjointTimerQueryPrototypeFunction_endQueryEXT, 1 } },
    { "queryCounterEXT"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsEXTDisjointTimerQueryPrototypeFunction_queryCounterEXT, 2 } },
    { "getQueryEXT"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsEXTDisjointTimerQueryPrototypeFunction_getQueryEXT, 2 } },
    { "getQueryObjectEXT"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsEXTDisjointTimerQueryPrototypeFunction_getQueryObjectEXT, 2 } },
    { "QUERY_COUNTER_BITS_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8864 } },
    { "CURRENT_QUERY_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8865 } },
    { "QUERY_RESULT_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8866 } },
    { "QUERY_RESULT_AVAILABLE_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8867 } },
    { "TIME_ELAPSED_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x88BF } },
    { "TIMESTAMP_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8E28 } },
    { "GPU_DISJOINT_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8FBB } },
};

const ClassInfo JSEXTDisjointTimerQueryPrototype::s_info = { "EXTDisjointTimerQuery"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTDisjointTimerQueryPrototype) };

void JSEXTDisjointTimerQueryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEXTDisjointTimerQuery::info(), JSEXTDisjointTimerQueryPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTDisjointTimerQuery::s_info = { "EXTDisjointTimerQuery"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTDisjointTimerQuery) };

JSEXTDisjointTimerQuery::JSEXTDisjointTimerQuery(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTDisjointTimerQuery>&& impl)
    : JSDOMWrapper<EXTDisjointTimerQuery>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTDisjointTimerQuery>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTDisjointTimerQuery::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTDisjointTimerQueryPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTDisjointTimerQueryPrototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTDisjointTimerQuery::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTDisjointTimerQuery>(vm, globalObject);
}

void JSEXTDisjointTimerQuery::destroy(JSC::JSCell* cell)
{
    JSEXTDisjointTimerQuery* thisObject = static_cast<JSEXTDisjointTimerQuery*>(cell);
    thisObject->JSEXTDisjointTimerQuery::~JSEXTDisjointTimerQuery();
}

static inline JSC::EncodedJSValue jsEXTDisjointTimerQueryPrototypeFunction_createQueryEXTBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSEXTDisjointTimerQuery>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<WebGLTimerQueryEXT>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createQueryEXT())));
}

JSC_DEFINE_HOST_FUNCTION(jsEXTDisjointTimerQueryPrototypeFunction_createQueryEXT, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSEXTDisjointTimerQuery>::call<jsEXTDisjointTimerQueryPrototypeFunction_createQueryEXTBody>(*lexicalGlobalObject, *callFrame, "createQueryEXT");
}

static inline JSC::EncodedJSValue jsEXTDisjointTimerQueryPrototypeFunction_deleteQueryEXTBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSEXTDisjointTimerQuery>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto queryConversionResult = convert<IDLNullable<IDLInterface<WebGLTimerQueryEXT>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "query"_s, "EXTDisjointTimerQuery"_s, "deleteQueryEXT"_s, "WebGLTimerQueryEXT"_s); });
    if (UNLIKELY(queryConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.deleteQueryEXT(queryConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsEXTDisjointTimerQueryPrototypeFunction_deleteQueryEXT, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSEXTDisjointTimerQuery>::call<jsEXTDisjointTimerQueryPrototypeFunction_deleteQueryEXTBody>(*lexicalGlobalObject, *callFrame, "deleteQueryEXT");
}

static inline JSC::EncodedJSValue jsEXTDisjointTimerQueryPrototypeFunction_isQueryEXTBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSEXTDisjointTimerQuery>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto queryConversionResult = convert<IDLNullable<IDLInterface<WebGLTimerQueryEXT>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "query"_s, "EXTDisjointTimerQuery"_s, "isQueryEXT"_s, "WebGLTimerQueryEXT"_s); });
    if (UNLIKELY(queryConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isQueryEXT(queryConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsEXTDisjointTimerQueryPrototypeFunction_isQueryEXT, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSEXTDisjointTimerQuery>::call<jsEXTDisjointTimerQueryPrototypeFunction_isQueryEXTBody>(*lexicalGlobalObject, *callFrame, "isQueryEXT");
}

static inline JSC::EncodedJSValue jsEXTDisjointTimerQueryPrototypeFunction_beginQueryEXTBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSEXTDisjointTimerQuery>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto targetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(targetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto queryConversionResult = convert<IDLInterface<WebGLTimerQueryEXT>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "query"_s, "EXTDisjointTimerQuery"_s, "beginQueryEXT"_s, "WebGLTimerQueryEXT"_s); });
    if (UNLIKELY(queryConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.beginQueryEXT(targetConversionResult.releaseReturnValue(), *queryConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsEXTDisjointTimerQueryPrototypeFunction_beginQueryEXT, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSEXTDisjointTimerQuery>::call<jsEXTDisjointTimerQueryPrototypeFunction_beginQueryEXTBody>(*lexicalGlobalObject, *callFrame, "beginQueryEXT");
}

static inline JSC::EncodedJSValue jsEXTDisjointTimerQueryPrototypeFunction_endQueryEXTBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSEXTDisjointTimerQuery>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto targetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(targetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.endQueryEXT(targetConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsEXTDisjointTimerQueryPrototypeFunction_endQueryEXT, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSEXTDisjointTimerQuery>::call<jsEXTDisjointTimerQueryPrototypeFunction_endQueryEXTBody>(*lexicalGlobalObject, *callFrame, "endQueryEXT");
}

static inline JSC::EncodedJSValue jsEXTDisjointTimerQueryPrototypeFunction_queryCounterEXTBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSEXTDisjointTimerQuery>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto queryConversionResult = convert<IDLInterface<WebGLTimerQueryEXT>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "query"_s, "EXTDisjointTimerQuery"_s, "queryCounterEXT"_s, "WebGLTimerQueryEXT"_s); });
    if (UNLIKELY(queryConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto targetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(targetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.queryCounterEXT(*queryConversionResult.releaseReturnValue(), targetConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsEXTDisjointTimerQueryPrototypeFunction_queryCounterEXT, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSEXTDisjointTimerQuery>::call<jsEXTDisjointTimerQueryPrototypeFunction_queryCounterEXTBody>(*lexicalGlobalObject, *callFrame, "queryCounterEXT");
}

static inline JSC::EncodedJSValue jsEXTDisjointTimerQueryPrototypeFunction_getQueryEXTBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSEXTDisjointTimerQuery>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto targetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(targetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto pnameConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(pnameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getQueryEXT(targetConversionResult.releaseReturnValue(), pnameConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsEXTDisjointTimerQueryPrototypeFunction_getQueryEXT, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSEXTDisjointTimerQuery>::call<jsEXTDisjointTimerQueryPrototypeFunction_getQueryEXTBody>(*lexicalGlobalObject, *callFrame, "getQueryEXT");
}

static inline JSC::EncodedJSValue jsEXTDisjointTimerQueryPrototypeFunction_getQueryObjectEXTBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSEXTDisjointTimerQuery>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto queryConversionResult = convert<IDLInterface<WebGLTimerQueryEXT>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "query"_s, "EXTDisjointTimerQuery"_s, "getQueryObjectEXT"_s, "WebGLTimerQueryEXT"_s); });
    if (UNLIKELY(queryConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto pnameConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(pnameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getQueryObjectEXT(*queryConversionResult.releaseReturnValue(), pnameConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsEXTDisjointTimerQueryPrototypeFunction_getQueryObjectEXT, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSEXTDisjointTimerQuery>::call<jsEXTDisjointTimerQueryPrototypeFunction_getQueryObjectEXTBody>(*lexicalGlobalObject, *callFrame, "getQueryObjectEXT");
}

JSC::GCClient::IsoSubspace* JSEXTDisjointTimerQuery::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTDisjointTimerQuery, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTDisjointTimerQuery.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTDisjointTimerQuery = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTDisjointTimerQuery.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTDisjointTimerQuery = std::forward<decltype(space)>(space); }
    );
}

void JSEXTDisjointTimerQuery::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTDisjointTimerQuery*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTDisjointTimerQueryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsEXTDisjointTimerQuery = jsCast<JSEXTDisjointTimerQuery*>(handle.slot()->asCell());
    auto& owner = jsEXTDisjointTimerQuery->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsEXTDisjointTimerQuery"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTDisjointTimerQueryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTDisjointTimerQuery = static_cast<JSEXTDisjointTimerQuery*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEXTDisjointTimerQuery->protectedWrapped().ptr(), jsEXTDisjointTimerQuery);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTDisjointTimerQuery@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21EXTDisjointTimerQueryE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, EXTDisjointTimerQuery>, void>> static inline void verifyVTable(EXTDisjointTimerQuery* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTDisjointTimerQuery@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21EXTDisjointTimerQueryE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTDisjointTimerQuery has subclasses. If EXTDisjointTimerQuery has subclasses that get passed
        // to toJS() we currently require EXTDisjointTimerQuery you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTDisjointTimerQuery>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<EXTDisjointTimerQuery>(impl.ptr());
#endif
    return createWrapper<EXTDisjointTimerQuery>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTDisjointTimerQuery& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTDisjointTimerQuery* JSEXTDisjointTimerQuery::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTDisjointTimerQuery*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
