/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioListener.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAudioParam.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsAudioListenerPrototypeFunction_setPosition);
static JSC_DECLARE_HOST_FUNCTION(jsAudioListenerPrototypeFunction_setOrientation);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsAudioListenerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioListener_positionX);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioListener_positionY);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioListener_positionZ);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioListener_forwardX);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioListener_forwardY);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioListener_forwardZ);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioListener_upX);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioListener_upY);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioListener_upZ);

class JSAudioListenerPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAudioListenerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioListenerPrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioListenerPrototype>(vm)) JSAudioListenerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioListenerPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioListenerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioListenerPrototype, JSAudioListenerPrototype::Base);

using JSAudioListenerDOMConstructor = JSDOMConstructorNotConstructable<JSAudioListener>;

template<> const ClassInfo JSAudioListenerDOMConstructor::s_info = { "AudioListener"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioListenerDOMConstructor) };

template<> JSValue JSAudioListenerDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSAudioListenerDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AudioListener"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSAudioListener::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSAudioListenerPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioListenerConstructor, 0 } },
    { "positionX"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioListener_positionX, 0 } },
    { "positionY"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioListener_positionY, 0 } },
    { "positionZ"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioListener_positionZ, 0 } },
    { "forwardX"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioListener_forwardX, 0 } },
    { "forwardY"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioListener_forwardY, 0 } },
    { "forwardZ"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioListener_forwardZ, 0 } },
    { "upX"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioListener_upX, 0 } },
    { "upY"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioListener_upY, 0 } },
    { "upZ"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioListener_upZ, 0 } },
    { "setPosition"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioListenerPrototypeFunction_setPosition, 3 } },
    { "setOrientation"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioListenerPrototypeFunction_setOrientation, 6 } },
};

const ClassInfo JSAudioListenerPrototype::s_info = { "AudioListener"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioListenerPrototype) };

void JSAudioListenerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioListener::info(), JSAudioListenerPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSAudioListener::s_info = { "AudioListener"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioListener) };

JSAudioListener::JSAudioListener(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioListener>&& impl)
    : JSDOMWrapper<AudioListener>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, AudioListener>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSAudioListener::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSAudioListenerPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSAudioListenerPrototype::create(vm, &globalObject, structure);
}

JSObject* JSAudioListener::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAudioListener>(vm, globalObject);
}

JSValue JSAudioListener::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioListenerDOMConstructor, DOMConstructorID::AudioListener>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSAudioListener::destroy(JSC::JSCell* cell)
{
    JSAudioListener* thisObject = static_cast<JSAudioListener*>(cell);
    thisObject->JSAudioListener::~JSAudioListener();
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioListenerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioListenerPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAudioListener::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsAudioListener_positionXGetter(JSGlobalObject& lexicalGlobalObject, JSAudioListener& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.positionX())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioListener_positionX, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioListener>::get<jsAudioListener_positionXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioListener_positionYGetter(JSGlobalObject& lexicalGlobalObject, JSAudioListener& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.positionY())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioListener_positionY, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioListener>::get<jsAudioListener_positionYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioListener_positionZGetter(JSGlobalObject& lexicalGlobalObject, JSAudioListener& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.positionZ())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioListener_positionZ, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioListener>::get<jsAudioListener_positionZGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioListener_forwardXGetter(JSGlobalObject& lexicalGlobalObject, JSAudioListener& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.forwardX())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioListener_forwardX, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioListener>::get<jsAudioListener_forwardXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioListener_forwardYGetter(JSGlobalObject& lexicalGlobalObject, JSAudioListener& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.forwardY())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioListener_forwardY, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioListener>::get<jsAudioListener_forwardYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioListener_forwardZGetter(JSGlobalObject& lexicalGlobalObject, JSAudioListener& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.forwardZ())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioListener_forwardZ, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioListener>::get<jsAudioListener_forwardZGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioListener_upXGetter(JSGlobalObject& lexicalGlobalObject, JSAudioListener& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.upX())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioListener_upX, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioListener>::get<jsAudioListener_upXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioListener_upYGetter(JSGlobalObject& lexicalGlobalObject, JSAudioListener& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.upY())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioListener_upY, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioListener>::get<jsAudioListener_upYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioListener_upZGetter(JSGlobalObject& lexicalGlobalObject, JSAudioListener& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.upZ())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioListener_upZ, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioListener>::get<jsAudioListener_upZGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsAudioListenerPrototypeFunction_setPositionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioListener>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(xConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(yConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto zConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(zConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setPosition(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), zConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioListenerPrototypeFunction_setPosition, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioListener>::call<jsAudioListenerPrototypeFunction_setPositionBody>(*lexicalGlobalObject, *callFrame, "setPosition");
}

static inline JSC::EncodedJSValue jsAudioListenerPrototypeFunction_setOrientationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioListener>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(xConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(yConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto zConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(zConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto xUpConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument3.value());
    if (UNLIKELY(xUpConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto yUpConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument4.value());
    if (UNLIKELY(yUpConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto zUpConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument5.value());
    if (UNLIKELY(zUpConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setOrientation(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), zConversionResult.releaseReturnValue(), xUpConversionResult.releaseReturnValue(), yUpConversionResult.releaseReturnValue(), zUpConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioListenerPrototypeFunction_setOrientation, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioListener>::call<jsAudioListenerPrototypeFunction_setOrientationBody>(*lexicalGlobalObject, *callFrame, "setOrientation");
}

JSC::GCClient::IsoSubspace* JSAudioListener::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSAudioListener, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForAudioListener.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForAudioListener = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForAudioListener.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForAudioListener = std::forward<decltype(space)>(space); }
    );
}

void JSAudioListener::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAudioListener*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSAudioListenerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSAudioListenerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioListener = static_cast<JSAudioListener*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsAudioListener->protectedWrapped().ptr(), jsAudioListener);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioListener@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13AudioListenerE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, AudioListener>, void>> static inline void verifyVTable(AudioListener* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7AudioListener@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13AudioListenerE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // AudioListener has subclasses. If AudioListener has subclasses that get passed
        // to toJS() we currently require AudioListener you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AudioListener>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<AudioListener>(impl.ptr());
#endif
    return createWrapper<AudioListener>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AudioListener& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

AudioListener* JSAudioListener::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAudioListener*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
