/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * Copyright (C) 2017-2023 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebPreferences.h"

#include "WebKit2Initialize.h"
#include "WebPreferencesDefinitions.h"
#include "WebPreferencesKeys.h"
#include <wtf/ExperimentalFeatureNames.h>
#include <wtf/NeverDestroyed.h>

namespace WebKit {

const Vector<RefPtr<API::Object>>& WebPreferences::features()
{
    InitializeWebKit2();
    static NeverDestroyed<Vector<RefPtr<API::Object>>> features(std::initializer_list<RefPtr<API::Object>> {
        API::Feature::create(""""_s, "AcceleratedCompositingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AcceleratedCompositingEnabled, false),
        API::Feature::create(""""_s, "AcceleratedCompositingForFixedPositionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AcceleratedCompositingForFixedPositionEnabled, false),
        API::Feature::create(""""_s, "AggressiveTileRetentionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AggressiveTileRetentionEnabled, false),
        API::Feature::create(""""_s, "AllowContentSecurityPolicySourceStarToMatchAnyProtocol"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AllowContentSecurityPolicySourceStarToMatchAnyProtocol, false),
        API::Feature::create(""""_s, "AllowDisplayOfInsecureContent"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AllowDisplayOfInsecureContent, false),
        API::Feature::create(""""_s, "AllowFileAccessFromFileURLs"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AllowFileAccessFromFileURLs, false),
        API::Feature::create(""""_s, "AllowMultiElementImplicitSubmission"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AllowMultiElementImplicitSubmission, false),
        API::Feature::create(""""_s, "AllowRunningOfInsecureContent"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AllowRunningOfInsecureContent, false),
        API::Feature::create(""""_s, "AllowSettingAnyXHRHeaderFromFileURLs"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AllowSettingAnyXHRHeaderFromFileURLs, false),
        API::Feature::create(""""_s, "AllowTestOnlyIPC"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AllowTestOnlyIPC, false),
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        API::Feature::create(""""_s, "AllowsAirPlayForMediaPlayback"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AllowsAirPlayForMediaPlayback, false),
#endif
        API::Feature::create(""""_s, "AllowsInlineMediaPlayback"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AllowsInlineMediaPlayback, false),
        API::Feature::create(""""_s, "AllowsInlineMediaPlaybackAfterFullscreen"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AllowsInlineMediaPlaybackAfterFullscreen, false),
        API::Feature::create(""""_s, "AllowsPictureInPictureMediaPlayback"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AllowsPictureInPictureMediaPlayback, false),
#if PLATFORM(IOS_FAMILY)
        API::Feature::create(""""_s, "AlternateFormControlDesignEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AlternateFormControlDesignEnabled, false),
#endif
#if PLATFORM(IOS_FAMILY)
        API::Feature::create(""""_s, "AlternateFullScreenControlDesignEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AlternateFullScreenControlDesignEnabled, false),
#endif
        API::Feature::create(""""_s, "AnimatedImageAsyncDecodingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AnimatedImageAsyncDecodingEnabled, false),
        API::Feature::create(""""_s, "AppleMailPaginationQuirkEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AppleMailPaginationQuirkEnabled, false),
#if ENABLE(APPLE_PAY)
        API::Feature::create(""""_s, "ApplePayCapabilityDisclosureAllowed"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ApplePayCapabilityDisclosureAllowed, false),
#endif
#if ENABLE(APPLE_PAY)
        API::Feature::create(""""_s, "ApplePayEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ApplePayEnabled, false),
#endif
        API::Feature::create(""""_s, "AsynchronousSpellCheckingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AsynchronousSpellCheckingEnabled, false),
        API::Feature::create(""""_s, "AudioControlsScaleWithPageZoom"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::Media, """"_s, DEFAULT_VALUE_FOR_AudioControlsScaleWithPageZoom, false),
        API::Feature::create(""""_s, "AuthorAndUserStylesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AuthorAndUserStylesEnabled, false),
        API::Feature::create(""""_s, "BackspaceKeyNavigationEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_BackspaceKeyNavigationEnabled, false),
        API::Feature::create(""""_s, "CaretBrowsingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_CaretBrowsingEnabled, false),
        API::Feature::create(""""_s, "ColorFilterEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ColorFilterEnabled, false),
#if ENABLE(CONTENT_CHANGE_OBSERVER)
        API::Feature::create(""""_s, "ContentChangeObserverEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ContentChangeObserverEnabled, false),
#endif
        API::Feature::create(""""_s, "ContentDispositionAttachmentSandboxEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ContentDispositionAttachmentSandboxEnabled, false),
#if ENABLE(CONTEXT_MENU_QR_CODE_DETECTION)
        API::Feature::create(""""_s, "ContextMenuQRCodeDetectionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ContextMenuQRCodeDetectionEnabled, false),
#endif
        API::Feature::create(""""_s, "DNSPrefetchingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_DNSPrefetchingEnabled, false),
        API::Feature::create(""""_s, "DOMPasteAllowed"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_DOMPasteAllowed, false),
        API::Feature::create(""""_s, "DatabasesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_DatabasesEnabled, false),
        API::Feature::create(""""_s, "DeveloperExtrasEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_DeveloperExtrasEnabled, false),
#if ENABLE(DEVICE_ORIENTATION)
        API::Feature::create(""""_s, "DeviceOrientationEventEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_DeviceOrientationEventEnabled, false),
#endif
#if ENABLE(DEVICE_ORIENTATION)
        API::Feature::create(""""_s, "DeviceOrientationPermissionAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_DeviceOrientationPermissionAPIEnabled, false),
#endif
        API::Feature::create(""""_s, "DisabledAdaptationsMetaTagEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_DisabledAdaptationsMetaTagEnabled, false),
        API::Feature::create(""""_s, "DownloadAttributeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_DownloadAttributeEnabled, false),
        API::Feature::create(""""_s, "EnableInheritURIQueryComponent"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_EnableInheritURIQueryComponent, false),
#if ENABLE(ENCRYPTED_MEDIA)
        API::Feature::create(""""_s, "EncryptedMediaAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_EncryptedMediaAPIEnabled, false),
#endif
#if HAVE(APP_SSO)
        API::Feature::create(""""_s, "ExtensibleSSOEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ExtensibleSSOEnabled, false),
#endif
        API::Feature::create(""""_s, "ForceCompositingMode"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ForceCompositingMode, false),
        API::Feature::create(""""_s, "ForceFTPDirectoryListings"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ForceFTPDirectoryListings, false),
        API::Feature::create(""""_s, "ForceWebGLUsesLowPower"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ForceWebGLUsesLowPower, false),
#if USE(GSTREAMER)
        API::Feature::create(""""_s, "GStreamerEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_GStreamerEnabled, false),
#endif
        API::Feature::create(""""_s, "HiddenPageCSSAnimationSuspensionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_HiddenPageCSSAnimationSuspensionEnabled, false),
        API::Feature::create(""""_s, "IncompleteImageBorderEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_IncompleteImageBorderEnabled, false),
#if HAVE(INCREMENTAL_PDF_APIS)
        API::Feature::create(""""_s, "IncrementalPDFLoadingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_IncrementalPDFLoadingEnabled, false),
#endif
        API::Feature::create(""""_s, "InlineMediaPlaybackRequiresPlaysInlineAttribute"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_InlineMediaPlaybackRequiresPlaysInlineAttribute, false),
        API::Feature::create(""""_s, "InspectorStartsAttached"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_InspectorStartsAttached, false),
#if ENABLE(MEDIA_STREAM)
        API::Feature::create(""""_s, "InterruptAudioOnPageVisibilityChangeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_InterruptAudioOnPageVisibilityChangeEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::Feature::create(""""_s, "InterruptVideoOnPageVisibilityChangeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_InterruptVideoOnPageVisibilityChangeEnabled, false),
#endif
        API::Feature::create(""""_s, "InvisibleAutoplayNotPermitted"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_InvisibleAutoplayNotPermitted, false),
        API::Feature::create(""""_s, "JavaScriptCanAccessClipboard"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_JavaScriptCanAccessClipboard, false),
        API::Feature::create(""""_s, "JavaScriptCanOpenWindowsAutomatically"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_JavaScriptCanOpenWindowsAutomatically, false),
        API::Feature::create(""""_s, "JavaScriptMarkupEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_JavaScriptMarkupEnabled, false),
        API::Feature::create(""""_s, "LargeImageAsyncDecodingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_LargeImageAsyncDecodingEnabled, false),
        API::Feature::create(""""_s, "LinkPreconnect"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_LinkPreconnect, false),
        API::Feature::create(""""_s, "LinkPreloadEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_LinkPreloadEnabled, false),
        API::Feature::create(""""_s, "LoadDeferringEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_LoadDeferringEnabled, false),
        API::Feature::create(""""_s, "LoadsImagesAutomatically"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_LoadsImagesAutomatically, false),
        API::Feature::create(""""_s, "LowPowerVideoAudioBufferSizeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_LowPowerVideoAudioBufferSizeEnabled, false),
#if ENABLE(MATHML)
        API::Feature::create(""""_s, "MathMLEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_MathMLEnabled, false),
#endif
        API::Feature::create(""""_s, "MediaCapabilitiesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_MediaCapabilitiesEnabled, false),
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS)
        API::Feature::create(""""_s, "MediaControlsContextMenusEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_MediaControlsContextMenusEnabled, false),
#endif
        API::Feature::create(""""_s, "MediaControlsScaleWithPageZoom"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_MediaControlsScaleWithPageZoom, false),
        API::Feature::create(""""_s, "MediaDataLoadsAutomatically"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_MediaDataLoadsAutomatically, false),
#if ENABLE(VIDEO)
        API::Feature::create(""""_s, "MediaEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_MediaEnabled, false),
#endif
        API::Feature::create(""""_s, "MediaPreloadingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_MediaPreloadingEnabled, false),
#if ENABLE(MEDIA_STREAM)
        API::Feature::create(""""_s, "MediaStreamEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_MediaStreamEnabled, false),
#endif
        API::Feature::create(""""_s, "MediaUserGestureInheritsFromDocument"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_MediaUserGestureInheritsFromDocument, false),
        API::Feature::create(""""_s, "MockCaptureDevicesPromptEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_MockCaptureDevicesPromptEnabled, false),
        API::Feature::create(""""_s, "MockScrollbarsControllerEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_MockScrollbarsControllerEnabled, false),
        API::Feature::create(""""_s, "MockScrollbarsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_MockScrollbarsEnabled, false),
        API::Feature::create(""""_s, "NeedsAdobeFrameReloadingQuirk"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_NeedsAdobeFrameReloadingQuirk, false),
        API::Feature::create(""""_s, "NeedsFrameNameFallbackToIdQuirk"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_NeedsFrameNameFallbackToIdQuirk, false),
        API::Feature::create(""""_s, "NeedsKeyboardEventDisambiguationQuirks"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_NeedsKeyboardEventDisambiguationQuirks, false),
#if PLATFORM(COCOA)
        API::Feature::create(""""_s, "PDFPluginEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_PDFPluginEnabled, false),
#endif
#if PLATFORM(COCOA)
        API::Feature::create(""""_s, "PDFPluginHUDEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_PDFPluginHUDEnabled, false),
#endif
        API::Feature::create(""""_s, "PassiveTouchListenersAsDefaultOnDocument"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_PassiveTouchListenersAsDefaultOnDocument, false),
        API::Feature::create(""""_s, "PasswordEchoEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_PasswordEchoEnabled, false),
#if ENABLE(PICTURE_IN_PICTURE_API)
        API::Feature::create(""""_s, "PictureInPictureAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_PictureInPictureAPIEnabled, false),
#endif
        API::Feature::create(""""_s, "PunchOutWhiteBackgroundsInDarkMode"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_PunchOutWhiteBackgroundsInDarkMode, false),
        API::Feature::create(""""_s, "RequiresPageVisibilityToPlayAudio"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_RequiresPageVisibilityToPlayAudio, false),
        API::Feature::create(""""_s, "RequiresUserGestureForAudioPlayback"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_RequiresUserGestureForAudioPlayback, false),
        API::Feature::create(""""_s, "RequiresUserGestureForMediaPlayback"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_RequiresUserGestureForMediaPlayback, false),
        API::Feature::create(""""_s, "RequiresUserGestureForVideoPlayback"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_RequiresUserGestureForVideoPlayback, false),
        API::Feature::create(""""_s, "RequiresUserGestureToLoadVideo"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_RequiresUserGestureToLoadVideo, false),
#if HAVE(RUBBER_BANDING)
        API::Feature::create(""""_s, "RubberBandingForSubScrollableRegionsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_RubberBandingForSubScrollableRegionsEnabled, false),
#endif
        API::Feature::create(""""_s, "SelectTrailingWhitespaceEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_SelectTrailingWhitespaceEnabled, false),
#if ENABLE(SERVICE_CONTROLS)
        API::Feature::create(""""_s, "ServiceControlsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ServiceControlsEnabled, false),
#endif
        API::Feature::create(""""_s, "ServiceWorkerEntitlementDisabledForTesting"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ServiceWorkerEntitlementDisabledForTesting, false),
        API::Feature::create(""""_s, "ShouldAllowUserInstalledFonts"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShouldAllowUserInstalledFonts, false),
        API::Feature::create(""""_s, "ShouldConvertInvalidURLsToBlank"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShouldConvertInvalidURLsToBlank, false),
        API::Feature::create(""""_s, "ShouldConvertPositionStyleOnCopy"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShouldConvertPositionStyleOnCopy, false),
        API::Feature::create(""""_s, "ShouldDecidePolicyBeforeLoadingQuickLookPreview"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShouldDecidePolicyBeforeLoadingQuickLookPreview, false),
#if ENABLE(VIDEO)
        API::Feature::create(""""_s, "ShouldDisplayCaptions"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShouldDisplayCaptions, false),
#endif
#if ENABLE(VIDEO)
        API::Feature::create(""""_s, "ShouldDisplaySubtitles"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShouldDisplaySubtitles, false),
#endif
#if ENABLE(VIDEO)
        API::Feature::create(""""_s, "ShouldDisplayTextDescriptions"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShouldDisplayTextDescriptions, false),
#endif
#if ENABLE(TEXT_AUTOSIZING)
        API::Feature::create(""""_s, "ShouldEnableTextAutosizingBoost"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShouldEnableTextAutosizingBoost, false),
#endif
        API::Feature::create(""""_s, "ShouldIgnoreMetaViewport"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShouldIgnoreMetaViewport, false),
        API::Feature::create(""""_s, "ShouldPrintBackgrounds"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShouldPrintBackgrounds, false),
        API::Feature::create(""""_s, "ShouldRespectImageOrientation"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShouldRespectImageOrientation, false),
        API::Feature::create(""""_s, "ShouldRestrictBaseURLSchemes"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShouldRestrictBaseURLSchemes, false),
        API::Feature::create(""""_s, "ShouldSuppressTextInputFromEditingDuringProvisionalNavigation"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShouldSuppressTextInputFromEditingDuringProvisionalNavigation, false),
        API::Feature::create(""""_s, "ShouldUseServiceWorkerShortTimeout"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShouldUseServiceWorkerShortTimeout, false),
        API::Feature::create(""""_s, "ShowsToolTipOverTruncatedText"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShowsToolTipOverTruncatedText, false),
        API::Feature::create(""""_s, "ShowsURLsInToolTipsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShowsURLsInToolTipsEnabled, false),
        API::Feature::create(""""_s, "ShrinksStandaloneImagesToFit"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ShrinksStandaloneImagesToFit, false),
        API::Feature::create(""""_s, "SmartInsertDeleteEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_SmartInsertDeleteEnabled, false),
#if ENABLE(MEDIA_SOURCE)
        API::Feature::create(""""_s, "SourceBufferChangeTypeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_SourceBufferChangeTypeEnabled, false),
#endif
        API::Feature::create(""""_s, "SpatialNavigationEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_SpatialNavigationEnabled, false),
        API::Feature::create(""""_s, "Standalone"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_Standalone, false),
        API::Feature::create(""""_s, "SuppressesIncrementalRendering"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_SuppressesIncrementalRendering, false),
#if USE(SYSTEM_PREVIEW)
        API::Feature::create(""""_s, "SystemPreviewEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_SystemPreviewEnabled, false),
#endif
        API::Feature::create(""""_s, "TabsToLinks"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_TabsToLinks, false),
        API::Feature::create(""""_s, "TelephoneNumberParsingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_TelephoneNumberParsingEnabled, false),
        API::Feature::create(""""_s, "TemporaryTileCohortRetentionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_TemporaryTileCohortRetentionEnabled, false),
        API::Feature::create(""""_s, "TextAreasAreResizable"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_TextAreasAreResizable, false),
#if ENABLE(TEXT_AUTOSIZING)
        API::Feature::create(""""_s, "TextAutosizingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_TextAutosizingEnabled, false),
#endif
        API::Feature::create(""""_s, "TextExtractionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_TextExtractionEnabled, false),
        API::Feature::create(""""_s, "TextInteractionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_TextInteractionEnabled, false),
        API::Feature::create(""""_s, "ThreadedScrollingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ThreadedScrollingEnabled, false),
        API::Feature::create(""""_s, "TreatsAnyTextCSSLinkAsStylesheet"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_TreatsAnyTextCSSLinkAsStylesheet, false),
        API::Feature::create(""""_s, "UseImageDocumentForSubframePDF"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_UseImageDocumentForSubframePDF, false),
        API::Feature::create(""""_s, "UsePreHTML5ParserQuirks"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_UsePreHTML5ParserQuirks, false),
        API::Feature::create(""""_s, "UsesBackForwardCache"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_UsesBackForwardCache, false),
        API::Feature::create(""""_s, "UsesEncodingDetector"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_UsesEncodingDetector, false),
        API::Feature::create(""""_s, "UsesSingleWebProcess"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_UsesSingleWebProcess, false),
#if ENABLE(VP9)
        API::Feature::create(""""_s, "VP8DecoderEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_VP8DecoderEnabled, false),
#endif
#if ENABLE(VP9)
        API::Feature::create(""""_s, "VP9DecoderEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_VP9DecoderEnabled, false),
#endif
#if PLATFORM(IOS_FAMILY)
        API::Feature::create(""""_s, "VideoFullscreenRequiresElementFullscreen"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_VideoFullscreenRequiresElementFullscreen, false),
#endif
        API::Feature::create(""""_s, "VideoPresentationModeAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_VideoPresentationModeAPIEnabled, false),
#if ENABLE(VIDEO)
        API::Feature::create(""""_s, "VideoQualityIncludesDisplayCompositingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_VideoQualityIncludesDisplayCompositingEnabled, false),
#endif
        API::Feature::create(""""_s, "VisualViewportEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_VisualViewportEnabled, false),
        API::Feature::create(""""_s, "WantsBalancedSetDefersLoadingBehavior"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_WantsBalancedSetDefersLoadingBehavior, false),
#if ENABLE(WEB_AUDIO)
        API::Feature::create(""""_s, "WebAudioEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_WebAudioEnabled, false),
#endif
#if ENABLE(WEBM_FORMAT_READER)
        API::Feature::create(""""_s, "WebMFormatReaderEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_WebMFormatReaderEnabled, false),
#endif
#if ENABLE(MEDIA_SOURCE)
        API::Feature::create(""""_s, "WebMParserEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_WebMParserEnabled, false),
#endif
        API::Feature::create(""""_s, "WebSecurityEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_WebSecurityEnabled, false),
        API::Feature::create(""""_s, "WebSocketEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_WebSocketEnabled, false),
        API::Feature::create(""""_s, "WindowFocusRestricted"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_WindowFocusRestricted, false),
        API::Feature::create(""""_s, "WirelessPlaybackTargetAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_WirelessPlaybackTargetAPIEnabled, false),
        API::Feature::create("::grammar-error and ::spelling-error pseudo-elements"""_s, "GrammarAndSpellingPseudoElementsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable the ::grammar-error and ::spelling-error CSS pseudo-elements"""_s, DEFAULT_VALUE_FOR_GrammarAndSpellingPseudoElementsEnabled, false),
        API::Feature::create("::target-text pseudo-element"""_s, "TargetTextPseudoElementEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable the ::target-text CSS pseudo-element"""_s, DEFAULT_VALUE_FOR_TargetTextPseudoElementEnabled, false),
        API::Feature::create("::thumb and ::track pseudo-elements"""_s, "ThumbAndTrackPseudoElementsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable support for CSS ::thumb and ::track pseudo-elements"""_s, DEFAULT_VALUE_FOR_ThumbAndTrackPseudoElementsEnabled, false),
        API::Feature::create("<select> showPicker() method"""_s, "SelectShowPickerEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Enable showPicker() method on <select>"""_s, DEFAULT_VALUE_FOR_SelectShowPickerEnabled, false),
        API::Feature::create("@page CSS at-rule margin descriptors"""_s, "PageAtRuleMarginDescriptorsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable support for @page margin descriptors"""_s, DEFAULT_VALUE_FOR_PageAtRuleMarginDescriptorsEnabled, false),
#if USE(AVFOUNDATION)
        API::Feature::create("AVFoundation"""_s, "AVFoundationEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable AVFoundation"""_s, DEFAULT_VALUE_FOR_AVFoundationEnabled, false),
#endif
        API::Feature::create("AbortSignal.any() API"""_s, "AbortSignalAnyOperationEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable AbortSignal.any() API"""_s, DEFAULT_VALUE_FOR_AbortSignalAnyOperationEnabled, false),
#if USE(CORE_IMAGE)
        API::Feature::create("Accelerated Filter Rendering"""_s, "AcceleratedFiltersEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::None, "Accelerated CSS and SVG filter rendering"""_s, DEFAULT_VALUE_FOR_AcceleratedFiltersEnabled, false),
#endif
        API::Feature::create("AccessHandle API"""_s, "AccessHandleEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable AccessHandle API"""_s, DEFAULT_VALUE_FOR_AccessHandleEnabled, false),
        API::Feature::create("Additional Testing APIs for DOM Objects"""_s, "DOMTestingAPIsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Enable additional testing APIs for DOM objects"""_s, DEFAULT_VALUE_FOR_DOMTestingAPIsEnabled, false),
        API::Feature::create("Allow Media Content Types Requirining Hardware As Fallback"""_s, "AllowMediaContentTypesRequiringHardwareSupportAsFallback"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Allow Media Content Types Requirining Hardware As Fallback"""_s, DEFAULT_VALUE_FOR_AllowMediaContentTypesRequiringHardwareSupportAsFallback, false),
        API::Feature::create("Allow Privacy-Sensitive Operations in Non-Persistent Data Stores"""_s, "AllowPrivacySensitiveOperationsInNonPersistentDataStores"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Allow Privacy-Sensitive Operations in Non-Persistent Data Stores"""_s, DEFAULT_VALUE_FOR_AllowPrivacySensitiveOperationsInNonPersistentDataStores, false),
#if PLATFORM(IOS_FAMILY)
        API::Feature::create("Allow Viewport Shrink to Fit Content"""_s, "AllowViewportShrinkToFitContent"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Allow the viewport shrink to fit content heuristic when appropriate"""_s, DEFAULT_VALUE_FOR_AllowViewportShrinkToFitContent, false),
#endif
#if ENABLE(WEBGL)
        API::Feature::create("Allow WebGL in Web Workers"""_s, "AllowWebGLInWorkers"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, """"_s, DEFAULT_VALUE_FOR_AllowWebGLInWorkers, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::Feature::create("Allow per media element speaker device selection"""_s, "PerElementSpeakerSelectionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Media, "Allow per media element speaker device selection"""_s, DEFAULT_VALUE_FOR_PerElementSpeakerSelectionEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::Feature::create("Allow speaker device selection"""_s, "ExposeSpeakersEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Media, "Allow speaker device selection"""_s, DEFAULT_VALUE_FOR_ExposeSpeakersEnabled, false),
#endif
        API::Feature::create("Allow top navigation to data: URLs"""_s, "AllowTopNavigationToDataURLs"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_AllowTopNavigationToDataURLs, false),
        API::Feature::create("Allow universal access from file: URLs"""_s, "AllowUniversalAccessFromFileURLs"_s, API::FeatureConstant<API::FeatureStatus::Developer>{}, API::FeatureCategory::Security, """"_s, DEFAULT_VALUE_FOR_AllowUniversalAccessFromFileURLs, false),
#if ENABLE(ALTERNATE_WEBM_PLAYER) && ENABLE(MEDIA_SOURCE)
        API::Feature::create("Alternate WebM Player"""_s, "AlternateWebMPlayerEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "Enable Alternate WebM Player"""_s, DEFAULT_VALUE_FOR_AlternateWebMPlayerEnabled, false),
#endif
#if ENABLE(WEB_ARCHIVE)
        API::Feature::create("Always allow loading local Web Archive"""_s, "AlwaysAllowLocalWebarchive"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Enable always allowing loading local Web Archive"""_s, DEFAULT_VALUE_FOR_AlwaysAllowLocalWebarchive, false),
#endif
#if ENABLE(VP9)
        API::Feature::create("Always enable VPx software decoders"""_s, "SWVPDecodersAlwaysEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Always enable VPx software decoders"""_s, DEFAULT_VALUE_FOR_SWVPDecodersAlwaysEnabled, false),
#endif
        API::Feature::create("App Badge"""_s, "AppBadgeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::DOM, "Enable App Badge"""_s, DEFAULT_VALUE_FOR_AppBadgeEnabled, false),
#if ENABLE(APP_HIGHLIGHTS)
        API::Feature::create("App Highlights"""_s, "AppHighlightsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::CSS, "Enable App Highlights"""_s, DEFAULT_VALUE_FOR_AppHighlightsEnabled, false),
#endif
        API::Feature::create("Async Frame Scrolling"""_s, "AsyncFrameScrollingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Perform frame scrolling off the main thread"""_s, DEFAULT_VALUE_FOR_AsyncFrameScrollingEnabled, false),
        API::Feature::create("Async Overflow Scrolling"""_s, "AsyncOverflowScrollingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Perform overflow scrolling off the main thread"""_s, DEFAULT_VALUE_FOR_AsyncOverflowScrollingEnabled, false),
#if PLATFORM(IOS_FAMILY)
        API::Feature::create("Async UIKit Interactions"""_s, "UseAsyncUIKitInteractions"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Use Async UIKit Interactions"""_s, DEFAULT_VALUE_FOR_UseAsyncUIKitInteractions, false),
#endif
        API::Feature::create("Async clipboard API"""_s, "AsyncClipboardAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::None, "Enable the async clipboard API"""_s, DEFAULT_VALUE_FOR_AsyncClipboardAPIEnabled, false),
#if ENABLE(ATTACHMENT_ELEMENT)
        API::Feature::create("Attachment Element"""_s, "AttachmentElementEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Allow the insertion of attachment elements"""_s, DEFAULT_VALUE_FOR_AttachmentElementEnabled, false),
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
        API::Feature::create("Attachment wide-layout styling"""_s, "AttachmentWideLayoutEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Use horizontal wide-layout attachment style, requires Attachment Element"""_s, DEFAULT_VALUE_FOR_AttachmentWideLayoutEnabled, false),
#endif
#if ENABLE(VIDEO)
        API::Feature::create("Audio descriptions for video - Extended"""_s, "ExtendedAudioDescriptionsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Preview>{}, API::FeatureCategory::Media, "Enable extended audio descriptions for video"""_s, DEFAULT_VALUE_FOR_ExtendedAudioDescriptionsEnabled, false),
#endif
#if ENABLE(VIDEO)
        API::Feature::create("Audio descriptions for video - Standard"""_s, "AudioDescriptionsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Preview>{}, API::FeatureCategory::Media, "Enable standard audio descriptions for video"""_s, DEFAULT_VALUE_FOR_AudioDescriptionsEnabled, false),
#endif
#if ENABLE(DOM_AUDIO_SESSION)
        API::Feature::create("AudioSession API"""_s, "DOMAudioSessionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "Enable AudioSession API"""_s, DEFAULT_VALUE_FOR_DOMAudioSessionEnabled, false),
#endif
#if ENABLE(DOM_AUDIO_SESSION)
        API::Feature::create("AudioSession full API"""_s, "DOMAudioSessionFullEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Media, "Enable AudioSession full API"""_s, DEFAULT_VALUE_FOR_DOMAudioSessionFullEnabled, false),
#endif
        API::Feature::create("Automatically Adjust View Scale"""_s, "AutomaticallyAdjustsViewScaleUsingMinimumEffectiveDeviceWidth"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Automatically Adjust View Scale to Fit Min. Effective Device Width"""_s, DEFAULT_VALUE_FOR_AutomaticallyAdjustsViewScaleUsingMinimumEffectiveDeviceWidth, false),
        API::Feature::create("Beacon API"""_s, "BeaconAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::None, "Beacon API"""_s, DEFAULT_VALUE_FOR_BeaconAPIEnabled, false),
        API::Feature::create("BroadcastChannel API"""_s, "BroadcastChannelEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "BroadcastChannel API"""_s, DEFAULT_VALUE_FOR_BroadcastChannelEnabled, false),
        API::Feature::create("BroadcastChannel Origin Partitioning"""_s, "BroadcastChannelOriginPartitioningEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "BroadcastChannel Origin Partitioning"""_s, DEFAULT_VALUE_FOR_BroadcastChannelOriginPartitioningEnabled, false),
#if ENABLE(WEB_PUSH_NOTIFICATIONS)
        API::Feature::create("Built-In Web Notifications"""_s, "BuiltInNotificationsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::DOM, "Enable built-in WebKit managed notifications"""_s, DEFAULT_VALUE_FOR_BuiltInNotificationsEnabled, false),
#endif
        API::Feature::create("CSS 3D Transform Interoperability for backface-visibility"""_s, "CSS3DTransformBackfaceVisibilityInteroperabilityEnabled"_s, API::FeatureConstant<API::FeatureStatus::Preview>{}, API::FeatureCategory::CSS, "Enable 3D transform behavior for backface-visibility that is specification-compliant but backwards incompatible"""_s, DEFAULT_VALUE_FOR_CSS3DTransformBackfaceVisibilityInteroperabilityEnabled, false),
        API::Feature::create("CSS @counter-style <image> symbols"""_s, "CSSCounterStyleAtRuleImageSymbolsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable support for <image> symbols in CSS @counter-style rules"""_s, DEFAULT_VALUE_FOR_CSSCounterStyleAtRuleImageSymbolsEnabled, false),
        API::Feature::create("CSS @counter-style"""_s, "CSSCounterStyleAtRulesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable support for CSS @counter-style rules"""_s, DEFAULT_VALUE_FOR_CSSCounterStyleAtRulesEnabled, false),
        API::Feature::create("CSS @font-face size-adjust"""_s, "CSSFontFaceSizeAdjustEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable size-adjust descriptor in @font-face"""_s, DEFAULT_VALUE_FOR_CSSFontFaceSizeAdjustEnabled, false),
        API::Feature::create("CSS @starting-style rule"""_s, "CSSStartingStyleAtRuleEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable CSS @starting-style rule"""_s, DEFAULT_VALUE_FOR_CSSStartingStyleAtRuleEnabled, false),
        API::Feature::create("CSS Accent Color"""_s, "AccentColorEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable accent-color CSS property"""_s, DEFAULT_VALUE_FOR_AccentColorEnabled, false),
        API::Feature::create("CSS Anchor Positioning"""_s, "CSSAnchorPositioningEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable CSS Anchor Positioning"""_s, DEFAULT_VALUE_FOR_CSSAnchorPositioningEnabled, false),
        API::Feature::create("CSS Content Visibility"""_s, "CSSContentVisibilityEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable CSS content-visibility"""_s, DEFAULT_VALUE_FOR_CSSContentVisibilityEnabled, false),
        API::Feature::create("CSS Input Security"""_s, "CSSInputSecurityEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable input-security CSS property"""_s, DEFAULT_VALUE_FOR_CSSInputSecurityEnabled, false),
        API::Feature::create("CSS Masonry Layout"""_s, "MasonryEnabled"_s, API::FeatureConstant<API::FeatureStatus::Preview>{}, API::FeatureCategory::CSS, "Enable Masonry Layout for CSS Grid"""_s, DEFAULT_VALUE_FOR_MasonryEnabled, false),
        API::Feature::create("CSS Motion Path"""_s, "CSSMotionPathEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable CSS Motion Path support"""_s, DEFAULT_VALUE_FOR_CSSMotionPathEnabled, false),
        API::Feature::create("CSS Nesting"""_s, "CSSNestingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable support for CSS nesting https://www.w3.org/TR/css-nesting-1/"""_s, DEFAULT_VALUE_FOR_CSSNestingEnabled, false),
        API::Feature::create("CSS Overscroll Behavior"""_s, "OverscrollBehaviorEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable CSS overscroll-behavior"""_s, DEFAULT_VALUE_FOR_OverscrollBehaviorEnabled, false),
        API::Feature::create("CSS Painting API"""_s, "CSSPaintingAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable the CSS Painting API"""_s, DEFAULT_VALUE_FOR_CSSPaintingAPIEnabled, false),
        API::Feature::create("CSS Rhythmic Sizing"""_s, "CSSRhythmicSizingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable CSS Rhythmic Sizing properties"""_s, DEFAULT_VALUE_FOR_CSSRhythmicSizingEnabled, false),
        API::Feature::create("CSS Scoping (@scope)"""_s, "CSSScopeAtRuleEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable the CSS Scoping feature with @scope rule"""_s, DEFAULT_VALUE_FOR_CSSScopeAtRuleEnabled, false),
        API::Feature::create("CSS Scroll Anchoring"""_s, "CSSScrollAnchoringEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable CSS Scroll Anchoring"""_s, DEFAULT_VALUE_FOR_CSSScrollAnchoringEnabled, false),
        API::Feature::create("CSS Spring Animations"""_s, "SpringTimingFunctionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::CSS, "CSS Spring Animation prototype"""_s, DEFAULT_VALUE_FOR_SpringTimingFunctionEnabled, false),
        API::Feature::create("CSS Typed OM: Color Support"""_s, "CSSTypedOMColorEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable the CSS Typed OM Color support"""_s, DEFAULT_VALUE_FOR_CSSTypedOMColorEnabled, false),
        API::Feature::create("CSS Unprefixed Backdrop Filter"""_s, "CSSUnprefixedBackdropFilterEnabled"_s, API::FeatureConstant<API::FeatureStatus::Backdropfilter_feature_status>{}, API::FeatureCategory::CSS, "Enable unprefixed backdrop-filter CSS property"""_s, DEFAULT_VALUE_FOR_CSSUnprefixedBackdropFilterEnabled, false),
        API::Feature::create("CSS background-clip: border-area"""_s, "CSSBackgroundClipBorderAreaEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable the border-area value for background-clip"""_s, DEFAULT_VALUE_FOR_CSSBackgroundClipBorderAreaEnabled, false),
        API::Feature::create("CSS color-contrast()"""_s, "CSSColorContrastEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable support for CSS color-contrast() defined in CSS Color 5"""_s, DEFAULT_VALUE_FOR_CSSColorContrastEnabled, false),
        API::Feature::create("CSS color-layers()"""_s, "CSSColorLayersEnabled"_s, API::FeatureConstant<API::FeatureStatus::Preview>{}, API::FeatureCategory::CSS, "Enable support for CSS color-layers()"""_s, DEFAULT_VALUE_FOR_CSSColorLayersEnabled, false),
        API::Feature::create("CSS d property"""_s, "CSSDPropertyEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable support for the CSS d property and SVG d presentation attribute"""_s, DEFAULT_VALUE_FOR_CSSDPropertyEnabled, false),
        API::Feature::create("CSS field-sizing property"""_s, "CSSFieldSizingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable field-sizing CSS property"""_s, DEFAULT_VALUE_FOR_CSSFieldSizingEnabled, false),
        API::Feature::create("CSS font-variant-emoji property"""_s, "CSSFontVariantEmojiEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable the font-variant-emoji CSS property"""_s, DEFAULT_VALUE_FOR_CSSFontVariantEmojiEnabled, false),
        API::Feature::create("CSS light-dark()"""_s, "CSSLightDarkEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable support for CSS light-dark() defined in CSS Color 5"""_s, DEFAULT_VALUE_FOR_CSSLightDarkEnabled, false),
        API::Feature::create("CSS margin-trim property"""_s, "CSSMarginTrimEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable margin-trim CSS property"""_s, DEFAULT_VALUE_FOR_CSSMarginTrimEnabled, false),
        API::Feature::create("CSS ruby-align property"""_s, "CSSRubyAlignEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable ruby-align"""_s, DEFAULT_VALUE_FOR_CSSRubyAlignEnabled, false),
        API::Feature::create("CSS scrollbar-color property"""_s, "CSSScrollbarColorEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable scrollbar-color CSS property"""_s, DEFAULT_VALUE_FOR_CSSScrollbarColorEnabled, false),
        API::Feature::create("CSS scrollbar-gutter property"""_s, "CSSScrollbarGutterEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable scrollbar-gutter CSS property"""_s, DEFAULT_VALUE_FOR_CSSScrollbarGutterEnabled, false),
        API::Feature::create("CSS scrollbar-width property"""_s, "CSSScrollbarWidthEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable scrollbar-width CSS property"""_s, DEFAULT_VALUE_FOR_CSSScrollbarWidthEnabled, false),
        API::Feature::create("CSS shape() function"""_s, "CSSShapeFunctionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Preview>{}, API::FeatureCategory::CSS, "Enable the CSS shape() function"""_s, DEFAULT_VALUE_FOR_CSSShapeFunctionEnabled, false),
        API::Feature::create("CSS style queries"""_s, "CSSStyleQueriesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable CSS style queries for custom properties"""_s, DEFAULT_VALUE_FOR_CSSStyleQueriesEnabled, false),
        API::Feature::create("CSS text-autospace property"""_s, "CSSTextAutospaceEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable the property text-autospace, defined in CSS Text 4"""_s, DEFAULT_VALUE_FOR_CSSTextAutospaceEnabled, false),
        API::Feature::create("CSS text-box-trim property"""_s, "CSSTextBoxTrimEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable text-box-trim"""_s, DEFAULT_VALUE_FOR_CSSTextBoxTrimEnabled, false),
        API::Feature::create("CSS text-group-align property"""_s, "CSSTextGroupAlignEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable text-group-align CSS property"""_s, DEFAULT_VALUE_FOR_CSSTextGroupAlignEnabled, false),
        API::Feature::create("CSS text-justify property"""_s, "CSSTextJustifyEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable the property text-justify, defined in CSS Text 3"""_s, DEFAULT_VALUE_FOR_CSSTextJustifyEnabled, false),
        API::Feature::create("CSS text-spacing property"""_s, "CSSTextSpacingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable the property text-spacing, defined in CSS Text 4"""_s, DEFAULT_VALUE_FOR_CSSTextSpacingEnabled, false),
        API::Feature::create("CSS text-underline-position: left right"""_s, "CSSTextUnderlinePositionLeftRightEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable the property text-underline-position left and right value support"""_s, DEFAULT_VALUE_FOR_CSSTextUnderlinePositionLeftRightEnabled, false),
        API::Feature::create("CSS text-wrap-style property"""_s, "CSSTextWrapStyleEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable the property text-wrap-style, defined in CSS Text 4"""_s, DEFAULT_VALUE_FOR_CSSTextWrapStyleEnabled, false),
        API::Feature::create("CSS text-wrap: pretty"""_s, "CSSTextWrapPrettyEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable the pretty value for text-wrap-style"""_s, DEFAULT_VALUE_FOR_CSSTextWrapPrettyEnabled, false),
#if ENABLE(CSS_TRANSFORM_STYLE_OPTIMIZED_3D)
        API::Feature::create("CSS transform-style: optimized-3d"""_s, "CSSTransformStyleOptimized3DEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::CSS, "Enable transform-style: optimized-3d property to access the separated graphics layer"""_s, DEFAULT_VALUE_FOR_CSSTransformStyleOptimized3DEnabled, false),
#endif
        API::Feature::create("CSSOM View Scrolling API"""_s, "CSSOMViewScrollingAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Implement standard behavior for scrollLeft, scrollTop, scrollWidth, scrollHeight, scrollTo, scrollBy and scrollingElement."""_s, DEFAULT_VALUE_FOR_CSSOMViewScrollingAPIEnabled, false),
        API::Feature::create("CSSOM View Smooth Scrolling"""_s, "CSSOMViewSmoothScrollingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable DOM API and CSS property for 'smooth' scroll behavior"""_s, DEFAULT_VALUE_FOR_CSSOMViewSmoothScrollingEnabled, false),
        API::Feature::create("Cache API"""_s, "CacheAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Cache API"""_s, DEFAULT_VALUE_FOR_CacheAPIEnabled, false),
        API::Feature::create("Canvas Color Spaces"""_s, "CanvasColorSpaceEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable use of predefined canvas color spaces"""_s, DEFAULT_VALUE_FOR_CanvasColorSpaceEnabled, false),
        API::Feature::create("Canvas Filters"""_s, "CanvasFiltersEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Canvas Filters"""_s, DEFAULT_VALUE_FOR_CanvasFiltersEnabled, false),
        API::Feature::create("Canvas Layers"""_s, "CanvasLayersEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Enable Canvas Layers"""_s, DEFAULT_VALUE_FOR_CanvasLayersEnabled, false),
#if USE(CA) || USE(SKIA)
        API::Feature::create("Canvas uses accelerated drawing"""_s, "CanvasUsesAcceleratedDrawing"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_CanvasUsesAcceleratedDrawing, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::Feature::create("Capture audio in UI Process"""_s, "CaptureAudioInUIProcessEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Enable audio capture in UI Process"""_s, DEFAULT_VALUE_FOR_CaptureAudioInUIProcessEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::Feature::create("Capture video in UI Process"""_s, "CaptureVideoInUIProcessEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Enable video capture in UI Process"""_s, DEFAULT_VALUE_FOR_CaptureVideoInUIProcessEnabled, false),
#endif
        API::Feature::create("Child Process Debuggability"""_s, "ChildProcessDebuggabilityEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Enable stopping child processes with a debugger"""_s, DEFAULT_VALUE_FOR_ChildProcessDebuggabilityEnabled, false),
        API::Feature::create("Clear-Site-Data HTTP Header"""_s, "ClearSiteDataHTTPHeaderEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Networking, "Enable Clear-Site-Data HTTP Header support"""_s, DEFAULT_VALUE_FOR_ClearSiteDataHTTPHeaderEnabled, false),
        API::Feature::create("Client Badge"""_s, "ClientBadgeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::DOM, "Enable Client Badge"""_s, DEFAULT_VALUE_FOR_ClientBadgeEnabled, false),
#if ENABLE(INPUT_TYPE_COLOR)
        API::Feature::create("Color Inputs"""_s, "InputTypeColorEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable input elements of type color"""_s, DEFAULT_VALUE_FOR_InputTypeColorEnabled, false),
#endif
        API::Feature::create("Compositing borders visible"""_s, "CompositingBordersVisible"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_CompositingBordersVisible, false),
        API::Feature::create("Compositing repaint counters visible"""_s, "CompositingRepaintCountersVisible"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_CompositingRepaintCountersVisible, false),
        API::Feature::create("Compression Stream API"""_s, "CompressionStreamEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable Compression Stream API"""_s, DEFAULT_VALUE_FOR_CompressionStreamEnabled, false),
        API::Feature::create("Contact Picker API"""_s, "ContactPickerAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Enable the Contact Picker API"""_s, DEFAULT_VALUE_FOR_ContactPickerAPIEnabled, false),
#if HAVE(AVCONTENTKEYSPECIFIER)
        API::Feature::create("ContentKeySession support for SampleBuffer Renderers"""_s, "SampleBufferContentKeySessionSupportEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::Media, "ContentKeySession support for SampleBuffer Renderers Enabled"""_s, DEFAULT_VALUE_FOR_SampleBufferContentKeySessionSupportEnabled, false),
#endif
        API::Feature::create("Cookie Consent API"""_s, "CookieConsentAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::DOM, "Enable cookie consent API"""_s, DEFAULT_VALUE_FOR_CookieConsentAPIEnabled, false),
        API::Feature::create("Cookie Store API CookieStoreManager"""_s, "CookieStoreManagerEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Enable Cookie Store API CookieStoreManager which controls cookie change subscriptions for Service Workers"""_s, DEFAULT_VALUE_FOR_CookieStoreManagerEnabled, false),
        API::Feature::create("Cookie Store API Extended Attributes"""_s, "CookieStoreAPIExtendedAttributesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Enable Extended Attributes of the Cookie Store API"""_s, DEFAULT_VALUE_FOR_CookieStoreAPIExtendedAttributesEnabled, false),
        API::Feature::create("Cookie Store API"""_s, "CookieStoreAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Enable Cookie Store API"""_s, DEFAULT_VALUE_FOR_CookieStoreAPIEnabled, false),
        API::Feature::create("Cookies Enabled"""_s, "CookieEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_CookieEnabled, false),
        API::Feature::create("Cross document view-transitions"""_s, "CrossDocumentViewTransitionsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable support for view-transitions cross-document"""_s, DEFAULT_VALUE_FOR_CrossDocumentViewTransitionsEnabled, false),
        API::Feature::create("Cross-Origin-Embedder-Policy (COEP) header"""_s, "CrossOriginEmbedderPolicyEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Security, "Support for Cross-Origin-Embedder-Policy (COEP) header"""_s, DEFAULT_VALUE_FOR_CrossOriginEmbedderPolicyEnabled, false),
        API::Feature::create("Cross-Origin-Opener-Policy (COOP) header"""_s, "CrossOriginOpenerPolicyEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Security, "Support for Cross-Origin-Opener-Policy (COOP) header"""_s, DEFAULT_VALUE_FOR_CrossOriginOpenerPolicyEnabled, false),
        API::Feature::create("Custom pasteboard data"""_s, "CustomPasteboardDataEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable custom clipboard types and better security model for clipboard API."""_s, DEFAULT_VALUE_FOR_CustomPasteboardDataEnabled, false),
        API::Feature::create("CustomStateSet and :state() pseudo class"""_s, "CustomStateSetEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Support for CustomStateSet in custom elements"""_s, DEFAULT_VALUE_FOR_CustomStateSetEnabled, false),
        API::Feature::create("DOM Paste Access Requests"""_s, "DOMPasteAccessRequestsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Enable DOM Paste Access Requests"""_s, DEFAULT_VALUE_FOR_DOMPasteAccessRequestsEnabled, false),
        API::Feature::create("DOM timer throttling enabled"""_s, "DOMTimersThrottlingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_DOMTimersThrottlingEnabled, false),
#if PLATFORM(IOS_FAMILY)
        API::Feature::create("DTTZ also when root"""_s, "ZoomOnDoubleTapWhenRoot"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Double taps zoom, even if we dispatched a click on the root nodes"""_s, DEFAULT_VALUE_FOR_ZoomOnDoubleTapWhenRoot, false),
#endif
#if PLATFORM(IOS_FAMILY)
        API::Feature::create("DTTZ always"""_s, "AlwaysZoomOnDoubleTap"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Double taps zoom, even if we dispatched a click anywhere"""_s, DEFAULT_VALUE_FOR_AlwaysZoomOnDoubleTap, false),
#endif
        API::Feature::create("Data Transfer Items"""_s, "DataTransferItemsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enables DataTransferItem in the clipboard API"""_s, DEFAULT_VALUE_FOR_DataTransferItemsEnabled, false),
#if ENABLE(DATALIST_ELEMENT)
        API::Feature::create("DataList Element"""_s, "DataListElementEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable datalist elements"""_s, DEFAULT_VALUE_FOR_DataListElementEnabled, false),
#endif
#if ENABLE(INPUT_TYPE_DATE)
        API::Feature::create("Date Input"""_s, "InputTypeDateEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable input elements of type date"""_s, DEFAULT_VALUE_FOR_InputTypeDateEnabled, false),
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
        API::Feature::create("Date/Time inputs have editable components"""_s, "DateTimeInputsEditableComponentsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable multiple editable components in date/time inputs"""_s, DEFAULT_VALUE_FOR_DateTimeInputsEditableComponentsEnabled, false),
#endif
        API::Feature::create("Declarative Shadow Roots Parser APIs"""_s, "DeclarativeShadowRootsParserAPIsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Declarative Shadow Roots Parser APIs (Element/ShadowRoot's setHTMLUnsafe() and Document.parseHTMLUnsafe())"""_s, DEFAULT_VALUE_FOR_DeclarativeShadowRootsParserAPIsEnabled, false),
        API::Feature::create("Declarative Shadow Roots Serializer APIs"""_s, "DeclarativeShadowRootsSerializerAPIsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Declarative Shadow Roots Serializer APIs (Element/ShadowRoot's getHTML() and ShadowRoot's serializable)"""_s, DEFAULT_VALUE_FOR_DeclarativeShadowRootsSerializerAPIsEnabled, false),
#if ENABLE(DECLARATIVE_WEB_PUSH)
        API::Feature::create("Declarative Web Push"""_s, "DeclarativeWebPush"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::DOM, "Enable Declarative Web Push"""_s, DEFAULT_VALUE_FOR_DeclarativeWebPush, false),
#endif
        API::Feature::create("Defer async scripts until DOMContentLoaded or first-paint"""_s, "ShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Defer async scripts until DOMContentLoaded or first-paint"""_s, DEFAULT_VALUE_FOR_ShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint, false),
        API::Feature::create("Deprecate AES-CFB Web Crypto"""_s, "DeprecateAESCFBWebCryptoEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable Deprecation of AES-CFB from Web Crypto"""_s, DEFAULT_VALUE_FOR_DeprecateAESCFBWebCryptoEnabled, false),
        API::Feature::create("Deprecate RSAES-PKCS1-v1_5 Web Crypto"""_s, "DeprecateRSAESPKCSWebCryptoEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable Deprecation of RSAES-PKCS1-v1_5 Web Crypto"""_s, DEFAULT_VALUE_FOR_DeprecateRSAESPKCSWebCryptoEnabled, false),
        API::Feature::create("Deprecation Reporting"""_s, "DeprecationReportingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Enable Deprecation Reporting"""_s, DEFAULT_VALUE_FOR_DeprecationReportingEnabled, false),
        API::Feature::create("Detect UA visual transitions"""_s, "UAVisualTransitionDetectionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable detection of UA visual transitions"""_s, DEFAULT_VALUE_FOR_UAVisualTransitionDetectionEnabled, false),
        API::Feature::create("Diagnostic logging enabled"""_s, "DiagnosticLoggingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_DiagnosticLoggingEnabled, false),
        API::Feature::create("Digital Credentials API"""_s, "DigitalCredentialsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Enable the experimental Digital Credentials API"""_s, DEFAULT_VALUE_FOR_DigitalCredentialsEnabled, false),
        API::Feature::create("Directory Upload"""_s, "DirectoryUploadEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "input.webkitdirectory / dataTransferItem.webkitGetAsEntry()"""_s, DEFAULT_VALUE_FOR_DirectoryUploadEnabled, false),
        API::Feature::create("Disable Full 3rd-Party Cookie Blocking (ITP)"""_s, "IsThirdPartyCookieBlockingDisabled"_s, API::FeatureConstant<API::FeatureStatus::Developer>{}, API::FeatureCategory::Privacy, "Disable full third-party cookie blocking when Intelligent Tracking Prevention is enabled"""_s, DEFAULT_VALUE_FOR_IsThirdPartyCookieBlockingDisabled, false),
        API::Feature::create("Disable Removal of Non-Cookie Data After 7 Days of No User Interaction (ITP)"""_s, "IsFirstPartyWebsiteDataRemovalDisabled"_s, API::FeatureConstant<API::FeatureStatus::Developer>{}, API::FeatureCategory::Privacy, "Disable removal of all non-cookie website data after seven days of no user interaction when Intelligent Tracking Prevention is enabled"""_s, DEFAULT_VALUE_FOR_IsFirstPartyWebsiteDataRemovalDisabled, false),
#if PLATFORM(IOS_FAMILY)
        API::Feature::create("Disable screen size override"""_s, "DisableScreenSizeOverride"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_DisableScreenSizeOverride, false),
#endif
        API::Feature::create("Disallow sync XHR during page dismissal"""_s, "DisallowSyncXHRDuringPageDismissalEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Security, "Disallow synchronous XMLHttpRequest during page dismissal"""_s, DEFAULT_VALUE_FOR_DisallowSyncXHRDuringPageDismissalEnabled, false),
        API::Feature::create("Drop Near-Suspended Assertion After Delay"""_s, "ShouldDropNearSuspendedAssertionAfterDelay"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Causes processes to fully suspend after a delay"""_s, DEFAULT_VALUE_FOR_ShouldDropNearSuspendedAssertionAfterDelay, false),
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
        API::Feature::create("Dynamic Content Scaling: DOM Rendering"""_s, "UseCGDisplayListsForDOMRendering"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Use Dynamic Content Scaling for DOM rendering"""_s, DEFAULT_VALUE_FOR_UseCGDisplayListsForDOMRendering, false),
#endif
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
        API::Feature::create("Dynamic Content Scaling: Replay for Testing"""_s, "ReplayCGDisplayListsIntoBackingStore"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Replay Dynamic Content Scaling Display Lists into layer contents for testing"""_s, DEFAULT_VALUE_FOR_ReplayCGDisplayListsIntoBackingStore, false),
#endif
        API::Feature::create("Embed Element"""_s, "EmbedElementEnabled"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::None, "Embed Element"""_s, DEFAULT_VALUE_FOR_EmbedElementEnabled, false),
#if PLATFORM(IOS_FAMILY)
        API::Feature::create("Enable Automatic Live Resize"""_s, "AutomaticLiveResizeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Automatically synchronize web view resize with painting"""_s, DEFAULT_VALUE_FOR_AutomaticLiveResizeEnabled, false),
#endif
        API::Feature::create("Enable Canvas fingerprinting-related quirk"""_s, "CanvasFingerprintingQuirkEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, """"_s, DEFAULT_VALUE_FOR_CanvasFingerprintingQuirkEnabled, false),
        API::Feature::create("Enable CryptoKit for supported Algorithms."""_s, "CryptoKitEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Security, "Enable CryptoKit for supported Algorithms."""_s, DEFAULT_VALUE_FOR_CryptoKitEnabled, false),
        API::Feature::create("Enable Enumerating All Network Interfaces"""_s, "EnumeratingAllNetworkInterfacesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_EnumeratingAllNetworkInterfacesEnabled, false),
        API::Feature::create("Enable Enumerating Visible Network Interfaces"""_s, "EnumeratingVisibleNetworkInterfacesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_EnumeratingVisibleNetworkInterfacesEnabled, false),
        API::Feature::create("Enable ICE Candidate Filtering"""_s, "ICECandidateFilteringEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Enable ICE Candidate Filtering"""_s, DEFAULT_VALUE_FOR_ICECandidateFilteringEnabled, false),
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
        API::Feature::create("Enable Legacy EME API"""_s, "LegacyEncryptedMediaAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable legacy EME API"""_s, DEFAULT_VALUE_FOR_LegacyEncryptedMediaAPIEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::Feature::create("Enable Mock Capture Devices"""_s, "MockCaptureDevicesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Enable Mock Capture Devices"""_s, DEFAULT_VALUE_FOR_MockCaptureDevicesEnabled, false),
#endif
#if ENABLE(MODEL_PROCESS)
        API::Feature::create("Enable Model Process"""_s, "ModelProcessEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::None, "Load <model> content in a separate process"""_s, DEFAULT_VALUE_FOR_ModelProcessEnabled, false),
#endif
#if ENABLE(PDFJS)
        API::Feature::create("Enable PDF.js viewer"""_s, "PDFJSViewerEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::HTML, "Enable PDF.js viewer"""_s, DEFAULT_VALUE_FOR_PDFJSViewerEnabled, false),
#endif
        API::Feature::create("Enable `auxclick` event"""_s, "AuxclickEventEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable the `auxclick` UI event"""_s, DEFAULT_VALUE_FOR_AuxclickEventEnabled, false),
#if PLATFORM(MAC) && USE(RUNNINGBOARD)
        API::Feature::create("Enable background web content throttling via RunningBoard"""_s, "BackgroundWebContentRunningBoardThrottlingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::Networking, "Enable background web content throttling via RunningBoard"""_s, DEFAULT_VALUE_FOR_BackgroundWebContentRunningBoardThrottlingEnabled, false),
#endif
        API::Feature::create("Enable background-fetch API"""_s, "BackgroundFetchAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Networking, "Enable background-fetch API"""_s, DEFAULT_VALUE_FOR_BackgroundFetchAPIEnabled, false),
#if HAVE(NETWORK_LOADER)
        API::Feature::create("Enable experimental network loader"""_s, "CFNetworkNetworkLoaderEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Networking, "Enable experimental network loader"""_s, DEFAULT_VALUE_FOR_CFNetworkNetworkLoaderEnabled, false),
#endif
#if HAVE(MACH_BOOTSTRAP_EXTENSION) || HAVE(SANDBOX_STATE_FLAGS)
        API::Feature::create("Enable experimental sandbox features"""_s, "ExperimentalSandboxEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Security, "Enable experimental sandbox features"""_s, DEFAULT_VALUE_FOR_ExperimentalSandboxEnabled, false),
#endif
        API::Feature::create("Enforce blob backed file access valid for web process"""_s, "BlobFileAccessEnforcementEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Security, "Validate file backed blobs were created by the correct web process"""_s, DEFAULT_VALUE_FOR_BlobFileAccessEnforcementEnabled, false),
        API::Feature::create("Enter Key Hint"""_s, "EnterKeyHintEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Enable the enterKeyHint HTML attribute"""_s, DEFAULT_VALUE_FOR_EnterKeyHintEnabled, false),
        API::Feature::create("EventHandler driven smooth keyboard scrolling"""_s, "EventHandlerDrivenSmoothKeyboardScrollingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Enable EventHandler driven smooth keyboard scrolling"""_s, DEFAULT_VALUE_FOR_EventHandlerDrivenSmoothKeyboardScrollingEnabled, false),
#if ENABLE(MEDIA_SESSION_COORDINATOR)
        API::Feature::create("Experimental MediaSession coordinator API"""_s, "MediaSessionCoordinatorEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "Enable experimental MediaSession coordinator API"""_s, DEFAULT_VALUE_FOR_MediaSessionCoordinatorEnabled, false),
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR) && ENABLE(MEDIA_SESSION_PLAYLIST)
        API::Feature::create("Experimental MediaSession playlist API"""_s, "MediaSessionPlaylistEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "Enable experimental MediaSession playlist API"""_s, DEFAULT_VALUE_FOR_MediaSessionPlaylistEnabled, false),
#endif
#if ENABLE(MEDIA_SOURCE) && (HAVE(AVSAMPLEBUFFERVIDEOOUTPUT) || USE(GSTREAMER))
        API::Feature::create("Experimental MediaSource Inline Painting"""_s, "MediaSourceInlinePaintingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::Media, "Experimental MediaSource Inline Painting"""_s, DEFAULT_VALUE_FOR_MediaSourceInlinePaintingEnabled, false),
#endif
        API::Feature::create("FTP support enabled"""_s, "FTPEnabled"_s, API::FeatureConstant<API::FeatureStatus::Developer>{}, API::FeatureCategory::Networking, "FTP support enabled"""_s, DEFAULT_VALUE_FOR_FTPEnabled, false),
#if PLATFORM(IOS_FAMILY)
        API::Feature::create("Fast clicks beat DTTZ"""_s, "PreferFasterClickOverDoubleTap"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Prefer a faster click over a double tap"""_s, DEFAULT_VALUE_FOR_PreferFasterClickOverDoubleTap, false),
#endif
#if PLATFORM(IOS_FAMILY)
        API::Feature::create("Fast clicks"""_s, "FasterClicksEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Support faster clicks on zoomable pages"""_s, DEFAULT_VALUE_FOR_FasterClicksEnabled, false),
#endif
        API::Feature::create("Fetch Priority"""_s, "FetchPriorityEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Networking, "Enable Fetch Priority support"""_s, DEFAULT_VALUE_FOR_FetchPriorityEnabled, false),
        API::Feature::create("File System Access API"""_s, "FileSystemAccessEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable File System Access API"""_s, DEFAULT_VALUE_FOR_FileSystemAccessEnabled, false),
        API::Feature::create("FileReader API"""_s, "FileReaderAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "FileReader API"""_s, DEFAULT_VALUE_FOR_FileReaderAPIEnabled, false),
        API::Feature::create("Filter HTTP Response for Web Processes"""_s, "RestrictedHTTPResponseAccess"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Networking, "Enable HTTP Response filtering for Web Processes"""_s, DEFAULT_VALUE_FOR_RestrictedHTTPResponseAccess, false),
        API::Feature::create("Filter Link Decoration"""_s, "FilterLinkDecorationByDefaultEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Networking, "Enable Filtering Link Decoration"""_s, DEFAULT_VALUE_FOR_FilterLinkDecorationByDefaultEnabled, false),
#if PLATFORM(IOS_FAMILY)
        API::Feature::create("Force always user-scalable"""_s, "ForceAlwaysUserScalable"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_ForceAlwaysUserScalable, false),
#endif
#if ENABLE(FULLSCREEN_API)
        API::Feature::create("Fullscreen API based Keyboard Lock"""_s, "FullScreenKeyboardLock"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Fullscreen API based Keyboard Lock"""_s, DEFAULT_VALUE_FOR_FullScreenKeyboardLock, false),
#endif
#if ENABLE(FULLSCREEN_API)
        API::Feature::create("Fullscreen API"""_s, "FullScreenEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Fullscreen API"""_s, DEFAULT_VALUE_FOR_FullScreenEnabled, EXPERIMENTAL_FULLSCREEN_API_HIDDEN),
#endif
#if PLATFORM(VISION)
        API::Feature::create("Fullscreen scene aspect ratio locking"""_s, "FullscreenSceneAspectRatioLockingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Enable scene aspect ratio locking in Fullscreen"""_s, DEFAULT_VALUE_FOR_FullscreenSceneAspectRatioLockingEnabled, false),
#endif
#if PLATFORM(VISION)
        API::Feature::create("Fullscreen scene dimming"""_s, "FullscreenSceneDimmingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Enable scene dimming in Fullscreen"""_s, DEFAULT_VALUE_FOR_FullscreenSceneDimmingEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::Feature::create("GPU Process: Audio Capture"""_s, "CaptureAudioInGPUProcessEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Enable audio capture in GPU Process"""_s, DEFAULT_VALUE_FOR_CaptureAudioInGPUProcessEnabled, false),
#endif
#if ENABLE(GPU_PROCESS)
        API::Feature::create("GPU Process: Block Media Layer Re-hosting"""_s, "BlockMediaLayerRehostingInWebContentProcess"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "GPU Process: Block Media Layer Re-hosting in WebContent process"""_s, DEFAULT_VALUE_FOR_BlockMediaLayerRehostingInWebContentProcess, false),
#endif
#if ENABLE(GPU_PROCESS) && !(PLATFORM(GTK) || PLATFORM(WPE))
        API::Feature::create("GPU Process: Canvas Rendering"""_s, "UseGPUProcessForCanvasRenderingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable canvas rendering in GPU Process"""_s, DEFAULT_VALUE_FOR_UseGPUProcessForCanvasRenderingEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM) && PLATFORM(IOS_FAMILY)
        API::Feature::create("GPU Process: Capture Status Bar management"""_s, "ManageCaptureStatusBarInGPUProcessEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Enable Capture Status Bar management in GPU Process"""_s, DEFAULT_VALUE_FOR_ManageCaptureStatusBarInGPUProcessEnabled, false),
#endif
#if ENABLE(GPU_PROCESS)
        API::Feature::create("GPU Process: DOM Rendering"""_s, "UseGPUProcessForDOMRenderingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable DOM rendering in GPU Process"""_s, DEFAULT_VALUE_FOR_UseGPUProcessForDOMRenderingEnabled, false),
#endif
#if ENABLE(GPU_PROCESS) && !USE(GSTREAMER)
        API::Feature::create("GPU Process: Media"""_s, "UseGPUProcessForMediaEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Do all media loading and playback in the GPU Process"""_s, DEFAULT_VALUE_FOR_UseGPUProcessForMediaEnabled, false),
#endif
#if HAVE(SCREEN_CAPTURE_KIT)
        API::Feature::create("GPU Process: Screen and Window capture"""_s, "UseGPUProcessForDisplayCapture"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "Display capture in GPU Process"""_s, DEFAULT_VALUE_FOR_UseGPUProcessForDisplayCapture, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::Feature::create("GPU Process: Video Capture"""_s, "CaptureVideoInGPUProcessEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Enable video capture in GPU Process"""_s, DEFAULT_VALUE_FOR_CaptureVideoInGPUProcessEnabled, false),
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        API::Feature::create("GPU Process: WebGL"""_s, "UseGPUProcessForWebGLEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Process all WebGL operations in GPU Process"""_s, DEFAULT_VALUE_FOR_UseGPUProcessForWebGLEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::Feature::create("GPU Process: WebRTC Platform Codecs"""_s, "WebRTCPlatformCodecsInGPUProcessEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable WebRTC Platform Codecs in GPU Process"""_s, DEFAULT_VALUE_FOR_WebRTCPlatformCodecsInGPUProcessEnabled, false),
#endif
#if ENABLE(GAMEPAD)
        API::Feature::create("Gamepad trigger vibration support"""_s, "GamepadTriggerRumbleEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Support for Gamepad trigger vibration"""_s, DEFAULT_VALUE_FOR_GamepadTriggerRumbleEnabled, false),
#endif
#if ENABLE(GAMEPAD)
        API::Feature::create("Gamepad.vibrationActuator support"""_s, "GamepadVibrationActuatorEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Support for Gamepad.vibrationActuator"""_s, DEFAULT_VALUE_FOR_GamepadVibrationActuatorEnabled, false),
#endif
#if ENABLE(GAMEPAD)
        API::Feature::create("Gamepads"""_s, "GamepadsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Web Gamepad API support"""_s, DEFAULT_VALUE_FOR_GamepadsEnabled, false),
#endif
#if ENABLE(VIDEO)
        API::Feature::create("Generic Text Track Cue API"""_s, "GenericCueAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::None, "Enable Generic Text Track Cue API"""_s, DEFAULT_VALUE_FOR_GenericCueAPIEnabled, false),
#endif
#if USE(GRAPHICS_CONTEXT_FILTERS)
        API::Feature::create("GraphicsContext Filter Rendering"""_s, "GraphicsContextFiltersEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "GraphicsContext Filter Rendering"""_s, DEFAULT_VALUE_FOR_GraphicsContextFiltersEnabled, false),
#endif
        API::Feature::create("GraphicsLayer accelerated drawing"""_s, "AcceleratedDrawingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Enable GraphicsLayer accelerated drawing"""_s, DEFAULT_VALUE_FOR_AcceleratedDrawingEnabled, false),
        API::Feature::create("HTML <details name> attribute"""_s, "DetailsNameAttributeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::HTML, "Enable HTML <details name> attribute"""_s, DEFAULT_VALUE_FOR_DetailsNameAttributeEnabled, false),
#if ENABLE(MODEL_ELEMENT)
        API::Feature::create("HTML <model> element"""_s, "ModelElementEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::HTML, "Enable HTML <model> element"""_s, DEFAULT_VALUE_FOR_ModelElementEnabled, false),
#endif
#if ENABLE(MODEL_ELEMENT)
        API::Feature::create("HTML <model> elements for stand-alone document"""_s, "ModelDocumentEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::HTML, "Enable HTML <model> element for model documents"""_s, DEFAULT_VALUE_FOR_ModelDocumentEnabled, false),
#endif
        API::Feature::create("HTML Interactive Form Validation"""_s, "InteractiveFormValidationEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "HTML interactive form validation"""_s, DEFAULT_VALUE_FOR_InteractiveFormValidationEnabled, false),
        API::Feature::create("HTML command & commandfor attributes"""_s, "InvokerAttributesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::HTML, "Enable HTML command & commandfor attribute support"""_s, DEFAULT_VALUE_FOR_InvokerAttributesEnabled, false),
        API::Feature::create("HTML popover attribute"""_s, "PopoverAttributeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::HTML, "Enable HTML popover attribute support"""_s, DEFAULT_VALUE_FOR_PopoverAttributeEnabled, false),
        API::Feature::create("HTML switch control"""_s, "SwitchControlEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::HTML, "Enable HTML switch control"""_s, DEFAULT_VALUE_FOR_SwitchControlEnabled, false),
        API::Feature::create("HTTPS-by-default (HTTPS-First)"""_s, "HTTPSByDefaultEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Security, "Enable HTTPS-by-default (HTTPS-First)"""_s, DEFAULT_VALUE_FOR_HTTPSByDefaultEnabled, false),
        API::Feature::create("Hidden page DOM timer throttling auto-increases"""_s, "HiddenPageDOMTimerThrottlingAutoIncreases"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_HiddenPageDOMTimerThrottlingAutoIncreases, false),
        API::Feature::create("Hidden page DOM timer throttling"""_s, "HiddenPageDOMTimerThrottlingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable hidden page DOM timer throttling"""_s, DEFAULT_VALUE_FOR_HiddenPageDOMTimerThrottlingEnabled, false),
        API::Feature::create("Highlight API"""_s, "HighlightAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Highlight API support"""_s, DEFAULT_VALUE_FOR_HighlightAPIEnabled, false),
        API::Feature::create("Hyperlink Auditing"""_s, "HyperlinkAuditingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable Hyperlink Auditing"""_s, DEFAULT_VALUE_FOR_HyperlinkAuditingEnabled, false),
#if HAVE(SANDBOX_STATE_FLAGS)
        API::Feature::create("IOKit blocking in the WebContent sandbox"""_s, "BlockIOKitInWebContentSandbox"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Networking, "Block IOKit access in the WebContent sandbox"""_s, DEFAULT_VALUE_FOR_BlockIOKitInWebContentSandbox, false),
#endif
#if ENABLE(IPC_TESTING_API)
        API::Feature::create("IPC Testing API"""_s, "IPCTestingAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Security, "Enable IPC Testing API for JavaScript"""_s, DEFAULT_VALUE_FOR_IPCTestingAPIEnabled, false),
#endif
        API::Feature::create("ITP Debug Mode"""_s, "ItpDebugModeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Developer>{}, API::FeatureCategory::Privacy, "Intelligent Tracking Prevention Debug Mode"""_s, DEFAULT_VALUE_FOR_ItpDebugModeEnabled, false),
#if ENABLE(TEXT_AUTOSIZING)
        API::Feature::create("Idempotent Text Autosizing"""_s, "TextAutosizingUsesIdempotentMode"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Use idempotent text autosizing mode"""_s, DEFAULT_VALUE_FOR_TextAutosizingUsesIdempotentMode, false),
#endif
#if ENABLE(IPC_TESTING_API)
        API::Feature::create("Ignore Invalid IPC Messages For Testing"""_s, "IgnoreInvalidMessageWhenIPCTestingAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Security, "Prevents invalid IPC messages from terminating the caller"""_s, DEFAULT_VALUE_FOR_IgnoreInvalidMessageWhenIPCTestingAPIEnabled, false),
#endif
        API::Feature::create("Ignore iframe Embedding Protections"""_s, "IgnoreIframeEmbeddingProtectionsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Security, "Ignores X-Frame-Options and CSP ancestors"""_s, DEFAULT_VALUE_FOR_IgnoreIframeEmbeddingProtectionsEnabled, false),
#if ENABLE(IMAGE_ANALYSIS)
        API::Feature::create("Image Analysis for Find-in-Page"""_s, "ImageAnalysisDuringFindInPageEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::None, "Trigger image analysis when performing Find-in-Page"""_s, DEFAULT_VALUE_FOR_ImageAnalysisDuringFindInPageEnabled, false),
#endif
#if ENABLE(ACCESSIBILITY_ANIMATION_CONTROL)
        API::Feature::create("Image Animation Control"""_s, "ImageAnimationControlEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Animation, "Enable controls for image animations"""_s, DEFAULT_VALUE_FOR_ImageAnimationControlEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::Feature::create("Image Capture API"""_s, "ImageCaptureEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Media, "Enable Image Capture API"""_s, DEFAULT_VALUE_FOR_ImageCaptureEnabled, false),
#endif
#if ENABLE(SERVICE_CONTROLS)
        API::Feature::create("Image Controls"""_s, "ImageControlsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::DOM, "Enable image controls"""_s, DEFAULT_VALUE_FOR_ImageControlsEnabled, false),
#endif
        API::Feature::create("In-Window Fullscreen"""_s, "InWindowFullscreenEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Enable In-Window Fullscreen"""_s, DEFAULT_VALUE_FOR_InWindowFullscreenEnabled, false),
        API::Feature::create("IndexedDB API"""_s, "IndexedDBAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "IndexedDB API"""_s, DEFAULT_VALUE_FOR_IndexedDBAPIEnabled, false),
#if ENABLE(INTERACTION_REGIONS_IN_EVENT_REGION)
        API::Feature::create("Interaction Regions"""_s, "InteractionRegionsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Generate and visualize interaction regions"""_s, DEFAULT_VALUE_FOR_InteractionRegionsEnabled, false),
#endif
#if ENABLE(ACCESSIBILITY_ISOLATED_TREE)
        API::Feature::create("Isolated Accessibility Tree Mode"""_s, "IsAccessibilityIsolatedTreeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable an accessibility hierarchy for VoiceOver that can be accessed on a secondary thread for improved performance"""_s, DEFAULT_VALUE_FOR_IsAccessibilityIsolatedTreeEnabled, false),
#endif
        API::Feature::create("JavaScript"""_s, "JavaScriptEnabled"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::None, "Enable JavaScript"""_s, DEFAULT_VALUE_FOR_JavaScriptEnabled, false),
#if PLATFORM(IOS_FAMILY)
        API::Feature::create("Keyboard Dismissal Gesture"""_s, "KeyboardDismissalGestureEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Enable the keyboard dismissal gesture"""_s, DEFAULT_VALUE_FOR_KeyboardDismissalGestureEnabled, false),
#endif
        API::Feature::create("Layer-based SVG Engine (LBSE)"""_s, "LayerBasedSVGEngineEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::None, "Enable next-generation layer-based SVG Engine (LBSE)"""_s, DEFAULT_VALUE_FOR_LayerBasedSVGEngineEnabled, false),
        API::Feature::create("Lazy iframe loading"""_s, "LazyIframeLoadingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::HTML, "Enable lazy iframe loading support"""_s, DEFAULT_VALUE_FOR_LazyIframeLoadingEnabled, false),
        API::Feature::create("Lazy image loading"""_s, "LazyImageLoadingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::HTML, "Enable lazy image loading support"""_s, DEFAULT_VALUE_FOR_LazyImageLoadingEnabled, false),
#if ENABLE(OVERFLOW_SCROLLING_TOUCH)
        API::Feature::create("Legacy -webkit-overflow-scrolling property"""_s, "LegacyOverflowScrollingTouchEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Support the legacy -webkit-overflow-scrolling CSS property"""_s, DEFAULT_VALUE_FOR_LegacyOverflowScrollingTouchEnabled, false),
#endif
        API::Feature::create("Legacy line layout visual coverage"""_s, "LegacyLineLayoutVisualCoverageEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Enable legacy line layout visual coverage"""_s, DEFAULT_VALUE_FOR_LegacyLineLayoutVisualCoverageEnabled, false),
        API::Feature::create("Legacy showModalDialog() API"""_s, "ShowModalDialogEnabled"_s, API::FeatureConstant<API::FeatureStatus::Developer>{}, API::FeatureCategory::DOM, "Legacy showModalDialog() API"""_s, DEFAULT_VALUE_FOR_ShowModalDialogEnabled, false),
#if ENABLE(MEDIA_STREAM)
        API::Feature::create("Limit Media Capture to Secure Sites"""_s, "MediaCaptureRequiresSecureConnection"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Limit Media Capture to Secure Sites"""_s, DEFAULT_VALUE_FOR_MediaCaptureRequiresSecureConnection, false),
#endif
#if ENABLE(LINEAR_MEDIA_PLAYER)
        API::Feature::create("Linear Media Player"""_s, "LinearMediaPlayerEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Enable LinearMediaPlayer for fullscreen video"""_s, DEFAULT_VALUE_FOR_LinearMediaPlayerEnabled, false),
#endif
        API::Feature::create("Link Sanitizer"""_s, "LinkSanitizerEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::Networking, "Enable link sanitizer"""_s, DEFAULT_VALUE_FOR_LinkSanitizerEnabled, false),
        API::Feature::create("Link preload responsive images"""_s, "LinkPreloadResponsiveImagesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Networking, "Enable link preload responsive images"""_s, DEFAULT_VALUE_FOR_LinkPreloadResponsiveImagesEnabled, false),
        API::Feature::create("Link rel=modulepreload"""_s, "LinkModulePreloadEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Networking, "Enable Link rel=modulepreload"""_s, DEFAULT_VALUE_FOR_LinkModulePreloadEnabled, false),
        API::Feature::create("Link rel=preconnect via HTTP early hints"""_s, "LinkPreconnectEarlyHintsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Networking, "Enable link rel=preconnect via early hints"""_s, DEFAULT_VALUE_FOR_LinkPreconnectEarlyHintsEnabled, false),
        API::Feature::create("LinkPrefetch"""_s, "LinkPrefetchEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Networking, "Enable LinkedPrefetch"""_s, DEFAULT_VALUE_FOR_LinkPrefetchEnabled, false),
        API::Feature::create("Live Ranges in Selection"""_s, "LiveRangeSelectionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Live range behavior for ranges in the Selection object"""_s, DEFAULT_VALUE_FOR_LiveRangeSelectionEnabled, false),
#if ENABLE(WEB_ARCHIVE)
        API::Feature::create("Load Web Archive with ephemeral storage"""_s, "LoadWebArchiveWithEphemeralStorageEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable loading web archive with ephemeral storage"""_s, DEFAULT_VALUE_FOR_LoadWebArchiveWithEphemeralStorageEnabled, false),
#endif
        API::Feature::create("Local File Content Sniffing"""_s, "LocalFileContentSniffingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Networking, "Enable Local File Content Sniffing"""_s, DEFAULT_VALUE_FOR_LocalFileContentSniffingEnabled, false),
        API::Feature::create("Local Storage"""_s, "LocalStorageEnabled"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::None, "Enable Local Storage"""_s, DEFAULT_VALUE_FOR_LocalStorageEnabled, false),
        API::Feature::create("Lockdown Mode Safe Fonts"""_s, "LockdownFontParserEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Security, "Try parsing Web fonts with safe font parser in Lockdown Mode"""_s, DEFAULT_VALUE_FOR_LockdownFontParserEnabled, false),
        API::Feature::create("Log page messages to system console"""_s, "LogsPageMessagesToSystemConsoleEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Enable logging page messages to system console"""_s, DEFAULT_VALUE_FOR_LogsPageMessagesToSystemConsoleEnabled, false),
        API::Feature::create("Login Status API"""_s, "LoginStatusAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Enable the proposed Login Status API"""_s, DEFAULT_VALUE_FOR_LoginStatusAPIEnabled, false),
        API::Feature::create("Main content user gesture override"""_s, "MainContentUserGestureOverrideEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable main content user gesture override"""_s, DEFAULT_VALUE_FOR_MainContentUserGestureOverrideEnabled, false),
#if ENABLE(MEDIA_SOURCE)
        API::Feature::create("Managed Media Source API"""_s, "ManagedMediaSourceEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "Managed Media Source API"""_s, DEFAULT_VALUE_FOR_ManagedMediaSourceEnabled, false),
#endif
#if ENABLE(MEDIA_SOURCE) && ENABLE(WIRELESS_PLAYBACK_TARGET)
        API::Feature::create("Managed Media Source Requires AirPlay source"""_s, "ManagedMediaSourceNeedsAirPlay"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "Managed Media Source Requires AirPlay source"""_s, DEFAULT_VALUE_FOR_ManagedMediaSourceNeedsAirPlay, false),
#endif
        API::Feature::create("MathML Core"""_s, "CoreMathMLEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::DOM, "Disable features removed from the MathML Core spec."""_s, DEFAULT_VALUE_FOR_CoreMathMLEnabled, false),
        API::Feature::create("Media Capabilities Extensions"""_s, "MediaCapabilitiesExtensionsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "Media Capabilities Extensions"""_s, DEFAULT_VALUE_FOR_MediaCapabilitiesExtensionsEnabled, false),
#if ENABLE(EXTENSION_CAPABILITIES)
        API::Feature::create("Media Capability Grants"""_s, "MediaCapabilityGrantsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable granting and revoking of media capabilities"""_s, DEFAULT_VALUE_FOR_MediaCapabilityGrantsEnabled, false),
#endif
#if ENABLE(MEDIA_SESSION)
        API::Feature::create("Media Session API"""_s, "MediaSessionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::None, "Media Session API"""_s, DEFAULT_VALUE_FOR_MediaSessionEnabled, false),
#endif
        API::Feature::create("Media Source API"""_s, "MediaSourceEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::Media, "Media Source API"""_s, DEFAULT_VALUE_FOR_MediaSourceEnabled, false),
#if ENABLE(MEDIA_STREAM)
        API::Feature::create("Media devices"""_s, "MediaDevicesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable media devices"""_s, DEFAULT_VALUE_FOR_MediaDevicesEnabled, false),
#endif
#if ENABLE(MEDIA_RECORDER)
        API::Feature::create("MediaRecorder"""_s, "MediaRecorderEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "MediaRecorder"""_s, DEFAULT_VALUE_FOR_MediaRecorderEnabled, false),
#endif
        API::Feature::create("MediaSession capture related API"""_s, "MediaSessionCaptureToggleAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Media, "Enable MediaSession capture related API"""_s, DEFAULT_VALUE_FOR_MediaSessionCaptureToggleAPIEnabled, false),
#if ENABLE(MEDIA_SOURCE_IN_WORKERS)
        API::Feature::create("MediaSource in a Worker"""_s, "MediaSourceInWorkerEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "MediaSource in a Worker"""_s, DEFAULT_VALUE_FOR_MediaSourceInWorkerEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::Feature::create("MediaStreamTrack Processing"""_s, "MediaStreamTrackProcessingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "Enable MediaStreamTrack Processing"""_s, DEFAULT_VALUE_FOR_MediaStreamTrackProcessingEnabled, false),
#endif
        API::Feature::create("Momentum Scrolling Animator"""_s, "MomentumScrollingAnimatorEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Generate momentum events in WebKit instead of using those delivered by the system"""_s, DEFAULT_VALUE_FOR_MomentumScrollingAnimatorEnabled, false),
#if ENABLE(INPUT_TYPE_MONTH)
        API::Feature::create("Month Input"""_s, "InputTypeMonthEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable input elements of type month"""_s, DEFAULT_VALUE_FOR_InputTypeMonthEnabled, false),
#endif
#if ENABLE(TOUCH_EVENTS)
        API::Feature::create("Mouse events simulation"""_s, "MouseEventsSimulationEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Enable mouse events dispatch along with touch events on iOS"""_s, DEFAULT_VALUE_FOR_MouseEventsSimulationEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::Feature::create("Mute Camera on Microphone Interruption"""_s, "MuteCameraOnMicrophoneInterruptionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Mute Camera on Microphone Interruption"""_s, DEFAULT_VALUE_FOR_MuteCameraOnMicrophoneInterruptionEnabled, false),
#endif
        API::Feature::create("Navigation API"""_s, "NavigationAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Enable Navigation API"""_s, DEFAULT_VALUE_FOR_NavigationAPIEnabled, false),
#if ENABLE(APP_BOUND_DOMAINS)
        API::Feature::create("Needs In-App Browser Privacy Quirks"""_s, "NeedsInAppBrowserPrivacyQuirks"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Enable quirks needed to support In-App Browser privacy"""_s, DEFAULT_VALUE_FOR_NeedsInAppBrowserPrivacyQuirks, false),
#endif
        API::Feature::create("Needs Site-Specific Quirks"""_s, "NeedsSiteSpecificQuirks"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable site-specific quirks"""_s, DEFAULT_VALUE_FOR_NeedsSiteSpecificQuirks, false),
        API::Feature::create("Needs storage access from file URLs quirk"""_s, "NeedsStorageAccessFromFileURLsQuirk"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_NeedsStorageAccessFromFileURLsQuirk, false),
        API::Feature::create("Next-generation flex layout integration (FFC)"""_s, "FlexFormattingContextIntegrationEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::DOM, "Enable next-generation flex layout integration (FFC)"""_s, DEFAULT_VALUE_FOR_FlexFormattingContextIntegrationEnabled, false),
#if ENABLE(NOTIFICATION_EVENT)
        API::Feature::create("NotificationEvent support"""_s, "NotificationEventEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "NotificationEvent and ServiceWorkerRegistration.showNotification() support"""_s, DEFAULT_VALUE_FOR_NotificationEventEnabled, false),
#endif
#if ENABLE(NOTIFICATIONS)
        API::Feature::create("Notifications"""_s, "NotificationsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable the Notifications API"""_s, DEFAULT_VALUE_FOR_NotificationsEnabled, false),
#endif
        API::Feature::create("Observable API"""_s, "ObservableEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Support for the Observable API"""_s, DEFAULT_VALUE_FOR_ObservableEnabled, false),
        API::Feature::create("Off Main-Thread Accessibility Text APIs"""_s, "AccessibilityThreadTextApisEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Serve accessibility text APIs off the main-thread"""_s, DEFAULT_VALUE_FOR_AccessibilityThreadTextApisEnabled, false),
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
        API::Feature::create("OffscreenCanvas in Workers"""_s, "OffscreenCanvasInWorkersEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Support for the OffscreenCanvas APIs in Workers"""_s, DEFAULT_VALUE_FOR_OffscreenCanvasInWorkersEnabled, false),
#endif
#if ENABLE(OFFSCREEN_CANVAS)
        API::Feature::create("OffscreenCanvas"""_s, "OffscreenCanvasEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Support for the OffscreenCanvas APIs"""_s, DEFAULT_VALUE_FOR_OffscreenCanvasEnabled, false),
#endif
#if ENABLE(OFFSCREEN_CANVAS)
        API::Feature::create("OffscreenCanvasRenderingContext2D's deprecated commit() method"""_s, "OffscreenCanvasDeprecatedCommitEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Support for OffscreenCanvasRenderingContext2D's deprecated commit() method"""_s, DEFAULT_VALUE_FOR_OffscreenCanvasDeprecatedCommitEnabled, false),
#endif
        API::Feature::create("Opportunistic Sweeping and GC"""_s, "OpportunisticSweepingAndGarbageCollectionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Javascript, "Enable Opportunistic Sweeping and GC"""_s, DEFAULT_VALUE_FOR_OpportunisticSweepingAndGarbageCollectionEnabled, false),
#if ENABLE(OPUS)
        API::Feature::create("Opus audio decoder"""_s, "OpusDecoderEnabled"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::None, "Enable Opus audio decoder"""_s, DEFAULT_VALUE_FOR_OpusDecoderEnabled, false),
#endif
        API::Feature::create("Overlapping backing stores"""_s, "OverlappingBackingStoreProvidersEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable overlapping backing stores compositor optimization"""_s, DEFAULT_VALUE_FOR_OverlappingBackingStoreProvidersEnabled, false),
        API::Feature::create("Page visibility-based process suppression"""_s, "PageVisibilityBasedProcessSuppressionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Enable page visibility-based process suppression"""_s, DEFAULT_VALUE_FOR_PageVisibilityBasedProcessSuppressionEnabled, false),
        API::Feature::create("Partition Blob URL Registry"""_s, "BlobRegistryTopOriginPartitioningEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Security, "Partition Blob URL Registry by Top-Level Origin"""_s, DEFAULT_VALUE_FOR_BlobRegistryTopOriginPartitioningEnabled, false),
        API::Feature::create("Permissions API"""_s, "PermissionsAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable Permissions API"""_s, DEFAULT_VALUE_FOR_PermissionsAPIEnabled, false),
#if HAVE(PHOTOS_UI)
        API::Feature::create("Photo Picker Prefers Original Image Format"""_s, "PhotoPickerPrefersOriginalImageFormat"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Prefer the original image format when selecting photos for file upload"""_s, DEFAULT_VALUE_FOR_PhotoPickerPrefersOriginalImageFormat, false),
#endif
        API::Feature::create("Pointer Events getCoalescedEvents API"""_s, "GetCoalescedEventsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable the `getCoalescedEvents` function of the Pointer Events API"""_s, DEFAULT_VALUE_FOR_GetCoalescedEventsEnabled, false),
        API::Feature::create("Pointer Events getPredictedEvents API"""_s, "GetPredictedEventsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable the `getPredictedEvents` function of the Pointer Events API"""_s, DEFAULT_VALUE_FOR_GetPredictedEventsEnabled, false),
#if ENABLE(POINTER_LOCK)
        API::Feature::create("Pointer Lock Options"""_s, "PointerLockOptionsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Element.requestPointerLock(options) and promise support."""_s, DEFAULT_VALUE_FOR_PointerLockOptionsEnabled, false),
#endif
        API::Feature::create("Prefer Page Rendering Updates near 60fps"""_s, "PreferPageRenderingUpdatesNear60FPSEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Prefer page rendering updates near 60 frames per second rather than using the display's refresh rate"""_s, DEFAULT_VALUE_FOR_PreferPageRenderingUpdatesNear60FPSEnabled, false),
#if ENABLE(VIDEO)
        API::Feature::create("Prefer Sandboxed Parsing of Media"""_s, "PreferSandboxedMediaParsing"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Prefer parsing media out-of-process in a sandboxed service"""_s, DEFAULT_VALUE_FOR_PreferSandboxedMediaParsing, false),
#endif
        API::Feature::create("Private Click Measurement Debug Mode"""_s, "PrivateClickMeasurementDebugModeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Developer>{}, API::FeatureCategory::Privacy, "Enable Private Click Measurement Debug Mode"""_s, DEFAULT_VALUE_FOR_PrivateClickMeasurementDebugModeEnabled, false),
        API::Feature::create("Private Click Measurement Fraud Prevention"""_s, "PrivateClickMeasurementFraudPreventionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Privacy, "Enable Private Click Measurement Fraud Prevention"""_s, DEFAULT_VALUE_FOR_PrivateClickMeasurementFraudPreventionEnabled, false),
        API::Feature::create("Private Click Measurement"""_s, "PrivateClickMeasurementEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable Private Click Measurement for Cross-Site Link Navigations"""_s, DEFAULT_VALUE_FOR_PrivateClickMeasurementEnabled, false),
        API::Feature::create("Private Token usage by third party"""_s, "PrivateTokenUsageByThirdPartyEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Privacy, "Enable private token usage by third party"""_s, DEFAULT_VALUE_FOR_PrivateTokenUsageByThirdPartyEnabled, false),
#if USE(COORDINATED_GRAPHICS)
        API::Feature::create("Propagate Damaging Information"""_s, "PropagateDamagingInformation"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Propagate Damaging Information"""_s, DEFAULT_VALUE_FOR_PropagateDamagingInformation, false),
#endif
        API::Feature::create("Push API"""_s, "PushAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::DOM, "Enable Push API"""_s, DEFAULT_VALUE_FOR_PushAPIEnabled, false),
        API::Feature::create("Quirk to get Mail to load signatures correctly with WebKitLegacy"""_s, "LegacyPluginQuirkForMailSignaturesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Quirk to get Mail to load signatures correctly with WebKitLegacy"""_s, DEFAULT_VALUE_FOR_LegacyPluginQuirkForMailSignaturesEnabled, false),
        API::Feature::create("Quirk to prevent delayed initial painting on sites using Google's Anti-Flicker optimization"""_s, "GoogleAntiFlickerOptimizationQuirkEnabled"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::None, "Quirk to prevent delayed initial painting on sites using Google's Anti-Flicker optimization"""_s, DEFAULT_VALUE_FOR_GoogleAntiFlickerOptimizationQuirkEnabled, false),
        API::Feature::create("ReadableByteStream"""_s, "ReadableByteStreamAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Enable Readable Byte Streams"""_s, DEFAULT_VALUE_FOR_ReadableByteStreamAPIEnabled, false),
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        API::Feature::create("Remote Playback API"""_s, "RemotePlaybackEnabled"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::None, "Enable Remote Playback API"""_s, DEFAULT_VALUE_FOR_RemotePlaybackEnabled, false),
#endif
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
        API::Feature::create("Remove Background"""_s, "RemoveBackgroundEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Enable Remove Background"""_s, DEFAULT_VALUE_FOR_RemoveBackgroundEnabled, false),
#endif
        API::Feature::create("Reporting API"""_s, "ReportingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable Reporting API"""_s, DEFAULT_VALUE_FOR_ReportingEnabled, false),
        API::Feature::create("RequestVideoFrameCallback"""_s, "RequestVideoFrameCallbackEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "Enable RequestVideoFrameCallback API"""_s, DEFAULT_VALUE_FOR_RequestVideoFrameCallbackEnabled, false),
#if HAVE(SC_CONTENT_SHARING_PICKER)
        API::Feature::create("Require User Agent getDisplayMedia prompt"""_s, "RequireUAGetDisplayMediaPrompt"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Require and use User Agent getDisplayMedia prompt"""_s, DEFAULT_VALUE_FOR_RequireUAGetDisplayMediaPrompt, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::Feature::create("Require a user gesture for speaker selection"""_s, "SpeakerSelectionRequiresUserGesture"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Require a user gesture for speaker selection"""_s, DEFAULT_VALUE_FOR_SpeakerSelectionRequiresUserGesture, false),
#endif
        API::Feature::create("Require being in Fullscreen to lock screen orientation"""_s, "FullscreenRequirementForScreenOrientationLockingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Require being in Fullscreen to lock screen orientation"""_s, DEFAULT_VALUE_FOR_FullscreenRequirementForScreenOrientationLockingEnabled, false),
#if ENABLE(MEDIA_STREAM)
        API::Feature::create("Require focus to start getUserMedia"""_s, "GetUserMediaRequiresFocus"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Require focus to start getUserMedia"""_s, DEFAULT_VALUE_FOR_GetUserMediaRequiresFocus, false),
#endif
        API::Feature::create("Resource Load Scheduling"""_s, "ResourceLoadSchedulingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Networking, "Network process side priority and visibility based resource load scheduling"""_s, DEFAULT_VALUE_FOR_ResourceLoadSchedulingEnabled, false),
#if ENABLE(RESOURCE_USAGE)
        API::Feature::create("Resource usage overlay"""_s, "ResourceUsageOverlayVisible"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Networking, "Make resource usage overlay visible"""_s, DEFAULT_VALUE_FOR_ResourceUsageOverlayVisible, false),
#endif
        API::Feature::create("SKAttribution"""_s, "SKAttributionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "SKAttribution"""_s, DEFAULT_VALUE_FOR_SKAttributionEnabled, false),
        API::Feature::create("Safe Browsing"""_s, "SafeBrowsingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable Safe Browsing"""_s, DEFAULT_VALUE_FOR_SafeBrowsingEnabled, false),
        API::Feature::create("SameSite strict enforcement (ITP)"""_s, "IsSameSiteStrictEnforcementEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::Privacy, "Enable SameSite strict enforcement to mitigate bounce tracking"""_s, DEFAULT_VALUE_FOR_IsSameSiteStrictEnforcementEnabled, false),
        API::Feature::create("Screen Orientation API (Locking / Unlocking)"""_s, "ScreenOrientationLockingAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Enable Screen Orientation API (Locking / Unlocking)"""_s, DEFAULT_VALUE_FOR_ScreenOrientationLockingAPIEnabled, false),
        API::Feature::create("Screen Orientation API"""_s, "ScreenOrientationAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable Screen Orientation API"""_s, DEFAULT_VALUE_FOR_ScreenOrientationAPIEnabled, false),
        API::Feature::create("Screen Wake Lock API"""_s, "ScreenWakeLockAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable Screen Wake Lock API"""_s, DEFAULT_VALUE_FOR_ScreenWakeLockAPIEnabled, false),
#if ENABLE(MEDIA_STREAM)
        API::Feature::create("ScreenCapture"""_s, "ScreenCaptureEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "Enable ScreenCapture"""_s, DEFAULT_VALUE_FOR_ScreenCaptureEnabled, false),
#endif
        API::Feature::create("Scroll Performance Testing Enabled"""_s, "ScrollingPerformanceTestingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Enable behaviors used by scrolling performance tests"""_s, DEFAULT_VALUE_FOR_ScrollingPerformanceTestingEnabled, false),
        API::Feature::create("Scroll To Text Fragment Feature Detection"""_s, "ScrollToTextFragmentFeatureDetectionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Preview>{}, API::FeatureCategory::DOM, "Enable Scroll To Text Fragment Feature Detection"""_s, DEFAULT_VALUE_FOR_ScrollToTextFragmentFeatureDetectionEnabled, false),
        API::Feature::create("Scroll To Text Fragment Generation"""_s, "ScrollToTextFragmentGenerationEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable Scroll To Text Fragment Generation Menu"""_s, DEFAULT_VALUE_FOR_ScrollToTextFragmentGenerationEnabled, false),
        API::Feature::create("Scroll To Text Fragment Indicator"""_s, "ScrollToTextFragmentIndicatorEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable Scroll To Text Fragment Indicator"""_s, DEFAULT_VALUE_FOR_ScrollToTextFragmentIndicatorEnabled, false),
        API::Feature::create("Scroll To Text Fragment Marking"""_s, "ScrollToTextFragmentMarkingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable Scroll To Text Fragment Marking"""_s, DEFAULT_VALUE_FOR_ScrollToTextFragmentMarkingEnabled, false),
        API::Feature::create("Scroll To Text Fragment"""_s, "ScrollToTextFragmentEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable Scroll To Text Fragment"""_s, DEFAULT_VALUE_FOR_ScrollToTextFragmentEnabled, false),
        API::Feature::create("Scroll animator"""_s, "ScrollAnimatorEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable scroll animator"""_s, DEFAULT_VALUE_FOR_ScrollAnimatorEnabled, false),
        API::Feature::create("Scroll-driven Animations"""_s, "ScrollDrivenAnimationsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Animation, "Enable Scroll-driven Animations"""_s, DEFAULT_VALUE_FOR_ScrollDrivenAnimationsEnabled, false),
        API::Feature::create("Search control incremental attribute and search event"""_s, "SearchInputIncrementalAttributeAndSearchEventEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::HTML, "Enable search control incremental attribute and search event support"""_s, DEFAULT_VALUE_FOR_SearchInputIncrementalAttributeAndSearchEventEnabled, false),
        API::Feature::create("Secure Context Checks"""_s, "SecureContextChecksEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Security, "Allow access to HTTPS-only Web APIs over HTTP"""_s, DEFAULT_VALUE_FOR_SecureContextChecksEnabled, false),
        API::Feature::create("Selection API for shadow DOM"""_s, "SelectionAPIForShadowDOMEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable selection API for shadow DOM"""_s, DEFAULT_VALUE_FOR_SelectionAPIForShadowDOMEnabled, false),
        API::Feature::create("Selection Flipping"""_s, "SelectionFlippingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable Selection Flipping"""_s, DEFAULT_VALUE_FOR_SelectionFlippingEnabled, false),
        API::Feature::create("Send mouse events to disabled form controls"""_s, "SendMouseEventsToDisabledFormControlsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::HTML, "Send mouse events to disabled form controls"""_s, DEFAULT_VALUE_FOR_SendMouseEventsToDisabledFormControlsEnabled, false),
        API::Feature::create("Service Worker Navigation Preload"""_s, "ServiceWorkerNavigationPreloadEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Networking, "Enable Service Worker Navigation Preload API"""_s, DEFAULT_VALUE_FOR_ServiceWorkerNavigationPreloadEnabled, false),
        API::Feature::create("Service Workers"""_s, "ServiceWorkersEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable Service Workers"""_s, DEFAULT_VALUE_FOR_ServiceWorkersEnabled, false),
        API::Feature::create("Shape Detection API"""_s, "ShapeDetection"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Media, "Enable the Shape Detection API"""_s, DEFAULT_VALUE_FOR_ShapeDetection, false),
        API::Feature::create("SharedWorker"""_s, "SharedWorkerEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enabled SharedWorker API"""_s, DEFAULT_VALUE_FOR_SharedWorkerEnabled, false),
        API::Feature::create("Show Media Stats"""_s, "ShowMediaStatsContextMenuItemEnabled"_s, API::FeatureConstant<API::FeatureStatus::Developer>{}, API::FeatureCategory::Media, "Adds a 'Media Stats' context menu item to <video> when the Develop menu is enabled"""_s, DEFAULT_VALUE_FOR_ShowMediaStatsContextMenuItemEnabled, false),
        API::Feature::create("Sideways writing modes"""_s, "SidewaysWritingModesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enable support for sideways writing modes"""_s, DEFAULT_VALUE_FOR_SidewaysWritingModesEnabled, false),
        API::Feature::create("Site Isolation"""_s, "SiteIsolationEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::Security, "Put cross-origin iframes in a different process"""_s, DEFAULT_VALUE_FOR_SiteIsolationEnabled, false),
        API::Feature::create("SpeechRecognition API"""_s, "SpeechRecognitionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::None, "Enable SpeechRecognition of WebSpeech API"""_s, DEFAULT_VALUE_FOR_SpeechRecognitionEnabled, false),
        API::Feature::create("SpeechSynthesis API"""_s, "SpeechSynthesisAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "SpeechSynthesis API"""_s, DEFAULT_VALUE_FOR_SpeechSynthesisAPIEnabled, false),
        API::Feature::create("Storage API Estimate"""_s, "StorageAPIEstimateEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable Storage API Estimate"""_s, DEFAULT_VALUE_FOR_StorageAPIEstimateEnabled, false),
        API::Feature::create("Storage API"""_s, "StorageAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable Storage API"""_s, DEFAULT_VALUE_FOR_StorageAPIEnabled, false),
        API::Feature::create("Swap Processes on Cross-Site Navigation"""_s, "ProcessSwapOnCrossSiteNavigationEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Networking, "Swap WebContent Processes on cross-site navigations"""_s, DEFAULT_VALUE_FOR_ProcessSwapOnCrossSiteNavigationEnabled, false),
        API::Feature::create("Take WebKit:NearSuspended assertions on background web content processes"""_s, "ShouldTakeNearSuspendedAssertions"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Take WebKit:NearSuspended assertions on background web content processes"""_s, DEFAULT_VALUE_FOR_ShouldTakeNearSuspendedAssertions, false),
#if ENABLE(WRITING_TOOLS_UI)
        API::Feature::create("Text Animations"""_s, "TextAnimationsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Text Animations"""_s, DEFAULT_VALUE_FOR_TextAnimationsEnabled, false),
#endif
#if ENABLE(IMAGE_ANALYSIS) && ENABLE(VIDEO)
        API::Feature::create("Text Recognition in Videos"""_s, "TextRecognitionInVideosEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Enable Text Recognition in Videos"""_s, DEFAULT_VALUE_FOR_TextRecognitionInVideosEnabled, false),
#endif
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        API::Feature::create("Threaded animation resolution"""_s, "ThreadedAnimationResolutionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::Animation, "Run accelerated animations on a separate thread"""_s, DEFAULT_VALUE_FOR_ThreadedAnimationResolutionEnabled, false),
#endif
        API::Feature::create("Tiled scrolling indicator"""_s, "TiledScrollingIndicatorVisible"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Make tiled scrolling indicator visible"""_s, DEFAULT_VALUE_FOR_TiledScrollingIndicatorVisible, false),
#if ENABLE(INPUT_TYPE_TIME)
        API::Feature::create("Time Input"""_s, "InputTypeTimeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable input elements of type time"""_s, DEFAULT_VALUE_FOR_InputTypeTimeEnabled, false),
#endif
        API::Feature::create("Track Configuration API"""_s, "TrackConfigurationEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Media, "Track Configuration API"""_s, DEFAULT_VALUE_FOR_TrackConfigurationEnabled, false),
        API::Feature::create("Trusted Types"""_s, "TrustedTypesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Enable Trusted Types"""_s, DEFAULT_VALUE_FOR_TrustedTypesEnabled, false),
        API::Feature::create("UndoManager DOM API"""_s, "UndoManagerAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::DOM, "Enable the UndoManager DOM API"""_s, DEFAULT_VALUE_FOR_UndoManagerAPIEnabled, false),
#if ENABLE(UNIFIED_PDF)
        API::Feature::create("Unified PDF Viewer"""_s, "UnifiedPDFEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unifiedpdf_feature_status>{}, API::FeatureCategory::Security, "Enable Unified PDF Viewer"""_s, DEFAULT_VALUE_FOR_UnifiedPDFEnabled, false),
#endif
#if USE(COORDINATED_GRAPHICS)
        API::Feature::create("Unify Damaged Regions"""_s, "UnifyDamagedRegions"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Unify Damaged Regions"""_s, DEFAULT_VALUE_FOR_UnifyDamagedRegions, false),
#endif
        API::Feature::create("Upgrade IP addresses and localhost in mixed content"""_s, "IPAddressAndLocalhostMixedContentUpgradeTestingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Security, "Enable Upgrading IP addresses and localhost in mixed content"""_s, DEFAULT_VALUE_FOR_IPAddressAndLocalhostMixedContentUpgradeTestingEnabled, false),
        API::Feature::create("Upgrade known hosts to HTTPS"""_s, "UpgradeKnownHostsToHTTPSEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Networking, "Upgrade known hosts to HTTPS"""_s, DEFAULT_VALUE_FOR_UpgradeKnownHostsToHTTPSEnabled, false),
        API::Feature::create("Upgrade upgradable mixed content"""_s, "UpgradeMixedContentEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Networking, "Upgrade upgradable mixed content"""_s, DEFAULT_VALUE_FOR_UpgradeMixedContentEnabled, false),
#if ENABLE(ARKIT_INLINE_PREVIEW)
        API::Feature::create("Use ARKit for <model>"""_s, "UseARKitForModel"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Use ARKit for <model>"""_s, DEFAULT_VALUE_FOR_UseARKitForModel, false),
#endif
#if HAVE(SC_CONTENT_SHARING_PICKER)
        API::Feature::create("Use SCContentSharingPicker"""_s, "UseSCContentSharingPicker"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Use SCContentSharingPicker when available"""_s, DEFAULT_VALUE_FOR_UseSCContentSharingPicker, false),
#endif
#if HAVE(SCENEKIT)
        API::Feature::create("Use SceneKit for <model>"""_s, "UseSceneKitForModel"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::None, "Use SceneKit for <model>"""_s, DEFAULT_VALUE_FOR_UseSceneKitForModel, false),
#endif
        API::Feature::create("Use giant tiles"""_s, "UseGiantTiles"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, """"_s, DEFAULT_VALUE_FOR_UseGiantTiles, false),
        API::Feature::create("User Activation API"""_s, "UserActivationAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable User Activation API"""_s, DEFAULT_VALUE_FOR_UserActivationAPIEnabled, false),
        API::Feature::create("UserGesture Promise Propagation"""_s, "UserGesturePromisePropagationEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "UserGesture Promise Propagation"""_s, DEFAULT_VALUE_FOR_UserGesturePromisePropagationEnabled, false),
        API::Feature::create("Validate UserGesture requirements in Service Workers"""_s, "ServiceWorkersUserGestureEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Validate UserGesture requirements in Service Workers"""_s, DEFAULT_VALUE_FOR_ServiceWorkersUserGestureEnabled, false),
        API::Feature::create("Verify window.open user gesture"""_s, "VerifyWindowOpenUserGestureFromUIProcess"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Security, "Verifies that the user gesture for window.open came from the UI process"""_s, DEFAULT_VALUE_FOR_VerifyWindowOpenUserGestureFromUIProcess, false),
        API::Feature::create("Vertical form control support"""_s, "VerticalFormControlsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::HTML, "Enable support for form controls in vertical writing mode"""_s, DEFAULT_VALUE_FOR_VerticalFormControlsEnabled, false),
        API::Feature::create("View Transition Classes"""_s, "ViewTransitionClassesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Animation, "Support specifying classes for view transitions"""_s, DEFAULT_VALUE_FOR_ViewTransitionClassesEnabled, false),
        API::Feature::create("View Transition Types"""_s, "ViewTransitionTypesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Animation, "Support specifying types for view transitions"""_s, DEFAULT_VALUE_FOR_ViewTransitionTypesEnabled, false),
        API::Feature::create("View Transitions"""_s, "ViewTransitionsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Animation, "Enable the View Transitions API"""_s, DEFAULT_VALUE_FOR_ViewTransitionsEnabled, false),
        API::Feature::create("View gesture debugging"""_s, "ViewGestureDebuggingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable view gesture debugging"""_s, DEFAULT_VALUE_FOR_ViewGestureDebuggingEnabled, false),
#if ENABLE(IMAGE_ANALYSIS)
        API::Feature::create("Visual Translation"""_s, "VisualTranslationEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Enable Visual Translation"""_s, DEFAULT_VALUE_FOR_VisualTranslationEnabled, false),
#endif
        API::Feature::create("Visual Viewport API"""_s, "VisualViewportAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::None, "Enable Visual Viewport API"""_s, DEFAULT_VALUE_FOR_VisualViewportAPIEnabled, false),
#if ENABLE(VORBIS)
        API::Feature::create("Vorbis audio decoder"""_s, "VorbisDecoderEnabled"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::None, "Enable Vorbis audio decoder"""_s, DEFAULT_VALUE_FOR_VorbisDecoderEnabled, false),
#endif
        API::Feature::create("Web API Statistics"""_s, "WebAPIStatisticsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::DOM, "Enable Web API Statistics"""_s, DEFAULT_VALUE_FOR_WebAPIStatisticsEnabled, false),
        API::Feature::create("Web APIs in ShadowRealm"""_s, "WebAPIsInShadowRealmEnabled"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::DOM, "Enable Web APIs to be exposed in ShadowRealm"""_s, DEFAULT_VALUE_FOR_WebAPIsInShadowRealmEnabled, false),
        API::Feature::create("Web Animations custom effects"""_s, "WebAnimationsCustomEffectsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Animation, "Support for the CustomEffect interface"""_s, DEFAULT_VALUE_FOR_WebAnimationsCustomEffectsEnabled, false),
        API::Feature::create("Web Animations custom frame rate"""_s, "WebAnimationsCustomFrameRateEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Animation, "Support for specifying a custom frame rate for Web Animations"""_s, DEFAULT_VALUE_FOR_WebAnimationsCustomFrameRateEnabled, false),
#if ENABLE(WEB_ARCHIVE)
        API::Feature::create("Web Archive debug mode"""_s, "WebArchiveDebugModeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable web archive debug mode"""_s, DEFAULT_VALUE_FOR_WebArchiveDebugModeEnabled, false),
#endif
#if ENABLE(WEB_ARCHIVE)
        API::Feature::create("Web Archive testing mode"""_s, "WebArchiveTestingModeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, "Enable web archive testing mode"""_s, DEFAULT_VALUE_FOR_WebArchiveTestingModeEnabled, false),
#endif
#if HAVE(WEB_AUTHN_AS_MODERN)
        API::Feature::create("Web Authentication AuthenticationServices"""_s, "WebAuthenticationASEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable Modern Web Authentication support though AuthenticationServices"""_s, DEFAULT_VALUE_FOR_WebAuthenticationASEnabled, false),
#endif
#if ENABLE(WEB_AUTHN)
        API::Feature::create("Web Authentication"""_s, "WebAuthenticationEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable Web Authentication support"""_s, DEFAULT_VALUE_FOR_WebAuthenticationEnabled, false),
#endif
        API::Feature::create("Web Crypto Safe Curves"""_s, "WebCryptoSafeCurvesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable Web Crypto Safe Curves"""_s, DEFAULT_VALUE_FOR_WebCryptoSafeCurvesEnabled, false),
        API::Feature::create("Web Crypto X25519 algorithm"""_s, "WebCryptoX25519Enabled"_s, API::FeatureConstant<API::FeatureStatus::Preview>{}, API::FeatureCategory::DOM, "Enable Web Crypto X25519 algorithm"""_s, DEFAULT_VALUE_FOR_WebCryptoX25519Enabled, false),
        API::Feature::create("Web Locks API"""_s, "WebLocksAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Web Locks API"""_s, DEFAULT_VALUE_FOR_WebLocksAPIEnabled, false),
        API::Feature::create("Web Share API Level 2"""_s, "WebShareFileAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable level 2 of Web Share API"""_s, DEFAULT_VALUE_FOR_WebShareFileAPIEnabled, false),
        API::Feature::create("Web Share"""_s, "WebShareEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable support for share sheet via Web Share API"""_s, DEFAULT_VALUE_FOR_WebShareEnabled, false),
#if ENABLE(WEBASSEMBLY)
        API::Feature::create("WebAssembly ES module integration support"""_s, "WebAssemblyESMIntegrationEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Javascript, "Support for allowing WebAssembly modules to integrate as ES modules"""_s, DEFAULT_VALUE_FOR_WebAssemblyESMIntegrationEnabled, false),
#endif
#if ENABLE(WEB_CODECS)
        API::Feature::create("WebCodecs AV1 codec"""_s, "WebCodecsAV1Enabled"_s, API::FeatureConstant<API::FeatureStatus::Preview>{}, API::FeatureCategory::Media, "Enable WebCodecs AV1 codec"""_s, DEFAULT_VALUE_FOR_WebCodecsAV1Enabled, false),
#endif
#if ENABLE(WEB_CODECS)
        API::Feature::create("WebCodecs Audio API"""_s, "WebCodecsAudioEnabled"_s, API::FeatureConstant<API::FeatureStatus::Preview>{}, API::FeatureCategory::Media, "Enable WebCodecs Audio API"""_s, DEFAULT_VALUE_FOR_WebCodecsAudioEnabled, false),
#endif
#if ENABLE(WEB_CODECS)
        API::Feature::create("WebCodecs HEVC codec"""_s, "WebCodecsHEVCEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "Enable WebCodecs HEVC codec"""_s, DEFAULT_VALUE_FOR_WebCodecsHEVCEnabled, false),
#endif
#if ENABLE(WEB_CODECS)
        API::Feature::create("WebCodecs Video API"""_s, "WebCodecsVideoEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "Enable WebCodecs Video API"""_s, DEFAULT_VALUE_FOR_WebCodecsVideoEnabled, false),
#endif
#if ENABLE(WK_WEB_EXTENSIONS_SIDEBAR)
        API::Feature::create("WebExtension sidebarAction and sidePanel APIs"""_s, "WebExtensionSidebarEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Extensions, "Enable support for WebExtensions using the sidebarAction / sidePanel family of APIs"""_s, DEFAULT_VALUE_FOR_WebExtensionSidebarEnabled, false),
#endif
        API::Feature::create("WebGL Draft Extensions"""_s, "WebGLDraftExtensionsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Enable WebGL extensions that are still in draft status"""_s, DEFAULT_VALUE_FOR_WebGLDraftExtensionsEnabled, false),
        API::Feature::create("WebGL Timer Queries"""_s, "WebGLTimerQueriesEnabled"_s, API::FeatureConstant<API::FeatureStatus::Developer>{}, API::FeatureCategory::DOM, "Enable WebGL extensions that provide GPU timer queries"""_s, DEFAULT_VALUE_FOR_WebGLTimerQueriesEnabled, false),
        API::Feature::create("WebGL"""_s, "WebGLEnabled"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::None, "Enable WebGL"""_s, DEFAULT_VALUE_FOR_WebGLEnabled, false),
        API::Feature::create("WebGPU Support for WebXR"""_s, "WebXRWebGPUBindingsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Webgpu_webxr_feature_status>{}, API::FeatureCategory::DOM, "Adds WebGPU support for WebXR"""_s, DEFAULT_VALUE_FOR_WebXRWebGPUBindingsEnabled, false),
        API::Feature::create("WebGPU"""_s, "WebGPUEnabled"_s, API::FeatureConstant<API::FeatureStatus::Webgpu_feature_status>{}, API::FeatureCategory::DOM, "Enable WebGPU"""_s, DEFAULT_VALUE_FOR_WebGPUEnabled, false),
        API::Feature::create("WebInspector engineering settings allowed"""_s, "WebInspectorEngineeringSettingsAllowed"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::DOM, """"_s, DEFAULT_VALUE_FOR_WebInspectorEngineeringSettingsAllowed, false),
#if ENABLE(WEB_RTC)
        API::Feature::create("WebRTC AV1 codec"""_s, "WebRTCAV1CodecEnabled"_s, API::FeatureConstant<API::FeatureStatus::Preview>{}, API::FeatureCategory::Media, "Enable WebRTC AV1 codec"""_s, DEFAULT_VALUE_FOR_WebRTCAV1CodecEnabled, false),
#endif
        API::Feature::create("WebRTC Audio Latency Adaptation"""_s, "WebRTCAudioLatencyAdaptationEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Enable WebRTC Audio Latency Adaptation"""_s, DEFAULT_VALUE_FOR_WebRTCAudioLatencyAdaptationEnabled, false),
#if ENABLE(WEB_RTC)
        API::Feature::create("WebRTC DTMF"""_s, "WebRTCDTMFEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Enable WebRTC DTMF"""_s, DEFAULT_VALUE_FOR_WebRTCDTMFEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::Feature::create("WebRTC Encoded Transform API"""_s, "WebRTCEncodedTransformEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "Enable WebRTC Encoded Transform API"""_s, DEFAULT_VALUE_FOR_WebRTCEncodedTransformEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::Feature::create("WebRTC H264 Hardware encoder"""_s, "WebRTCH264HardwareEncoderEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Enable H264 Hardware encoder"""_s, DEFAULT_VALUE_FOR_WebRTCH264HardwareEncoderEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::Feature::create("WebRTC HEVC codec"""_s, "WebRTCH265CodecEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "Enable WebRTC HEVC codec"""_s, DEFAULT_VALUE_FOR_WebRTCH265CodecEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::Feature::create("WebRTC L4S support"""_s, "WebRTCL4SEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Media, "Enable WebRTC L4S support"""_s, DEFAULT_VALUE_FOR_WebRTCL4SEnabled, false),
#endif
        API::Feature::create("WebRTC Media Pipeline Additional Logging"""_s, "WebRTCMediaPipelineAdditionalLoggingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Enable WebRTC Media Pipeline Additional Logging"""_s, DEFAULT_VALUE_FOR_WebRTCMediaPipelineAdditionalLoggingEnabled, false),
#if ENABLE(WEB_RTC)
        API::Feature::create("WebRTC Peer Connection Legacy Offer options"""_s, "LegacyWebRTCOfferOptionsEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable RTCPeerConnection Legacy offer options (offerToReceiveAudio, offerToReceiveVideo)"""_s, DEFAULT_VALUE_FOR_LegacyWebRTCOfferOptionsEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::Feature::create("WebRTC Peer Connection Video Scaling Adaptation"""_s, "PeerConnectionVideoScalingAdaptationDisabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Disable RTCPeerConnection Video Scaling Adaptation"""_s, DEFAULT_VALUE_FOR_PeerConnectionVideoScalingAdaptationDisabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::Feature::create("WebRTC Peer Connection"""_s, "PeerConnectionEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable RTCPeerConnection"""_s, DEFAULT_VALUE_FOR_PeerConnectionEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::Feature::create("WebRTC Remote Video Frame"""_s, "WebRTCRemoteVideoFrameEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Enable WebRTC Remote Video Frame"""_s, DEFAULT_VALUE_FOR_WebRTCRemoteVideoFrameEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::Feature::create("WebRTC SFrame Transform API"""_s, "WebRTCSFrameTransformEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Media, "Enable WebRTC SFrame Transform API"""_s, DEFAULT_VALUE_FOR_WebRTCSFrameTransformEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::Feature::create("WebRTC Sockets Proxying"""_s, "WebRTCSocketsProxyingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Enable WebRTC Sockets Proxying"""_s, DEFAULT_VALUE_FOR_WebRTCSocketsProxyingEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::Feature::create("WebRTC VP9 profile 0 codec"""_s, "WebRTCVP9Profile0CodecEnabled"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::Media, "Enable WebRTC VP9 profile 0 codec"""_s, DEFAULT_VALUE_FOR_WebRTCVP9Profile0CodecEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::Feature::create("WebRTC VP9 profile 2 codec"""_s, "WebRTCVP9Profile2CodecEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::Media, "Enable WebRTC VP9 profile 2 codec"""_s, DEFAULT_VALUE_FOR_WebRTCVP9Profile2CodecEnabled, false),
#endif
        API::Feature::create("WebTransport"""_s, "WebTransportEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::Networking, "Enable WebTransport"""_s, DEFAULT_VALUE_FOR_WebTransportEnabled, false),
#if ENABLE(WEBXR)
        API::Feature::create("WebXR Augmented Reality Module"""_s, "WebXRAugmentedRealityModuleEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::DOM, "Adds support for the WebXR Augmented Reality Module"""_s, DEFAULT_VALUE_FOR_WebXRAugmentedRealityModuleEnabled, false),
#endif
#if ENABLE(WEBXR)
        API::Feature::create("WebXR Device API"""_s, "WebXREnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Adds support for accessing virtual reality (VR) and augmented reality (AR) devices, including sensors and head-mounted displays, on the Web"""_s, DEFAULT_VALUE_FOR_WebXREnabled, false),
#endif
#if ENABLE(WEBXR)
        API::Feature::create("WebXR Gamepads Module"""_s, "WebXRGamepadsModuleEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Adds support for the WebXR Gamepads Module"""_s, DEFAULT_VALUE_FOR_WebXRGamepadsModuleEnabled, false),
#endif
#if ENABLE(WEBXR_HANDS)
        API::Feature::create("WebXR Hand Input Module"""_s, "WebXRHandInputModuleEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Adds support for the Hands Input Module for WebXR"""_s, DEFAULT_VALUE_FOR_WebXRHandInputModuleEnabled, false),
#endif
#if ENABLE(WEBXR_LAYERS)
        API::Feature::create("WebXR Layers API"""_s, "WebXRLayersAPIEnabled"_s, API::FeatureConstant<API::FeatureStatus::Webxr_layers_feature_status>{}, API::FeatureCategory::DOM, "Adds support for the WebXR Layers API"""_s, DEFAULT_VALUE_FOR_WebXRLayersAPIEnabled, false),
#endif
#if ENABLE(INPUT_TYPE_WEEK)
        API::Feature::create("Week Input"""_s, "InputTypeWeekEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable input elements of type week"""_s, DEFAULT_VALUE_FOR_InputTypeWeekEnabled, false),
#endif
        API::Feature::create("Wheel Event gestures become non-blocking"""_s, "WheelEventGesturesBecomeNonBlocking"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::None, "preventDefault() is only allowed on the first wheel event in a gesture"""_s, DEFAULT_VALUE_FOR_WheelEventGesturesBecomeNonBlocking, false),
        API::Feature::create("Wheel Event listeners on the root made passive"""_s, "PassiveWheelListenersAsDefaultOnDocument"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Force wheel event listeners registered on the window, document or body to be passive"""_s, DEFAULT_VALUE_FOR_PassiveWheelListenersAsDefaultOnDocument, false),
#if PLATFORM(COCOA)
        API::Feature::create("Write RTF on Copy"""_s, "WriteRichTextDataWhenCopyingOrDragging"_s, API::FeatureConstant<API::FeatureStatus::Internal>{}, API::FeatureCategory::None, "Write RTF, RTFD and attributed strings to the pasteboard when copying or dragging"""_s, DEFAULT_VALUE_FOR_WriteRichTextDataWhenCopyingOrDragging, false),
#endif
#if ENABLE(WRITING_SUGGESTIONS)
        API::Feature::create("Writing Suggestions"""_s, "WritingSuggestionsAttributeEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable the writingsuggestions attribute"""_s, DEFAULT_VALUE_FOR_WritingSuggestionsAttributeEnabled, false),
#endif
        API::Feature::create("[ITP Live-On] 1 Hour Timeout For Non-Cookie Data Removal"""_s, "IsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Developer>{}, API::FeatureCategory::Privacy, "Remove all non-cookie website data after just one hour of no user interaction when Intelligent Tracking Prevention is enabled"""_s, DEFAULT_VALUE_FOR_IsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled, false),
        API::Feature::create("[ITP Repro] 30 Second Timeout For Non-Cookie Data Removal"""_s, "IsFirstPartyWebsiteDataRemovalReproTestingEnabled"_s, API::FeatureConstant<API::FeatureStatus::Developer>{}, API::FeatureCategory::Privacy, "Remove all non-cookie website data after just 30 seconds of no user interaction when Intelligent Tracking Prevention is enabled"""_s, DEFAULT_VALUE_FOR_IsFirstPartyWebsiteDataRemovalReproTestingEnabled, false),
        API::Feature::create("align-content on blocks"""_s, "AlignContentOnBlocksEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::CSS, "Enable align-content for block containers"""_s, DEFAULT_VALUE_FOR_AlignContentOnBlocksEnabled, false),
        API::Feature::create("altitudeAngle PointerEvent Property"""_s, "AltitudeAngleEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable the `altitudeAngle` property of the PointerEvents API"""_s, DEFAULT_VALUE_FOR_AltitudeAngleEnabled, false),
        API::Feature::create("azimuthAngle PointerEvent Property"""_s, "AzimuthAngleEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable the `azimuthAngle` property of the PointerEvents API"""_s, DEFAULT_VALUE_FOR_AzimuthAngleEnabled, false),
#if ENABLE(INPUT_TYPE_DATETIMELOCAL)
        API::Feature::create("datetime-local Inputs"""_s, "InputTypeDateTimeLocalEnabled"_s, API::FeatureConstant<API::FeatureStatus::Embedder>{}, API::FeatureCategory::None, "Enable input elements of type datetime-local"""_s, DEFAULT_VALUE_FOR_InputTypeDateTimeLocalEnabled, false),
#endif
        API::Feature::create("element.checkVisibility() API"""_s, "ElementCheckVisibilityEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable element.checkVisibility() API"""_s, DEFAULT_VALUE_FOR_ElementCheckVisibilityEnabled, false),
        API::Feature::create("http-equiv"""_s, "HTTPEquivEnabled"_s, API::FeatureConstant<API::FeatureStatus::Mature>{}, API::FeatureCategory::None, "Enable http-equiv attribute"""_s, DEFAULT_VALUE_FOR_HTTPEquivEnabled, false),
        API::Feature::create("requestIdleCallback"""_s, "RequestIdleCallbackEnabled"_s, API::FeatureConstant<API::FeatureStatus::Stable>{}, API::FeatureCategory::DOM, "Enable requestIdleCallback support"""_s, DEFAULT_VALUE_FOR_RequestIdleCallbackEnabled, false),
        API::Feature::create("requestStorageAccess throws execption until reload"""_s, "RequestStorageAccessThrowsExceptionUntilReload"_s, API::FeatureConstant<API::FeatureStatus::Unstable>{}, API::FeatureCategory::DOM, "requestStorageAccess throws execption until reload"""_s, DEFAULT_VALUE_FOR_RequestStorageAccessThrowsExceptionUntilReload, false),
        API::Feature::create("word-break: auto-phrase enabled"""_s, "CSSWordBreakAutoPhraseEnabled"_s, API::FeatureConstant<API::FeatureStatus::Testable>{}, API::FeatureCategory::CSS, "Enables the auto-phrase value of the word-break CSS property"""_s, DEFAULT_VALUE_FOR_CSSWordBreakAutoPhraseEnabled, false),
    });

    return features;
}

bool WebPreferences::isFeatureEnabled(const API::Feature& feature) const
{
    struct FeatureGetterMapping {
        ASCIILiteral name;
        bool (WebPreferences::*function) () const;
    };

    static FeatureGetterMapping getters[] = {
        { "AcceleratedCompositingEnabled"_s, &WebPreferences::acceleratedCompositingEnabled },
        { "AcceleratedCompositingForFixedPositionEnabled"_s, &WebPreferences::acceleratedCompositingForFixedPositionEnabled },
        { "AggressiveTileRetentionEnabled"_s, &WebPreferences::aggressiveTileRetentionEnabled },
        { "AllowContentSecurityPolicySourceStarToMatchAnyProtocol"_s, &WebPreferences::allowContentSecurityPolicySourceStarToMatchAnyProtocol },
        { "AllowDisplayOfInsecureContent"_s, &WebPreferences::allowDisplayOfInsecureContent },
        { "AllowFileAccessFromFileURLs"_s, &WebPreferences::allowFileAccessFromFileURLs },
        { "AllowMultiElementImplicitSubmission"_s, &WebPreferences::allowMultiElementImplicitSubmission },
        { "AllowRunningOfInsecureContent"_s, &WebPreferences::allowRunningOfInsecureContent },
        { "AllowSettingAnyXHRHeaderFromFileURLs"_s, &WebPreferences::allowSettingAnyXHRHeaderFromFileURLs },
        { "AllowTestOnlyIPC"_s, &WebPreferences::allowTestOnlyIPC },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        { "AllowsAirPlayForMediaPlayback"_s, &WebPreferences::allowsAirPlayForMediaPlayback },
#endif
        { "AllowsInlineMediaPlayback"_s, &WebPreferences::allowsInlineMediaPlayback },
        { "AllowsInlineMediaPlaybackAfterFullscreen"_s, &WebPreferences::allowsInlineMediaPlaybackAfterFullscreen },
        { "AllowsPictureInPictureMediaPlayback"_s, &WebPreferences::allowsPictureInPictureMediaPlayback },
#if PLATFORM(IOS_FAMILY)
        { "AlternateFormControlDesignEnabled"_s, &WebPreferences::alternateFormControlDesignEnabled },
#endif
#if PLATFORM(IOS_FAMILY)
        { "AlternateFullScreenControlDesignEnabled"_s, &WebPreferences::alternateFullScreenControlDesignEnabled },
#endif
        { "AnimatedImageAsyncDecodingEnabled"_s, &WebPreferences::animatedImageAsyncDecodingEnabled },
        { "AppleMailPaginationQuirkEnabled"_s, &WebPreferences::appleMailPaginationQuirkEnabled },
#if ENABLE(APPLE_PAY)
        { "ApplePayCapabilityDisclosureAllowed"_s, &WebPreferences::applePayCapabilityDisclosureAllowed },
#endif
#if ENABLE(APPLE_PAY)
        { "ApplePayEnabled"_s, &WebPreferences::applePayEnabled },
#endif
        { "AsynchronousSpellCheckingEnabled"_s, &WebPreferences::asynchronousSpellCheckingEnabled },
        { "AudioControlsScaleWithPageZoom"_s, &WebPreferences::audioControlsScaleWithPageZoom },
        { "AuthorAndUserStylesEnabled"_s, &WebPreferences::authorAndUserStylesEnabled },
        { "BackspaceKeyNavigationEnabled"_s, &WebPreferences::backspaceKeyNavigationEnabled },
        { "CaretBrowsingEnabled"_s, &WebPreferences::caretBrowsingEnabled },
        { "ColorFilterEnabled"_s, &WebPreferences::colorFilterEnabled },
#if ENABLE(CONTENT_CHANGE_OBSERVER)
        { "ContentChangeObserverEnabled"_s, &WebPreferences::contentChangeObserverEnabled },
#endif
        { "ContentDispositionAttachmentSandboxEnabled"_s, &WebPreferences::contentDispositionAttachmentSandboxEnabled },
#if ENABLE(CONTEXT_MENU_QR_CODE_DETECTION)
        { "ContextMenuQRCodeDetectionEnabled"_s, &WebPreferences::contextMenuQRCodeDetectionEnabled },
#endif
        { "DNSPrefetchingEnabled"_s, &WebPreferences::dnsPrefetchingEnabled },
        { "DOMPasteAllowed"_s, &WebPreferences::domPasteAllowed },
        { "DatabasesEnabled"_s, &WebPreferences::databasesEnabled },
        { "DeveloperExtrasEnabled"_s, &WebPreferences::developerExtrasEnabled },
#if ENABLE(DEVICE_ORIENTATION)
        { "DeviceOrientationEventEnabled"_s, &WebPreferences::deviceOrientationEventEnabled },
#endif
#if ENABLE(DEVICE_ORIENTATION)
        { "DeviceOrientationPermissionAPIEnabled"_s, &WebPreferences::deviceOrientationPermissionAPIEnabled },
#endif
        { "DisabledAdaptationsMetaTagEnabled"_s, &WebPreferences::disabledAdaptationsMetaTagEnabled },
        { "DownloadAttributeEnabled"_s, &WebPreferences::downloadAttributeEnabled },
        { "EnableInheritURIQueryComponent"_s, &WebPreferences::enableInheritURIQueryComponent },
#if ENABLE(ENCRYPTED_MEDIA)
        { "EncryptedMediaAPIEnabled"_s, &WebPreferences::encryptedMediaAPIEnabled },
#endif
#if HAVE(APP_SSO)
        { "ExtensibleSSOEnabled"_s, &WebPreferences::isExtensibleSSOEnabled },
#endif
        { "ForceCompositingMode"_s, &WebPreferences::forceCompositingMode },
        { "ForceFTPDirectoryListings"_s, &WebPreferences::forceFTPDirectoryListings },
        { "ForceWebGLUsesLowPower"_s, &WebPreferences::forceWebGLUsesLowPower },
#if USE(GSTREAMER)
        { "GStreamerEnabled"_s, &WebPreferences::isGStreamerEnabled },
#endif
        { "HiddenPageCSSAnimationSuspensionEnabled"_s, &WebPreferences::hiddenPageCSSAnimationSuspensionEnabled },
        { "IncompleteImageBorderEnabled"_s, &WebPreferences::incompleteImageBorderEnabled },
#if HAVE(INCREMENTAL_PDF_APIS)
        { "IncrementalPDFLoadingEnabled"_s, &WebPreferences::incrementalPDFLoadingEnabled },
#endif
        { "InlineMediaPlaybackRequiresPlaysInlineAttribute"_s, &WebPreferences::inlineMediaPlaybackRequiresPlaysInlineAttribute },
        { "InspectorStartsAttached"_s, &WebPreferences::inspectorStartsAttached },
#if ENABLE(MEDIA_STREAM)
        { "InterruptAudioOnPageVisibilityChangeEnabled"_s, &WebPreferences::interruptAudioOnPageVisibilityChangeEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "InterruptVideoOnPageVisibilityChangeEnabled"_s, &WebPreferences::interruptVideoOnPageVisibilityChangeEnabled },
#endif
        { "InvisibleAutoplayNotPermitted"_s, &WebPreferences::invisibleAutoplayNotPermitted },
        { "JavaScriptCanAccessClipboard"_s, &WebPreferences::javaScriptCanAccessClipboard },
        { "JavaScriptCanOpenWindowsAutomatically"_s, &WebPreferences::javaScriptCanOpenWindowsAutomatically },
        { "JavaScriptMarkupEnabled"_s, &WebPreferences::javaScriptMarkupEnabled },
        { "LargeImageAsyncDecodingEnabled"_s, &WebPreferences::largeImageAsyncDecodingEnabled },
        { "LinkPreconnect"_s, &WebPreferences::linkPreconnect },
        { "LinkPreloadEnabled"_s, &WebPreferences::linkPreloadEnabled },
        { "LoadDeferringEnabled"_s, &WebPreferences::loadDeferringEnabled },
        { "LoadsImagesAutomatically"_s, &WebPreferences::loadsImagesAutomatically },
        { "LowPowerVideoAudioBufferSizeEnabled"_s, &WebPreferences::lowPowerVideoAudioBufferSizeEnabled },
#if ENABLE(MATHML)
        { "MathMLEnabled"_s, &WebPreferences::mathMLEnabled },
#endif
        { "MediaCapabilitiesEnabled"_s, &WebPreferences::mediaCapabilitiesEnabled },
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS)
        { "MediaControlsContextMenusEnabled"_s, &WebPreferences::mediaControlsContextMenusEnabled },
#endif
        { "MediaControlsScaleWithPageZoom"_s, &WebPreferences::mediaControlsScaleWithPageZoom },
        { "MediaDataLoadsAutomatically"_s, &WebPreferences::mediaDataLoadsAutomatically },
#if ENABLE(VIDEO)
        { "MediaEnabled"_s, &WebPreferences::mediaEnabled },
#endif
        { "MediaPreloadingEnabled"_s, &WebPreferences::mediaPreloadingEnabled },
#if ENABLE(MEDIA_STREAM)
        { "MediaStreamEnabled"_s, &WebPreferences::mediaStreamEnabled },
#endif
        { "MediaUserGestureInheritsFromDocument"_s, &WebPreferences::mediaUserGestureInheritsFromDocument },
        { "MockCaptureDevicesPromptEnabled"_s, &WebPreferences::mockCaptureDevicesPromptEnabled },
        { "MockScrollbarsControllerEnabled"_s, &WebPreferences::mockScrollbarsControllerEnabled },
        { "MockScrollbarsEnabled"_s, &WebPreferences::mockScrollbarsEnabled },
        { "NeedsAdobeFrameReloadingQuirk"_s, &WebPreferences::needsAdobeFrameReloadingQuirk },
        { "NeedsFrameNameFallbackToIdQuirk"_s, &WebPreferences::needsFrameNameFallbackToIdQuirk },
        { "NeedsKeyboardEventDisambiguationQuirks"_s, &WebPreferences::needsKeyboardEventDisambiguationQuirks },
#if PLATFORM(COCOA)
        { "PDFPluginEnabled"_s, &WebPreferences::pdfPluginEnabled },
#endif
#if PLATFORM(COCOA)
        { "PDFPluginHUDEnabled"_s, &WebPreferences::pdfPluginHUDEnabled },
#endif
        { "PassiveTouchListenersAsDefaultOnDocument"_s, &WebPreferences::passiveTouchListenersAsDefaultOnDocument },
        { "PasswordEchoEnabled"_s, &WebPreferences::passwordEchoEnabled },
#if ENABLE(PICTURE_IN_PICTURE_API)
        { "PictureInPictureAPIEnabled"_s, &WebPreferences::pictureInPictureAPIEnabled },
#endif
        { "PunchOutWhiteBackgroundsInDarkMode"_s, &WebPreferences::punchOutWhiteBackgroundsInDarkMode },
        { "RequiresPageVisibilityToPlayAudio"_s, &WebPreferences::requiresPageVisibilityToPlayAudio },
        { "RequiresUserGestureForAudioPlayback"_s, &WebPreferences::requiresUserGestureForAudioPlayback },
        { "RequiresUserGestureForMediaPlayback"_s, &WebPreferences::requiresUserGestureForMediaPlayback },
        { "RequiresUserGestureForVideoPlayback"_s, &WebPreferences::requiresUserGestureForVideoPlayback },
        { "RequiresUserGestureToLoadVideo"_s, &WebPreferences::requiresUserGestureToLoadVideo },
#if HAVE(RUBBER_BANDING)
        { "RubberBandingForSubScrollableRegionsEnabled"_s, &WebPreferences::rubberBandingForSubScrollableRegionsEnabled },
#endif
        { "SelectTrailingWhitespaceEnabled"_s, &WebPreferences::selectTrailingWhitespaceEnabled },
#if ENABLE(SERVICE_CONTROLS)
        { "ServiceControlsEnabled"_s, &WebPreferences::serviceControlsEnabled },
#endif
        { "ServiceWorkerEntitlementDisabledForTesting"_s, &WebPreferences::serviceWorkerEntitlementDisabledForTesting },
        { "ShouldAllowUserInstalledFonts"_s, &WebPreferences::shouldAllowUserInstalledFonts },
        { "ShouldConvertInvalidURLsToBlank"_s, &WebPreferences::shouldConvertInvalidURLsToBlank },
        { "ShouldConvertPositionStyleOnCopy"_s, &WebPreferences::shouldConvertPositionStyleOnCopy },
        { "ShouldDecidePolicyBeforeLoadingQuickLookPreview"_s, &WebPreferences::shouldDecidePolicyBeforeLoadingQuickLookPreview },
#if ENABLE(VIDEO)
        { "ShouldDisplayCaptions"_s, &WebPreferences::shouldDisplayCaptions },
#endif
#if ENABLE(VIDEO)
        { "ShouldDisplaySubtitles"_s, &WebPreferences::shouldDisplaySubtitles },
#endif
#if ENABLE(VIDEO)
        { "ShouldDisplayTextDescriptions"_s, &WebPreferences::shouldDisplayTextDescriptions },
#endif
#if ENABLE(TEXT_AUTOSIZING)
        { "ShouldEnableTextAutosizingBoost"_s, &WebPreferences::shouldEnableTextAutosizingBoost },
#endif
        { "ShouldIgnoreMetaViewport"_s, &WebPreferences::shouldIgnoreMetaViewport },
        { "ShouldPrintBackgrounds"_s, &WebPreferences::shouldPrintBackgrounds },
        { "ShouldRespectImageOrientation"_s, &WebPreferences::shouldRespectImageOrientation },
        { "ShouldRestrictBaseURLSchemes"_s, &WebPreferences::shouldRestrictBaseURLSchemes },
        { "ShouldSuppressTextInputFromEditingDuringProvisionalNavigation"_s, &WebPreferences::shouldSuppressTextInputFromEditingDuringProvisionalNavigation },
        { "ShouldUseServiceWorkerShortTimeout"_s, &WebPreferences::shouldUseServiceWorkerShortTimeout },
        { "ShowsToolTipOverTruncatedText"_s, &WebPreferences::showsToolTipOverTruncatedText },
        { "ShowsURLsInToolTipsEnabled"_s, &WebPreferences::showsURLsInToolTipsEnabled },
        { "ShrinksStandaloneImagesToFit"_s, &WebPreferences::shrinksStandaloneImagesToFit },
        { "SmartInsertDeleteEnabled"_s, &WebPreferences::smartInsertDeleteEnabled },
#if ENABLE(MEDIA_SOURCE)
        { "SourceBufferChangeTypeEnabled"_s, &WebPreferences::sourceBufferChangeTypeEnabled },
#endif
        { "SpatialNavigationEnabled"_s, &WebPreferences::spatialNavigationEnabled },
        { "Standalone"_s, &WebPreferences::standalone },
        { "SuppressesIncrementalRendering"_s, &WebPreferences::suppressesIncrementalRendering },
#if USE(SYSTEM_PREVIEW)
        { "SystemPreviewEnabled"_s, &WebPreferences::systemPreviewEnabled },
#endif
        { "TabsToLinks"_s, &WebPreferences::tabsToLinks },
        { "TelephoneNumberParsingEnabled"_s, &WebPreferences::telephoneNumberParsingEnabled },
        { "TemporaryTileCohortRetentionEnabled"_s, &WebPreferences::temporaryTileCohortRetentionEnabled },
        { "TextAreasAreResizable"_s, &WebPreferences::textAreasAreResizable },
#if ENABLE(TEXT_AUTOSIZING)
        { "TextAutosizingEnabled"_s, &WebPreferences::textAutosizingEnabled },
#endif
        { "TextExtractionEnabled"_s, &WebPreferences::textExtractionEnabled },
        { "TextInteractionEnabled"_s, &WebPreferences::textInteractionEnabled },
        { "ThreadedScrollingEnabled"_s, &WebPreferences::threadedScrollingEnabled },
        { "TreatsAnyTextCSSLinkAsStylesheet"_s, &WebPreferences::treatsAnyTextCSSLinkAsStylesheet },
        { "UseImageDocumentForSubframePDF"_s, &WebPreferences::useImageDocumentForSubframePDF },
        { "UsePreHTML5ParserQuirks"_s, &WebPreferences::usePreHTML5ParserQuirks },
        { "UsesBackForwardCache"_s, &WebPreferences::usesBackForwardCache },
        { "UsesEncodingDetector"_s, &WebPreferences::usesEncodingDetector },
        { "UsesSingleWebProcess"_s, &WebPreferences::usesSingleWebProcess },
#if ENABLE(VP9)
        { "VP8DecoderEnabled"_s, &WebPreferences::vp8DecoderEnabled },
#endif
#if ENABLE(VP9)
        { "VP9DecoderEnabled"_s, &WebPreferences::vp9DecoderEnabled },
#endif
#if PLATFORM(IOS_FAMILY)
        { "VideoFullscreenRequiresElementFullscreen"_s, &WebPreferences::videoFullscreenRequiresElementFullscreen },
#endif
        { "VideoPresentationModeAPIEnabled"_s, &WebPreferences::videoPresentationModeAPIEnabled },
#if ENABLE(VIDEO)
        { "VideoQualityIncludesDisplayCompositingEnabled"_s, &WebPreferences::videoQualityIncludesDisplayCompositingEnabled },
#endif
        { "VisualViewportEnabled"_s, &WebPreferences::visualViewportEnabled },
        { "WantsBalancedSetDefersLoadingBehavior"_s, &WebPreferences::wantsBalancedSetDefersLoadingBehavior },
#if ENABLE(WEB_AUDIO)
        { "WebAudioEnabled"_s, &WebPreferences::webAudioEnabled },
#endif
#if ENABLE(WEBM_FORMAT_READER)
        { "WebMFormatReaderEnabled"_s, &WebPreferences::webMFormatReaderEnabled },
#endif
#if ENABLE(MEDIA_SOURCE)
        { "WebMParserEnabled"_s, &WebPreferences::webMParserEnabled },
#endif
        { "WebSecurityEnabled"_s, &WebPreferences::webSecurityEnabled },
        { "WebSocketEnabled"_s, &WebPreferences::webSocketEnabled },
        { "WindowFocusRestricted"_s, &WebPreferences::windowFocusRestricted },
        { "WirelessPlaybackTargetAPIEnabled"_s, &WebPreferences::wirelessPlaybackTargetAPIEnabled },
        { "GrammarAndSpellingPseudoElementsEnabled"_s, &WebPreferences::grammarAndSpellingPseudoElementsEnabled },
        { "TargetTextPseudoElementEnabled"_s, &WebPreferences::targetTextPseudoElementEnabled },
        { "ThumbAndTrackPseudoElementsEnabled"_s, &WebPreferences::thumbAndTrackPseudoElementsEnabled },
        { "SelectShowPickerEnabled"_s, &WebPreferences::selectShowPickerEnabled },
        { "PageAtRuleMarginDescriptorsEnabled"_s, &WebPreferences::pageAtRuleMarginDescriptorsEnabled },
#if USE(AVFOUNDATION)
        { "AVFoundationEnabled"_s, &WebPreferences::isAVFoundationEnabled },
#endif
        { "AbortSignalAnyOperationEnabled"_s, &WebPreferences::abortSignalAnyOperationEnabled },
#if USE(CORE_IMAGE)
        { "AcceleratedFiltersEnabled"_s, &WebPreferences::acceleratedFiltersEnabled },
#endif
        { "AccessHandleEnabled"_s, &WebPreferences::accessHandleEnabled },
        { "DOMTestingAPIsEnabled"_s, &WebPreferences::domTestingAPIsEnabled },
        { "AllowMediaContentTypesRequiringHardwareSupportAsFallback"_s, &WebPreferences::allowMediaContentTypesRequiringHardwareSupportAsFallback },
        { "AllowPrivacySensitiveOperationsInNonPersistentDataStores"_s, &WebPreferences::allowPrivacySensitiveOperationsInNonPersistentDataStores },
#if PLATFORM(IOS_FAMILY)
        { "AllowViewportShrinkToFitContent"_s, &WebPreferences::allowViewportShrinkToFitContent },
#endif
#if ENABLE(WEBGL)
        { "AllowWebGLInWorkers"_s, &WebPreferences::allowWebGLInWorkers },
#endif
#if ENABLE(MEDIA_STREAM)
        { "PerElementSpeakerSelectionEnabled"_s, &WebPreferences::perElementSpeakerSelectionEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "ExposeSpeakersEnabled"_s, &WebPreferences::exposeSpeakersEnabled },
#endif
        { "AllowTopNavigationToDataURLs"_s, &WebPreferences::allowTopNavigationToDataURLs },
        { "AllowUniversalAccessFromFileURLs"_s, &WebPreferences::allowUniversalAccessFromFileURLs },
#if ENABLE(ALTERNATE_WEBM_PLAYER) && ENABLE(MEDIA_SOURCE)
        { "AlternateWebMPlayerEnabled"_s, &WebPreferences::alternateWebMPlayerEnabled },
#endif
#if ENABLE(WEB_ARCHIVE)
        { "AlwaysAllowLocalWebarchive"_s, &WebPreferences::alwaysAllowLocalWebarchive },
#endif
#if ENABLE(VP9)
        { "SWVPDecodersAlwaysEnabled"_s, &WebPreferences::sWVPDecodersAlwaysEnabled },
#endif
        { "AppBadgeEnabled"_s, &WebPreferences::appBadgeEnabled },
#if ENABLE(APP_HIGHLIGHTS)
        { "AppHighlightsEnabled"_s, &WebPreferences::appHighlightsEnabled },
#endif
        { "AsyncFrameScrollingEnabled"_s, &WebPreferences::asyncFrameScrollingEnabled },
        { "AsyncOverflowScrollingEnabled"_s, &WebPreferences::asyncOverflowScrollingEnabled },
#if PLATFORM(IOS_FAMILY)
        { "UseAsyncUIKitInteractions"_s, &WebPreferences::useAsyncUIKitInteractions },
#endif
        { "AsyncClipboardAPIEnabled"_s, &WebPreferences::asyncClipboardAPIEnabled },
#if ENABLE(ATTACHMENT_ELEMENT)
        { "AttachmentElementEnabled"_s, &WebPreferences::attachmentElementEnabled },
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
        { "AttachmentWideLayoutEnabled"_s, &WebPreferences::attachmentWideLayoutEnabled },
#endif
#if ENABLE(VIDEO)
        { "ExtendedAudioDescriptionsEnabled"_s, &WebPreferences::extendedAudioDescriptionsEnabled },
#endif
#if ENABLE(VIDEO)
        { "AudioDescriptionsEnabled"_s, &WebPreferences::audioDescriptionsEnabled },
#endif
#if ENABLE(DOM_AUDIO_SESSION)
        { "DOMAudioSessionEnabled"_s, &WebPreferences::domAudioSessionEnabled },
#endif
#if ENABLE(DOM_AUDIO_SESSION)
        { "DOMAudioSessionFullEnabled"_s, &WebPreferences::domAudioSessionFullEnabled },
#endif
        { "AutomaticallyAdjustsViewScaleUsingMinimumEffectiveDeviceWidth"_s, &WebPreferences::automaticallyAdjustsViewScaleUsingMinimumEffectiveDeviceWidth },
        { "BeaconAPIEnabled"_s, &WebPreferences::beaconAPIEnabled },
        { "BroadcastChannelEnabled"_s, &WebPreferences::broadcastChannelEnabled },
        { "BroadcastChannelOriginPartitioningEnabled"_s, &WebPreferences::broadcastChannelOriginPartitioningEnabled },
#if ENABLE(WEB_PUSH_NOTIFICATIONS)
        { "BuiltInNotificationsEnabled"_s, &WebPreferences::builtInNotificationsEnabled },
#endif
        { "CSS3DTransformBackfaceVisibilityInteroperabilityEnabled"_s, &WebPreferences::css3DTransformBackfaceVisibilityInteroperabilityEnabled },
        { "CSSCounterStyleAtRuleImageSymbolsEnabled"_s, &WebPreferences::cssCounterStyleAtRuleImageSymbolsEnabled },
        { "CSSCounterStyleAtRulesEnabled"_s, &WebPreferences::cssCounterStyleAtRulesEnabled },
        { "CSSFontFaceSizeAdjustEnabled"_s, &WebPreferences::cssFontFaceSizeAdjustEnabled },
        { "CSSStartingStyleAtRuleEnabled"_s, &WebPreferences::cssStartingStyleAtRuleEnabled },
        { "AccentColorEnabled"_s, &WebPreferences::accentColorEnabled },
        { "CSSAnchorPositioningEnabled"_s, &WebPreferences::cssAnchorPositioningEnabled },
        { "CSSContentVisibilityEnabled"_s, &WebPreferences::cssContentVisibilityEnabled },
        { "CSSInputSecurityEnabled"_s, &WebPreferences::cssInputSecurityEnabled },
        { "MasonryEnabled"_s, &WebPreferences::masonryEnabled },
        { "CSSMotionPathEnabled"_s, &WebPreferences::cssMotionPathEnabled },
        { "CSSNestingEnabled"_s, &WebPreferences::cssNestingEnabled },
        { "OverscrollBehaviorEnabled"_s, &WebPreferences::overscrollBehaviorEnabled },
        { "CSSPaintingAPIEnabled"_s, &WebPreferences::cssPaintingAPIEnabled },
        { "CSSRhythmicSizingEnabled"_s, &WebPreferences::cssRhythmicSizingEnabled },
        { "CSSScopeAtRuleEnabled"_s, &WebPreferences::cssScopeAtRuleEnabled },
        { "CSSScrollAnchoringEnabled"_s, &WebPreferences::cssScrollAnchoringEnabled },
        { "SpringTimingFunctionEnabled"_s, &WebPreferences::springTimingFunctionEnabled },
        { "CSSTypedOMColorEnabled"_s, &WebPreferences::cssTypedOMColorEnabled },
        { "CSSUnprefixedBackdropFilterEnabled"_s, &WebPreferences::cssUnprefixedBackdropFilterEnabled },
        { "CSSBackgroundClipBorderAreaEnabled"_s, &WebPreferences::cssBackgroundClipBorderAreaEnabled },
        { "CSSColorContrastEnabled"_s, &WebPreferences::cssColorContrastEnabled },
        { "CSSColorLayersEnabled"_s, &WebPreferences::cssColorLayersEnabled },
        { "CSSDPropertyEnabled"_s, &WebPreferences::cssDPropertyEnabled },
        { "CSSFieldSizingEnabled"_s, &WebPreferences::cssFieldSizingEnabled },
        { "CSSFontVariantEmojiEnabled"_s, &WebPreferences::cssFontVariantEmojiEnabled },
        { "CSSLightDarkEnabled"_s, &WebPreferences::cssLightDarkEnabled },
        { "CSSMarginTrimEnabled"_s, &WebPreferences::cssMarginTrimEnabled },
        { "CSSRubyAlignEnabled"_s, &WebPreferences::cssRubyAlignEnabled },
        { "CSSScrollbarColorEnabled"_s, &WebPreferences::cssScrollbarColorEnabled },
        { "CSSScrollbarGutterEnabled"_s, &WebPreferences::cssScrollbarGutterEnabled },
        { "CSSScrollbarWidthEnabled"_s, &WebPreferences::cssScrollbarWidthEnabled },
        { "CSSShapeFunctionEnabled"_s, &WebPreferences::cssShapeFunctionEnabled },
        { "CSSStyleQueriesEnabled"_s, &WebPreferences::cssStyleQueriesEnabled },
        { "CSSTextAutospaceEnabled"_s, &WebPreferences::cssTextAutospaceEnabled },
        { "CSSTextBoxTrimEnabled"_s, &WebPreferences::cssTextBoxTrimEnabled },
        { "CSSTextGroupAlignEnabled"_s, &WebPreferences::cssTextGroupAlignEnabled },
        { "CSSTextJustifyEnabled"_s, &WebPreferences::cssTextJustifyEnabled },
        { "CSSTextSpacingEnabled"_s, &WebPreferences::cssTextSpacingEnabled },
        { "CSSTextUnderlinePositionLeftRightEnabled"_s, &WebPreferences::cssTextUnderlinePositionLeftRightEnabled },
        { "CSSTextWrapStyleEnabled"_s, &WebPreferences::cssTextWrapStyleEnabled },
        { "CSSTextWrapPrettyEnabled"_s, &WebPreferences::cssTextWrapPrettyEnabled },
#if ENABLE(CSS_TRANSFORM_STYLE_OPTIMIZED_3D)
        { "CSSTransformStyleOptimized3DEnabled"_s, &WebPreferences::cssTransformStyleOptimized3DEnabled },
#endif
        { "CSSOMViewScrollingAPIEnabled"_s, &WebPreferences::cssOMViewScrollingAPIEnabled },
        { "CSSOMViewSmoothScrollingEnabled"_s, &WebPreferences::cssOMViewSmoothScrollingEnabled },
        { "CacheAPIEnabled"_s, &WebPreferences::cacheAPIEnabled },
        { "CanvasColorSpaceEnabled"_s, &WebPreferences::canvasColorSpaceEnabled },
        { "CanvasFiltersEnabled"_s, &WebPreferences::canvasFiltersEnabled },
        { "CanvasLayersEnabled"_s, &WebPreferences::canvasLayersEnabled },
#if USE(CA) || USE(SKIA)
        { "CanvasUsesAcceleratedDrawing"_s, &WebPreferences::canvasUsesAcceleratedDrawing },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureAudioInUIProcessEnabled"_s, &WebPreferences::captureAudioInUIProcessEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureVideoInUIProcessEnabled"_s, &WebPreferences::captureVideoInUIProcessEnabled },
#endif
        { "ChildProcessDebuggabilityEnabled"_s, &WebPreferences::childProcessDebuggabilityEnabled },
        { "ClearSiteDataHTTPHeaderEnabled"_s, &WebPreferences::clearSiteDataHTTPHeaderEnabled },
        { "ClientBadgeEnabled"_s, &WebPreferences::clientBadgeEnabled },
#if ENABLE(INPUT_TYPE_COLOR)
        { "InputTypeColorEnabled"_s, &WebPreferences::inputTypeColorEnabled },
#endif
        { "CompositingBordersVisible"_s, &WebPreferences::compositingBordersVisible },
        { "CompositingRepaintCountersVisible"_s, &WebPreferences::compositingRepaintCountersVisible },
        { "CompressionStreamEnabled"_s, &WebPreferences::compressionStreamEnabled },
        { "ContactPickerAPIEnabled"_s, &WebPreferences::contactPickerAPIEnabled },
#if HAVE(AVCONTENTKEYSPECIFIER)
        { "SampleBufferContentKeySessionSupportEnabled"_s, &WebPreferences::sampleBufferContentKeySessionSupportEnabled },
#endif
        { "CookieConsentAPIEnabled"_s, &WebPreferences::cookieConsentAPIEnabled },
        { "CookieStoreManagerEnabled"_s, &WebPreferences::cookieStoreManagerEnabled },
        { "CookieStoreAPIExtendedAttributesEnabled"_s, &WebPreferences::cookieStoreAPIExtendedAttributesEnabled },
        { "CookieStoreAPIEnabled"_s, &WebPreferences::cookieStoreAPIEnabled },
        { "CookieEnabled"_s, &WebPreferences::cookieEnabled },
        { "CrossDocumentViewTransitionsEnabled"_s, &WebPreferences::crossDocumentViewTransitionsEnabled },
        { "CrossOriginEmbedderPolicyEnabled"_s, &WebPreferences::crossOriginEmbedderPolicyEnabled },
        { "CrossOriginOpenerPolicyEnabled"_s, &WebPreferences::crossOriginOpenerPolicyEnabled },
        { "CustomPasteboardDataEnabled"_s, &WebPreferences::customPasteboardDataEnabled },
        { "CustomStateSetEnabled"_s, &WebPreferences::customStateSetEnabled },
        { "DOMPasteAccessRequestsEnabled"_s, &WebPreferences::domPasteAccessRequestsEnabled },
        { "DOMTimersThrottlingEnabled"_s, &WebPreferences::domTimersThrottlingEnabled },
#if PLATFORM(IOS_FAMILY)
        { "ZoomOnDoubleTapWhenRoot"_s, &WebPreferences::zoomOnDoubleTapWhenRoot },
#endif
#if PLATFORM(IOS_FAMILY)
        { "AlwaysZoomOnDoubleTap"_s, &WebPreferences::alwaysZoomOnDoubleTap },
#endif
        { "DataTransferItemsEnabled"_s, &WebPreferences::dataTransferItemsEnabled },
#if ENABLE(DATALIST_ELEMENT)
        { "DataListElementEnabled"_s, &WebPreferences::dataListElementEnabled },
#endif
#if ENABLE(INPUT_TYPE_DATE)
        { "InputTypeDateEnabled"_s, &WebPreferences::inputTypeDateEnabled },
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
        { "DateTimeInputsEditableComponentsEnabled"_s, &WebPreferences::dateTimeInputsEditableComponentsEnabled },
#endif
        { "DeclarativeShadowRootsParserAPIsEnabled"_s, &WebPreferences::declarativeShadowRootsParserAPIsEnabled },
        { "DeclarativeShadowRootsSerializerAPIsEnabled"_s, &WebPreferences::declarativeShadowRootsSerializerAPIsEnabled },
#if ENABLE(DECLARATIVE_WEB_PUSH)
        { "DeclarativeWebPush"_s, &WebPreferences::declarativeWebPush },
#endif
        { "ShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint"_s, &WebPreferences::shouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint },
        { "DeprecateAESCFBWebCryptoEnabled"_s, &WebPreferences::deprecateAESCFBWebCryptoEnabled },
        { "DeprecateRSAESPKCSWebCryptoEnabled"_s, &WebPreferences::deprecateRSAESPKCSWebCryptoEnabled },
        { "DeprecationReportingEnabled"_s, &WebPreferences::deprecationReportingEnabled },
        { "UAVisualTransitionDetectionEnabled"_s, &WebPreferences::uAVisualTransitionDetectionEnabled },
        { "DiagnosticLoggingEnabled"_s, &WebPreferences::diagnosticLoggingEnabled },
        { "DigitalCredentialsEnabled"_s, &WebPreferences::digitalCredentialsEnabled },
        { "DirectoryUploadEnabled"_s, &WebPreferences::directoryUploadEnabled },
        { "IsThirdPartyCookieBlockingDisabled"_s, &WebPreferences::isThirdPartyCookieBlockingDisabled },
        { "IsFirstPartyWebsiteDataRemovalDisabled"_s, &WebPreferences::isFirstPartyWebsiteDataRemovalDisabled },
#if PLATFORM(IOS_FAMILY)
        { "DisableScreenSizeOverride"_s, &WebPreferences::disableScreenSizeOverride },
#endif
        { "DisallowSyncXHRDuringPageDismissalEnabled"_s, &WebPreferences::disallowSyncXHRDuringPageDismissalEnabled },
        { "ShouldDropNearSuspendedAssertionAfterDelay"_s, &WebPreferences::shouldDropNearSuspendedAssertionAfterDelay },
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
        { "UseCGDisplayListsForDOMRendering"_s, &WebPreferences::useCGDisplayListsForDOMRendering },
#endif
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
        { "ReplayCGDisplayListsIntoBackingStore"_s, &WebPreferences::replayCGDisplayListsIntoBackingStore },
#endif
        { "EmbedElementEnabled"_s, &WebPreferences::embedElementEnabled },
#if PLATFORM(IOS_FAMILY)
        { "AutomaticLiveResizeEnabled"_s, &WebPreferences::automaticLiveResizeEnabled },
#endif
        { "CanvasFingerprintingQuirkEnabled"_s, &WebPreferences::canvasFingerprintingQuirkEnabled },
        { "CryptoKitEnabled"_s, &WebPreferences::cryptoKitEnabled },
        { "EnumeratingAllNetworkInterfacesEnabled"_s, &WebPreferences::enumeratingAllNetworkInterfacesEnabled },
        { "EnumeratingVisibleNetworkInterfacesEnabled"_s, &WebPreferences::enumeratingVisibleNetworkInterfacesEnabled },
        { "ICECandidateFilteringEnabled"_s, &WebPreferences::iceCandidateFilteringEnabled },
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
        { "LegacyEncryptedMediaAPIEnabled"_s, &WebPreferences::legacyEncryptedMediaAPIEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "MockCaptureDevicesEnabled"_s, &WebPreferences::mockCaptureDevicesEnabled },
#endif
#if ENABLE(MODEL_PROCESS)
        { "ModelProcessEnabled"_s, &WebPreferences::modelProcessEnabled },
#endif
#if ENABLE(PDFJS)
        { "PDFJSViewerEnabled"_s, &WebPreferences::pdfJSViewerEnabled },
#endif
        { "AuxclickEventEnabled"_s, &WebPreferences::auxclickEventEnabled },
#if PLATFORM(MAC) && USE(RUNNINGBOARD)
        { "BackgroundWebContentRunningBoardThrottlingEnabled"_s, &WebPreferences::backgroundWebContentRunningBoardThrottlingEnabled },
#endif
        { "BackgroundFetchAPIEnabled"_s, &WebPreferences::backgroundFetchAPIEnabled },
#if HAVE(NETWORK_LOADER)
        { "CFNetworkNetworkLoaderEnabled"_s, &WebPreferences::cFNetworkNetworkLoaderEnabled },
#endif
#if HAVE(MACH_BOOTSTRAP_EXTENSION) || HAVE(SANDBOX_STATE_FLAGS)
        { "ExperimentalSandboxEnabled"_s, &WebPreferences::experimentalSandboxEnabled },
#endif
        { "BlobFileAccessEnforcementEnabled"_s, &WebPreferences::blobFileAccessEnforcementEnabled },
        { "EnterKeyHintEnabled"_s, &WebPreferences::enterKeyHintEnabled },
        { "EventHandlerDrivenSmoothKeyboardScrollingEnabled"_s, &WebPreferences::eventHandlerDrivenSmoothKeyboardScrollingEnabled },
#if ENABLE(MEDIA_SESSION_COORDINATOR)
        { "MediaSessionCoordinatorEnabled"_s, &WebPreferences::mediaSessionCoordinatorEnabled },
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR) && ENABLE(MEDIA_SESSION_PLAYLIST)
        { "MediaSessionPlaylistEnabled"_s, &WebPreferences::mediaSessionPlaylistEnabled },
#endif
#if ENABLE(MEDIA_SOURCE) && (HAVE(AVSAMPLEBUFFERVIDEOOUTPUT) || USE(GSTREAMER))
        { "MediaSourceInlinePaintingEnabled"_s, &WebPreferences::mediaSourceInlinePaintingEnabled },
#endif
        { "FTPEnabled"_s, &WebPreferences::ftpEnabled },
#if PLATFORM(IOS_FAMILY)
        { "PreferFasterClickOverDoubleTap"_s, &WebPreferences::preferFasterClickOverDoubleTap },
#endif
#if PLATFORM(IOS_FAMILY)
        { "FasterClicksEnabled"_s, &WebPreferences::fasterClicksEnabled },
#endif
        { "FetchPriorityEnabled"_s, &WebPreferences::fetchPriorityEnabled },
        { "FileSystemAccessEnabled"_s, &WebPreferences::fileSystemAccessEnabled },
        { "FileReaderAPIEnabled"_s, &WebPreferences::fileReaderAPIEnabled },
        { "RestrictedHTTPResponseAccess"_s, &WebPreferences::restrictedHTTPResponseAccess },
        { "FilterLinkDecorationByDefaultEnabled"_s, &WebPreferences::filterLinkDecorationByDefaultEnabled },
#if PLATFORM(IOS_FAMILY)
        { "ForceAlwaysUserScalable"_s, &WebPreferences::forceAlwaysUserScalable },
#endif
#if ENABLE(FULLSCREEN_API)
        { "FullScreenKeyboardLock"_s, &WebPreferences::fullScreenKeyboardLock },
#endif
#if ENABLE(FULLSCREEN_API)
        { "FullScreenEnabled"_s, &WebPreferences::fullScreenEnabled },
#endif
#if PLATFORM(VISION)
        { "FullscreenSceneAspectRatioLockingEnabled"_s, &WebPreferences::fullscreenSceneAspectRatioLockingEnabled },
#endif
#if PLATFORM(VISION)
        { "FullscreenSceneDimmingEnabled"_s, &WebPreferences::fullscreenSceneDimmingEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureAudioInGPUProcessEnabled"_s, &WebPreferences::captureAudioInGPUProcessEnabled },
#endif
#if ENABLE(GPU_PROCESS)
        { "BlockMediaLayerRehostingInWebContentProcess"_s, &WebPreferences::blockMediaLayerRehostingInWebContentProcess },
#endif
#if ENABLE(GPU_PROCESS) && !(PLATFORM(GTK) || PLATFORM(WPE))
        { "UseGPUProcessForCanvasRenderingEnabled"_s, &WebPreferences::useGPUProcessForCanvasRenderingEnabled },
#endif
#if ENABLE(MEDIA_STREAM) && PLATFORM(IOS_FAMILY)
        { "ManageCaptureStatusBarInGPUProcessEnabled"_s, &WebPreferences::manageCaptureStatusBarInGPUProcessEnabled },
#endif
#if ENABLE(GPU_PROCESS)
        { "UseGPUProcessForDOMRenderingEnabled"_s, &WebPreferences::useGPUProcessForDOMRenderingEnabled },
#endif
#if ENABLE(GPU_PROCESS) && !USE(GSTREAMER)
        { "UseGPUProcessForMediaEnabled"_s, &WebPreferences::useGPUProcessForMediaEnabled },
#endif
#if HAVE(SCREEN_CAPTURE_KIT)
        { "UseGPUProcessForDisplayCapture"_s, &WebPreferences::useGPUProcessForDisplayCapture },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureVideoInGPUProcessEnabled"_s, &WebPreferences::captureVideoInGPUProcessEnabled },
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "UseGPUProcessForWebGLEnabled"_s, &WebPreferences::useGPUProcessForWebGLEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCPlatformCodecsInGPUProcessEnabled"_s, &WebPreferences::webRTCPlatformCodecsInGPUProcessEnabled },
#endif
#if ENABLE(GAMEPAD)
        { "GamepadTriggerRumbleEnabled"_s, &WebPreferences::gamepadTriggerRumbleEnabled },
#endif
#if ENABLE(GAMEPAD)
        { "GamepadVibrationActuatorEnabled"_s, &WebPreferences::gamepadVibrationActuatorEnabled },
#endif
#if ENABLE(GAMEPAD)
        { "GamepadsEnabled"_s, &WebPreferences::gamepadsEnabled },
#endif
#if ENABLE(VIDEO)
        { "GenericCueAPIEnabled"_s, &WebPreferences::genericCueAPIEnabled },
#endif
#if USE(GRAPHICS_CONTEXT_FILTERS)
        { "GraphicsContextFiltersEnabled"_s, &WebPreferences::graphicsContextFiltersEnabled },
#endif
        { "AcceleratedDrawingEnabled"_s, &WebPreferences::acceleratedDrawingEnabled },
        { "DetailsNameAttributeEnabled"_s, &WebPreferences::detailsNameAttributeEnabled },
#if ENABLE(MODEL_ELEMENT)
        { "ModelElementEnabled"_s, &WebPreferences::modelElementEnabled },
#endif
#if ENABLE(MODEL_ELEMENT)
        { "ModelDocumentEnabled"_s, &WebPreferences::modelDocumentEnabled },
#endif
        { "InteractiveFormValidationEnabled"_s, &WebPreferences::interactiveFormValidationEnabled },
        { "InvokerAttributesEnabled"_s, &WebPreferences::invokerAttributesEnabled },
        { "PopoverAttributeEnabled"_s, &WebPreferences::popoverAttributeEnabled },
        { "SwitchControlEnabled"_s, &WebPreferences::switchControlEnabled },
        { "HTTPSByDefaultEnabled"_s, &WebPreferences::httpSByDefaultEnabled },
        { "HiddenPageDOMTimerThrottlingAutoIncreases"_s, &WebPreferences::hiddenPageDOMTimerThrottlingAutoIncreases },
        { "HiddenPageDOMTimerThrottlingEnabled"_s, &WebPreferences::hiddenPageDOMTimerThrottlingEnabled },
        { "HighlightAPIEnabled"_s, &WebPreferences::highlightAPIEnabled },
        { "HyperlinkAuditingEnabled"_s, &WebPreferences::hyperlinkAuditingEnabled },
#if HAVE(SANDBOX_STATE_FLAGS)
        { "BlockIOKitInWebContentSandbox"_s, &WebPreferences::blockIOKitInWebContentSandbox },
#endif
#if ENABLE(IPC_TESTING_API)
        { "IPCTestingAPIEnabled"_s, &WebPreferences::ipcTestingAPIEnabled },
#endif
        { "ItpDebugModeEnabled"_s, &WebPreferences::itpDebugModeEnabled },
#if ENABLE(TEXT_AUTOSIZING)
        { "TextAutosizingUsesIdempotentMode"_s, &WebPreferences::textAutosizingUsesIdempotentMode },
#endif
#if ENABLE(IPC_TESTING_API)
        { "IgnoreInvalidMessageWhenIPCTestingAPIEnabled"_s, &WebPreferences::ignoreInvalidMessageWhenIPCTestingAPIEnabled },
#endif
        { "IgnoreIframeEmbeddingProtectionsEnabled"_s, &WebPreferences::ignoreIframeEmbeddingProtectionsEnabled },
#if ENABLE(IMAGE_ANALYSIS)
        { "ImageAnalysisDuringFindInPageEnabled"_s, &WebPreferences::imageAnalysisDuringFindInPageEnabled },
#endif
#if ENABLE(ACCESSIBILITY_ANIMATION_CONTROL)
        { "ImageAnimationControlEnabled"_s, &WebPreferences::imageAnimationControlEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "ImageCaptureEnabled"_s, &WebPreferences::imageCaptureEnabled },
#endif
#if ENABLE(SERVICE_CONTROLS)
        { "ImageControlsEnabled"_s, &WebPreferences::imageControlsEnabled },
#endif
        { "InWindowFullscreenEnabled"_s, &WebPreferences::inWindowFullscreenEnabled },
        { "IndexedDBAPIEnabled"_s, &WebPreferences::indexedDBAPIEnabled },
#if ENABLE(INTERACTION_REGIONS_IN_EVENT_REGION)
        { "InteractionRegionsEnabled"_s, &WebPreferences::interactionRegionsEnabled },
#endif
#if ENABLE(ACCESSIBILITY_ISOLATED_TREE)
        { "IsAccessibilityIsolatedTreeEnabled"_s, &WebPreferences::isAccessibilityIsolatedTreeEnabled },
#endif
        { "JavaScriptEnabled"_s, &WebPreferences::javaScriptEnabled },
#if PLATFORM(IOS_FAMILY)
        { "KeyboardDismissalGestureEnabled"_s, &WebPreferences::keyboardDismissalGestureEnabled },
#endif
        { "LayerBasedSVGEngineEnabled"_s, &WebPreferences::layerBasedSVGEngineEnabled },
        { "LazyIframeLoadingEnabled"_s, &WebPreferences::lazyIframeLoadingEnabled },
        { "LazyImageLoadingEnabled"_s, &WebPreferences::lazyImageLoadingEnabled },
#if ENABLE(OVERFLOW_SCROLLING_TOUCH)
        { "LegacyOverflowScrollingTouchEnabled"_s, &WebPreferences::legacyOverflowScrollingTouchEnabled },
#endif
        { "LegacyLineLayoutVisualCoverageEnabled"_s, &WebPreferences::legacyLineLayoutVisualCoverageEnabled },
        { "ShowModalDialogEnabled"_s, &WebPreferences::showModalDialogEnabled },
#if ENABLE(MEDIA_STREAM)
        { "MediaCaptureRequiresSecureConnection"_s, &WebPreferences::mediaCaptureRequiresSecureConnection },
#endif
#if ENABLE(LINEAR_MEDIA_PLAYER)
        { "LinearMediaPlayerEnabled"_s, &WebPreferences::linearMediaPlayerEnabled },
#endif
        { "LinkSanitizerEnabled"_s, &WebPreferences::linkSanitizerEnabled },
        { "LinkPreloadResponsiveImagesEnabled"_s, &WebPreferences::linkPreloadResponsiveImagesEnabled },
        { "LinkModulePreloadEnabled"_s, &WebPreferences::linkModulePreloadEnabled },
        { "LinkPreconnectEarlyHintsEnabled"_s, &WebPreferences::linkPreconnectEarlyHintsEnabled },
        { "LinkPrefetchEnabled"_s, &WebPreferences::linkPrefetchEnabled },
        { "LiveRangeSelectionEnabled"_s, &WebPreferences::liveRangeSelectionEnabled },
#if ENABLE(WEB_ARCHIVE)
        { "LoadWebArchiveWithEphemeralStorageEnabled"_s, &WebPreferences::loadWebArchiveWithEphemeralStorageEnabled },
#endif
        { "LocalFileContentSniffingEnabled"_s, &WebPreferences::localFileContentSniffingEnabled },
        { "LocalStorageEnabled"_s, &WebPreferences::localStorageEnabled },
        { "LockdownFontParserEnabled"_s, &WebPreferences::lockdownFontParserEnabled },
        { "LogsPageMessagesToSystemConsoleEnabled"_s, &WebPreferences::logsPageMessagesToSystemConsoleEnabled },
        { "LoginStatusAPIEnabled"_s, &WebPreferences::loginStatusAPIEnabled },
        { "MainContentUserGestureOverrideEnabled"_s, &WebPreferences::mainContentUserGestureOverrideEnabled },
#if ENABLE(MEDIA_SOURCE)
        { "ManagedMediaSourceEnabled"_s, &WebPreferences::managedMediaSourceEnabled },
#endif
#if ENABLE(MEDIA_SOURCE) && ENABLE(WIRELESS_PLAYBACK_TARGET)
        { "ManagedMediaSourceNeedsAirPlay"_s, &WebPreferences::managedMediaSourceNeedsAirPlay },
#endif
        { "CoreMathMLEnabled"_s, &WebPreferences::coreMathMLEnabled },
        { "MediaCapabilitiesExtensionsEnabled"_s, &WebPreferences::mediaCapabilitiesExtensionsEnabled },
#if ENABLE(EXTENSION_CAPABILITIES)
        { "MediaCapabilityGrantsEnabled"_s, &WebPreferences::mediaCapabilityGrantsEnabled },
#endif
#if ENABLE(MEDIA_SESSION)
        { "MediaSessionEnabled"_s, &WebPreferences::mediaSessionEnabled },
#endif
        { "MediaSourceEnabled"_s, &WebPreferences::mediaSourceEnabled },
#if ENABLE(MEDIA_STREAM)
        { "MediaDevicesEnabled"_s, &WebPreferences::mediaDevicesEnabled },
#endif
#if ENABLE(MEDIA_RECORDER)
        { "MediaRecorderEnabled"_s, &WebPreferences::mediaRecorderEnabled },
#endif
        { "MediaSessionCaptureToggleAPIEnabled"_s, &WebPreferences::mediaSessionCaptureToggleAPIEnabled },
#if ENABLE(MEDIA_SOURCE_IN_WORKERS)
        { "MediaSourceInWorkerEnabled"_s, &WebPreferences::mediaSourceInWorkerEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "MediaStreamTrackProcessingEnabled"_s, &WebPreferences::mediaStreamTrackProcessingEnabled },
#endif
        { "MomentumScrollingAnimatorEnabled"_s, &WebPreferences::momentumScrollingAnimatorEnabled },
#if ENABLE(INPUT_TYPE_MONTH)
        { "InputTypeMonthEnabled"_s, &WebPreferences::inputTypeMonthEnabled },
#endif
#if ENABLE(TOUCH_EVENTS)
        { "MouseEventsSimulationEnabled"_s, &WebPreferences::mouseEventsSimulationEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "MuteCameraOnMicrophoneInterruptionEnabled"_s, &WebPreferences::muteCameraOnMicrophoneInterruptionEnabled },
#endif
        { "NavigationAPIEnabled"_s, &WebPreferences::navigationAPIEnabled },
#if ENABLE(APP_BOUND_DOMAINS)
        { "NeedsInAppBrowserPrivacyQuirks"_s, &WebPreferences::needsInAppBrowserPrivacyQuirks },
#endif
        { "NeedsSiteSpecificQuirks"_s, &WebPreferences::needsSiteSpecificQuirks },
        { "NeedsStorageAccessFromFileURLsQuirk"_s, &WebPreferences::needsStorageAccessFromFileURLsQuirk },
        { "FlexFormattingContextIntegrationEnabled"_s, &WebPreferences::flexFormattingContextIntegrationEnabled },
#if ENABLE(NOTIFICATION_EVENT)
        { "NotificationEventEnabled"_s, &WebPreferences::notificationEventEnabled },
#endif
#if ENABLE(NOTIFICATIONS)
        { "NotificationsEnabled"_s, &WebPreferences::notificationsEnabled },
#endif
        { "ObservableEnabled"_s, &WebPreferences::observableEnabled },
        { "AccessibilityThreadTextApisEnabled"_s, &WebPreferences::accessibilityThreadTextApisEnabled },
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
        { "OffscreenCanvasInWorkersEnabled"_s, &WebPreferences::offscreenCanvasInWorkersEnabled },
#endif
#if ENABLE(OFFSCREEN_CANVAS)
        { "OffscreenCanvasEnabled"_s, &WebPreferences::offscreenCanvasEnabled },
#endif
#if ENABLE(OFFSCREEN_CANVAS)
        { "OffscreenCanvasDeprecatedCommitEnabled"_s, &WebPreferences::offscreenCanvasDeprecatedCommitEnabled },
#endif
        { "OpportunisticSweepingAndGarbageCollectionEnabled"_s, &WebPreferences::opportunisticSweepingAndGarbageCollectionEnabled },
#if ENABLE(OPUS)
        { "OpusDecoderEnabled"_s, &WebPreferences::opusDecoderEnabled },
#endif
        { "OverlappingBackingStoreProvidersEnabled"_s, &WebPreferences::overlappingBackingStoreProvidersEnabled },
        { "PageVisibilityBasedProcessSuppressionEnabled"_s, &WebPreferences::pageVisibilityBasedProcessSuppressionEnabled },
        { "BlobRegistryTopOriginPartitioningEnabled"_s, &WebPreferences::blobRegistryTopOriginPartitioningEnabled },
        { "PermissionsAPIEnabled"_s, &WebPreferences::permissionsAPIEnabled },
#if HAVE(PHOTOS_UI)
        { "PhotoPickerPrefersOriginalImageFormat"_s, &WebPreferences::photoPickerPrefersOriginalImageFormat },
#endif
        { "GetCoalescedEventsEnabled"_s, &WebPreferences::getCoalescedEventsEnabled },
        { "GetPredictedEventsEnabled"_s, &WebPreferences::getPredictedEventsEnabled },
#if ENABLE(POINTER_LOCK)
        { "PointerLockOptionsEnabled"_s, &WebPreferences::pointerLockOptionsEnabled },
#endif
        { "PreferPageRenderingUpdatesNear60FPSEnabled"_s, &WebPreferences::preferPageRenderingUpdatesNear60FPSEnabled },
#if ENABLE(VIDEO)
        { "PreferSandboxedMediaParsing"_s, &WebPreferences::preferSandboxedMediaParsing },
#endif
        { "PrivateClickMeasurementDebugModeEnabled"_s, &WebPreferences::privateClickMeasurementDebugModeEnabled },
        { "PrivateClickMeasurementFraudPreventionEnabled"_s, &WebPreferences::privateClickMeasurementFraudPreventionEnabled },
        { "PrivateClickMeasurementEnabled"_s, &WebPreferences::privateClickMeasurementEnabled },
        { "PrivateTokenUsageByThirdPartyEnabled"_s, &WebPreferences::privateTokenUsageByThirdPartyEnabled },
#if USE(COORDINATED_GRAPHICS)
        { "PropagateDamagingInformation"_s, &WebPreferences::propagateDamagingInformation },
#endif
        { "PushAPIEnabled"_s, &WebPreferences::pushAPIEnabled },
        { "LegacyPluginQuirkForMailSignaturesEnabled"_s, &WebPreferences::legacyPluginQuirkForMailSignaturesEnabled },
        { "GoogleAntiFlickerOptimizationQuirkEnabled"_s, &WebPreferences::googleAntiFlickerOptimizationQuirkEnabled },
        { "ReadableByteStreamAPIEnabled"_s, &WebPreferences::readableByteStreamAPIEnabled },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        { "RemotePlaybackEnabled"_s, &WebPreferences::remotePlaybackEnabled },
#endif
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
        { "RemoveBackgroundEnabled"_s, &WebPreferences::removeBackgroundEnabled },
#endif
        { "ReportingEnabled"_s, &WebPreferences::reportingEnabled },
        { "RequestVideoFrameCallbackEnabled"_s, &WebPreferences::requestVideoFrameCallbackEnabled },
#if HAVE(SC_CONTENT_SHARING_PICKER)
        { "RequireUAGetDisplayMediaPrompt"_s, &WebPreferences::requireUAGetDisplayMediaPrompt },
#endif
#if ENABLE(MEDIA_STREAM)
        { "SpeakerSelectionRequiresUserGesture"_s, &WebPreferences::speakerSelectionRequiresUserGesture },
#endif
        { "FullscreenRequirementForScreenOrientationLockingEnabled"_s, &WebPreferences::fullscreenRequirementForScreenOrientationLockingEnabled },
#if ENABLE(MEDIA_STREAM)
        { "GetUserMediaRequiresFocus"_s, &WebPreferences::getUserMediaRequiresFocus },
#endif
        { "ResourceLoadSchedulingEnabled"_s, &WebPreferences::resourceLoadSchedulingEnabled },
#if ENABLE(RESOURCE_USAGE)
        { "ResourceUsageOverlayVisible"_s, &WebPreferences::resourceUsageOverlayVisible },
#endif
        { "SKAttributionEnabled"_s, &WebPreferences::sKAttributionEnabled },
        { "SafeBrowsingEnabled"_s, &WebPreferences::safeBrowsingEnabled },
        { "IsSameSiteStrictEnforcementEnabled"_s, &WebPreferences::isSameSiteStrictEnforcementEnabled },
        { "ScreenOrientationLockingAPIEnabled"_s, &WebPreferences::screenOrientationLockingAPIEnabled },
        { "ScreenOrientationAPIEnabled"_s, &WebPreferences::screenOrientationAPIEnabled },
        { "ScreenWakeLockAPIEnabled"_s, &WebPreferences::screenWakeLockAPIEnabled },
#if ENABLE(MEDIA_STREAM)
        { "ScreenCaptureEnabled"_s, &WebPreferences::screenCaptureEnabled },
#endif
        { "ScrollingPerformanceTestingEnabled"_s, &WebPreferences::scrollingPerformanceTestingEnabled },
        { "ScrollToTextFragmentFeatureDetectionEnabled"_s, &WebPreferences::scrollToTextFragmentFeatureDetectionEnabled },
        { "ScrollToTextFragmentGenerationEnabled"_s, &WebPreferences::scrollToTextFragmentGenerationEnabled },
        { "ScrollToTextFragmentIndicatorEnabled"_s, &WebPreferences::scrollToTextFragmentIndicatorEnabled },
        { "ScrollToTextFragmentMarkingEnabled"_s, &WebPreferences::scrollToTextFragmentMarkingEnabled },
        { "ScrollToTextFragmentEnabled"_s, &WebPreferences::scrollToTextFragmentEnabled },
        { "ScrollAnimatorEnabled"_s, &WebPreferences::scrollAnimatorEnabled },
        { "ScrollDrivenAnimationsEnabled"_s, &WebPreferences::scrollDrivenAnimationsEnabled },
        { "SearchInputIncrementalAttributeAndSearchEventEnabled"_s, &WebPreferences::searchInputIncrementalAttributeAndSearchEventEnabled },
        { "SecureContextChecksEnabled"_s, &WebPreferences::secureContextChecksEnabled },
        { "SelectionAPIForShadowDOMEnabled"_s, &WebPreferences::selectionAPIForShadowDOMEnabled },
        { "SelectionFlippingEnabled"_s, &WebPreferences::selectionFlippingEnabled },
        { "SendMouseEventsToDisabledFormControlsEnabled"_s, &WebPreferences::sendMouseEventsToDisabledFormControlsEnabled },
        { "ServiceWorkerNavigationPreloadEnabled"_s, &WebPreferences::serviceWorkerNavigationPreloadEnabled },
        { "ServiceWorkersEnabled"_s, &WebPreferences::serviceWorkersEnabled },
        { "ShapeDetection"_s, &WebPreferences::shapeDetection },
        { "SharedWorkerEnabled"_s, &WebPreferences::sharedWorkerEnabled },
        { "ShowMediaStatsContextMenuItemEnabled"_s, &WebPreferences::showMediaStatsContextMenuItemEnabled },
        { "SidewaysWritingModesEnabled"_s, &WebPreferences::sidewaysWritingModesEnabled },
        { "SiteIsolationEnabled"_s, &WebPreferences::siteIsolationEnabled },
        { "SpeechRecognitionEnabled"_s, &WebPreferences::speechRecognitionEnabled },
        { "SpeechSynthesisAPIEnabled"_s, &WebPreferences::speechSynthesisAPIEnabled },
        { "StorageAPIEstimateEnabled"_s, &WebPreferences::storageAPIEstimateEnabled },
        { "StorageAPIEnabled"_s, &WebPreferences::storageAPIEnabled },
        { "ProcessSwapOnCrossSiteNavigationEnabled"_s, &WebPreferences::processSwapOnCrossSiteNavigationEnabled },
        { "ShouldTakeNearSuspendedAssertions"_s, &WebPreferences::shouldTakeNearSuspendedAssertions },
#if ENABLE(WRITING_TOOLS_UI)
        { "TextAnimationsEnabled"_s, &WebPreferences::textAnimationsEnabled },
#endif
#if ENABLE(IMAGE_ANALYSIS) && ENABLE(VIDEO)
        { "TextRecognitionInVideosEnabled"_s, &WebPreferences::textRecognitionInVideosEnabled },
#endif
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "ThreadedAnimationResolutionEnabled"_s, &WebPreferences::threadedAnimationResolutionEnabled },
#endif
        { "TiledScrollingIndicatorVisible"_s, &WebPreferences::tiledScrollingIndicatorVisible },
#if ENABLE(INPUT_TYPE_TIME)
        { "InputTypeTimeEnabled"_s, &WebPreferences::inputTypeTimeEnabled },
#endif
        { "TrackConfigurationEnabled"_s, &WebPreferences::trackConfigurationEnabled },
        { "TrustedTypesEnabled"_s, &WebPreferences::trustedTypesEnabled },
        { "UndoManagerAPIEnabled"_s, &WebPreferences::undoManagerAPIEnabled },
#if ENABLE(UNIFIED_PDF)
        { "UnifiedPDFEnabled"_s, &WebPreferences::unifiedPDFEnabled },
#endif
#if USE(COORDINATED_GRAPHICS)
        { "UnifyDamagedRegions"_s, &WebPreferences::unifyDamagedRegions },
#endif
        { "IPAddressAndLocalhostMixedContentUpgradeTestingEnabled"_s, &WebPreferences::iPAddressAndLocalhostMixedContentUpgradeTestingEnabled },
        { "UpgradeKnownHostsToHTTPSEnabled"_s, &WebPreferences::upgradeKnownHostsToHTTPSEnabled },
        { "UpgradeMixedContentEnabled"_s, &WebPreferences::upgradeMixedContentEnabled },
#if ENABLE(ARKIT_INLINE_PREVIEW)
        { "UseARKitForModel"_s, &WebPreferences::useARKitForModel },
#endif
#if HAVE(SC_CONTENT_SHARING_PICKER)
        { "UseSCContentSharingPicker"_s, &WebPreferences::useSCContentSharingPicker },
#endif
#if HAVE(SCENEKIT)
        { "UseSceneKitForModel"_s, &WebPreferences::useSceneKitForModel },
#endif
        { "UseGiantTiles"_s, &WebPreferences::useGiantTiles },
        { "UserActivationAPIEnabled"_s, &WebPreferences::userActivationAPIEnabled },
        { "UserGesturePromisePropagationEnabled"_s, &WebPreferences::userGesturePromisePropagationEnabled },
        { "ServiceWorkersUserGestureEnabled"_s, &WebPreferences::serviceWorkersUserGestureEnabled },
        { "VerifyWindowOpenUserGestureFromUIProcess"_s, &WebPreferences::verifyWindowOpenUserGestureFromUIProcess },
        { "VerticalFormControlsEnabled"_s, &WebPreferences::verticalFormControlsEnabled },
        { "ViewTransitionClassesEnabled"_s, &WebPreferences::viewTransitionClassesEnabled },
        { "ViewTransitionTypesEnabled"_s, &WebPreferences::viewTransitionTypesEnabled },
        { "ViewTransitionsEnabled"_s, &WebPreferences::viewTransitionsEnabled },
        { "ViewGestureDebuggingEnabled"_s, &WebPreferences::viewGestureDebuggingEnabled },
#if ENABLE(IMAGE_ANALYSIS)
        { "VisualTranslationEnabled"_s, &WebPreferences::visualTranslationEnabled },
#endif
        { "VisualViewportAPIEnabled"_s, &WebPreferences::visualViewportAPIEnabled },
#if ENABLE(VORBIS)
        { "VorbisDecoderEnabled"_s, &WebPreferences::vorbisDecoderEnabled },
#endif
        { "WebAPIStatisticsEnabled"_s, &WebPreferences::webAPIStatisticsEnabled },
        { "WebAPIsInShadowRealmEnabled"_s, &WebPreferences::webAPIsInShadowRealmEnabled },
        { "WebAnimationsCustomEffectsEnabled"_s, &WebPreferences::webAnimationsCustomEffectsEnabled },
        { "WebAnimationsCustomFrameRateEnabled"_s, &WebPreferences::webAnimationsCustomFrameRateEnabled },
#if ENABLE(WEB_ARCHIVE)
        { "WebArchiveDebugModeEnabled"_s, &WebPreferences::webArchiveDebugModeEnabled },
#endif
#if ENABLE(WEB_ARCHIVE)
        { "WebArchiveTestingModeEnabled"_s, &WebPreferences::webArchiveTestingModeEnabled },
#endif
#if HAVE(WEB_AUTHN_AS_MODERN)
        { "WebAuthenticationASEnabled"_s, &WebPreferences::webAuthenticationASEnabled },
#endif
#if ENABLE(WEB_AUTHN)
        { "WebAuthenticationEnabled"_s, &WebPreferences::webAuthenticationEnabled },
#endif
        { "WebCryptoSafeCurvesEnabled"_s, &WebPreferences::webCryptoSafeCurvesEnabled },
        { "WebCryptoX25519Enabled"_s, &WebPreferences::webCryptoX25519Enabled },
        { "WebLocksAPIEnabled"_s, &WebPreferences::webLocksAPIEnabled },
        { "WebShareFileAPIEnabled"_s, &WebPreferences::webShareFileAPIEnabled },
        { "WebShareEnabled"_s, &WebPreferences::webShareEnabled },
#if ENABLE(WEBASSEMBLY)
        { "WebAssemblyESMIntegrationEnabled"_s, &WebPreferences::webAssemblyESMIntegrationEnabled },
#endif
#if ENABLE(WEB_CODECS)
        { "WebCodecsAV1Enabled"_s, &WebPreferences::webCodecsAV1Enabled },
#endif
#if ENABLE(WEB_CODECS)
        { "WebCodecsAudioEnabled"_s, &WebPreferences::webCodecsAudioEnabled },
#endif
#if ENABLE(WEB_CODECS)
        { "WebCodecsHEVCEnabled"_s, &WebPreferences::webCodecsHEVCEnabled },
#endif
#if ENABLE(WEB_CODECS)
        { "WebCodecsVideoEnabled"_s, &WebPreferences::webCodecsVideoEnabled },
#endif
#if ENABLE(WK_WEB_EXTENSIONS_SIDEBAR)
        { "WebExtensionSidebarEnabled"_s, &WebPreferences::webExtensionSidebarEnabled },
#endif
        { "WebGLDraftExtensionsEnabled"_s, &WebPreferences::webGLDraftExtensionsEnabled },
        { "WebGLTimerQueriesEnabled"_s, &WebPreferences::webGLTimerQueriesEnabled },
        { "WebGLEnabled"_s, &WebPreferences::webGLEnabled },
        { "WebXRWebGPUBindingsEnabled"_s, &WebPreferences::webXRWebGPUBindingsEnabled },
        { "WebGPUEnabled"_s, &WebPreferences::webGPUEnabled },
        { "WebInspectorEngineeringSettingsAllowed"_s, &WebPreferences::webInspectorEngineeringSettingsAllowed },
#if ENABLE(WEB_RTC)
        { "WebRTCAV1CodecEnabled"_s, &WebPreferences::webRTCAV1CodecEnabled },
#endif
        { "WebRTCAudioLatencyAdaptationEnabled"_s, &WebPreferences::webRTCAudioLatencyAdaptationEnabled },
#if ENABLE(WEB_RTC)
        { "WebRTCDTMFEnabled"_s, &WebPreferences::webRTCDTMFEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCEncodedTransformEnabled"_s, &WebPreferences::webRTCEncodedTransformEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH264HardwareEncoderEnabled"_s, &WebPreferences::webRTCH264HardwareEncoderEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH265CodecEnabled"_s, &WebPreferences::webRTCH265CodecEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCL4SEnabled"_s, &WebPreferences::webRTCL4SEnabled },
#endif
        { "WebRTCMediaPipelineAdditionalLoggingEnabled"_s, &WebPreferences::webRTCMediaPipelineAdditionalLoggingEnabled },
#if ENABLE(WEB_RTC)
        { "LegacyWebRTCOfferOptionsEnabled"_s, &WebPreferences::legacyWebRTCOfferOptionsEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "PeerConnectionVideoScalingAdaptationDisabled"_s, &WebPreferences::peerConnectionVideoScalingAdaptationDisabled },
#endif
#if ENABLE(WEB_RTC)
        { "PeerConnectionEnabled"_s, &WebPreferences::peerConnectionEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCRemoteVideoFrameEnabled"_s, &WebPreferences::webRTCRemoteVideoFrameEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCSFrameTransformEnabled"_s, &WebPreferences::webRTCSFrameTransformEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCSocketsProxyingEnabled"_s, &WebPreferences::webRTCSocketsProxyingEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCVP9Profile0CodecEnabled"_s, &WebPreferences::webRTCVP9Profile0CodecEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCVP9Profile2CodecEnabled"_s, &WebPreferences::webRTCVP9Profile2CodecEnabled },
#endif
        { "WebTransportEnabled"_s, &WebPreferences::webTransportEnabled },
#if ENABLE(WEBXR)
        { "WebXRAugmentedRealityModuleEnabled"_s, &WebPreferences::webXRAugmentedRealityModuleEnabled },
#endif
#if ENABLE(WEBXR)
        { "WebXREnabled"_s, &WebPreferences::webXREnabled },
#endif
#if ENABLE(WEBXR)
        { "WebXRGamepadsModuleEnabled"_s, &WebPreferences::webXRGamepadsModuleEnabled },
#endif
#if ENABLE(WEBXR_HANDS)
        { "WebXRHandInputModuleEnabled"_s, &WebPreferences::webXRHandInputModuleEnabled },
#endif
#if ENABLE(WEBXR_LAYERS)
        { "WebXRLayersAPIEnabled"_s, &WebPreferences::webXRLayersAPIEnabled },
#endif
#if ENABLE(INPUT_TYPE_WEEK)
        { "InputTypeWeekEnabled"_s, &WebPreferences::inputTypeWeekEnabled },
#endif
        { "WheelEventGesturesBecomeNonBlocking"_s, &WebPreferences::wheelEventGesturesBecomeNonBlocking },
        { "PassiveWheelListenersAsDefaultOnDocument"_s, &WebPreferences::passiveWheelListenersAsDefaultOnDocument },
#if PLATFORM(COCOA)
        { "WriteRichTextDataWhenCopyingOrDragging"_s, &WebPreferences::writeRichTextDataWhenCopyingOrDragging },
#endif
#if ENABLE(WRITING_SUGGESTIONS)
        { "WritingSuggestionsAttributeEnabled"_s, &WebPreferences::writingSuggestionsAttributeEnabled },
#endif
        { "IsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled"_s, &WebPreferences::isFirstPartyWebsiteDataRemovalLiveOnTestingEnabled },
        { "IsFirstPartyWebsiteDataRemovalReproTestingEnabled"_s, &WebPreferences::isFirstPartyWebsiteDataRemovalReproTestingEnabled },
        { "AlignContentOnBlocksEnabled"_s, &WebPreferences::alignContentOnBlocksEnabled },
        { "AltitudeAngleEnabled"_s, &WebPreferences::altitudeAngleEnabled },
        { "AzimuthAngleEnabled"_s, &WebPreferences::azimuthAngleEnabled },
#if ENABLE(INPUT_TYPE_DATETIMELOCAL)
        { "InputTypeDateTimeLocalEnabled"_s, &WebPreferences::inputTypeDateTimeLocalEnabled },
#endif
        { "ElementCheckVisibilityEnabled"_s, &WebPreferences::elementCheckVisibilityEnabled },
        { "HTTPEquivEnabled"_s, &WebPreferences::httpEquivEnabled },
        { "RequestIdleCallbackEnabled"_s, &WebPreferences::requestIdleCallbackEnabled },
        { "RequestStorageAccessThrowsExceptionUntilReload"_s, &WebPreferences::requestStorageAccessThrowsExceptionUntilReload },
        { "CSSWordBreakAutoPhraseEnabled"_s, &WebPreferences::cssWordBreakAutoPhraseEnabled },
    };

    const String& key = feature.key();

    for (auto& getter : getters) {
        if (key == getter.name)
            return (this->*getter.function)();
    }

    return false;
}

void WebPreferences::setFeatureEnabled(const API::Feature& feature, bool value)
{
    setFeatureEnabledForKey(feature.key(), value);
}

void WebPreferences::setFeatureEnabledForKey(const String& key, bool value)
{
    struct FeatureSetterMapping {
        ASCIILiteral name;
        void (WebPreferences::*function) (const bool&);
    };

    static FeatureSetterMapping setters[] = {
        { "AcceleratedCompositingEnabled"_s, &WebPreferences::setAcceleratedCompositingEnabled },
        { "AcceleratedCompositingForFixedPositionEnabled"_s, &WebPreferences::setAcceleratedCompositingForFixedPositionEnabled },
        { "AggressiveTileRetentionEnabled"_s, &WebPreferences::setAggressiveTileRetentionEnabled },
        { "AllowContentSecurityPolicySourceStarToMatchAnyProtocol"_s, &WebPreferences::setAllowContentSecurityPolicySourceStarToMatchAnyProtocol },
        { "AllowDisplayOfInsecureContent"_s, &WebPreferences::setAllowDisplayOfInsecureContent },
        { "AllowFileAccessFromFileURLs"_s, &WebPreferences::setAllowFileAccessFromFileURLs },
        { "AllowMultiElementImplicitSubmission"_s, &WebPreferences::setAllowMultiElementImplicitSubmission },
        { "AllowRunningOfInsecureContent"_s, &WebPreferences::setAllowRunningOfInsecureContent },
        { "AllowSettingAnyXHRHeaderFromFileURLs"_s, &WebPreferences::setAllowSettingAnyXHRHeaderFromFileURLs },
        { "AllowTestOnlyIPC"_s, &WebPreferences::setAllowTestOnlyIPC },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        { "AllowsAirPlayForMediaPlayback"_s, &WebPreferences::setAllowsAirPlayForMediaPlayback },
#endif
        { "AllowsInlineMediaPlayback"_s, &WebPreferences::setAllowsInlineMediaPlayback },
        { "AllowsInlineMediaPlaybackAfterFullscreen"_s, &WebPreferences::setAllowsInlineMediaPlaybackAfterFullscreen },
        { "AllowsPictureInPictureMediaPlayback"_s, &WebPreferences::setAllowsPictureInPictureMediaPlayback },
#if PLATFORM(IOS_FAMILY)
        { "AlternateFormControlDesignEnabled"_s, &WebPreferences::setAlternateFormControlDesignEnabled },
#endif
#if PLATFORM(IOS_FAMILY)
        { "AlternateFullScreenControlDesignEnabled"_s, &WebPreferences::setAlternateFullScreenControlDesignEnabled },
#endif
        { "AnimatedImageAsyncDecodingEnabled"_s, &WebPreferences::setAnimatedImageAsyncDecodingEnabled },
        { "AppleMailPaginationQuirkEnabled"_s, &WebPreferences::setAppleMailPaginationQuirkEnabled },
#if ENABLE(APPLE_PAY)
        { "ApplePayCapabilityDisclosureAllowed"_s, &WebPreferences::setApplePayCapabilityDisclosureAllowed },
#endif
#if ENABLE(APPLE_PAY)
        { "ApplePayEnabled"_s, &WebPreferences::setApplePayEnabled },
#endif
        { "AsynchronousSpellCheckingEnabled"_s, &WebPreferences::setAsynchronousSpellCheckingEnabled },
        { "AudioControlsScaleWithPageZoom"_s, &WebPreferences::setAudioControlsScaleWithPageZoom },
        { "AuthorAndUserStylesEnabled"_s, &WebPreferences::setAuthorAndUserStylesEnabled },
        { "BackspaceKeyNavigationEnabled"_s, &WebPreferences::setBackspaceKeyNavigationEnabled },
        { "CaretBrowsingEnabled"_s, &WebPreferences::setCaretBrowsingEnabled },
        { "ColorFilterEnabled"_s, &WebPreferences::setColorFilterEnabled },
#if ENABLE(CONTENT_CHANGE_OBSERVER)
        { "ContentChangeObserverEnabled"_s, &WebPreferences::setContentChangeObserverEnabled },
#endif
        { "ContentDispositionAttachmentSandboxEnabled"_s, &WebPreferences::setContentDispositionAttachmentSandboxEnabled },
#if ENABLE(CONTEXT_MENU_QR_CODE_DETECTION)
        { "ContextMenuQRCodeDetectionEnabled"_s, &WebPreferences::setContextMenuQRCodeDetectionEnabled },
#endif
        { "DNSPrefetchingEnabled"_s, &WebPreferences::setDNSPrefetchingEnabled },
        { "DOMPasteAllowed"_s, &WebPreferences::setDOMPasteAllowed },
        { "DatabasesEnabled"_s, &WebPreferences::setDatabasesEnabled },
        { "DeveloperExtrasEnabled"_s, &WebPreferences::setDeveloperExtrasEnabled },
#if ENABLE(DEVICE_ORIENTATION)
        { "DeviceOrientationEventEnabled"_s, &WebPreferences::setDeviceOrientationEventEnabled },
#endif
#if ENABLE(DEVICE_ORIENTATION)
        { "DeviceOrientationPermissionAPIEnabled"_s, &WebPreferences::setDeviceOrientationPermissionAPIEnabled },
#endif
        { "DisabledAdaptationsMetaTagEnabled"_s, &WebPreferences::setDisabledAdaptationsMetaTagEnabled },
        { "DownloadAttributeEnabled"_s, &WebPreferences::setDownloadAttributeEnabled },
        { "EnableInheritURIQueryComponent"_s, &WebPreferences::setEnableInheritURIQueryComponent },
#if ENABLE(ENCRYPTED_MEDIA)
        { "EncryptedMediaAPIEnabled"_s, &WebPreferences::setEncryptedMediaAPIEnabled },
#endif
#if HAVE(APP_SSO)
        { "ExtensibleSSOEnabled"_s, &WebPreferences::setExtensibleSSOEnabled },
#endif
        { "ForceCompositingMode"_s, &WebPreferences::setForceCompositingMode },
        { "ForceFTPDirectoryListings"_s, &WebPreferences::setForceFTPDirectoryListings },
        { "ForceWebGLUsesLowPower"_s, &WebPreferences::setForceWebGLUsesLowPower },
#if USE(GSTREAMER)
        { "GStreamerEnabled"_s, &WebPreferences::setGStreamerEnabled },
#endif
        { "HiddenPageCSSAnimationSuspensionEnabled"_s, &WebPreferences::setHiddenPageCSSAnimationSuspensionEnabled },
        { "IncompleteImageBorderEnabled"_s, &WebPreferences::setIncompleteImageBorderEnabled },
#if HAVE(INCREMENTAL_PDF_APIS)
        { "IncrementalPDFLoadingEnabled"_s, &WebPreferences::setIncrementalPDFLoadingEnabled },
#endif
        { "InlineMediaPlaybackRequiresPlaysInlineAttribute"_s, &WebPreferences::setInlineMediaPlaybackRequiresPlaysInlineAttribute },
        { "InspectorStartsAttached"_s, &WebPreferences::setInspectorStartsAttached },
#if ENABLE(MEDIA_STREAM)
        { "InterruptAudioOnPageVisibilityChangeEnabled"_s, &WebPreferences::setInterruptAudioOnPageVisibilityChangeEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "InterruptVideoOnPageVisibilityChangeEnabled"_s, &WebPreferences::setInterruptVideoOnPageVisibilityChangeEnabled },
#endif
        { "InvisibleAutoplayNotPermitted"_s, &WebPreferences::setInvisibleAutoplayNotPermitted },
        { "JavaScriptCanAccessClipboard"_s, &WebPreferences::setJavaScriptCanAccessClipboard },
        { "JavaScriptCanOpenWindowsAutomatically"_s, &WebPreferences::setJavaScriptCanOpenWindowsAutomatically },
        { "JavaScriptMarkupEnabled"_s, &WebPreferences::setJavaScriptMarkupEnabled },
        { "LargeImageAsyncDecodingEnabled"_s, &WebPreferences::setLargeImageAsyncDecodingEnabled },
        { "LinkPreconnect"_s, &WebPreferences::setLinkPreconnect },
        { "LinkPreloadEnabled"_s, &WebPreferences::setLinkPreloadEnabled },
        { "LoadDeferringEnabled"_s, &WebPreferences::setLoadDeferringEnabled },
        { "LoadsImagesAutomatically"_s, &WebPreferences::setLoadsImagesAutomatically },
        { "LowPowerVideoAudioBufferSizeEnabled"_s, &WebPreferences::setLowPowerVideoAudioBufferSizeEnabled },
#if ENABLE(MATHML)
        { "MathMLEnabled"_s, &WebPreferences::setMathMLEnabled },
#endif
        { "MediaCapabilitiesEnabled"_s, &WebPreferences::setMediaCapabilitiesEnabled },
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS)
        { "MediaControlsContextMenusEnabled"_s, &WebPreferences::setMediaControlsContextMenusEnabled },
#endif
        { "MediaControlsScaleWithPageZoom"_s, &WebPreferences::setMediaControlsScaleWithPageZoom },
        { "MediaDataLoadsAutomatically"_s, &WebPreferences::setMediaDataLoadsAutomatically },
#if ENABLE(VIDEO)
        { "MediaEnabled"_s, &WebPreferences::setMediaEnabled },
#endif
        { "MediaPreloadingEnabled"_s, &WebPreferences::setMediaPreloadingEnabled },
#if ENABLE(MEDIA_STREAM)
        { "MediaStreamEnabled"_s, &WebPreferences::setMediaStreamEnabled },
#endif
        { "MediaUserGestureInheritsFromDocument"_s, &WebPreferences::setMediaUserGestureInheritsFromDocument },
        { "MockCaptureDevicesPromptEnabled"_s, &WebPreferences::setMockCaptureDevicesPromptEnabled },
        { "MockScrollbarsControllerEnabled"_s, &WebPreferences::setMockScrollbarsControllerEnabled },
        { "MockScrollbarsEnabled"_s, &WebPreferences::setMockScrollbarsEnabled },
        { "NeedsAdobeFrameReloadingQuirk"_s, &WebPreferences::setNeedsAdobeFrameReloadingQuirk },
        { "NeedsFrameNameFallbackToIdQuirk"_s, &WebPreferences::setNeedsFrameNameFallbackToIdQuirk },
        { "NeedsKeyboardEventDisambiguationQuirks"_s, &WebPreferences::setNeedsKeyboardEventDisambiguationQuirks },
#if PLATFORM(COCOA)
        { "PDFPluginEnabled"_s, &WebPreferences::setPDFPluginEnabled },
#endif
#if PLATFORM(COCOA)
        { "PDFPluginHUDEnabled"_s, &WebPreferences::setPDFPluginHUDEnabled },
#endif
        { "PassiveTouchListenersAsDefaultOnDocument"_s, &WebPreferences::setPassiveTouchListenersAsDefaultOnDocument },
        { "PasswordEchoEnabled"_s, &WebPreferences::setPasswordEchoEnabled },
#if ENABLE(PICTURE_IN_PICTURE_API)
        { "PictureInPictureAPIEnabled"_s, &WebPreferences::setPictureInPictureAPIEnabled },
#endif
        { "PunchOutWhiteBackgroundsInDarkMode"_s, &WebPreferences::setPunchOutWhiteBackgroundsInDarkMode },
        { "RequiresPageVisibilityToPlayAudio"_s, &WebPreferences::setRequiresPageVisibilityToPlayAudio },
        { "RequiresUserGestureForAudioPlayback"_s, &WebPreferences::setRequiresUserGestureForAudioPlayback },
        { "RequiresUserGestureForMediaPlayback"_s, &WebPreferences::setRequiresUserGestureForMediaPlayback },
        { "RequiresUserGestureForVideoPlayback"_s, &WebPreferences::setRequiresUserGestureForVideoPlayback },
        { "RequiresUserGestureToLoadVideo"_s, &WebPreferences::setRequiresUserGestureToLoadVideo },
#if HAVE(RUBBER_BANDING)
        { "RubberBandingForSubScrollableRegionsEnabled"_s, &WebPreferences::setRubberBandingForSubScrollableRegionsEnabled },
#endif
        { "SelectTrailingWhitespaceEnabled"_s, &WebPreferences::setSelectTrailingWhitespaceEnabled },
#if ENABLE(SERVICE_CONTROLS)
        { "ServiceControlsEnabled"_s, &WebPreferences::setServiceControlsEnabled },
#endif
        { "ServiceWorkerEntitlementDisabledForTesting"_s, &WebPreferences::setServiceWorkerEntitlementDisabledForTesting },
        { "ShouldAllowUserInstalledFonts"_s, &WebPreferences::setShouldAllowUserInstalledFonts },
        { "ShouldConvertInvalidURLsToBlank"_s, &WebPreferences::setShouldConvertInvalidURLsToBlank },
        { "ShouldConvertPositionStyleOnCopy"_s, &WebPreferences::setShouldConvertPositionStyleOnCopy },
        { "ShouldDecidePolicyBeforeLoadingQuickLookPreview"_s, &WebPreferences::setShouldDecidePolicyBeforeLoadingQuickLookPreview },
#if ENABLE(VIDEO)
        { "ShouldDisplayCaptions"_s, &WebPreferences::setShouldDisplayCaptions },
#endif
#if ENABLE(VIDEO)
        { "ShouldDisplaySubtitles"_s, &WebPreferences::setShouldDisplaySubtitles },
#endif
#if ENABLE(VIDEO)
        { "ShouldDisplayTextDescriptions"_s, &WebPreferences::setShouldDisplayTextDescriptions },
#endif
#if ENABLE(TEXT_AUTOSIZING)
        { "ShouldEnableTextAutosizingBoost"_s, &WebPreferences::setShouldEnableTextAutosizingBoost },
#endif
        { "ShouldIgnoreMetaViewport"_s, &WebPreferences::setShouldIgnoreMetaViewport },
        { "ShouldPrintBackgrounds"_s, &WebPreferences::setShouldPrintBackgrounds },
        { "ShouldRespectImageOrientation"_s, &WebPreferences::setShouldRespectImageOrientation },
        { "ShouldRestrictBaseURLSchemes"_s, &WebPreferences::setShouldRestrictBaseURLSchemes },
        { "ShouldSuppressTextInputFromEditingDuringProvisionalNavigation"_s, &WebPreferences::setShouldSuppressTextInputFromEditingDuringProvisionalNavigation },
        { "ShouldUseServiceWorkerShortTimeout"_s, &WebPreferences::setShouldUseServiceWorkerShortTimeout },
        { "ShowsToolTipOverTruncatedText"_s, &WebPreferences::setShowsToolTipOverTruncatedText },
        { "ShowsURLsInToolTipsEnabled"_s, &WebPreferences::setShowsURLsInToolTipsEnabled },
        { "ShrinksStandaloneImagesToFit"_s, &WebPreferences::setShrinksStandaloneImagesToFit },
        { "SmartInsertDeleteEnabled"_s, &WebPreferences::setSmartInsertDeleteEnabled },
#if ENABLE(MEDIA_SOURCE)
        { "SourceBufferChangeTypeEnabled"_s, &WebPreferences::setSourceBufferChangeTypeEnabled },
#endif
        { "SpatialNavigationEnabled"_s, &WebPreferences::setSpatialNavigationEnabled },
        { "Standalone"_s, &WebPreferences::setStandalone },
        { "SuppressesIncrementalRendering"_s, &WebPreferences::setSuppressesIncrementalRendering },
#if USE(SYSTEM_PREVIEW)
        { "SystemPreviewEnabled"_s, &WebPreferences::setSystemPreviewEnabled },
#endif
        { "TabsToLinks"_s, &WebPreferences::setTabsToLinks },
        { "TelephoneNumberParsingEnabled"_s, &WebPreferences::setTelephoneNumberParsingEnabled },
        { "TemporaryTileCohortRetentionEnabled"_s, &WebPreferences::setTemporaryTileCohortRetentionEnabled },
        { "TextAreasAreResizable"_s, &WebPreferences::setTextAreasAreResizable },
#if ENABLE(TEXT_AUTOSIZING)
        { "TextAutosizingEnabled"_s, &WebPreferences::setTextAutosizingEnabled },
#endif
        { "TextExtractionEnabled"_s, &WebPreferences::setTextExtractionEnabled },
        { "TextInteractionEnabled"_s, &WebPreferences::setTextInteractionEnabled },
        { "ThreadedScrollingEnabled"_s, &WebPreferences::setThreadedScrollingEnabled },
        { "TreatsAnyTextCSSLinkAsStylesheet"_s, &WebPreferences::setTreatsAnyTextCSSLinkAsStylesheet },
        { "UseImageDocumentForSubframePDF"_s, &WebPreferences::setUseImageDocumentForSubframePDF },
        { "UsePreHTML5ParserQuirks"_s, &WebPreferences::setUsePreHTML5ParserQuirks },
        { "UsesBackForwardCache"_s, &WebPreferences::setUsesBackForwardCache },
        { "UsesEncodingDetector"_s, &WebPreferences::setUsesEncodingDetector },
        { "UsesSingleWebProcess"_s, &WebPreferences::setUsesSingleWebProcess },
#if ENABLE(VP9)
        { "VP8DecoderEnabled"_s, &WebPreferences::setVP8DecoderEnabled },
#endif
#if ENABLE(VP9)
        { "VP9DecoderEnabled"_s, &WebPreferences::setVP9DecoderEnabled },
#endif
#if PLATFORM(IOS_FAMILY)
        { "VideoFullscreenRequiresElementFullscreen"_s, &WebPreferences::setVideoFullscreenRequiresElementFullscreen },
#endif
        { "VideoPresentationModeAPIEnabled"_s, &WebPreferences::setVideoPresentationModeAPIEnabled },
#if ENABLE(VIDEO)
        { "VideoQualityIncludesDisplayCompositingEnabled"_s, &WebPreferences::setVideoQualityIncludesDisplayCompositingEnabled },
#endif
        { "VisualViewportEnabled"_s, &WebPreferences::setVisualViewportEnabled },
        { "WantsBalancedSetDefersLoadingBehavior"_s, &WebPreferences::setWantsBalancedSetDefersLoadingBehavior },
#if ENABLE(WEB_AUDIO)
        { "WebAudioEnabled"_s, &WebPreferences::setWebAudioEnabled },
#endif
#if ENABLE(WEBM_FORMAT_READER)
        { "WebMFormatReaderEnabled"_s, &WebPreferences::setWebMFormatReaderEnabled },
#endif
#if ENABLE(MEDIA_SOURCE)
        { "WebMParserEnabled"_s, &WebPreferences::setWebMParserEnabled },
#endif
        { "WebSecurityEnabled"_s, &WebPreferences::setWebSecurityEnabled },
        { "WebSocketEnabled"_s, &WebPreferences::setWebSocketEnabled },
        { "WindowFocusRestricted"_s, &WebPreferences::setWindowFocusRestricted },
        { "WirelessPlaybackTargetAPIEnabled"_s, &WebPreferences::setWirelessPlaybackTargetAPIEnabled },
        { "GrammarAndSpellingPseudoElementsEnabled"_s, &WebPreferences::setGrammarAndSpellingPseudoElementsEnabled },
        { "TargetTextPseudoElementEnabled"_s, &WebPreferences::setTargetTextPseudoElementEnabled },
        { "ThumbAndTrackPseudoElementsEnabled"_s, &WebPreferences::setThumbAndTrackPseudoElementsEnabled },
        { "SelectShowPickerEnabled"_s, &WebPreferences::setSelectShowPickerEnabled },
        { "PageAtRuleMarginDescriptorsEnabled"_s, &WebPreferences::setPageAtRuleMarginDescriptorsEnabled },
#if USE(AVFOUNDATION)
        { "AVFoundationEnabled"_s, &WebPreferences::setAVFoundationEnabled },
#endif
        { "AbortSignalAnyOperationEnabled"_s, &WebPreferences::setAbortSignalAnyOperationEnabled },
#if USE(CORE_IMAGE)
        { "AcceleratedFiltersEnabled"_s, &WebPreferences::setAcceleratedFiltersEnabled },
#endif
        { "AccessHandleEnabled"_s, &WebPreferences::setAccessHandleEnabled },
        { "DOMTestingAPIsEnabled"_s, &WebPreferences::setDOMTestingAPIsEnabled },
        { "AllowMediaContentTypesRequiringHardwareSupportAsFallback"_s, &WebPreferences::setAllowMediaContentTypesRequiringHardwareSupportAsFallback },
        { "AllowPrivacySensitiveOperationsInNonPersistentDataStores"_s, &WebPreferences::setAllowPrivacySensitiveOperationsInNonPersistentDataStores },
#if PLATFORM(IOS_FAMILY)
        { "AllowViewportShrinkToFitContent"_s, &WebPreferences::setAllowViewportShrinkToFitContent },
#endif
#if ENABLE(WEBGL)
        { "AllowWebGLInWorkers"_s, &WebPreferences::setAllowWebGLInWorkers },
#endif
#if ENABLE(MEDIA_STREAM)
        { "PerElementSpeakerSelectionEnabled"_s, &WebPreferences::setPerElementSpeakerSelectionEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "ExposeSpeakersEnabled"_s, &WebPreferences::setExposeSpeakersEnabled },
#endif
        { "AllowTopNavigationToDataURLs"_s, &WebPreferences::setAllowTopNavigationToDataURLs },
        { "AllowUniversalAccessFromFileURLs"_s, &WebPreferences::setAllowUniversalAccessFromFileURLs },
#if ENABLE(ALTERNATE_WEBM_PLAYER) && ENABLE(MEDIA_SOURCE)
        { "AlternateWebMPlayerEnabled"_s, &WebPreferences::setAlternateWebMPlayerEnabled },
#endif
#if ENABLE(WEB_ARCHIVE)
        { "AlwaysAllowLocalWebarchive"_s, &WebPreferences::setAlwaysAllowLocalWebarchive },
#endif
#if ENABLE(VP9)
        { "SWVPDecodersAlwaysEnabled"_s, &WebPreferences::setSWVPDecodersAlwaysEnabled },
#endif
        { "AppBadgeEnabled"_s, &WebPreferences::setAppBadgeEnabled },
#if ENABLE(APP_HIGHLIGHTS)
        { "AppHighlightsEnabled"_s, &WebPreferences::setAppHighlightsEnabled },
#endif
        { "AsyncFrameScrollingEnabled"_s, &WebPreferences::setAsyncFrameScrollingEnabled },
        { "AsyncOverflowScrollingEnabled"_s, &WebPreferences::setAsyncOverflowScrollingEnabled },
#if PLATFORM(IOS_FAMILY)
        { "UseAsyncUIKitInteractions"_s, &WebPreferences::setUseAsyncUIKitInteractions },
#endif
        { "AsyncClipboardAPIEnabled"_s, &WebPreferences::setAsyncClipboardAPIEnabled },
#if ENABLE(ATTACHMENT_ELEMENT)
        { "AttachmentElementEnabled"_s, &WebPreferences::setAttachmentElementEnabled },
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
        { "AttachmentWideLayoutEnabled"_s, &WebPreferences::setAttachmentWideLayoutEnabled },
#endif
#if ENABLE(VIDEO)
        { "ExtendedAudioDescriptionsEnabled"_s, &WebPreferences::setExtendedAudioDescriptionsEnabled },
#endif
#if ENABLE(VIDEO)
        { "AudioDescriptionsEnabled"_s, &WebPreferences::setAudioDescriptionsEnabled },
#endif
#if ENABLE(DOM_AUDIO_SESSION)
        { "DOMAudioSessionEnabled"_s, &WebPreferences::setDOMAudioSessionEnabled },
#endif
#if ENABLE(DOM_AUDIO_SESSION)
        { "DOMAudioSessionFullEnabled"_s, &WebPreferences::setDOMAudioSessionFullEnabled },
#endif
        { "AutomaticallyAdjustsViewScaleUsingMinimumEffectiveDeviceWidth"_s, &WebPreferences::setAutomaticallyAdjustsViewScaleUsingMinimumEffectiveDeviceWidth },
        { "BeaconAPIEnabled"_s, &WebPreferences::setBeaconAPIEnabled },
        { "BroadcastChannelEnabled"_s, &WebPreferences::setBroadcastChannelEnabled },
        { "BroadcastChannelOriginPartitioningEnabled"_s, &WebPreferences::setBroadcastChannelOriginPartitioningEnabled },
#if ENABLE(WEB_PUSH_NOTIFICATIONS)
        { "BuiltInNotificationsEnabled"_s, &WebPreferences::setBuiltInNotificationsEnabled },
#endif
        { "CSS3DTransformBackfaceVisibilityInteroperabilityEnabled"_s, &WebPreferences::setCSS3DTransformBackfaceVisibilityInteroperabilityEnabled },
        { "CSSCounterStyleAtRuleImageSymbolsEnabled"_s, &WebPreferences::setCSSCounterStyleAtRuleImageSymbolsEnabled },
        { "CSSCounterStyleAtRulesEnabled"_s, &WebPreferences::setCSSCounterStyleAtRulesEnabled },
        { "CSSFontFaceSizeAdjustEnabled"_s, &WebPreferences::setCSSFontFaceSizeAdjustEnabled },
        { "CSSStartingStyleAtRuleEnabled"_s, &WebPreferences::setCSSStartingStyleAtRuleEnabled },
        { "AccentColorEnabled"_s, &WebPreferences::setAccentColorEnabled },
        { "CSSAnchorPositioningEnabled"_s, &WebPreferences::setCSSAnchorPositioningEnabled },
        { "CSSContentVisibilityEnabled"_s, &WebPreferences::setCSSContentVisibilityEnabled },
        { "CSSInputSecurityEnabled"_s, &WebPreferences::setCSSInputSecurityEnabled },
        { "MasonryEnabled"_s, &WebPreferences::setMasonryEnabled },
        { "CSSMotionPathEnabled"_s, &WebPreferences::setCSSMotionPathEnabled },
        { "CSSNestingEnabled"_s, &WebPreferences::setCSSNestingEnabled },
        { "OverscrollBehaviorEnabled"_s, &WebPreferences::setOverscrollBehaviorEnabled },
        { "CSSPaintingAPIEnabled"_s, &WebPreferences::setCSSPaintingAPIEnabled },
        { "CSSRhythmicSizingEnabled"_s, &WebPreferences::setCSSRhythmicSizingEnabled },
        { "CSSScopeAtRuleEnabled"_s, &WebPreferences::setCSSScopeAtRuleEnabled },
        { "CSSScrollAnchoringEnabled"_s, &WebPreferences::setCSSScrollAnchoringEnabled },
        { "SpringTimingFunctionEnabled"_s, &WebPreferences::setSpringTimingFunctionEnabled },
        { "CSSTypedOMColorEnabled"_s, &WebPreferences::setCSSTypedOMColorEnabled },
        { "CSSUnprefixedBackdropFilterEnabled"_s, &WebPreferences::setCSSUnprefixedBackdropFilterEnabled },
        { "CSSBackgroundClipBorderAreaEnabled"_s, &WebPreferences::setCSSBackgroundClipBorderAreaEnabled },
        { "CSSColorContrastEnabled"_s, &WebPreferences::setCSSColorContrastEnabled },
        { "CSSColorLayersEnabled"_s, &WebPreferences::setCSSColorLayersEnabled },
        { "CSSDPropertyEnabled"_s, &WebPreferences::setCSSDPropertyEnabled },
        { "CSSFieldSizingEnabled"_s, &WebPreferences::setCSSFieldSizingEnabled },
        { "CSSFontVariantEmojiEnabled"_s, &WebPreferences::setCSSFontVariantEmojiEnabled },
        { "CSSLightDarkEnabled"_s, &WebPreferences::setCSSLightDarkEnabled },
        { "CSSMarginTrimEnabled"_s, &WebPreferences::setCSSMarginTrimEnabled },
        { "CSSRubyAlignEnabled"_s, &WebPreferences::setCSSRubyAlignEnabled },
        { "CSSScrollbarColorEnabled"_s, &WebPreferences::setCSSScrollbarColorEnabled },
        { "CSSScrollbarGutterEnabled"_s, &WebPreferences::setCSSScrollbarGutterEnabled },
        { "CSSScrollbarWidthEnabled"_s, &WebPreferences::setCSSScrollbarWidthEnabled },
        { "CSSShapeFunctionEnabled"_s, &WebPreferences::setCSSShapeFunctionEnabled },
        { "CSSStyleQueriesEnabled"_s, &WebPreferences::setCSSStyleQueriesEnabled },
        { "CSSTextAutospaceEnabled"_s, &WebPreferences::setCSSTextAutospaceEnabled },
        { "CSSTextBoxTrimEnabled"_s, &WebPreferences::setCSSTextBoxTrimEnabled },
        { "CSSTextGroupAlignEnabled"_s, &WebPreferences::setCSSTextGroupAlignEnabled },
        { "CSSTextJustifyEnabled"_s, &WebPreferences::setCSSTextJustifyEnabled },
        { "CSSTextSpacingEnabled"_s, &WebPreferences::setCSSTextSpacingEnabled },
        { "CSSTextUnderlinePositionLeftRightEnabled"_s, &WebPreferences::setCSSTextUnderlinePositionLeftRightEnabled },
        { "CSSTextWrapStyleEnabled"_s, &WebPreferences::setCSSTextWrapStyleEnabled },
        { "CSSTextWrapPrettyEnabled"_s, &WebPreferences::setCSSTextWrapPrettyEnabled },
#if ENABLE(CSS_TRANSFORM_STYLE_OPTIMIZED_3D)
        { "CSSTransformStyleOptimized3DEnabled"_s, &WebPreferences::setCSSTransformStyleOptimized3DEnabled },
#endif
        { "CSSOMViewScrollingAPIEnabled"_s, &WebPreferences::setCSSOMViewScrollingAPIEnabled },
        { "CSSOMViewSmoothScrollingEnabled"_s, &WebPreferences::setCSSOMViewSmoothScrollingEnabled },
        { "CacheAPIEnabled"_s, &WebPreferences::setCacheAPIEnabled },
        { "CanvasColorSpaceEnabled"_s, &WebPreferences::setCanvasColorSpaceEnabled },
        { "CanvasFiltersEnabled"_s, &WebPreferences::setCanvasFiltersEnabled },
        { "CanvasLayersEnabled"_s, &WebPreferences::setCanvasLayersEnabled },
#if USE(CA) || USE(SKIA)
        { "CanvasUsesAcceleratedDrawing"_s, &WebPreferences::setCanvasUsesAcceleratedDrawing },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureAudioInUIProcessEnabled"_s, &WebPreferences::setCaptureAudioInUIProcessEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureVideoInUIProcessEnabled"_s, &WebPreferences::setCaptureVideoInUIProcessEnabled },
#endif
        { "ChildProcessDebuggabilityEnabled"_s, &WebPreferences::setChildProcessDebuggabilityEnabled },
        { "ClearSiteDataHTTPHeaderEnabled"_s, &WebPreferences::setClearSiteDataHTTPHeaderEnabled },
        { "ClientBadgeEnabled"_s, &WebPreferences::setClientBadgeEnabled },
#if ENABLE(INPUT_TYPE_COLOR)
        { "InputTypeColorEnabled"_s, &WebPreferences::setInputTypeColorEnabled },
#endif
        { "CompositingBordersVisible"_s, &WebPreferences::setCompositingBordersVisible },
        { "CompositingRepaintCountersVisible"_s, &WebPreferences::setCompositingRepaintCountersVisible },
        { "CompressionStreamEnabled"_s, &WebPreferences::setCompressionStreamEnabled },
        { "ContactPickerAPIEnabled"_s, &WebPreferences::setContactPickerAPIEnabled },
#if HAVE(AVCONTENTKEYSPECIFIER)
        { "SampleBufferContentKeySessionSupportEnabled"_s, &WebPreferences::setSampleBufferContentKeySessionSupportEnabled },
#endif
        { "CookieConsentAPIEnabled"_s, &WebPreferences::setCookieConsentAPIEnabled },
        { "CookieStoreManagerEnabled"_s, &WebPreferences::setCookieStoreManagerEnabled },
        { "CookieStoreAPIExtendedAttributesEnabled"_s, &WebPreferences::setCookieStoreAPIExtendedAttributesEnabled },
        { "CookieStoreAPIEnabled"_s, &WebPreferences::setCookieStoreAPIEnabled },
        { "CookieEnabled"_s, &WebPreferences::setCookieEnabled },
        { "CrossDocumentViewTransitionsEnabled"_s, &WebPreferences::setCrossDocumentViewTransitionsEnabled },
        { "CrossOriginEmbedderPolicyEnabled"_s, &WebPreferences::setCrossOriginEmbedderPolicyEnabled },
        { "CrossOriginOpenerPolicyEnabled"_s, &WebPreferences::setCrossOriginOpenerPolicyEnabled },
        { "CustomPasteboardDataEnabled"_s, &WebPreferences::setCustomPasteboardDataEnabled },
        { "CustomStateSetEnabled"_s, &WebPreferences::setCustomStateSetEnabled },
        { "DOMPasteAccessRequestsEnabled"_s, &WebPreferences::setDOMPasteAccessRequestsEnabled },
        { "DOMTimersThrottlingEnabled"_s, &WebPreferences::setDOMTimersThrottlingEnabled },
#if PLATFORM(IOS_FAMILY)
        { "ZoomOnDoubleTapWhenRoot"_s, &WebPreferences::setZoomOnDoubleTapWhenRoot },
#endif
#if PLATFORM(IOS_FAMILY)
        { "AlwaysZoomOnDoubleTap"_s, &WebPreferences::setAlwaysZoomOnDoubleTap },
#endif
        { "DataTransferItemsEnabled"_s, &WebPreferences::setDataTransferItemsEnabled },
#if ENABLE(DATALIST_ELEMENT)
        { "DataListElementEnabled"_s, &WebPreferences::setDataListElementEnabled },
#endif
#if ENABLE(INPUT_TYPE_DATE)
        { "InputTypeDateEnabled"_s, &WebPreferences::setInputTypeDateEnabled },
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
        { "DateTimeInputsEditableComponentsEnabled"_s, &WebPreferences::setDateTimeInputsEditableComponentsEnabled },
#endif
        { "DeclarativeShadowRootsParserAPIsEnabled"_s, &WebPreferences::setDeclarativeShadowRootsParserAPIsEnabled },
        { "DeclarativeShadowRootsSerializerAPIsEnabled"_s, &WebPreferences::setDeclarativeShadowRootsSerializerAPIsEnabled },
#if ENABLE(DECLARATIVE_WEB_PUSH)
        { "DeclarativeWebPush"_s, &WebPreferences::setDeclarativeWebPush },
#endif
        { "ShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint"_s, &WebPreferences::setShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint },
        { "DeprecateAESCFBWebCryptoEnabled"_s, &WebPreferences::setDeprecateAESCFBWebCryptoEnabled },
        { "DeprecateRSAESPKCSWebCryptoEnabled"_s, &WebPreferences::setDeprecateRSAESPKCSWebCryptoEnabled },
        { "DeprecationReportingEnabled"_s, &WebPreferences::setDeprecationReportingEnabled },
        { "UAVisualTransitionDetectionEnabled"_s, &WebPreferences::setUAVisualTransitionDetectionEnabled },
        { "DiagnosticLoggingEnabled"_s, &WebPreferences::setDiagnosticLoggingEnabled },
        { "DigitalCredentialsEnabled"_s, &WebPreferences::setDigitalCredentialsEnabled },
        { "DirectoryUploadEnabled"_s, &WebPreferences::setDirectoryUploadEnabled },
        { "IsThirdPartyCookieBlockingDisabled"_s, &WebPreferences::setIsThirdPartyCookieBlockingDisabled },
        { "IsFirstPartyWebsiteDataRemovalDisabled"_s, &WebPreferences::setIsFirstPartyWebsiteDataRemovalDisabled },
#if PLATFORM(IOS_FAMILY)
        { "DisableScreenSizeOverride"_s, &WebPreferences::setDisableScreenSizeOverride },
#endif
        { "DisallowSyncXHRDuringPageDismissalEnabled"_s, &WebPreferences::setDisallowSyncXHRDuringPageDismissalEnabled },
        { "ShouldDropNearSuspendedAssertionAfterDelay"_s, &WebPreferences::setShouldDropNearSuspendedAssertionAfterDelay },
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
        { "UseCGDisplayListsForDOMRendering"_s, &WebPreferences::setUseCGDisplayListsForDOMRendering },
#endif
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
        { "ReplayCGDisplayListsIntoBackingStore"_s, &WebPreferences::setReplayCGDisplayListsIntoBackingStore },
#endif
        { "EmbedElementEnabled"_s, &WebPreferences::setEmbedElementEnabled },
#if PLATFORM(IOS_FAMILY)
        { "AutomaticLiveResizeEnabled"_s, &WebPreferences::setAutomaticLiveResizeEnabled },
#endif
        { "CanvasFingerprintingQuirkEnabled"_s, &WebPreferences::setCanvasFingerprintingQuirkEnabled },
        { "CryptoKitEnabled"_s, &WebPreferences::setCryptoKitEnabled },
        { "EnumeratingAllNetworkInterfacesEnabled"_s, &WebPreferences::setEnumeratingAllNetworkInterfacesEnabled },
        { "EnumeratingVisibleNetworkInterfacesEnabled"_s, &WebPreferences::setEnumeratingVisibleNetworkInterfacesEnabled },
        { "ICECandidateFilteringEnabled"_s, &WebPreferences::setICECandidateFilteringEnabled },
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
        { "LegacyEncryptedMediaAPIEnabled"_s, &WebPreferences::setLegacyEncryptedMediaAPIEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "MockCaptureDevicesEnabled"_s, &WebPreferences::setMockCaptureDevicesEnabled },
#endif
#if ENABLE(MODEL_PROCESS)
        { "ModelProcessEnabled"_s, &WebPreferences::setModelProcessEnabled },
#endif
#if ENABLE(PDFJS)
        { "PDFJSViewerEnabled"_s, &WebPreferences::setPDFJSViewerEnabled },
#endif
        { "AuxclickEventEnabled"_s, &WebPreferences::setAuxclickEventEnabled },
#if PLATFORM(MAC) && USE(RUNNINGBOARD)
        { "BackgroundWebContentRunningBoardThrottlingEnabled"_s, &WebPreferences::setBackgroundWebContentRunningBoardThrottlingEnabled },
#endif
        { "BackgroundFetchAPIEnabled"_s, &WebPreferences::setBackgroundFetchAPIEnabled },
#if HAVE(NETWORK_LOADER)
        { "CFNetworkNetworkLoaderEnabled"_s, &WebPreferences::setCFNetworkNetworkLoaderEnabled },
#endif
#if HAVE(MACH_BOOTSTRAP_EXTENSION) || HAVE(SANDBOX_STATE_FLAGS)
        { "ExperimentalSandboxEnabled"_s, &WebPreferences::setExperimentalSandboxEnabled },
#endif
        { "BlobFileAccessEnforcementEnabled"_s, &WebPreferences::setBlobFileAccessEnforcementEnabled },
        { "EnterKeyHintEnabled"_s, &WebPreferences::setEnterKeyHintEnabled },
        { "EventHandlerDrivenSmoothKeyboardScrollingEnabled"_s, &WebPreferences::setEventHandlerDrivenSmoothKeyboardScrollingEnabled },
#if ENABLE(MEDIA_SESSION_COORDINATOR)
        { "MediaSessionCoordinatorEnabled"_s, &WebPreferences::setMediaSessionCoordinatorEnabled },
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR) && ENABLE(MEDIA_SESSION_PLAYLIST)
        { "MediaSessionPlaylistEnabled"_s, &WebPreferences::setMediaSessionPlaylistEnabled },
#endif
#if ENABLE(MEDIA_SOURCE) && (HAVE(AVSAMPLEBUFFERVIDEOOUTPUT) || USE(GSTREAMER))
        { "MediaSourceInlinePaintingEnabled"_s, &WebPreferences::setMediaSourceInlinePaintingEnabled },
#endif
        { "FTPEnabled"_s, &WebPreferences::setFTPEnabled },
#if PLATFORM(IOS_FAMILY)
        { "PreferFasterClickOverDoubleTap"_s, &WebPreferences::setPreferFasterClickOverDoubleTap },
#endif
#if PLATFORM(IOS_FAMILY)
        { "FasterClicksEnabled"_s, &WebPreferences::setFasterClicksEnabled },
#endif
        { "FetchPriorityEnabled"_s, &WebPreferences::setFetchPriorityEnabled },
        { "FileSystemAccessEnabled"_s, &WebPreferences::setFileSystemAccessEnabled },
        { "FileReaderAPIEnabled"_s, &WebPreferences::setFileReaderAPIEnabled },
        { "RestrictedHTTPResponseAccess"_s, &WebPreferences::setRestrictedHTTPResponseAccess },
        { "FilterLinkDecorationByDefaultEnabled"_s, &WebPreferences::setFilterLinkDecorationByDefaultEnabled },
#if PLATFORM(IOS_FAMILY)
        { "ForceAlwaysUserScalable"_s, &WebPreferences::setForceAlwaysUserScalable },
#endif
#if ENABLE(FULLSCREEN_API)
        { "FullScreenKeyboardLock"_s, &WebPreferences::setFullScreenKeyboardLock },
#endif
#if ENABLE(FULLSCREEN_API)
        { "FullScreenEnabled"_s, &WebPreferences::setFullScreenEnabled },
#endif
#if PLATFORM(VISION)
        { "FullscreenSceneAspectRatioLockingEnabled"_s, &WebPreferences::setFullscreenSceneAspectRatioLockingEnabled },
#endif
#if PLATFORM(VISION)
        { "FullscreenSceneDimmingEnabled"_s, &WebPreferences::setFullscreenSceneDimmingEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureAudioInGPUProcessEnabled"_s, &WebPreferences::setCaptureAudioInGPUProcessEnabled },
#endif
#if ENABLE(GPU_PROCESS)
        { "BlockMediaLayerRehostingInWebContentProcess"_s, &WebPreferences::setBlockMediaLayerRehostingInWebContentProcess },
#endif
#if ENABLE(GPU_PROCESS) && !(PLATFORM(GTK) || PLATFORM(WPE))
        { "UseGPUProcessForCanvasRenderingEnabled"_s, &WebPreferences::setUseGPUProcessForCanvasRenderingEnabled },
#endif
#if ENABLE(MEDIA_STREAM) && PLATFORM(IOS_FAMILY)
        { "ManageCaptureStatusBarInGPUProcessEnabled"_s, &WebPreferences::setManageCaptureStatusBarInGPUProcessEnabled },
#endif
#if ENABLE(GPU_PROCESS)
        { "UseGPUProcessForDOMRenderingEnabled"_s, &WebPreferences::setUseGPUProcessForDOMRenderingEnabled },
#endif
#if ENABLE(GPU_PROCESS) && !USE(GSTREAMER)
        { "UseGPUProcessForMediaEnabled"_s, &WebPreferences::setUseGPUProcessForMediaEnabled },
#endif
#if HAVE(SCREEN_CAPTURE_KIT)
        { "UseGPUProcessForDisplayCapture"_s, &WebPreferences::setUseGPUProcessForDisplayCapture },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureVideoInGPUProcessEnabled"_s, &WebPreferences::setCaptureVideoInGPUProcessEnabled },
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "UseGPUProcessForWebGLEnabled"_s, &WebPreferences::setUseGPUProcessForWebGLEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCPlatformCodecsInGPUProcessEnabled"_s, &WebPreferences::setWebRTCPlatformCodecsInGPUProcessEnabled },
#endif
#if ENABLE(GAMEPAD)
        { "GamepadTriggerRumbleEnabled"_s, &WebPreferences::setGamepadTriggerRumbleEnabled },
#endif
#if ENABLE(GAMEPAD)
        { "GamepadVibrationActuatorEnabled"_s, &WebPreferences::setGamepadVibrationActuatorEnabled },
#endif
#if ENABLE(GAMEPAD)
        { "GamepadsEnabled"_s, &WebPreferences::setGamepadsEnabled },
#endif
#if ENABLE(VIDEO)
        { "GenericCueAPIEnabled"_s, &WebPreferences::setGenericCueAPIEnabled },
#endif
#if USE(GRAPHICS_CONTEXT_FILTERS)
        { "GraphicsContextFiltersEnabled"_s, &WebPreferences::setGraphicsContextFiltersEnabled },
#endif
        { "AcceleratedDrawingEnabled"_s, &WebPreferences::setAcceleratedDrawingEnabled },
        { "DetailsNameAttributeEnabled"_s, &WebPreferences::setDetailsNameAttributeEnabled },
#if ENABLE(MODEL_ELEMENT)
        { "ModelElementEnabled"_s, &WebPreferences::setModelElementEnabled },
#endif
#if ENABLE(MODEL_ELEMENT)
        { "ModelDocumentEnabled"_s, &WebPreferences::setModelDocumentEnabled },
#endif
        { "InteractiveFormValidationEnabled"_s, &WebPreferences::setInteractiveFormValidationEnabled },
        { "InvokerAttributesEnabled"_s, &WebPreferences::setInvokerAttributesEnabled },
        { "PopoverAttributeEnabled"_s, &WebPreferences::setPopoverAttributeEnabled },
        { "SwitchControlEnabled"_s, &WebPreferences::setSwitchControlEnabled },
        { "HTTPSByDefaultEnabled"_s, &WebPreferences::setHTTPSByDefaultEnabled },
        { "HiddenPageDOMTimerThrottlingAutoIncreases"_s, &WebPreferences::setHiddenPageDOMTimerThrottlingAutoIncreases },
        { "HiddenPageDOMTimerThrottlingEnabled"_s, &WebPreferences::setHiddenPageDOMTimerThrottlingEnabled },
        { "HighlightAPIEnabled"_s, &WebPreferences::setHighlightAPIEnabled },
        { "HyperlinkAuditingEnabled"_s, &WebPreferences::setHyperlinkAuditingEnabled },
#if HAVE(SANDBOX_STATE_FLAGS)
        { "BlockIOKitInWebContentSandbox"_s, &WebPreferences::setBlockIOKitInWebContentSandbox },
#endif
#if ENABLE(IPC_TESTING_API)
        { "IPCTestingAPIEnabled"_s, &WebPreferences::setIPCTestingAPIEnabled },
#endif
        { "ItpDebugModeEnabled"_s, &WebPreferences::setItpDebugModeEnabled },
#if ENABLE(TEXT_AUTOSIZING)
        { "TextAutosizingUsesIdempotentMode"_s, &WebPreferences::setTextAutosizingUsesIdempotentMode },
#endif
#if ENABLE(IPC_TESTING_API)
        { "IgnoreInvalidMessageWhenIPCTestingAPIEnabled"_s, &WebPreferences::setIgnoreInvalidMessageWhenIPCTestingAPIEnabled },
#endif
        { "IgnoreIframeEmbeddingProtectionsEnabled"_s, &WebPreferences::setIgnoreIframeEmbeddingProtectionsEnabled },
#if ENABLE(IMAGE_ANALYSIS)
        { "ImageAnalysisDuringFindInPageEnabled"_s, &WebPreferences::setImageAnalysisDuringFindInPageEnabled },
#endif
#if ENABLE(ACCESSIBILITY_ANIMATION_CONTROL)
        { "ImageAnimationControlEnabled"_s, &WebPreferences::setImageAnimationControlEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "ImageCaptureEnabled"_s, &WebPreferences::setImageCaptureEnabled },
#endif
#if ENABLE(SERVICE_CONTROLS)
        { "ImageControlsEnabled"_s, &WebPreferences::setImageControlsEnabled },
#endif
        { "InWindowFullscreenEnabled"_s, &WebPreferences::setInWindowFullscreenEnabled },
        { "IndexedDBAPIEnabled"_s, &WebPreferences::setIndexedDBAPIEnabled },
#if ENABLE(INTERACTION_REGIONS_IN_EVENT_REGION)
        { "InteractionRegionsEnabled"_s, &WebPreferences::setInteractionRegionsEnabled },
#endif
#if ENABLE(ACCESSIBILITY_ISOLATED_TREE)
        { "IsAccessibilityIsolatedTreeEnabled"_s, &WebPreferences::setIsAccessibilityIsolatedTreeEnabled },
#endif
        { "JavaScriptEnabled"_s, &WebPreferences::setJavaScriptEnabled },
#if PLATFORM(IOS_FAMILY)
        { "KeyboardDismissalGestureEnabled"_s, &WebPreferences::setKeyboardDismissalGestureEnabled },
#endif
        { "LayerBasedSVGEngineEnabled"_s, &WebPreferences::setLayerBasedSVGEngineEnabled },
        { "LazyIframeLoadingEnabled"_s, &WebPreferences::setLazyIframeLoadingEnabled },
        { "LazyImageLoadingEnabled"_s, &WebPreferences::setLazyImageLoadingEnabled },
#if ENABLE(OVERFLOW_SCROLLING_TOUCH)
        { "LegacyOverflowScrollingTouchEnabled"_s, &WebPreferences::setLegacyOverflowScrollingTouchEnabled },
#endif
        { "LegacyLineLayoutVisualCoverageEnabled"_s, &WebPreferences::setLegacyLineLayoutVisualCoverageEnabled },
        { "ShowModalDialogEnabled"_s, &WebPreferences::setShowModalDialogEnabled },
#if ENABLE(MEDIA_STREAM)
        { "MediaCaptureRequiresSecureConnection"_s, &WebPreferences::setMediaCaptureRequiresSecureConnection },
#endif
#if ENABLE(LINEAR_MEDIA_PLAYER)
        { "LinearMediaPlayerEnabled"_s, &WebPreferences::setLinearMediaPlayerEnabled },
#endif
        { "LinkSanitizerEnabled"_s, &WebPreferences::setLinkSanitizerEnabled },
        { "LinkPreloadResponsiveImagesEnabled"_s, &WebPreferences::setLinkPreloadResponsiveImagesEnabled },
        { "LinkModulePreloadEnabled"_s, &WebPreferences::setLinkModulePreloadEnabled },
        { "LinkPreconnectEarlyHintsEnabled"_s, &WebPreferences::setLinkPreconnectEarlyHintsEnabled },
        { "LinkPrefetchEnabled"_s, &WebPreferences::setLinkPrefetchEnabled },
        { "LiveRangeSelectionEnabled"_s, &WebPreferences::setLiveRangeSelectionEnabled },
#if ENABLE(WEB_ARCHIVE)
        { "LoadWebArchiveWithEphemeralStorageEnabled"_s, &WebPreferences::setLoadWebArchiveWithEphemeralStorageEnabled },
#endif
        { "LocalFileContentSniffingEnabled"_s, &WebPreferences::setLocalFileContentSniffingEnabled },
        { "LocalStorageEnabled"_s, &WebPreferences::setLocalStorageEnabled },
        { "LockdownFontParserEnabled"_s, &WebPreferences::setLockdownFontParserEnabled },
        { "LogsPageMessagesToSystemConsoleEnabled"_s, &WebPreferences::setLogsPageMessagesToSystemConsoleEnabled },
        { "LoginStatusAPIEnabled"_s, &WebPreferences::setLoginStatusAPIEnabled },
        { "MainContentUserGestureOverrideEnabled"_s, &WebPreferences::setMainContentUserGestureOverrideEnabled },
#if ENABLE(MEDIA_SOURCE)
        { "ManagedMediaSourceEnabled"_s, &WebPreferences::setManagedMediaSourceEnabled },
#endif
#if ENABLE(MEDIA_SOURCE) && ENABLE(WIRELESS_PLAYBACK_TARGET)
        { "ManagedMediaSourceNeedsAirPlay"_s, &WebPreferences::setManagedMediaSourceNeedsAirPlay },
#endif
        { "CoreMathMLEnabled"_s, &WebPreferences::setCoreMathMLEnabled },
        { "MediaCapabilitiesExtensionsEnabled"_s, &WebPreferences::setMediaCapabilitiesExtensionsEnabled },
#if ENABLE(EXTENSION_CAPABILITIES)
        { "MediaCapabilityGrantsEnabled"_s, &WebPreferences::setMediaCapabilityGrantsEnabled },
#endif
#if ENABLE(MEDIA_SESSION)
        { "MediaSessionEnabled"_s, &WebPreferences::setMediaSessionEnabled },
#endif
        { "MediaSourceEnabled"_s, &WebPreferences::setMediaSourceEnabled },
#if ENABLE(MEDIA_STREAM)
        { "MediaDevicesEnabled"_s, &WebPreferences::setMediaDevicesEnabled },
#endif
#if ENABLE(MEDIA_RECORDER)
        { "MediaRecorderEnabled"_s, &WebPreferences::setMediaRecorderEnabled },
#endif
        { "MediaSessionCaptureToggleAPIEnabled"_s, &WebPreferences::setMediaSessionCaptureToggleAPIEnabled },
#if ENABLE(MEDIA_SOURCE_IN_WORKERS)
        { "MediaSourceInWorkerEnabled"_s, &WebPreferences::setMediaSourceInWorkerEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "MediaStreamTrackProcessingEnabled"_s, &WebPreferences::setMediaStreamTrackProcessingEnabled },
#endif
        { "MomentumScrollingAnimatorEnabled"_s, &WebPreferences::setMomentumScrollingAnimatorEnabled },
#if ENABLE(INPUT_TYPE_MONTH)
        { "InputTypeMonthEnabled"_s, &WebPreferences::setInputTypeMonthEnabled },
#endif
#if ENABLE(TOUCH_EVENTS)
        { "MouseEventsSimulationEnabled"_s, &WebPreferences::setMouseEventsSimulationEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "MuteCameraOnMicrophoneInterruptionEnabled"_s, &WebPreferences::setMuteCameraOnMicrophoneInterruptionEnabled },
#endif
        { "NavigationAPIEnabled"_s, &WebPreferences::setNavigationAPIEnabled },
#if ENABLE(APP_BOUND_DOMAINS)
        { "NeedsInAppBrowserPrivacyQuirks"_s, &WebPreferences::setNeedsInAppBrowserPrivacyQuirks },
#endif
        { "NeedsSiteSpecificQuirks"_s, &WebPreferences::setNeedsSiteSpecificQuirks },
        { "NeedsStorageAccessFromFileURLsQuirk"_s, &WebPreferences::setNeedsStorageAccessFromFileURLsQuirk },
        { "FlexFormattingContextIntegrationEnabled"_s, &WebPreferences::setFlexFormattingContextIntegrationEnabled },
#if ENABLE(NOTIFICATION_EVENT)
        { "NotificationEventEnabled"_s, &WebPreferences::setNotificationEventEnabled },
#endif
#if ENABLE(NOTIFICATIONS)
        { "NotificationsEnabled"_s, &WebPreferences::setNotificationsEnabled },
#endif
        { "ObservableEnabled"_s, &WebPreferences::setObservableEnabled },
        { "AccessibilityThreadTextApisEnabled"_s, &WebPreferences::setAccessibilityThreadTextApisEnabled },
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
        { "OffscreenCanvasInWorkersEnabled"_s, &WebPreferences::setOffscreenCanvasInWorkersEnabled },
#endif
#if ENABLE(OFFSCREEN_CANVAS)
        { "OffscreenCanvasEnabled"_s, &WebPreferences::setOffscreenCanvasEnabled },
#endif
#if ENABLE(OFFSCREEN_CANVAS)
        { "OffscreenCanvasDeprecatedCommitEnabled"_s, &WebPreferences::setOffscreenCanvasDeprecatedCommitEnabled },
#endif
        { "OpportunisticSweepingAndGarbageCollectionEnabled"_s, &WebPreferences::setOpportunisticSweepingAndGarbageCollectionEnabled },
#if ENABLE(OPUS)
        { "OpusDecoderEnabled"_s, &WebPreferences::setOpusDecoderEnabled },
#endif
        { "OverlappingBackingStoreProvidersEnabled"_s, &WebPreferences::setOverlappingBackingStoreProvidersEnabled },
        { "PageVisibilityBasedProcessSuppressionEnabled"_s, &WebPreferences::setPageVisibilityBasedProcessSuppressionEnabled },
        { "BlobRegistryTopOriginPartitioningEnabled"_s, &WebPreferences::setBlobRegistryTopOriginPartitioningEnabled },
        { "PermissionsAPIEnabled"_s, &WebPreferences::setPermissionsAPIEnabled },
#if HAVE(PHOTOS_UI)
        { "PhotoPickerPrefersOriginalImageFormat"_s, &WebPreferences::setPhotoPickerPrefersOriginalImageFormat },
#endif
        { "GetCoalescedEventsEnabled"_s, &WebPreferences::setGetCoalescedEventsEnabled },
        { "GetPredictedEventsEnabled"_s, &WebPreferences::setGetPredictedEventsEnabled },
#if ENABLE(POINTER_LOCK)
        { "PointerLockOptionsEnabled"_s, &WebPreferences::setPointerLockOptionsEnabled },
#endif
        { "PreferPageRenderingUpdatesNear60FPSEnabled"_s, &WebPreferences::setPreferPageRenderingUpdatesNear60FPSEnabled },
#if ENABLE(VIDEO)
        { "PreferSandboxedMediaParsing"_s, &WebPreferences::setPreferSandboxedMediaParsing },
#endif
        { "PrivateClickMeasurementDebugModeEnabled"_s, &WebPreferences::setPrivateClickMeasurementDebugModeEnabled },
        { "PrivateClickMeasurementFraudPreventionEnabled"_s, &WebPreferences::setPrivateClickMeasurementFraudPreventionEnabled },
        { "PrivateClickMeasurementEnabled"_s, &WebPreferences::setPrivateClickMeasurementEnabled },
        { "PrivateTokenUsageByThirdPartyEnabled"_s, &WebPreferences::setPrivateTokenUsageByThirdPartyEnabled },
#if USE(COORDINATED_GRAPHICS)
        { "PropagateDamagingInformation"_s, &WebPreferences::setPropagateDamagingInformation },
#endif
        { "PushAPIEnabled"_s, &WebPreferences::setPushAPIEnabled },
        { "LegacyPluginQuirkForMailSignaturesEnabled"_s, &WebPreferences::setLegacyPluginQuirkForMailSignaturesEnabled },
        { "GoogleAntiFlickerOptimizationQuirkEnabled"_s, &WebPreferences::setGoogleAntiFlickerOptimizationQuirkEnabled },
        { "ReadableByteStreamAPIEnabled"_s, &WebPreferences::setReadableByteStreamAPIEnabled },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        { "RemotePlaybackEnabled"_s, &WebPreferences::setRemotePlaybackEnabled },
#endif
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
        { "RemoveBackgroundEnabled"_s, &WebPreferences::setRemoveBackgroundEnabled },
#endif
        { "ReportingEnabled"_s, &WebPreferences::setReportingEnabled },
        { "RequestVideoFrameCallbackEnabled"_s, &WebPreferences::setRequestVideoFrameCallbackEnabled },
#if HAVE(SC_CONTENT_SHARING_PICKER)
        { "RequireUAGetDisplayMediaPrompt"_s, &WebPreferences::setRequireUAGetDisplayMediaPrompt },
#endif
#if ENABLE(MEDIA_STREAM)
        { "SpeakerSelectionRequiresUserGesture"_s, &WebPreferences::setSpeakerSelectionRequiresUserGesture },
#endif
        { "FullscreenRequirementForScreenOrientationLockingEnabled"_s, &WebPreferences::setFullscreenRequirementForScreenOrientationLockingEnabled },
#if ENABLE(MEDIA_STREAM)
        { "GetUserMediaRequiresFocus"_s, &WebPreferences::setGetUserMediaRequiresFocus },
#endif
        { "ResourceLoadSchedulingEnabled"_s, &WebPreferences::setResourceLoadSchedulingEnabled },
#if ENABLE(RESOURCE_USAGE)
        { "ResourceUsageOverlayVisible"_s, &WebPreferences::setResourceUsageOverlayVisible },
#endif
        { "SKAttributionEnabled"_s, &WebPreferences::setSKAttributionEnabled },
        { "SafeBrowsingEnabled"_s, &WebPreferences::setSafeBrowsingEnabled },
        { "IsSameSiteStrictEnforcementEnabled"_s, &WebPreferences::setIsSameSiteStrictEnforcementEnabled },
        { "ScreenOrientationLockingAPIEnabled"_s, &WebPreferences::setScreenOrientationLockingAPIEnabled },
        { "ScreenOrientationAPIEnabled"_s, &WebPreferences::setScreenOrientationAPIEnabled },
        { "ScreenWakeLockAPIEnabled"_s, &WebPreferences::setScreenWakeLockAPIEnabled },
#if ENABLE(MEDIA_STREAM)
        { "ScreenCaptureEnabled"_s, &WebPreferences::setScreenCaptureEnabled },
#endif
        { "ScrollingPerformanceTestingEnabled"_s, &WebPreferences::setScrollingPerformanceTestingEnabled },
        { "ScrollToTextFragmentFeatureDetectionEnabled"_s, &WebPreferences::setScrollToTextFragmentFeatureDetectionEnabled },
        { "ScrollToTextFragmentGenerationEnabled"_s, &WebPreferences::setScrollToTextFragmentGenerationEnabled },
        { "ScrollToTextFragmentIndicatorEnabled"_s, &WebPreferences::setScrollToTextFragmentIndicatorEnabled },
        { "ScrollToTextFragmentMarkingEnabled"_s, &WebPreferences::setScrollToTextFragmentMarkingEnabled },
        { "ScrollToTextFragmentEnabled"_s, &WebPreferences::setScrollToTextFragmentEnabled },
        { "ScrollAnimatorEnabled"_s, &WebPreferences::setScrollAnimatorEnabled },
        { "ScrollDrivenAnimationsEnabled"_s, &WebPreferences::setScrollDrivenAnimationsEnabled },
        { "SearchInputIncrementalAttributeAndSearchEventEnabled"_s, &WebPreferences::setSearchInputIncrementalAttributeAndSearchEventEnabled },
        { "SecureContextChecksEnabled"_s, &WebPreferences::setSecureContextChecksEnabled },
        { "SelectionAPIForShadowDOMEnabled"_s, &WebPreferences::setSelectionAPIForShadowDOMEnabled },
        { "SelectionFlippingEnabled"_s, &WebPreferences::setSelectionFlippingEnabled },
        { "SendMouseEventsToDisabledFormControlsEnabled"_s, &WebPreferences::setSendMouseEventsToDisabledFormControlsEnabled },
        { "ServiceWorkerNavigationPreloadEnabled"_s, &WebPreferences::setServiceWorkerNavigationPreloadEnabled },
        { "ServiceWorkersEnabled"_s, &WebPreferences::setServiceWorkersEnabled },
        { "ShapeDetection"_s, &WebPreferences::setShapeDetection },
        { "SharedWorkerEnabled"_s, &WebPreferences::setSharedWorkerEnabled },
        { "ShowMediaStatsContextMenuItemEnabled"_s, &WebPreferences::setShowMediaStatsContextMenuItemEnabled },
        { "SidewaysWritingModesEnabled"_s, &WebPreferences::setSidewaysWritingModesEnabled },
        { "SiteIsolationEnabled"_s, &WebPreferences::setSiteIsolationEnabled },
        { "SpeechRecognitionEnabled"_s, &WebPreferences::setSpeechRecognitionEnabled },
        { "SpeechSynthesisAPIEnabled"_s, &WebPreferences::setSpeechSynthesisAPIEnabled },
        { "StorageAPIEstimateEnabled"_s, &WebPreferences::setStorageAPIEstimateEnabled },
        { "StorageAPIEnabled"_s, &WebPreferences::setStorageAPIEnabled },
        { "ProcessSwapOnCrossSiteNavigationEnabled"_s, &WebPreferences::setProcessSwapOnCrossSiteNavigationEnabled },
        { "ShouldTakeNearSuspendedAssertions"_s, &WebPreferences::setShouldTakeNearSuspendedAssertions },
#if ENABLE(WRITING_TOOLS_UI)
        { "TextAnimationsEnabled"_s, &WebPreferences::setTextAnimationsEnabled },
#endif
#if ENABLE(IMAGE_ANALYSIS) && ENABLE(VIDEO)
        { "TextRecognitionInVideosEnabled"_s, &WebPreferences::setTextRecognitionInVideosEnabled },
#endif
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "ThreadedAnimationResolutionEnabled"_s, &WebPreferences::setThreadedAnimationResolutionEnabled },
#endif
        { "TiledScrollingIndicatorVisible"_s, &WebPreferences::setTiledScrollingIndicatorVisible },
#if ENABLE(INPUT_TYPE_TIME)
        { "InputTypeTimeEnabled"_s, &WebPreferences::setInputTypeTimeEnabled },
#endif
        { "TrackConfigurationEnabled"_s, &WebPreferences::setTrackConfigurationEnabled },
        { "TrustedTypesEnabled"_s, &WebPreferences::setTrustedTypesEnabled },
        { "UndoManagerAPIEnabled"_s, &WebPreferences::setUndoManagerAPIEnabled },
#if ENABLE(UNIFIED_PDF)
        { "UnifiedPDFEnabled"_s, &WebPreferences::setUnifiedPDFEnabled },
#endif
#if USE(COORDINATED_GRAPHICS)
        { "UnifyDamagedRegions"_s, &WebPreferences::setUnifyDamagedRegions },
#endif
        { "IPAddressAndLocalhostMixedContentUpgradeTestingEnabled"_s, &WebPreferences::setIPAddressAndLocalhostMixedContentUpgradeTestingEnabled },
        { "UpgradeKnownHostsToHTTPSEnabled"_s, &WebPreferences::setUpgradeKnownHostsToHTTPSEnabled },
        { "UpgradeMixedContentEnabled"_s, &WebPreferences::setUpgradeMixedContentEnabled },
#if ENABLE(ARKIT_INLINE_PREVIEW)
        { "UseARKitForModel"_s, &WebPreferences::setUseARKitForModel },
#endif
#if HAVE(SC_CONTENT_SHARING_PICKER)
        { "UseSCContentSharingPicker"_s, &WebPreferences::setUseSCContentSharingPicker },
#endif
#if HAVE(SCENEKIT)
        { "UseSceneKitForModel"_s, &WebPreferences::setUseSceneKitForModel },
#endif
        { "UseGiantTiles"_s, &WebPreferences::setUseGiantTiles },
        { "UserActivationAPIEnabled"_s, &WebPreferences::setUserActivationAPIEnabled },
        { "UserGesturePromisePropagationEnabled"_s, &WebPreferences::setUserGesturePromisePropagationEnabled },
        { "ServiceWorkersUserGestureEnabled"_s, &WebPreferences::setServiceWorkersUserGestureEnabled },
        { "VerifyWindowOpenUserGestureFromUIProcess"_s, &WebPreferences::setVerifyWindowOpenUserGestureFromUIProcess },
        { "VerticalFormControlsEnabled"_s, &WebPreferences::setVerticalFormControlsEnabled },
        { "ViewTransitionClassesEnabled"_s, &WebPreferences::setViewTransitionClassesEnabled },
        { "ViewTransitionTypesEnabled"_s, &WebPreferences::setViewTransitionTypesEnabled },
        { "ViewTransitionsEnabled"_s, &WebPreferences::setViewTransitionsEnabled },
        { "ViewGestureDebuggingEnabled"_s, &WebPreferences::setViewGestureDebuggingEnabled },
#if ENABLE(IMAGE_ANALYSIS)
        { "VisualTranslationEnabled"_s, &WebPreferences::setVisualTranslationEnabled },
#endif
        { "VisualViewportAPIEnabled"_s, &WebPreferences::setVisualViewportAPIEnabled },
#if ENABLE(VORBIS)
        { "VorbisDecoderEnabled"_s, &WebPreferences::setVorbisDecoderEnabled },
#endif
        { "WebAPIStatisticsEnabled"_s, &WebPreferences::setWebAPIStatisticsEnabled },
        { "WebAPIsInShadowRealmEnabled"_s, &WebPreferences::setWebAPIsInShadowRealmEnabled },
        { "WebAnimationsCustomEffectsEnabled"_s, &WebPreferences::setWebAnimationsCustomEffectsEnabled },
        { "WebAnimationsCustomFrameRateEnabled"_s, &WebPreferences::setWebAnimationsCustomFrameRateEnabled },
#if ENABLE(WEB_ARCHIVE)
        { "WebArchiveDebugModeEnabled"_s, &WebPreferences::setWebArchiveDebugModeEnabled },
#endif
#if ENABLE(WEB_ARCHIVE)
        { "WebArchiveTestingModeEnabled"_s, &WebPreferences::setWebArchiveTestingModeEnabled },
#endif
#if HAVE(WEB_AUTHN_AS_MODERN)
        { "WebAuthenticationASEnabled"_s, &WebPreferences::setWebAuthenticationASEnabled },
#endif
#if ENABLE(WEB_AUTHN)
        { "WebAuthenticationEnabled"_s, &WebPreferences::setWebAuthenticationEnabled },
#endif
        { "WebCryptoSafeCurvesEnabled"_s, &WebPreferences::setWebCryptoSafeCurvesEnabled },
        { "WebCryptoX25519Enabled"_s, &WebPreferences::setWebCryptoX25519Enabled },
        { "WebLocksAPIEnabled"_s, &WebPreferences::setWebLocksAPIEnabled },
        { "WebShareFileAPIEnabled"_s, &WebPreferences::setWebShareFileAPIEnabled },
        { "WebShareEnabled"_s, &WebPreferences::setWebShareEnabled },
#if ENABLE(WEBASSEMBLY)
        { "WebAssemblyESMIntegrationEnabled"_s, &WebPreferences::setWebAssemblyESMIntegrationEnabled },
#endif
#if ENABLE(WEB_CODECS)
        { "WebCodecsAV1Enabled"_s, &WebPreferences::setWebCodecsAV1Enabled },
#endif
#if ENABLE(WEB_CODECS)
        { "WebCodecsAudioEnabled"_s, &WebPreferences::setWebCodecsAudioEnabled },
#endif
#if ENABLE(WEB_CODECS)
        { "WebCodecsHEVCEnabled"_s, &WebPreferences::setWebCodecsHEVCEnabled },
#endif
#if ENABLE(WEB_CODECS)
        { "WebCodecsVideoEnabled"_s, &WebPreferences::setWebCodecsVideoEnabled },
#endif
#if ENABLE(WK_WEB_EXTENSIONS_SIDEBAR)
        { "WebExtensionSidebarEnabled"_s, &WebPreferences::setWebExtensionSidebarEnabled },
#endif
        { "WebGLDraftExtensionsEnabled"_s, &WebPreferences::setWebGLDraftExtensionsEnabled },
        { "WebGLTimerQueriesEnabled"_s, &WebPreferences::setWebGLTimerQueriesEnabled },
        { "WebGLEnabled"_s, &WebPreferences::setWebGLEnabled },
        { "WebXRWebGPUBindingsEnabled"_s, &WebPreferences::setWebXRWebGPUBindingsEnabled },
        { "WebGPUEnabled"_s, &WebPreferences::setWebGPUEnabled },
        { "WebInspectorEngineeringSettingsAllowed"_s, &WebPreferences::setWebInspectorEngineeringSettingsAllowed },
#if ENABLE(WEB_RTC)
        { "WebRTCAV1CodecEnabled"_s, &WebPreferences::setWebRTCAV1CodecEnabled },
#endif
        { "WebRTCAudioLatencyAdaptationEnabled"_s, &WebPreferences::setWebRTCAudioLatencyAdaptationEnabled },
#if ENABLE(WEB_RTC)
        { "WebRTCDTMFEnabled"_s, &WebPreferences::setWebRTCDTMFEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCEncodedTransformEnabled"_s, &WebPreferences::setWebRTCEncodedTransformEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH264HardwareEncoderEnabled"_s, &WebPreferences::setWebRTCH264HardwareEncoderEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH265CodecEnabled"_s, &WebPreferences::setWebRTCH265CodecEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCL4SEnabled"_s, &WebPreferences::setWebRTCL4SEnabled },
#endif
        { "WebRTCMediaPipelineAdditionalLoggingEnabled"_s, &WebPreferences::setWebRTCMediaPipelineAdditionalLoggingEnabled },
#if ENABLE(WEB_RTC)
        { "LegacyWebRTCOfferOptionsEnabled"_s, &WebPreferences::setLegacyWebRTCOfferOptionsEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "PeerConnectionVideoScalingAdaptationDisabled"_s, &WebPreferences::setPeerConnectionVideoScalingAdaptationDisabled },
#endif
#if ENABLE(WEB_RTC)
        { "PeerConnectionEnabled"_s, &WebPreferences::setPeerConnectionEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCRemoteVideoFrameEnabled"_s, &WebPreferences::setWebRTCRemoteVideoFrameEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCSFrameTransformEnabled"_s, &WebPreferences::setWebRTCSFrameTransformEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCSocketsProxyingEnabled"_s, &WebPreferences::setWebRTCSocketsProxyingEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCVP9Profile0CodecEnabled"_s, &WebPreferences::setWebRTCVP9Profile0CodecEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCVP9Profile2CodecEnabled"_s, &WebPreferences::setWebRTCVP9Profile2CodecEnabled },
#endif
        { "WebTransportEnabled"_s, &WebPreferences::setWebTransportEnabled },
#if ENABLE(WEBXR)
        { "WebXRAugmentedRealityModuleEnabled"_s, &WebPreferences::setWebXRAugmentedRealityModuleEnabled },
#endif
#if ENABLE(WEBXR)
        { "WebXREnabled"_s, &WebPreferences::setWebXREnabled },
#endif
#if ENABLE(WEBXR)
        { "WebXRGamepadsModuleEnabled"_s, &WebPreferences::setWebXRGamepadsModuleEnabled },
#endif
#if ENABLE(WEBXR_HANDS)
        { "WebXRHandInputModuleEnabled"_s, &WebPreferences::setWebXRHandInputModuleEnabled },
#endif
#if ENABLE(WEBXR_LAYERS)
        { "WebXRLayersAPIEnabled"_s, &WebPreferences::setWebXRLayersAPIEnabled },
#endif
#if ENABLE(INPUT_TYPE_WEEK)
        { "InputTypeWeekEnabled"_s, &WebPreferences::setInputTypeWeekEnabled },
#endif
        { "WheelEventGesturesBecomeNonBlocking"_s, &WebPreferences::setWheelEventGesturesBecomeNonBlocking },
        { "PassiveWheelListenersAsDefaultOnDocument"_s, &WebPreferences::setPassiveWheelListenersAsDefaultOnDocument },
#if PLATFORM(COCOA)
        { "WriteRichTextDataWhenCopyingOrDragging"_s, &WebPreferences::setWriteRichTextDataWhenCopyingOrDragging },
#endif
#if ENABLE(WRITING_SUGGESTIONS)
        { "WritingSuggestionsAttributeEnabled"_s, &WebPreferences::setWritingSuggestionsAttributeEnabled },
#endif
        { "IsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled"_s, &WebPreferences::setIsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled },
        { "IsFirstPartyWebsiteDataRemovalReproTestingEnabled"_s, &WebPreferences::setIsFirstPartyWebsiteDataRemovalReproTestingEnabled },
        { "AlignContentOnBlocksEnabled"_s, &WebPreferences::setAlignContentOnBlocksEnabled },
        { "AltitudeAngleEnabled"_s, &WebPreferences::setAltitudeAngleEnabled },
        { "AzimuthAngleEnabled"_s, &WebPreferences::setAzimuthAngleEnabled },
#if ENABLE(INPUT_TYPE_DATETIMELOCAL)
        { "InputTypeDateTimeLocalEnabled"_s, &WebPreferences::setInputTypeDateTimeLocalEnabled },
#endif
        { "ElementCheckVisibilityEnabled"_s, &WebPreferences::setElementCheckVisibilityEnabled },
        { "HTTPEquivEnabled"_s, &WebPreferences::setHTTPEquivEnabled },
        { "RequestIdleCallbackEnabled"_s, &WebPreferences::setRequestIdleCallbackEnabled },
        { "RequestStorageAccessThrowsExceptionUntilReload"_s, &WebPreferences::setRequestStorageAccessThrowsExceptionUntilReload },
        { "CSSWordBreakAutoPhraseEnabled"_s, &WebPreferences::setCSSWordBreakAutoPhraseEnabled },
    };

    for (auto& setter : setters) {
        if (key == setter.name) {
            (this->*setter.function)(value);
            return;
        }
    }
}

void WebPreferences::enableAllExperimentalFeatures()
{
    UpdateBatch batch(*this);
    setGrammarAndSpellingPseudoElementsEnabled(true);
    setTargetTextPseudoElementEnabled(true);
    setThumbAndTrackPseudoElementsEnabled(true);
    setSelectShowPickerEnabled(true);
    setPageAtRuleMarginDescriptorsEnabled(true);
    setAbortSignalAnyOperationEnabled(true);
    setAccessHandleEnabled(true);
#if ENABLE(WEBGL)
    setAllowWebGLInWorkers(true);
#endif
#if ENABLE(MEDIA_STREAM)
    setPerElementSpeakerSelectionEnabled(true);
#endif
#if ENABLE(MEDIA_STREAM)
    setExposeSpeakersEnabled(true);
#endif
#if ENABLE(ALTERNATE_WEBM_PLAYER) && ENABLE(MEDIA_SOURCE)
    setAlternateWebMPlayerEnabled(true);
#endif
    setAsyncClipboardAPIEnabled(true);
#if ENABLE(VIDEO)
    setExtendedAudioDescriptionsEnabled(true);
#endif
#if ENABLE(VIDEO)
    setAudioDescriptionsEnabled(true);
#endif
#if ENABLE(DOM_AUDIO_SESSION)
    setDOMAudioSessionEnabled(true);
#endif
#if ENABLE(DOM_AUDIO_SESSION)
    setDOMAudioSessionFullEnabled(true);
#endif
    setBeaconAPIEnabled(true);
    setBroadcastChannelEnabled(true);
    setBroadcastChannelOriginPartitioningEnabled(true);
    setCSS3DTransformBackfaceVisibilityInteroperabilityEnabled(true);
    setCSSCounterStyleAtRuleImageSymbolsEnabled(true);
    setCSSCounterStyleAtRulesEnabled(true);
    setCSSFontFaceSizeAdjustEnabled(true);
    setCSSStartingStyleAtRuleEnabled(true);
    setAccentColorEnabled(true);
    setCSSAnchorPositioningEnabled(true);
    setCSSContentVisibilityEnabled(true);
    setCSSInputSecurityEnabled(true);
    setMasonryEnabled(true);
    setCSSMotionPathEnabled(true);
    setCSSNestingEnabled(true);
    setOverscrollBehaviorEnabled(true);
    setCSSPaintingAPIEnabled(true);
    setCSSRhythmicSizingEnabled(true);
    setCSSScopeAtRuleEnabled(true);
    setCSSScrollAnchoringEnabled(true);
    setCSSTypedOMColorEnabled(true);
    setCSSBackgroundClipBorderAreaEnabled(true);
    setCSSColorContrastEnabled(true);
    setCSSColorLayersEnabled(true);
    setCSSDPropertyEnabled(true);
    setCSSFieldSizingEnabled(true);
    setCSSFontVariantEmojiEnabled(true);
    setCSSLightDarkEnabled(true);
    setCSSMarginTrimEnabled(true);
    setCSSRubyAlignEnabled(true);
    setCSSScrollbarColorEnabled(true);
    setCSSScrollbarGutterEnabled(true);
    setCSSScrollbarWidthEnabled(true);
    setCSSShapeFunctionEnabled(true);
    setCSSStyleQueriesEnabled(true);
    setCSSTextAutospaceEnabled(true);
    setCSSTextBoxTrimEnabled(true);
    setCSSTextGroupAlignEnabled(true);
    setCSSTextJustifyEnabled(true);
    setCSSTextSpacingEnabled(true);
    setCSSTextUnderlinePositionLeftRightEnabled(true);
    setCSSTextWrapStyleEnabled(true);
    setCSSTextWrapPrettyEnabled(true);
    setCSSOMViewScrollingAPIEnabled(true);
    setCSSOMViewSmoothScrollingEnabled(true);
    setCanvasColorSpaceEnabled(true);
    setCanvasFiltersEnabled(true);
    setCanvasLayersEnabled(true);
    setClearSiteDataHTTPHeaderEnabled(true);
    setCompressionStreamEnabled(true);
    setContactPickerAPIEnabled(true);
    setCookieStoreManagerEnabled(true);
    setCookieStoreAPIExtendedAttributesEnabled(true);
    setCookieStoreAPIEnabled(true);
    setCrossDocumentViewTransitionsEnabled(true);
    setCrossOriginEmbedderPolicyEnabled(true);
    setCrossOriginOpenerPolicyEnabled(true);
    setCustomStateSetEnabled(true);
    setDeclarativeShadowRootsParserAPIsEnabled(true);
    setDeclarativeShadowRootsSerializerAPIsEnabled(true);
    setShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint(true);
    setDeprecateAESCFBWebCryptoEnabled(true);
    setDeprecateRSAESPKCSWebCryptoEnabled(true);
    setDeprecationReportingEnabled(true);
    setUAVisualTransitionDetectionEnabled(true);
    setDigitalCredentialsEnabled(true);
    setDisallowSyncXHRDuringPageDismissalEnabled(true);
    setEmbedElementEnabled(true);
    setCanvasFingerprintingQuirkEnabled(true);
#if ENABLE(PDFJS)
    setPDFJSViewerEnabled(true);
#endif
    setAuxclickEventEnabled(true);
    setBackgroundFetchAPIEnabled(true);
#if HAVE(NETWORK_LOADER)
    setCFNetworkNetworkLoaderEnabled(true);
#endif
    setBlobFileAccessEnforcementEnabled(true);
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    setMediaSessionCoordinatorEnabled(true);
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR) && ENABLE(MEDIA_SESSION_PLAYLIST)
    setMediaSessionPlaylistEnabled(true);
#endif
#if ENABLE(MEDIA_SOURCE) && (HAVE(AVSAMPLEBUFFERVIDEOOUTPUT) || USE(GSTREAMER))
    setMediaSourceInlinePaintingEnabled(true);
#endif
    setFetchPriorityEnabled(true);
    setFileSystemAccessEnabled(true);
    setFilterLinkDecorationByDefaultEnabled(true);
#if ENABLE(FULLSCREEN_API)
    setFullScreenKeyboardLock(true);
#endif
#if ENABLE(GPU_PROCESS) && !(PLATFORM(GTK) || PLATFORM(WPE))
    setUseGPUProcessForCanvasRenderingEnabled(true);
#endif
#if ENABLE(GPU_PROCESS)
    setUseGPUProcessForDOMRenderingEnabled(true);
#endif
#if HAVE(SCREEN_CAPTURE_KIT)
    setUseGPUProcessForDisplayCapture(true);
#endif
#if ENABLE(GAMEPAD)
    setGamepadTriggerRumbleEnabled(true);
#endif
#if ENABLE(GAMEPAD)
    setGamepadVibrationActuatorEnabled(true);
#endif
#if ENABLE(VIDEO)
    setGenericCueAPIEnabled(true);
#endif
#if USE(GRAPHICS_CONTEXT_FILTERS)
    setGraphicsContextFiltersEnabled(true);
#endif
    setDetailsNameAttributeEnabled(true);
#if ENABLE(MODEL_ELEMENT)
    setModelElementEnabled(true);
#endif
#if ENABLE(MODEL_ELEMENT)
    setModelDocumentEnabled(true);
#endif
    setInvokerAttributesEnabled(true);
    setPopoverAttributeEnabled(true);
    setSwitchControlEnabled(true);
    setHTTPSByDefaultEnabled(true);
    setHighlightAPIEnabled(true);
#if ENABLE(ACCESSIBILITY_ANIMATION_CONTROL)
    setImageAnimationControlEnabled(true);
#endif
#if ENABLE(MEDIA_STREAM)
    setImageCaptureEnabled(true);
#endif
    setJavaScriptEnabled(true);
    setLazyIframeLoadingEnabled(true);
    setLazyImageLoadingEnabled(true);
    setLinkPreloadResponsiveImagesEnabled(true);
    setLinkModulePreloadEnabled(true);
    setLinkPreconnectEarlyHintsEnabled(true);
    setLinkPrefetchEnabled(true);
    setLiveRangeSelectionEnabled(true);
#if ENABLE(WEB_ARCHIVE)
    setLoadWebArchiveWithEphemeralStorageEnabled(true);
#endif
    setLocalStorageEnabled(true);
    setLockdownFontParserEnabled(true);
    setLoginStatusAPIEnabled(true);
#if ENABLE(MEDIA_SOURCE)
    setManagedMediaSourceEnabled(true);
#endif
#if ENABLE(MEDIA_SOURCE) && ENABLE(WIRELESS_PLAYBACK_TARGET)
    setManagedMediaSourceNeedsAirPlay(true);
#endif
    setMediaCapabilitiesExtensionsEnabled(true);
#if ENABLE(MEDIA_SESSION)
    setMediaSessionEnabled(true);
#endif
#if ENABLE(MEDIA_RECORDER)
    setMediaRecorderEnabled(true);
#endif
    setMediaSessionCaptureToggleAPIEnabled(true);
#if ENABLE(MEDIA_SOURCE_IN_WORKERS)
    setMediaSourceInWorkerEnabled(true);
#endif
#if ENABLE(MEDIA_STREAM)
    setMediaStreamTrackProcessingEnabled(true);
#endif
    setNavigationAPIEnabled(true);
#if ENABLE(NOTIFICATIONS)
    setNotificationsEnabled(true);
#endif
    setObservableEnabled(true);
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
    setOffscreenCanvasInWorkersEnabled(true);
#endif
#if ENABLE(OFFSCREEN_CANVAS)
    setOffscreenCanvasEnabled(true);
#endif
#if ENABLE(OFFSCREEN_CANVAS)
    setOffscreenCanvasDeprecatedCommitEnabled(true);
#endif
#if ENABLE(OPUS)
    setOpusDecoderEnabled(true);
#endif
    setOverlappingBackingStoreProvidersEnabled(true);
    setBlobRegistryTopOriginPartitioningEnabled(true);
    setPermissionsAPIEnabled(true);
    setGetCoalescedEventsEnabled(true);
    setGetPredictedEventsEnabled(true);
#if ENABLE(POINTER_LOCK)
    setPointerLockOptionsEnabled(true);
#endif
    setPreferPageRenderingUpdatesNear60FPSEnabled(true);
    setPrivateClickMeasurementFraudPreventionEnabled(true);
    setPrivateTokenUsageByThirdPartyEnabled(true);
#if USE(COORDINATED_GRAPHICS)
    setPropagateDamagingInformation(true);
#endif
    setGoogleAntiFlickerOptimizationQuirkEnabled(true);
    setReadableByteStreamAPIEnabled(true);
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    setRemotePlaybackEnabled(true);
#endif
    setReportingEnabled(true);
    setRequestVideoFrameCallbackEnabled(true);
    setScreenOrientationLockingAPIEnabled(true);
    setScreenOrientationAPIEnabled(true);
    setScreenWakeLockAPIEnabled(true);
#if ENABLE(MEDIA_STREAM)
    setScreenCaptureEnabled(true);
#endif
    setScrollToTextFragmentFeatureDetectionEnabled(true);
    setScrollToTextFragmentGenerationEnabled(true);
    setScrollToTextFragmentEnabled(true);
    setScrollDrivenAnimationsEnabled(true);
    setSelectionAPIForShadowDOMEnabled(true);
    setSendMouseEventsToDisabledFormControlsEnabled(true);
    setServiceWorkerNavigationPreloadEnabled(true);
    setServiceWorkersEnabled(true);
    setShapeDetection(true);
    setSharedWorkerEnabled(true);
    setSidewaysWritingModesEnabled(true);
    setSpeechRecognitionEnabled(true);
    setStorageAPIEstimateEnabled(true);
    setStorageAPIEnabled(true);
    setProcessSwapOnCrossSiteNavigationEnabled(true);
    setTrackConfigurationEnabled(true);
    setTrustedTypesEnabled(true);
#if USE(COORDINATED_GRAPHICS)
    setUnifyDamagedRegions(true);
#endif
    setIPAddressAndLocalhostMixedContentUpgradeTestingEnabled(true);
    setUpgradeMixedContentEnabled(true);
    setUserActivationAPIEnabled(true);
    setVerifyWindowOpenUserGestureFromUIProcess(true);
    setVerticalFormControlsEnabled(true);
    setViewTransitionClassesEnabled(true);
    setViewTransitionTypesEnabled(true);
    setViewTransitionsEnabled(true);
    setVisualViewportAPIEnabled(true);
#if ENABLE(VORBIS)
    setVorbisDecoderEnabled(true);
#endif
    setWebAnimationsCustomEffectsEnabled(true);
    setWebAnimationsCustomFrameRateEnabled(true);
    setWebCryptoSafeCurvesEnabled(true);
    setWebCryptoX25519Enabled(true);
    setWebLocksAPIEnabled(true);
    setWebShareFileAPIEnabled(true);
#if ENABLE(WEBASSEMBLY)
    setWebAssemblyESMIntegrationEnabled(true);
#endif
#if ENABLE(WEB_CODECS)
    setWebCodecsAV1Enabled(true);
#endif
#if ENABLE(WEB_CODECS)
    setWebCodecsAudioEnabled(true);
#endif
#if ENABLE(WEB_CODECS)
    setWebCodecsHEVCEnabled(true);
#endif
#if ENABLE(WEB_CODECS)
    setWebCodecsVideoEnabled(true);
#endif
#if ENABLE(WK_WEB_EXTENSIONS_SIDEBAR)
    setWebExtensionSidebarEnabled(true);
#endif
    setWebGLDraftExtensionsEnabled(true);
    setWebGLEnabled(true);
#if ENABLE(WEB_RTC)
    setWebRTCAV1CodecEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCEncodedTransformEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCH265CodecEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCL4SEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCSFrameTransformEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCVP9Profile2CodecEnabled(true);
#endif
    setWebTransportEnabled(true);
#if ENABLE(WEBXR)
    setWebXRAugmentedRealityModuleEnabled(true);
#endif
#if ENABLE(WEBXR)
    setWebXREnabled(true);
#endif
#if ENABLE(WEBXR)
    setWebXRGamepadsModuleEnabled(true);
#endif
#if ENABLE(WEBXR_HANDS)
    setWebXRHandInputModuleEnabled(true);
#endif
    setWheelEventGesturesBecomeNonBlocking(true);
#if ENABLE(WRITING_SUGGESTIONS)
    setWritingSuggestionsAttributeEnabled(true);
#endif
    setAlignContentOnBlocksEnabled(true);
    setAltitudeAngleEnabled(true);
    setAzimuthAngleEnabled(true);
    setElementCheckVisibilityEnabled(true);
    setHTTPEquivEnabled(true);
    setRequestIdleCallbackEnabled(true);
    setCSSWordBreakAutoPhraseEnabled(true);
}

void WebPreferences::resetAllInternalDebugFeatures()
{
    UpdateBatch batch(*this);
#if USE(CORE_IMAGE)
    setAcceleratedFiltersEnabled(DEFAULT_VALUE_FOR_AcceleratedFiltersEnabled);
#endif
    setDOMTestingAPIsEnabled(DEFAULT_VALUE_FOR_DOMTestingAPIsEnabled);
#if PLATFORM(IOS_FAMILY)
    setAllowViewportShrinkToFitContent(DEFAULT_VALUE_FOR_AllowViewportShrinkToFitContent);
#endif
#if ENABLE(WEB_ARCHIVE)
    setAlwaysAllowLocalWebarchive(DEFAULT_VALUE_FOR_AlwaysAllowLocalWebarchive);
#endif
#if ENABLE(VP9)
    setSWVPDecodersAlwaysEnabled(DEFAULT_VALUE_FOR_SWVPDecodersAlwaysEnabled);
#endif
    setAppBadgeEnabled(DEFAULT_VALUE_FOR_AppBadgeEnabled);
#if ENABLE(APP_HIGHLIGHTS)
    setAppHighlightsEnabled(DEFAULT_VALUE_FOR_AppHighlightsEnabled);
#endif
    setAsyncFrameScrollingEnabled(DEFAULT_VALUE_FOR_AsyncFrameScrollingEnabled);
    setAsyncOverflowScrollingEnabled(DEFAULT_VALUE_FOR_AsyncOverflowScrollingEnabled);
#if PLATFORM(IOS_FAMILY)
    setUseAsyncUIKitInteractions(DEFAULT_VALUE_FOR_UseAsyncUIKitInteractions);
#endif
    setAutomaticallyAdjustsViewScaleUsingMinimumEffectiveDeviceWidth(DEFAULT_VALUE_FOR_AutomaticallyAdjustsViewScaleUsingMinimumEffectiveDeviceWidth);
#if ENABLE(WEB_PUSH_NOTIFICATIONS)
    setBuiltInNotificationsEnabled(DEFAULT_VALUE_FOR_BuiltInNotificationsEnabled);
#endif
    setSpringTimingFunctionEnabled(DEFAULT_VALUE_FOR_SpringTimingFunctionEnabled);
#if ENABLE(CSS_TRANSFORM_STYLE_OPTIMIZED_3D)
    setCSSTransformStyleOptimized3DEnabled(DEFAULT_VALUE_FOR_CSSTransformStyleOptimized3DEnabled);
#endif
#if ENABLE(MEDIA_STREAM)
    setCaptureAudioInUIProcessEnabled(DEFAULT_VALUE_FOR_CaptureAudioInUIProcessEnabled);
#endif
#if ENABLE(MEDIA_STREAM)
    setCaptureVideoInUIProcessEnabled(DEFAULT_VALUE_FOR_CaptureVideoInUIProcessEnabled);
#endif
    setChildProcessDebuggabilityEnabled(DEFAULT_VALUE_FOR_ChildProcessDebuggabilityEnabled);
    setClientBadgeEnabled(DEFAULT_VALUE_FOR_ClientBadgeEnabled);
    setCompositingBordersVisible(DEFAULT_VALUE_FOR_CompositingBordersVisible);
    setCompositingRepaintCountersVisible(DEFAULT_VALUE_FOR_CompositingRepaintCountersVisible);
#if HAVE(AVCONTENTKEYSPECIFIER)
    setSampleBufferContentKeySessionSupportEnabled(DEFAULT_VALUE_FOR_SampleBufferContentKeySessionSupportEnabled);
#endif
    setCookieConsentAPIEnabled(DEFAULT_VALUE_FOR_CookieConsentAPIEnabled);
    setDOMPasteAccessRequestsEnabled(DEFAULT_VALUE_FOR_DOMPasteAccessRequestsEnabled);
#if PLATFORM(IOS_FAMILY)
    setZoomOnDoubleTapWhenRoot(DEFAULT_VALUE_FOR_ZoomOnDoubleTapWhenRoot);
#endif
#if PLATFORM(IOS_FAMILY)
    setAlwaysZoomOnDoubleTap(DEFAULT_VALUE_FOR_AlwaysZoomOnDoubleTap);
#endif
#if ENABLE(DECLARATIVE_WEB_PUSH)
    setDeclarativeWebPush(DEFAULT_VALUE_FOR_DeclarativeWebPush);
#endif
#if PLATFORM(IOS_FAMILY)
    setDisableScreenSizeOverride(DEFAULT_VALUE_FOR_DisableScreenSizeOverride);
#endif
    setShouldDropNearSuspendedAssertionAfterDelay(DEFAULT_VALUE_FOR_ShouldDropNearSuspendedAssertionAfterDelay);
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
    setUseCGDisplayListsForDOMRendering(DEFAULT_VALUE_FOR_UseCGDisplayListsForDOMRendering);
#endif
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
    setReplayCGDisplayListsIntoBackingStore(DEFAULT_VALUE_FOR_ReplayCGDisplayListsIntoBackingStore);
#endif
#if PLATFORM(IOS_FAMILY)
    setAutomaticLiveResizeEnabled(DEFAULT_VALUE_FOR_AutomaticLiveResizeEnabled);
#endif
    setCryptoKitEnabled(DEFAULT_VALUE_FOR_CryptoKitEnabled);
    setEnumeratingAllNetworkInterfacesEnabled(DEFAULT_VALUE_FOR_EnumeratingAllNetworkInterfacesEnabled);
    setEnumeratingVisibleNetworkInterfacesEnabled(DEFAULT_VALUE_FOR_EnumeratingVisibleNetworkInterfacesEnabled);
    setICECandidateFilteringEnabled(DEFAULT_VALUE_FOR_ICECandidateFilteringEnabled);
#if ENABLE(MEDIA_STREAM)
    setMockCaptureDevicesEnabled(DEFAULT_VALUE_FOR_MockCaptureDevicesEnabled);
#endif
#if ENABLE(MODEL_PROCESS)
    setModelProcessEnabled(DEFAULT_VALUE_FOR_ModelProcessEnabled);
#endif
#if PLATFORM(MAC) && USE(RUNNINGBOARD)
    setBackgroundWebContentRunningBoardThrottlingEnabled(DEFAULT_VALUE_FOR_BackgroundWebContentRunningBoardThrottlingEnabled);
#endif
#if HAVE(MACH_BOOTSTRAP_EXTENSION) || HAVE(SANDBOX_STATE_FLAGS)
    setExperimentalSandboxEnabled(DEFAULT_VALUE_FOR_ExperimentalSandboxEnabled);
#endif
    setEnterKeyHintEnabled(DEFAULT_VALUE_FOR_EnterKeyHintEnabled);
    setEventHandlerDrivenSmoothKeyboardScrollingEnabled(DEFAULT_VALUE_FOR_EventHandlerDrivenSmoothKeyboardScrollingEnabled);
#if PLATFORM(IOS_FAMILY)
    setPreferFasterClickOverDoubleTap(DEFAULT_VALUE_FOR_PreferFasterClickOverDoubleTap);
#endif
#if PLATFORM(IOS_FAMILY)
    setFasterClicksEnabled(DEFAULT_VALUE_FOR_FasterClicksEnabled);
#endif
    setRestrictedHTTPResponseAccess(DEFAULT_VALUE_FOR_RestrictedHTTPResponseAccess);
#if PLATFORM(IOS_FAMILY)
    setForceAlwaysUserScalable(DEFAULT_VALUE_FOR_ForceAlwaysUserScalable);
#endif
#if PLATFORM(VISION)
    setFullscreenSceneAspectRatioLockingEnabled(DEFAULT_VALUE_FOR_FullscreenSceneAspectRatioLockingEnabled);
#endif
#if PLATFORM(VISION)
    setFullscreenSceneDimmingEnabled(DEFAULT_VALUE_FOR_FullscreenSceneDimmingEnabled);
#endif
#if ENABLE(MEDIA_STREAM)
    setCaptureAudioInGPUProcessEnabled(DEFAULT_VALUE_FOR_CaptureAudioInGPUProcessEnabled);
#endif
#if ENABLE(GPU_PROCESS)
    setBlockMediaLayerRehostingInWebContentProcess(DEFAULT_VALUE_FOR_BlockMediaLayerRehostingInWebContentProcess);
#endif
#if ENABLE(MEDIA_STREAM) && PLATFORM(IOS_FAMILY)
    setManageCaptureStatusBarInGPUProcessEnabled(DEFAULT_VALUE_FOR_ManageCaptureStatusBarInGPUProcessEnabled);
#endif
#if ENABLE(MEDIA_STREAM)
    setCaptureVideoInGPUProcessEnabled(DEFAULT_VALUE_FOR_CaptureVideoInGPUProcessEnabled);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
    setUseGPUProcessForWebGLEnabled(DEFAULT_VALUE_FOR_UseGPUProcessForWebGLEnabled);
#endif
    setAcceleratedDrawingEnabled(DEFAULT_VALUE_FOR_AcceleratedDrawingEnabled);
#if HAVE(SANDBOX_STATE_FLAGS)
    setBlockIOKitInWebContentSandbox(DEFAULT_VALUE_FOR_BlockIOKitInWebContentSandbox);
#endif
#if ENABLE(IPC_TESTING_API)
    setIPCTestingAPIEnabled(DEFAULT_VALUE_FOR_IPCTestingAPIEnabled);
#endif
#if ENABLE(IPC_TESTING_API)
    setIgnoreInvalidMessageWhenIPCTestingAPIEnabled(DEFAULT_VALUE_FOR_IgnoreInvalidMessageWhenIPCTestingAPIEnabled);
#endif
    setIgnoreIframeEmbeddingProtectionsEnabled(DEFAULT_VALUE_FOR_IgnoreIframeEmbeddingProtectionsEnabled);
#if ENABLE(IMAGE_ANALYSIS)
    setImageAnalysisDuringFindInPageEnabled(DEFAULT_VALUE_FOR_ImageAnalysisDuringFindInPageEnabled);
#endif
#if ENABLE(SERVICE_CONTROLS)
    setImageControlsEnabled(DEFAULT_VALUE_FOR_ImageControlsEnabled);
#endif
    setInWindowFullscreenEnabled(DEFAULT_VALUE_FOR_InWindowFullscreenEnabled);
#if ENABLE(INTERACTION_REGIONS_IN_EVENT_REGION)
    setInteractionRegionsEnabled(DEFAULT_VALUE_FOR_InteractionRegionsEnabled);
#endif
#if PLATFORM(IOS_FAMILY)
    setKeyboardDismissalGestureEnabled(DEFAULT_VALUE_FOR_KeyboardDismissalGestureEnabled);
#endif
    setLayerBasedSVGEngineEnabled(DEFAULT_VALUE_FOR_LayerBasedSVGEngineEnabled);
#if ENABLE(OVERFLOW_SCROLLING_TOUCH)
    setLegacyOverflowScrollingTouchEnabled(DEFAULT_VALUE_FOR_LegacyOverflowScrollingTouchEnabled);
#endif
    setLegacyLineLayoutVisualCoverageEnabled(DEFAULT_VALUE_FOR_LegacyLineLayoutVisualCoverageEnabled);
#if ENABLE(MEDIA_STREAM)
    setMediaCaptureRequiresSecureConnection(DEFAULT_VALUE_FOR_MediaCaptureRequiresSecureConnection);
#endif
#if ENABLE(LINEAR_MEDIA_PLAYER)
    setLinearMediaPlayerEnabled(DEFAULT_VALUE_FOR_LinearMediaPlayerEnabled);
#endif
    setLinkSanitizerEnabled(DEFAULT_VALUE_FOR_LinkSanitizerEnabled);
    setLocalFileContentSniffingEnabled(DEFAULT_VALUE_FOR_LocalFileContentSniffingEnabled);
    setLogsPageMessagesToSystemConsoleEnabled(DEFAULT_VALUE_FOR_LogsPageMessagesToSystemConsoleEnabled);
    setCoreMathMLEnabled(DEFAULT_VALUE_FOR_CoreMathMLEnabled);
    setMomentumScrollingAnimatorEnabled(DEFAULT_VALUE_FOR_MomentumScrollingAnimatorEnabled);
#if ENABLE(TOUCH_EVENTS)
    setMouseEventsSimulationEnabled(DEFAULT_VALUE_FOR_MouseEventsSimulationEnabled);
#endif
#if ENABLE(MEDIA_STREAM)
    setMuteCameraOnMicrophoneInterruptionEnabled(DEFAULT_VALUE_FOR_MuteCameraOnMicrophoneInterruptionEnabled);
#endif
#if ENABLE(APP_BOUND_DOMAINS)
    setNeedsInAppBrowserPrivacyQuirks(DEFAULT_VALUE_FOR_NeedsInAppBrowserPrivacyQuirks);
#endif
    setFlexFormattingContextIntegrationEnabled(DEFAULT_VALUE_FOR_FlexFormattingContextIntegrationEnabled);
#if ENABLE(NOTIFICATION_EVENT)
    setNotificationEventEnabled(DEFAULT_VALUE_FOR_NotificationEventEnabled);
#endif
    setOpportunisticSweepingAndGarbageCollectionEnabled(DEFAULT_VALUE_FOR_OpportunisticSweepingAndGarbageCollectionEnabled);
    setPageVisibilityBasedProcessSuppressionEnabled(DEFAULT_VALUE_FOR_PageVisibilityBasedProcessSuppressionEnabled);
#if HAVE(PHOTOS_UI)
    setPhotoPickerPrefersOriginalImageFormat(DEFAULT_VALUE_FOR_PhotoPickerPrefersOriginalImageFormat);
#endif
#if ENABLE(VIDEO)
    setPreferSandboxedMediaParsing(DEFAULT_VALUE_FOR_PreferSandboxedMediaParsing);
#endif
    setLegacyPluginQuirkForMailSignaturesEnabled(DEFAULT_VALUE_FOR_LegacyPluginQuirkForMailSignaturesEnabled);
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
    setRemoveBackgroundEnabled(DEFAULT_VALUE_FOR_RemoveBackgroundEnabled);
#endif
#if HAVE(SC_CONTENT_SHARING_PICKER)
    setRequireUAGetDisplayMediaPrompt(DEFAULT_VALUE_FOR_RequireUAGetDisplayMediaPrompt);
#endif
#if ENABLE(MEDIA_STREAM)
    setSpeakerSelectionRequiresUserGesture(DEFAULT_VALUE_FOR_SpeakerSelectionRequiresUserGesture);
#endif
#if ENABLE(MEDIA_STREAM)
    setGetUserMediaRequiresFocus(DEFAULT_VALUE_FOR_GetUserMediaRequiresFocus);
#endif
    setResourceLoadSchedulingEnabled(DEFAULT_VALUE_FOR_ResourceLoadSchedulingEnabled);
#if ENABLE(RESOURCE_USAGE)
    setResourceUsageOverlayVisible(DEFAULT_VALUE_FOR_ResourceUsageOverlayVisible);
#endif
    setIsSameSiteStrictEnforcementEnabled(DEFAULT_VALUE_FOR_IsSameSiteStrictEnforcementEnabled);
    setScrollingPerformanceTestingEnabled(DEFAULT_VALUE_FOR_ScrollingPerformanceTestingEnabled);
    setSecureContextChecksEnabled(DEFAULT_VALUE_FOR_SecureContextChecksEnabled);
    setSiteIsolationEnabled(DEFAULT_VALUE_FOR_SiteIsolationEnabled);
    setShouldTakeNearSuspendedAssertions(DEFAULT_VALUE_FOR_ShouldTakeNearSuspendedAssertions);
#if ENABLE(WRITING_TOOLS_UI)
    setTextAnimationsEnabled(DEFAULT_VALUE_FOR_TextAnimationsEnabled);
#endif
#if ENABLE(IMAGE_ANALYSIS) && ENABLE(VIDEO)
    setTextRecognitionInVideosEnabled(DEFAULT_VALUE_FOR_TextRecognitionInVideosEnabled);
#endif
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
    setThreadedAnimationResolutionEnabled(DEFAULT_VALUE_FOR_ThreadedAnimationResolutionEnabled);
#endif
    setTiledScrollingIndicatorVisible(DEFAULT_VALUE_FOR_TiledScrollingIndicatorVisible);
    setUndoManagerAPIEnabled(DEFAULT_VALUE_FOR_UndoManagerAPIEnabled);
    setUpgradeKnownHostsToHTTPSEnabled(DEFAULT_VALUE_FOR_UpgradeKnownHostsToHTTPSEnabled);
#if ENABLE(ARKIT_INLINE_PREVIEW)
    setUseARKitForModel(DEFAULT_VALUE_FOR_UseARKitForModel);
#endif
#if HAVE(SC_CONTENT_SHARING_PICKER)
    setUseSCContentSharingPicker(DEFAULT_VALUE_FOR_UseSCContentSharingPicker);
#endif
#if HAVE(SCENEKIT)
    setUseSceneKitForModel(DEFAULT_VALUE_FOR_UseSceneKitForModel);
#endif
    setUserGesturePromisePropagationEnabled(DEFAULT_VALUE_FOR_UserGesturePromisePropagationEnabled);
    setServiceWorkersUserGestureEnabled(DEFAULT_VALUE_FOR_ServiceWorkersUserGestureEnabled);
#if ENABLE(IMAGE_ANALYSIS)
    setVisualTranslationEnabled(DEFAULT_VALUE_FOR_VisualTranslationEnabled);
#endif
    setWebAPIStatisticsEnabled(DEFAULT_VALUE_FOR_WebAPIStatisticsEnabled);
    setWebAPIsInShadowRealmEnabled(DEFAULT_VALUE_FOR_WebAPIsInShadowRealmEnabled);
#if ENABLE(WEB_ARCHIVE)
    setWebArchiveTestingModeEnabled(DEFAULT_VALUE_FOR_WebArchiveTestingModeEnabled);
#endif
    setWebInspectorEngineeringSettingsAllowed(DEFAULT_VALUE_FOR_WebInspectorEngineeringSettingsAllowed);
    setWebRTCAudioLatencyAdaptationEnabled(DEFAULT_VALUE_FOR_WebRTCAudioLatencyAdaptationEnabled);
#if ENABLE(WEB_RTC)
    setWebRTCDTMFEnabled(DEFAULT_VALUE_FOR_WebRTCDTMFEnabled);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCH264HardwareEncoderEnabled(DEFAULT_VALUE_FOR_WebRTCH264HardwareEncoderEnabled);
#endif
    setWebRTCMediaPipelineAdditionalLoggingEnabled(DEFAULT_VALUE_FOR_WebRTCMediaPipelineAdditionalLoggingEnabled);
#if ENABLE(WEB_RTC)
    setWebRTCRemoteVideoFrameEnabled(DEFAULT_VALUE_FOR_WebRTCRemoteVideoFrameEnabled);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCSocketsProxyingEnabled(DEFAULT_VALUE_FOR_WebRTCSocketsProxyingEnabled);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCVP9Profile0CodecEnabled(DEFAULT_VALUE_FOR_WebRTCVP9Profile0CodecEnabled);
#endif
#if PLATFORM(COCOA)
    setWriteRichTextDataWhenCopyingOrDragging(DEFAULT_VALUE_FOR_WriteRichTextDataWhenCopyingOrDragging);
#endif
    setRequestStorageAccessThrowsExceptionUntilReload(DEFAULT_VALUE_FOR_RequestStorageAccessThrowsExceptionUntilReload);
}

}
