load ../lib/import

@test "import any on Parabola repos" {
	# Initial run
	releasePackage libre 'pkg-any-a'
	STAGING=$STAGING db-update
	checkPackage libre pkg-any-a 1-1
	rmdir "$STAGING"

	# Add an arch
	echo 'ARCHES+=(ppc64le)' >> "$DBSCRIPTS_CONFIG"
	ARCHES+=(ppc64le)
	db-init

	# Adding the arch broke checkPackage
	if checkPackage libre pkg-any-a 1-1; then return 1; fi
	# But db-import-any fixes it
	db-import-any
	checkPackage libre pkg-any-a 1-1
}

@test "import any on imported repos" {
	export TESTSUITE_ENABLE_PPC64LE=t

	cat >"${TMP}/config.local.import-ourarches" <<-eot
		source ${DBSCRIPTS_CONFIG@Q}
		source ../config.local.import-ourarches
		PKGREPOS=(core core-testing)
	eot
	DBSCRIPTS_CONFIG="${TMP}/config.local.import-ourarches" db-init

	__releaseImportedPackage pkg-any-a    x86_64 "$TMP/rsyncd/archlinux/core/os/x86_64/core.db.tar.gz" "$TMP/rsyncd/archlinux/pool/packages"
	__releaseImportedPackage pkg-simple-c x86_64 "$TMP/rsyncd/archlinux/core/os/x86_64/core.db.tar.gz" "$TMP/rsyncd/archlinux/pool/packages"
	DBSCRIPTS_CONFIG="${TMP}/config.local.packages" db-import-pkg

	[[ -z $(bsdtar tf "${TMP}/ftp/core/os/ppc64le/core.db") ]]

	DBSCRIPTS_CONFIG="${TMP}/config.local.import-ourarches" db-import-any

	bsdtar tf "${TMP}/ftp/core/os/ppc64le/core.db" pkg-any-a-1-1/desc
	if bsdtar tf "${TMP}/ftp/core/os/ppc64le/core.db" pkg-simple-c-1-1; then return 1; fi
	__isLinkTo "${TMP}/ftp/core/os/ppc64le/pkg-any-a-1-1-any.pkg.tar.xz" "${TMP}/ftp/pool/packages/pkg-any-a-1-1-any.pkg.tar.xz"
}

@test "import any succeeds if there's nothing to do" {
	# Initial release
	releasePackage libre 'pkg-any-a'
	STAGING=$STAGING db-update
	checkPackage libre pkg-any-a 1-1
	rmdir "$STAGING"

	# Add an arch
	echo 'ARCHES+=(ppc64le)' >> "$DBSCRIPTS_CONFIG"
	ARCHES+=(ppc64le)
	db-init

	# This run does the work
	db-import-any
	# And so this run is a no-op
	db-import-any
}
