"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const exposes = __importStar(require("../lib/exposes"));
const tuya = __importStar(require("../lib/tuya"));
const e = exposes.presets;
function sceneAction() {
    const lookup = ["scene_1", "scene_2", "scene_3", "scene_4", "scene_5", "scene_6", "scene_7", "scene_8", "scene_9", "scene_10"];
    const expose = e.action(lookup);
    return [
        tuya.modernExtend.dpEnumLookup({
            dp: 0x01,
            name: "action",
            type: tuya.dataTypes.enum,
            readOnly: true,
            expose: expose,
            lookup: { scene_1: 0 },
        }),
        tuya.modernExtend.dpEnumLookup({
            dp: 0x02,
            name: "action",
            type: tuya.dataTypes.enum,
            readOnly: true,
            expose: expose,
            lookup: { scene_2: 0 },
        }),
        tuya.modernExtend.dpEnumLookup({
            dp: 0x03,
            name: "action",
            type: tuya.dataTypes.enum,
            readOnly: true,
            expose: expose,
            lookup: { scene_3: 0 },
        }),
        tuya.modernExtend.dpEnumLookup({
            dp: 0x04,
            name: "action",
            type: tuya.dataTypes.enum,
            readOnly: true,
            expose: expose,
            lookup: { scene_4: 0 },
        }),
        tuya.modernExtend.dpEnumLookup({
            dp: 0x05,
            name: "action",
            type: tuya.dataTypes.enum,
            readOnly: true,
            expose: expose,
            lookup: { scene_5: 0 },
        }),
        tuya.modernExtend.dpEnumLookup({
            dp: 0x06,
            name: "action",
            type: tuya.dataTypes.enum,
            readOnly: true,
            expose: expose,
            lookup: { scene_6: 0 },
        }),
        tuya.modernExtend.dpEnumLookup({
            dp: 0x07,
            name: "action",
            type: tuya.dataTypes.enum,
            readOnly: true,
            expose: expose,
            lookup: { scene_7: 0 },
        }),
        tuya.modernExtend.dpEnumLookup({
            dp: 0x08,
            name: "action",
            type: tuya.dataTypes.enum,
            readOnly: true,
            expose: expose,
            lookup: { scene_8: 0 },
        }),
        tuya.modernExtend.dpEnumLookup({
            dp: 0x09,
            name: "action",
            type: tuya.dataTypes.enum,
            readOnly: true,
            expose: expose,
            lookup: { scene_9: 0 },
        }),
        tuya.modernExtend.dpEnumLookup({
            dp: 0x0a,
            name: "action",
            type: tuya.dataTypes.enum,
            readOnly: true,
            expose: expose,
            lookup: { scene_10: 0 },
        }),
    ];
}
exports.definitions = [
    {
        fingerprint: tuya.fingerprint("TS0601", ["_TZE200_lhpnrfmy"]),
        model: "ERC2201-Z",
        vendor: "BOX",
        description: "Wireless controller",
        extend: [
            tuya.modernExtend.tuyaMagicPacket(),
            tuya.modernExtend.dpOnOff({
                dp: 0x13,
            }),
            tuya.modernExtend.dpEnumLookup({
                name: "record_rf",
                dp: 0x66,
                type: tuya.dataTypes.enum,
                description: "Record RF control",
                lookup: { record: 0 },
            }),
            tuya.modernExtend.dpEnumLookup({
                name: "clear_rf",
                dp: 0x66,
                type: tuya.dataTypes.enum,
                description: "Clear RF control",
                lookup: { clear: 1 },
            }),
            tuya.modernExtend.dpEnumLookup({
                name: "rf_status",
                dp: 0x67,
                type: tuya.dataTypes.enum,
                description: "RF control status",
                lookup: { ok: 0, error: 1 },
                readOnly: true,
            }),
            tuya.modernExtend.dpEnumLookup({
                dp: 0x68,
                name: "record_scene",
                type: tuya.dataTypes.enum,
                description: "Record RF for scene",
                lookup: {
                    scene_1: 0,
                    scene_2: 1,
                    scene_3: 2,
                    scene_4: 3,
                    scene_5: 4,
                    scene_6: 5,
                    scene_7: 6,
                    scene_8: 7,
                    scene_9: 8,
                    scene_10: 9,
                },
            }),
            tuya.modernExtend.dpEnumLookup({
                dp: 0x68,
                name: "clear_scene",
                type: tuya.dataTypes.enum,
                description: "Clear RF for scene",
                lookup: {
                    scene_1: 10,
                    scene_2: 11,
                    scene_3: 12,
                    scene_4: 13,
                    scene_5: 14,
                    scene_6: 15,
                    scene_7: 16,
                    scene_8: 17,
                    scene_9: 18,
                    scene_10: 19,
                },
            }),
            tuya.modernExtend.dpEnumLookup({
                name: "rf_scene_status",
                dp: 0x69,
                type: tuya.dataTypes.enum,
                description: "RF control command for scene status",
                lookup: { ok: 0, error: 1 },
                readOnly: true,
            }),
            ...sceneAction(),
        ],
    },
    {
        fingerprint: tuya.fingerprint("TS0601", ["_TZE200_o7vduidq"]),
        model: "ERC2202-Z",
        vendor: "BOX",
        description: "Dual controller",
        extend: [
            tuya.modernExtend.tuyaMagicPacket(),
            tuya.modernExtend.dpBinary({
                name: "state_l1",
                dp: 19,
                type: tuya.dataTypes.bool,
                valueOn: ["ON", true],
                valueOff: ["OFF", false],
                description: "On/off state of the switch",
            }),
            tuya.modernExtend.dpBinary({
                name: "state_l2",
                dp: 20,
                type: tuya.dataTypes.bool,
                valueOn: ["ON", true],
                valueOff: ["OFF", false],
                description: "On/off state of the switch",
            }),
            tuya.modernExtend.dpEnumLookup({
                name: "record_rf",
                dp: 0x66,
                type: tuya.dataTypes.enum,
                description: "Record RF control",
                lookup: { record_l1: 0, record_l2: 1 },
            }),
            tuya.modernExtend.dpEnumLookup({
                name: "clear_rf",
                dp: 0x66,
                type: tuya.dataTypes.enum,
                description: "Clear RF control",
                lookup: { clear_l1: 2, clear_l2: 3 },
            }),
            tuya.modernExtend.dpEnumLookup({
                name: "rf_status",
                dp: 0x67,
                type: tuya.dataTypes.enum,
                description: "RF control status",
                lookup: { ok: 0, error: 1 },
                readOnly: true,
            }),
        ],
    },
    {
        fingerprint: tuya.fingerprint("TS0601", ["_TZE200_ra6wrlgv"]),
        model: "ERC2206-Z",
        vendor: "BOX",
        description: "Roller shutter controller",
        extend: [
            tuya.modernExtend.tuyaMagicPacket(),
            tuya.modernExtend.dpEnumLookup({
                name: "state",
                dp: 0x01,
                type: tuya.dataTypes.enum,
                description: "Shutter state",
                lookup: { open: 0, stop: 1, close: 2 },
            }),
            tuya.modernExtend.dpEnumLookup({
                name: "direction",
                dp: 0x05,
                type: tuya.dataTypes.enum,
                description: "Motor direction",
                lookup: { forward: 0, back: 1 },
            }),
            tuya.modernExtend.dpEnumLookup({
                name: "record_rf",
                dp: 0x65,
                type: tuya.dataTypes.bool,
                description: "Record RF control",
                lookup: { record: true, stop: false },
            }),
            tuya.modernExtend.dpEnumLookup({
                name: "clear_rf",
                dp: 0x66,
                type: tuya.dataTypes.bool,
                description: "Clear RF control",
                lookup: { clear: true, stop: false },
            }),
        ],
    },
    {
        fingerprint: tuya.fingerprint("TS0601", ["_TZE200_yp5tsi3y"]),
        model: "EWS1154-Z",
        vendor: "BOX",
        description: "Wall switch",
        extend: [
            tuya.modernExtend.tuyaMagicPacket(),
            tuya.modernExtend.dpOnOff({
                dp: 0x13,
            }),
            tuya.modernExtend.dpEnumLookup({
                name: "record_rf",
                dp: 0x66,
                type: tuya.dataTypes.enum,
                description: "Record RF control",
                lookup: { record: 0 },
            }),
            tuya.modernExtend.dpEnumLookup({
                name: "clear_rf",
                dp: 0x66,
                type: tuya.dataTypes.enum,
                description: "Clear RF control",
                lookup: { clear: 1 },
            }),
            tuya.modernExtend.dpEnumLookup({
                name: "rf_status",
                dp: 0x67,
                type: tuya.dataTypes.enum,
                description: "RF control status",
                lookup: { ok: 0, error: 1 },
                readOnly: true,
            }),
            tuya.modernExtend.dpEnumLookup({
                dp: 0x68,
                name: "record_scene",
                type: tuya.dataTypes.enum,
                description: "Record RF for scene",
                lookup: {
                    scene_1: 0,
                    scene_2: 1,
                    scene_3: 2,
                    scene_4: 3,
                    scene_5: 4,
                    scene_6: 5,
                    scene_7: 6,
                    scene_8: 7,
                    scene_9: 8,
                    scene_10: 9,
                },
            }),
            tuya.modernExtend.dpEnumLookup({
                dp: 0x68,
                name: "clear_scene",
                type: tuya.dataTypes.enum,
                description: "Clear RF for scene",
                lookup: {
                    scene_1: 10,
                    scene_2: 11,
                    scene_3: 12,
                    scene_4: 13,
                    scene_5: 14,
                    scene_6: 15,
                    scene_7: 16,
                    scene_8: 17,
                    scene_9: 18,
                    scene_10: 19,
                },
            }),
            tuya.modernExtend.dpEnumLookup({
                name: "rf_scene_status",
                dp: 0x69,
                type: tuya.dataTypes.enum,
                description: "RF control command for scene status",
                lookup: { ok: 0, error: 1 },
                readOnly: true,
            }),
            ...sceneAction(),
        ],
    },
];
//# sourceMappingURL=box.js.map